META
key;value
description;District PB in Warszawa, Mokotów
country;Poland
unit;Warszawa
district;Mokotów
subunit;Mokotów
instance;2024
num_projects;76
num_votes;9442
budget;8722733
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
286;248450;3615;Około 111 nowych drzew na Mokotowie i nowe ławki;environmental protection,public space,urban greenery;children,seniors;1;52.20290546417487;21.04051390587384
1720;44000;3449;Chronimy mokotowskie jerzyki i wróble - montaż skrzynek lęgowych;environmental protection;;1;52.186764745454546;21.017159682835253
1238;561000;3332;Nie jesteś sam - pierwsza pomoc psychologiczna dla dzieci i młodzieży. Zróbmy to po raz trzeci!;education,welfare;children;1;52.1953734;21.018839657263133
221;342750;3239;100 drzew i kwiaty dla Mokotowa.;environmental protection,urban greenery;children,seniors;1;52.20280943892203;21.04984974874242
1623;312000;3129;Zielone przystanki na Mokotowie;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.20460515;21.016613741666667
660;615004;3085;Jeszcze więcej drzew, krzewów i kwiatów na Mokotowie!!!;public space,urban greenery;children,seniors;1;;
544;309500;2977;Jeziorko Czerniakowskie - wspólnie zadbajmy o jego otoczenie - etap II;education,environmental protection,public space,sport;children,seniors;1;52.18746215;21.071820306677957
739;1744547;2835;Zieleń zamiast betonu;environmental protection,public space,urban greenery;children,seniors;1;52.20356800825389;21.015343666076664
925;480000;2767;Mokotowska ślizgawka;public space,sport;children,seniors;1;52.19165375;20.99614208159896
539;260300;2600;Naturalna zieleń w miejscu asfaltu na terenach Mokotowa;environmental protection,public space,urban greenery;children,seniors;1;52.1694957;21.008476293473066
109;200000;2060;Zakup nowości wydawniczych: książek, audiobooków, gier planszowych dla Bibliotek Publicznych w Dzielnicy Mokotów m.st. Warszawy;education,culture,public space;children,seniors;1;;
1199;41900;1990;Jadłodzielnia i słoikodzielnia dla Mokotowa;education,environmental protection,welfare,public space;children,seniors;1;52.2076151;21.0216805
1628;1650000;1971;Ścieżka rowerowa i chodnik wzdłuż al. Sikorskiego (Leśnej Jeżyny - Sobieskiego);public transit and roads,public space;children,seniors;1;52.18775763321174;21.045765280723575
1550;470000;1809;Renowacja oczka wodnego w parku Promenada;environmental protection,public space,urban greenery;children,seniors;1;52.20360910336133;21.02969884872437
1240;212200;1735;Zielona ul. Madalińskiego;environmental protection,public space,urban greenery;children,seniors;1;52.203924713267;21.011459827423096
260;654000;1699;Cały Mokotów - zakup książek, audiobooków i gier dla Bibliotek Publicznych Mokotowa + teatrzyki w wybranych bibliotekach;education,culture,public space;children,seniors;1;;
567;212000;1568;Służewiec przyjazny pieszym - nowe chodniki zamiast błota i popękanych płyt;public transit and roads,public space,urban greenery;seniors;1;52.17738420314848;20.998664194865395
440;207000;1557;Więcej powietrza na Naszym Podwórku - nasadzenia drzew;education,public transit and roads,culture,environmental protection,welfare,public space,sport,urban greenery;children,seniors;1;;
1236;350950;1475;Zielono i czysto na Mokotowie: ul. Dąbrowskiego na odcinku między ul. Wiśniową i Bałuckiego i al. Niepodległości;environmental protection,public space,urban greenery;children,seniors;0;52.20238609040091;21.015043258666996
909;690920;1465;Robimy porządki dla pieszych na całym Służewcu;public transit and roads,environmental protection,public space,urban greenery;seniors;0;52.178415225;20.99968034688517
422;850000;1454;Miasteczko miniRowerowe;education,public transit and roads,sport;children;0;52.1739998;21.0284786
193;40000;1399;Murale metra - Zdzisław Beksiński;culture,public space;children,seniors;1;52.1732466;21.0257137
434;500000;1363;Eko Strefa na Spartańskiej;education,environmental protection,urban greenery;children,seniors;0;52.19193343708;20.996822245271
780;345000;1331;Bezpieczne wiaty rowerowe na Mokotowie dla mieszkańców;public transit and roads,public space,sport,urban greenery;children,seniors;0;52.196033775392564;21.01366996765137
1666;39700;1318;Nie zamykajmy się w czterech ścianach - seniorzy +60, + 70 + 80 - ćwiczmy;education,culture,welfare,sport;seniors;1;52.21002999545454;21.06567704040438
1217;30000;1317;Czystsze powietrze dzięki krzewom - Al. Lotników / Modzelewskiego;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.174027499999994;21.01180404524978
868;84700;1267;Bezpłatne spektakle dla dzieci na Mokotowie;education,culture;children;0;52.17543758119243;21.003305912017826
57;70000;1225;Wiata i podpórki rowerowe na Mokotowie;sport;seniors;0;52.173365840066865;21.023004055023197
1016;170675;1200;Piękna Kazimierzowska;public space,urban greenery;children,seniors;0;52.205184430155285;21.01381381767377
97;655000;1188;Profesjonalna wolnostojąca ścianka wspinaczkowa w Parku im. Stanisława Dygata na Sadybie;public space,sport;children;0;52.18591515;21.055488382517872
339;37500;1174;Kurs samoobrony dla kobiet;education,welfare,sport;seniors;1;52.21222184009;21.072324514389
1075;3000;1165;Nowe książki popularnonaukowe dla dzieci;education,culture;children;1;52.1760078;21.0047388
274;170000;1149;Zielona Górka - Mokotów;environmental protection,public space,urban greenery;children,seniors;0;52.184563113143994;21.008048057556152
1163;46000;1147;Ratujmy Mural Mechanicznego Centaura;education,culture,public space,urban greenery;children,seniors;0;52.199686650000004;21.026714566227945
553;430000;1118;Modernizacja zniszczonego placu zabaw na terenie Służewskiego Domu Kultury (SDK) przy ul. Bacha.;public space;children,seniors;0;52.168385125181835;21.02545022964478
119;102656;1113;Bezpłatne zajęcia sportowe dla mieszkańców Warszawy Mokotów;education,welfare,sport;children,seniors;0;52.17350225;21.00844116327292
531;475200;1052;336 zielonych m2. Rozpłytowanie, obsadzenie zielenią i aranżacja małej architektury dla podwórza przy ul. Iwickiej na Sielcach w Warszawie;environmental protection,public space,urban greenery;children,seniors;0;52.2060855;21.042130609042598
700;1027000;1048;Kładka przez Bernardyńską Wodę;public space,urban greenery;children,seniors;0;52.192119843199514;21.05188608169556
650;1478120;1044;Remont i oświetlenie chodnika al. Niepodległości między ulicami Ksawerów i Woronicza;public transit and roads,environmental protection,public space;children,seniors;0;52.18794672837727;21.01815462112427
1153;100000;1021;Strefa relaksu w Parku Dygata;public space,urban greenery;children,seniors;0;52.18756260874485;21.055941581726074
180;1500000;953;Rewitalizacja placu zabaw przy Wałbrzyskiej;public space,sport;children;0;52.1739998;21.0284786
335;37000;939;Zajęcia z robotyki i programowania dla dzieci i młodzieży;education;children;0;52.211830165166;21.073723605357
446;184000;933;Serce mokotowskiej Sadyby dla dzieci i młodzieży. Remont placu zabaw i powiększenie strefy rekreacji.;public space,sport,urban greenery;seniors;0;52.18339585;21.064697492602196
442;69450;930;Aktywny senior -bezpłatne zajęcia sportowe dla mieszkańców Mokotowa;welfare,sport;seniors;0;52.1769958;21.0022166
1442;1200000;928;Od klepiska do boiska - wielofunkcyjne boisko i plac do kalisteniki przy ul. Tynieckiej 25;education,public space,sport;children,seniors;0;52.19369647326335;21.02214574813843
674;300000;905;Zagospodarowanie terenu wokół Bernardyńskiej Wody;education,public space,sport,urban greenery;children,seniors;0;52.19227193479661;21.05203628540039
894;30000;854;Próg zwalniający dla rowerzystów przy placu zabaw w parku Arkadia na Mokotowie;public transit and roads,public space,urban greenery;children,seniors;0;52.190167269721044;21.02864742279053
1234;85900;836;Biblioteka plenerowa i książkodzielnia;education,culture,environmental protection,public space,urban greenery;children,seniors;0;52.20555533353898;21.011009216308597
626;19000;825;Kosze i sprzątanie na skarpie przy Wilanowskiej;environmental protection,public space,urban greenery;children,seniors;0;52.18040556299329;21.03032970428467
1381;350000;825;Huśtawka integracyjna;education,sport;children;0;52.177205099999995;21.048636809926634
897;474350;796;Więcej miejsc parkingowych Konstruktorska;public transit and roads,public space,urban greenery;children,seniors;0;52.185405097248115;20.99362655911967
337;18700;774;Bezpieczny uczeń na Mokotowie;education,sport;children;0;52.211969431021;21.073515320161
459;68000;756;Zadaszone miejsce na rowery;education,public space,sport;children;0;52.17353355;21.039039003232467
169;280000;671;Zieleń i bezpieczeństwo na skwerze przy Konduktorskiej;environmental protection,public space,urban greenery;children,seniors;0;52.198822067169786;21.028604507446293
250;837000;654;Nasze zielone podwórko na Wierzbnie;environmental protection,public space,sport,urban greenery;children,seniors;0;52.189741921544396;21.010055527728273
1149;260000;647;Street Workout w Parku Dygata;public space,sport;children,seniors;0;52.186772259643;21.056220531463623
685;300000;644;„Ogród Marii” Rewitalizacja skweru przed Szkołą Podstawową nr 69;education,culture,environmental protection,public space,urban greenery;children,seniors;0;52.19833078585542;21.009650230189436
1221;510000;634;Nowe nasadzenia na skwerze przy Niegocińskiej oraz remont siłowni plenerowej i placu zabaw na skwerze Bartłomieja;environmental protection,public space,sport,urban greenery;children,seniors;0;52.17126021366484;21.00673913955689
1414;86400;622;Poznaj swoje prawa. Szkolenie dla uczniów szkół ponadpodstawowych z prawa pracy i działalności związków zawodowych;education;;0;52.199366675;21.017557494189465
1041;365650;618;Bezpieczne i wygodne skrzyżowania na Wyględowie;public transit and roads;children;0;52.19188236655759;20.9952948431393
127;95750;616;Chodnik na Piaseczyńskiej;public transit and roads,public space,urban greenery;children,seniors;0;52.19796101971238;21.032338142395023
633;61600;610;Spotkajmy się pod lipą;environmental protection,public space,urban greenery;children,seniors;0;52.20613392601469;21.015644071369668
170;60000;604;Tablice informacyjne w Parku Morskie Oko;education,culture,public space,sport,urban greenery;children,seniors;0;52.204544722519756;21.025545309916243
677;35860;571;Promenada Łowicka;education,public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.20135768277953;21.00625419603603
1214;70000;473;Zadaszony parking rowerowy przy OSiR Mokotów i Szkole Podstawowej nr 271;public transit and roads,environmental protection,public space,sport,urban greenery;children;0;52.17443675;21.009742670750455
244;152000;434;Bezpieczne i zielone podwórko-łącznik między ulicami Kwiatową a Ligocką.;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.20452962836125;21.011524200439457
1699;340000;433;Woronicza nr 34, Bukietowa nr 2, Modzelewskiego nr 61 – remont podwórka;public space,urban greenery;children,seniors;0;52.18951801666666;21.012978839497933
573;84500;432;Skontaktuj się! Cykl bezpłatnych warsztatów dla dzieci i dorosłych pogłębiających kontakt ze sobą, innymi oraz naturą;education,welfare,urban greenery;children,seniors;0;52.193402675;21.011631174666974
1288;12800;428;Zdrowie i witalność dla każdego - Slow Jogging bieganie z uśmiechem :);education,sport;seniors;0;52.209026775390655;20.997962931543693
963;360200;404;Funkcjonalne zagospodarowanie terenu przylegającego do budynku Racławicka 46;public transit and roads,culture,public space,sport,urban greenery;children;0;52.19620185;21.003627162039674
1093;16880;372;Spotkania z haftem tradycyjnym i współczesnym;education,culture;seniors;0;52.175481149999996;21.003205989459115
461;150000;369;Mural na cześć patrona szkoły Bronisława Malinowskiego;education,culture,public space,sport;children,seniors;0;52.17353355;21.039039003232467
1490;29500;365;Pozytywna Dyscyplina - warsztat dla rodziców dzieci w wieku przedszkolnym oraz rodziców dzieci ze specjalnymi potrzebami;education,welfare;;0;52.1935186;21.02154402583092
321;47000;303;Uprzątnięcie terenu zielonego wzdłuż ulicy Ajewskiego;environmental protection,public space,urban greenery;children,seniors;0;52.2057394319621;21.054482460021973
55;27000;273;Tablica informacyjna na Mokotowie;education,environmental protection,public space;seniors;0;52.180195064734946;21.024355888366703
154;58000;259;Dwa śmietniki przy ul. Rostafińskich;environmental protection,public space;children,seniors;0;52.2080111;20.9938439
VOTES
voter_id;vote;age;sex
3;109,909,286,739,660,1199,1234,335,422,434,260,780,221,1238,925;43;F
22;446,221,1238,544,1153;45;F
49;626,127,780,1628,57;41;M
125;780,1016,274,250,1240,221,459,909,286,1236,1214,739,660,1623,1628;33;M
127;180,422;48;F
135;422,180;12;M
160;660,221,1238,274,1623,925,1217,1720,1149,868,909,553,193,461,180;76;F
166;780,442,119,539,1288,274,250,1236,440,650,739,660,1720,1623,1153;58;F
184;650,685,1628,531,700,1236,1217,739,660,539,1623,274,221,1163,286;43;F
196;97,894,286,459,422,1163,221,274,1623,1720,739,1442,119,780,925;15;F
199;650,339,1490,739,660,442,573,1199,1666,119,1623,221,1238,544,286;29;F
204;894,925,780,1623,337,539,674,626,1149,650,739,127,221,1628,286;44;M
206;127,1238,109,1075,286,894,531,97,321;35;M
228;440,127,1720,1623,1240,1238,925,1628,459,286,57,780,221,1550,531;42;M
267;925,434;40;M
275;1221,660,539,1623,1720,674,221,544,286,97,700;43;F
305;1628,335,544,422,1699,1236,650,539,193,1041,1623,250,1240,1550,909;32;M
327;170,440,868,1238,422,459,97,221,286,57;35;F
355;650,260,660,868,119,1041,221,925,1075,434,1699;39;F
365;221,193,1720,1041,544,109;53;F
373;339,1666,539,1199,1093,260,567,193,1234,1720,1623,1238,109,1075,909;26;M
379;260,739,1217,55,170,1720,1623,1238,335,544,1666,1163,1550,127,169;27;M
392;660,260,1221,739,339,685,1214,567,868,1720,1623,1238,925,109,909;41;F
415;544,925,1628,1550,1221,739,446,440,539,1720,221,422,286,660,1199;66;F
421;55,650,170,339,660,193,1016,1240,221,544,180,286,531,1666,1236;21;M
434;739,660,1720,221,1238,1628,544,422,109,180,286,531,434,1236,894;37;F
444;1217,739,169,539,127,1550;30;F
470;1550,422,97,1236,440,1381,544,286,321,700,739,660,221;44;F
471;193,1238,461,963,286,1666,169,339,1199,1720,1623,1550,1163,544,531;45;F
486;660,633,739,446,169,868,119,250,109,894,1221,337,780,544,1442;45;M
491;180;47;M
492;553,539,567,1720,1414,1623,335,109,180,909,286,531,57,1238,440;36;F
497;339,739,660,440,539,567,1199,119,1720,1623,274,897,221,1238,1288;33;F
506;660,553,1199,868,1720,221,1238,925,335,544,573,180,894,57,1236;35;F
533;685;51;M
560;422,180;38;F
599;1149,674,1199,1238,544,422,97,700,1153;50;F
606;626,260,1240,221,109,1236,244,739,531,1628,1163,1720,337,127,1214;30;M
612;700,1236,193,567,539,440,553,660,1442,260,446,1214,685;10;M
615;286,739,260,193,1550,221,925,461,1149,626,1720,1628,544,109,700;29;M
621;170,553,442,1199,127,868,119,1720,1550,1238,1163,422,286,531,1666;43;F
667;422,180;44;F
685;1442,260,739,1214,1093,868,780,109,57,677,127,660,685,1550,544;41;F
710;1666;76;F
713;169,868,119,1550,1238,286,1153;40;F
724;650,660,193,1623,1550,221,1163,286;26;M
750;909,1623,650,422,739,660,539,1199,780,221,1550,1163,1628,544,459;31;M
831;1153,1550,169;32;F
844;925,434;38;F
875;660,193,221,422,1149,674,1720,1628,335,544,286,97,57,700,1153;41;M
876;677;65;F
902;180,422;50;F
908;894;38;F
914;897,1623,925,461,544,1699,1236,739,660,539,1381,193,1199,286,434;29;F
967;1016,544,109,459,963,1381,739,660,539,567,1041,434;29;F
977;1234,1221,170,894,422,1240,1199,553,660,260,1217,868,109,180,909;34;F
981;1628,626,553,567,193,1016,422,459,461,180,909,286,57,1236,650;57;M
1072;169;39;F
1096;544,422,1199,674,1217,650,1238,553,567,193,1720,1016,180,700,1666;25;M
1109;660,739,626,573,868,1288,335,1490,339,1199,1238,1628,422,894,57;44;F
1111;925,434;32;F
1218;1623,221,1288,286,57,440,573,1199,868,119,1238,925,544,422,894;36;F
1226;739,626,660,539,567,909,274,1238,544,1628,674,339,440,1075,109;54;M
1227;337,180;41;F
1231;274,1016,193,1381,335,1163,894;38;M
1250;1381,442,119,337,780,1288,459,461,97,57,1666,925,544,422,180;37;F
1253;422,109,1075,1238,1163,57,1666,925,963,97,1720,1199,260,739,685;41;M
1262;260,868,422;38;F
1302;1217,1221,539,567,1720,553,337,1238,422,180;42;F
1311;1720,193,57,422,180;39;F
1327;1217,660,539,780,1214,626,567,1199,127,1414,1623,1238,1550,1163,909;22;F
1355;55,170,1214,440,1199,193,1720,1623,1240,1550,909,286,531,57;33;M
1364;119,193,739,1623,422,1628;49;M
1377;780,1628,1199,963,685,1720,1041;20;M
1456;169,1214,1720,780,221,1238,1628,422,459,57;41;M
1457;1153,1720,1163,1628,422,97;44;M
1492;1163,1442,1221,97,1236,700,321,544,1628,1550,221,119,539,660,674;54;M
1523;339,446,573,1381,868,119,1720,1238,925,1628,335,544,286,97,700;34;F
1578;442;68;F
1581;422,180;11;M
1627;925;37;F
1643;170,1075,244,633,685,1199,677,1623,1016,1240,154;46;F
1676;925;45;M
1690;539,553,544,422,119,567,1041,909,57,626,446,1628,459,1720,1381;30;F
1693;650,685,170,739,260,660,1720,1016,1240,1550,1163,544,109,286,531;35;M
1708;127,286,660,260,633,685,677,780,221,1550,544,109,531,57,1236;69;F
1750;446,626,925,553,1199,193,544,180,97;75;F
1756;169,739,1490,1217,633,660,553,539,868,1720,221,1238,286,434,1699;37;F
1760;553,660,674,1221,446,244,1149,339,1381,337,894,97,321,700,1153;40;F
1774;1414,337,1234,1381,739,1199,119,1720,1628,1153,700,339,674,925,544;23;F
1796;97,1153;34;M
1872;1149,446,440,1199,193,1623,1628,544,97,700,1153;37;F
1892;567,1381,1238,1153,660,539,1199,119,97,1149,674,1720,1628,544,700;61;F
1893;422,180;43;M
1902;1720,337,119,127,1381,170,169,868,1550,925,544,459,894,57,1236;33;F
1913;57,1236,339,1490,244,677,1016,1240,1238;43;F
1991;221,109,57,286,459,544,1550,677,539,660,1442,260,739,633,685;71;M
2015;170,339,660,1199,127,337,1720,221,1163,335,109,286,531;37;M
2024;1217,1214,1221,660,539,567,868,221,925,1628,909,286,422,180,553;43;M
2052;274,1550,739,660,440,539,567,1199,1720,1623,897,221,909,286,434;40;F
2068;339,868,337,1623,780,274,897,221,1550,925,335,422,459,1075,685;43;M
2103;57,97,531,286,221,1720,1381,539,739,660,193,1550,1238,1628,544;62;M
2104;1381,1623,221,1288,459,1041,660,170,127,1720,1550,1238,1628,894,1153;50;M
2116;1628,531,286;52;F
2172;739,780,1238,1163,109,459,180,57,260,1016,1240,1550,544,286,1236;43;M
2181;894;37;M
2194;780,1016,1628,422,109,459,1075,286,57,274,897,221,1238,925,434;8;F
2219;1149,446,674,544,97,700,1153;29;M
2244;909,531,1236,650,1217,739,626,660,539,337,1623,286,57,434,925;40;F
2282;339,1149,446,674,442,119,1623,221,544,286,1153,700;58;F
2291;660,1623,1016,1240,221,1550,1238,894,286;38;F
2293;1666,1234,337,1720,925,434;41;F
2323;700,1236,1720,868,633,650,1442,1381,780,274,1238,925,1163,422,685;40;F
2347;170,780,459,57,1699,55,650,739,626,553,1238,180,1217,1720,909;42;M
2354;539,1238,1623,1720,337,119,660,260,339,685;38;F
2378;1628,260,660,539,1234,868,780,897,221,1238,925,335,422,459,434;11;M
2397;1720,1041,274,544,1623,567,897,909,925,434;32;M
2416;1217,660,539,567,193,1623,780,1628,57;47;M
2432;221,925,286,894,169,739;34;M
2491;868,337,1623,780,274,897,221,1550,925,335,544,422,459,1075,57;74;F
2506;739,1149,674,660,440,539,1199,1381,1720,221,1628,544,286,700,1153;88;F
2545;1075,193,260,109;52;F
2548;685,337,1623,1240,1238;38;F
2567;739,660,567,1199,193,127,1093,1240,221,1238,1628,286,97,57,1236;22;M
2582;1199,1381,1093,1720,1041,1623,1240,1550,1163,1628,1666,1236,650,868,97;17;F
2607;660,1623,780,1240,1550,286,57,1236,1153,1149,674,440,221,1628,544;30;M
2641;567,1199,193,1093,1238,544,461,909,531;21;F
2659;1217,626,660,539,193,1720,221,1550,544,274,1163;49;M
2710;660,1442,244,739,1016,1240,1550,1238,925,1628,109,963,286,1699,1236;40;M
2725;221,1238,154,286,57,1666;56;M
2760;440,539,567,337,1720,1041,274,250,221,1550,1628,909,286,434,1699;37;M
2798;1041,544,422,193,1163;31;M
2803;109,1214,1221,553,567,1381,868,1623,274,925,544,422,459,909,180;36;F
2807;553,260,193,1234,109;52;M
2813;1217,660,553,539,567,868,1623,422,180;35;F
2822;422,553,1628,626;40;M
2854;193,1163,440,260,109;42;M
2938;1628,1623,567,1217,180,422,909,553;33;M
2990;339,1720,1288,894;37;F
3010;650,633,1720,1041,250,1238,909,1699;69;F
3017;739,1442,660,440,539,1199,1720,1623,1016,1240,1550,286,221,1238,925;20;F
3028;1075,286,531,321,57,170,739,660,1199,1623,335,193,1550,1238,544;31;F
3073;434;46;M
3080;1214,1221,553,567,1381,868,1623,274,925,544,422,180,909;8;F
3100;260,440,1234,1199,660,674,1720,1414,221,1238,544,109,1075,286,700;71;F
3101;1214;44;M
3131;685;54;M
3141;1153,674;31;M
3173;286,1236,1153,1214,739,660,539,1623,780,1016,1238,925,109,1720,57;33;F
3187;539,440,660,674,739,127,1720,1550,1163,286,894,531,700,1153;37;M
3194;739,674,660,440,539,127,221,1550,1163,286,894,531;36;F
3197;660,739,170,55,440,539,193,1623,780,1550,544,1240,1720,221,1414;21;M
3214;57,909,286,109,1628,925,1240,1234,170,539,1623,780,221,440,260;31;M
3230;677,685;46;F
3254;1217,739,539,567,193,1623,780,1240,221,1550,459,909,286,531,57;23;M
3296;57,1623,154;53;M
3304;335,422,109,1075,739,260,660,868,1234,119,897,221,1238,925,434;46;F
3338;1381,1093,1720,677,1414,1623,1240,221,1550,1288,1628,1238,544,286,1666;38;M
3342;553,674,1442,260,1149,685,1381,963,170,1199,1016,1623,244,1240,1236;40;F
3399;440,539,739,685,633,660,1234,780,1016,1240,925,109,459,286,57;34;M
3406;567,286,897,422,180;59;F
3407;1217,1442,1628,1490,739,260,335,544,109,1075,909,286,1699,1666,1236;18;M
3473;57,97,1075,109,1240,1381,440,739,1217,119,1093,1199,260,660,539;64;F
3474;650,739,539,1199,1720,1623,250,221,109,459,286;34;M
3494;660,1199,1234,1720,1414,1238,925,1628,544,422,109,1075,286,531,321;34;F
3509;1720,1240,1236,963,739,553,193,925,685,1550,677;40;M
3515;925,1238,1414,660,1442,260,446,739,1217,57,1666,1214,553,422,180;65;F
3543;109,963,1666,1236,1199,193,244,633,1623,677,1720,442,1240,1238,1163;50;F
3558;539,274,286;26;F
3560;169;52;F
3593;446,1381,868,1238,925;28;F
3627;567,1381,868,119,337,274,221,1238,335,109,1075,909,286,422,180;39;F
3669;685;41;F
3677;1217,170,55,339,660,440,567,337,1016,1240,897,221,1238,544,286;29;F
3689;626,1238,1288,1666,573;40;F
3716;286,553,180,422;50;F
3718;544,459,1075,286,894,531,440,169,660,1414,221,1238,925,335,1163;28;M
3736;339,170,660,539,337,221,925,1628,335,422,286,97,57,700,1666;40;F
3737;339,660,440,539,1016,221,1238,925,335,422,1236,1240,573,1199,1414;43;F
3775;1623,1016,274,1240,1550,1628,1666,531,286,544,221,539,440,660,685;39;M
3783;677,685;8;F
3788;925,868,739,1238,553,1217,1381,567,660,335;40;F
3802;1550,1236,169,660,440,539,677,1016,1240,221,286,531,633,739,244;40;M
3803;250;56;F
3806;544,109,1075,1238,170,1720,1414,1550;45;F
3822;1199,260,1238,1163,109,1075,1666;34;F
3838;650,567,1236,739,780,1041,685,1238,909,1720,1240,1414,677,154,1623;14;M
3860;442,1236,440,868,1720,1163,1666,339,286,1075,335,1238,250;33;M
3923;739,539,1720,1623,461,909,567;23;F
3929;1217,339,739,169,1442,660,553,539,567,119,1720,1623,274,250;22;M
3935;1199,193,1240,1238,674,1720,1623,221,1550,1163,335,544,286,700;34;M
3947;544,434,440,539,1199,1720,780,1623,274,1240,221,1238,286,531,97;23;F
3957;250,650,274;24;F
3960;633,1234,1720,1623,274,250,897,1238,109,1075,894,573;62;M
3983;221,250,780,1623,1720,660,260,739,650,553,193,677,1016,274,897;43;F
4014;700;35;F
4017;1236,1240,1016,660,244,739,633;34;F
4022;1093;65;F
4066;1234,250,897,335,109,1075;32;M
4067;1623,780,1240,1288,544,109,1666,170,739,660,440,539,868,442,1016;45;F
4081;1221,244,1214,1217,739,660,553,567,1199,119,1623,1240,459,909,286;26;F
4092;650,626,660,539,567,1720,274,250,221,422,434,57;32;M
4093;1234,274;36;F
4095;169,553,180;50;M
4128;1234,337,1238,1288,1628,335,422,1075,1236,169,127,1550,97;27;M
4135;193,909,894,274;35;M
4137;274;41;M
4142;169;72;F
4150;1666,193,250;19;F
4178;739,442,440,1199,274,221,1238,335,109,1075,286,894,531,1699,1666;24;M
4190;1720,274,221,660,193,567,909,1217,1214,1221;46;M
4191;567,909;53;F
4219;1217,650,339,739,446,660,539,1199,1414,250,1075,894,531,1699,700;33;M
4259;274;28;M
4268;1217,55,739,553,539,567,1720,1623,422,459,57;40;M
4291;1199,567,539,660,260,339,650,685,1720,1041,1240,1238,925,1075,434;37;F
4307;1623,544,1699,1217,739,1221,660,539,1041,221,1550,461,180,909,286;73;M
4401;685;40;F
4411;459,57,446,1041,909,286,1238,1623,339,1666,221,170,321,1720,567;40;M
4444;180,286,1623,909,553,422,446,894,626,1628;36;M
4464;1214,446,674,567,1199,119,780,544,700,286,531;27;F
4567;739,170,55,337,1623,274,221,1217,461,553,57,909,286,180,422;43;F
4571;633,244,539,1199,193,1550,1238,286,339,442,677,250,1240,1699,1236;30;F
4617;1442,544,337,119,170,685,1199,1240,925,1163;35;M
4631;260,169,868,1550,925,544,422,109,286,1153;40;F
4639;422,180;65;F
4671;1214,1217,650,539,1381,1623,221,925,422,180,286,1221,626,660,553;46;F
4674;109,868,553,260,1221,1214,422,180;36;F
4700;1442;44;F
4702;553,539,1199,868,1623,780,925,909,57,180;45;F
4708;685;19;F
4709;685;10;M
4731;127,221,1550,544,286,531,700,1236,650,739,660,440,539,1623,1628;44;F
4735;260,660,1623,1240,1550,1163,109,1075,286,894,1442,553,1199,1016,335;45;F
4740;260,442,1199,1234,119,780,274,1238,925,1628,109,286,434,1666,1236;31;F
4746;1153,1666,544,1628,442,674,1238,925,700;66;F
4775;339,1221,660,442,119,1623,780,97,1628,321,1214,1238,925,422,286;31;F
4788;739,169,221,531,1720;33;M
4801;650,739,1199,780,1240,1238,1628,544,422,459,531,57;29;F
4825;180,286,109,894,531,170,339,739,660,440,868,119,1016,1238,544;22;F
4827;1628,1623,1381,1214,1149,780,674,553,544,459,446,97,57,700,1153;28;F
4844;685;36;F
4887;650,1214,1221,260,660,539,567,127,1240,221,1550,1628,544,109,1075;29;M
4892;193,1623,894,169;78;M
4904;170,339,1149,260,127,868,1550,925,1628,109,963,286,531;38;F
4944;660,677,780,1016,1240,221,1236;34;F
4956;553,422,180;40;F
4961;685,677;4;F
4979;553,1720,780,1238,180,1153;41;F
4983;1234,539,868,1623,221,925,1628,544,109,286,1666,442,119,1720,1153;76;F
4999;1628,544,286,1240,539,1442,739,1217,700,274,221,169,1720,626,909;30;M
5001;1381,626,1153,339,1149,446,544,97;45;F
5002;660,442,539,567,1234,1720,221,544,1666,1623,1238,925,1075,286,531;62;F
5019;170,894,1550,127,169;45;M
5029;553,868,337,1238,180,260,422;41;F
5071;553,109,180,1217,339,1214,1221,1199,897,1238,544,909,286,567,1720;33;F
5091;422,180;63;M
5099;868,119,337,925,422,180,1153;11;F
5127;739,660,539,1623,1550,544,286,531,57,321,1720,339;30;M
5130;193,1623,274,1240,221,1238,925,544,461,286,894,97,700,1666,1153;76;F
5139;685,650;51;M
5140;544;71;M
5175;1041,274,250,925,1236,650,739,1720,780,1016,244,1240,1623,677,685;41;F
5185;1699,531,286,1238,539,567,1016,274,1153,650,169,660,1720,1041,909;32;M
5197;660,739,633,170,894,169,127,868,1720,1550,1238,1288,1163,286;45;F
5200;626,633,1217,1214,1240,459,180,894,57,1699,553,1720,1414,925,422;47;F
5208;422,180;9;F
5225;169,660,127,1720,1550,531,286,1623;29;M
5229;1490,553,567,119,337,250,1238,925,335,422,109,461,1075,180;43;F
5232;422,180;2;F
5237;1217,1163,335,286,531,57,1666,1628,422,109,180,909,626,553,193;44;M
5240;274;59;F
5253;1163,109,459,739,260,169,660,440,539,119,1550,1238,422,286,531;38;M
5255;531,1153,170,339,1214,1199,1238,925,459,286,1666,544,674,700,1628;39;F
5258;685;9;M
5298;650,170,1720,1414,1623,780,221,544,154,286,894,531,422,339,1666;35;F
5299;127,677,337,1016,780,1240,221,97,633,544,1628,1550,1381,339,531;33;F
5306;573,868,1720,1414,1623,221,1238,335,286,434,925,1666;37;F
5328;685;44;F
5339;650,1217,169,660,440,539,193,1720,250,897,1550,925,1238,221,274;28;F
5350;339,442,539,1093,119,1720,1288;58;F
5361;660,442,1041,1288,544,180,221,286,1666,1699;40;F
5370;739,1075,1153,461,1149,1288,780,544,337,440,446,339,1381,925,97;44;F
5378;685;41;F
5379;567,55,909,250,274;25;M
5391;193,1720,780,1016,1550,544,286,531;37;M
5401;1623,925,274;36;M
5459;660,193,127,274,700,567,539,739,1217,1041,1720,55,650,1016,626;33;M
5468;539,868,337,1720,925,544,286,531,97,700,440;38;F
5470;1217,553,544,422,180;48;M
5473;1240,250,1016,1720,193,539,440,553,660,1442,169,260,739,422,1075;44;F
5477;780,1720,677,1623,154;52;M
5481;1238,739,660,539,1199,1623,440,221;47;F
5484;1550,221,286,531,1236,650,739,626,660,539,1623,274,250,1240,909;29;M
5486;119,337,780,1623,274;39;F
5489;677,539,169,244,739,633,55,685,660,440,897,221,544,1720,531;31;M
5495;260,1623,1240,109,1075;41;F
5503;1628,422,1666,1238,1214,260,539,700,739,567,250,897,544,909,434;25;M
5516;440,539,868,1720,1240,221,1550,1238,1628,544,422,180,286,531,434;43;M
5530;539,868,337,1720,1623,1550,1238,422,544,531,221,1163,286,321,1666;42;F
5543;57,1217,660,440,897,925,909,286,1381,1093,868,119,337,1623,274;43;F
5544;544,1623,660,739,1217,440,1199,1720,221,286;29;F
5575;274;32;M
5582;1153,1234,553,1221,739,339,567,868,925,422,909;38;F
5594;674,868,119,1720,1238,1628,544,531,286,700,1153;46;F
5606;626,700,422,539,567,909;27;M
5619;650,127,1623,1240,897,221,1238,1628,154,286,677,274;32;F
5622;286,909,1628,567,660;41;M
5627;461,169;70;M
5649;1163,544,286,169;57;M
5656;170,633,660,1381,1093,337,274,925,963,1075,286,434,97,1238,1199;26;M
5659;780,221,1238,544,459,286,1236,739,1163;47;M
5665;440,274,1240,1238,544,422,154,459,57,1236,339,660,539,1720,221;33;F
5671;127,1720,1550,169,1623,925,1163,1075,286,894,531,739,1214,170,260;40;F
5689;169;76;M
5695;1221,1217,169,1720,1238,544,109,1075,434,1699;38;F
5701;170,1217,739,169,660,539,1623,221,1550,1163,544,286,531,321,1236;30;M
5724;685,650;47;F
5726;660,440,539,1199,1720,1623,780,1016,221,1550,1238,544,286,531,57;32;M
5743;127,1153;44;F
5757;274,1217,567,1720,1041,422,180;45;M
5767;685;49;F
5800;660,553,539,567,193,337,1623,780,274,1238,335,459,963,909,286;26;F
5803;633,1199,1234,780,1016,1240,109,1236;44;F
5806;169,127,1623,1550;45;M
5825;1199,650,700,674,567,1623,274,1240,434,1720,250,897,925,544,909;24;F
5833;1041,1240,1699,1666,650,739,1221,660,442,539,1238,434,567,909,897;39;F
5834;573,1199,868,119,1720,1623,1016,1240,221,1238,544,422,286;34;F
5849;739,446,260,660,539,193,1234,868,119,1720,1623,274,221,925,286;36;F
5862;1628,1623,446,260,127,544,531,434,440,660,868,221,1238,925,286;35;F
5866;685;42;F
5871;127;73;F
5916;1720,677,1016,1240,221,1238,963,1075,286,894,685;41;F
5919;127;50;F
5921;660,626,446,868,180;45;M
5944;1699,700,1236,1217,650,339,1221,660,1199,1381,274,221,286,180,1153;31;F
5955;1623,780,1016,274,250,286,963,925;43;F
5958;685;43;M
5960;170,633,339,1199,1381,868,1720,1240,1550,1238,925,544,894;26;F
5968;660,539,1199,1623,1628,459,57,1666,1238;37;F
5996;339,739,244,1442,573,539,1234,119,337,1720,1016,1238,925,1163,109;47;F
6036;244,739,780,1240,1236;36;M
6039;1442,544;37;F
6052;440,539,567,1720,250,1628,544,459,963,180,894,57,553,780,925;35;F
6056;1414,1236,1666,1628,1238,1550,339,739,539,1623,544;26;F
6073;685,170,1720,221,1550,1163;44;F
6101;531,660,539,434,57,739,260,1199,1720,677,780,1016,1240,963,685;44;F
6103;539,250,1240,221,1550,286,739;31;M
6125;274,57,1093,868,442,567,539,119,1221,1075,1720,1217,909,1238,1214;38;M
6129;739,685,650,442,1199,1041,274,897,925,422,154;29;F
6137;180;46;F
6152;700,1217,739,446,260,660,440,539,567,1623,221,1628,544,109,1153;33;F
6176;685;48;F
6195;1217,633,339,739,169,660,440,539,1199,1720,1238,221,1623,531,286;43;F
6200;739,567,1199,1720,780,221,925,544,154,459,909,286,531,1699,1236;26;F
6220;1163,894,685;43;F
6233;650,739,1238,925,274,1442,660,539,567,1720,1623,897,459,909,57;26;M
6249;909,544,739,626,660,1623,221;21;M
6267;1041;44;M
6297;422,459,286,1666,1236,57,260,244,739,633,1199,677,780,1240,925;44;F
6322;1550,1238,1628,422,286,539,660,650,1217,626,442,1199,127,1720,909;58;F
6352;660,260,442,1199,677,1240,221,1238,1163,109,286;63;F
6356;170,739,1442,440,573,539,1381,1720,1623,1550,544,531;32;F
6359;894,55,650,660,1199,1234,868,780,1240,897,1628,739,626,1238,925;52;M
6363;685;41;F
6373;925,1163,286,894,57,1699,1666,442,1199,1720,780,1016,1240,221,1550;68;M
6374;250,1623,660,169;38;F
6390;193,674,1550,925,286,97,700;39;M
6397;274;49;M
6398;1236,286,1238,1623,440,739,660,539,1720,1016,221;45;F
6399;963,894,626,1236,685,286;46;F
6403;1041,1720,1623,567,685,739,1234,250,1240,925,109,963,1075,434;19;F
6406;1217,739,660,440,539,1720,677,1623,1240,221,1550,544,286,531,1236;42;M
6411;57,1699,1666,1236,1153,1199,1720,221,1550,1238,1163,544,109,1075,286;36;M
6413;422,685,633,339,739,244,1199,193,1720,1016,1240,1238,1163,544,109;9;F
6421;422,180;40;F
6437;660,739,650,274,1153;40;M
6438;544,422,1075,286,244,739,633,170,1442,660,1199,1240,1550,109,963;45;F
6452;170,660,544,109;48;M
6490;244,1214,339,1217,739,660,539,1720,1240,221,1238,1628,286,531,57;30;F
6516;1623,1720,1381,1199,539,440,339,739,660,221,1550,1238,544,286,531;26;F
6529;739,1149,1490,339,170,685,925,544,1236,260,660,1234,1414,1623,1238;14;F
6533;1217,57,55,626,674,539,1199,119,780,1240,1238,544,286,1153,700;29;M
6536;180;44;M
6537;260,573,633,244,1199,119,1381,677,1623,1236,739,660,868,925,1238;30;F
6539;739,660,553,567,1016,1240,925,1628,422,909,260,539,868,274,109;43;F
6543;55,339,1221,193,1016,544;66;M
6548;633,650,685,1236,1240,221,250,1623,1720,539,440,660,169,1217,739;48;F
6560;650,1217,739,660,442,677,1623,250,1628,544,286,434,57,1666;36;F
6590;544,422,180,434,127,446,221,1720,1623,674,700,626,1628,286,1153;38;F
6622;650,567,250,221,1238,1628,286,274;36;M
6629;1720,539,660,260,442,868,119,780,221,1163,544,109,286,531,1666;51;F
6660;274;39;M
6690;260,446,1490,339,674,868,119,337,1720,1238,544,109,1075,97,700;50;M
6697;925,1628;38;M
6703;1550,544,685,154,531,97,321,244,1240,1238,109,963,1075,286,1236;46;F
6708;119,1234,260,685,739,660,442,539,1199,1720,1016,1240,1238,1236,1666;28;F
6719;963;38;M
6774;446,739,1490,650,894;36;M
6775;1236,1550,1240,739,660,440,1720,1016,1623,780;32;M
6810;925,685,119,1153;39;F
6816;1442,1199,193,1414,274,1238,925,1163,544;47;F
6834;1628,109,531,1414,1623,1016,1236,1199,739,650,1240,221,1238,909,286;33;F
6844;55,650,1720,1240,434,274;28;M
6867;1442;42;M
6873;1720,1240,422,109,739,660,1199,1623,780,221,1238,1628,286,894,1236;40;F
6918;260,244,633,685,739,442,337,1623,274,1240,180,286,1236;47;F
6932;434,925;28;F
6942;1238,335,544,422;38;F
6943;250;70;F
6953;440,660,244,633,739,1720,780,1016,1240,1236;46;F
6957;274,221,1288,544,422,459,286,57,700,531,894,1381,897,1550,925;30;F
6971;626,1550,1628;31;M
6983;700,169,440,250,1240,1699,650,1217,739,660,539,567,221,1628,286;35;F
6988;633,57,739,260,626,660,539,567,221,1628,109,459,909,286,894;54;F
7008;674,700;72;M
7022;739,660,539,909,286,434,1666,567,1628,1199,1623,1238,221,1414,1720;25;F
7023;685,170,1550,1628,335,422,1075,286,97,57;45;F
7025;780,544,925,1236,685,650,660,1199,1163,739,1720,677,1623,1240,154;16;M
7041;1623,109,925,1199,739,1234,442,260,660,1550;62;F
7056;169,650,1217,1149,739,260,626,1442,660,1720,221,1628,109,909,286;20;M
7066;1720,1623,221,109,1075,909,286,1666,567,539,660,260,1221,739,1153;41;F
7081;650,193,127,1234,897,1550,335,422,531,434,57,925,1623,633,274;44;M
7092;446,739,1217,685,1238,1720,544,531,434,170,1163,1214,440,1628,169;39;M
7102;739;50;F
7111;274;47;M
7116;97,286,909,459,544,274,1623,868,739,442,567,193,337,1720,1238;21;F
7120;1149,573,337,677,1414,1016,335,154,109,1075,894,321,57,1666,909;29;F
7160;660,440,119,1414,1623,221,1238,925,544,422,459,286;37;F
7174;1199,780,963,193,650,660,440,1623,1236,1016,739,685,1720,677,1240;64;F
7193;1623,286,1699,685,650,660,539,274,250,1240,897,925;37;F
7194;1238,221,780,1623,677,868,193,685;46;F
7209;544,1550,626,1628;34;F
7210;109,1550,739,660,440,539,1234,260,1075,1236;56;F
7241;674,193,1720,897,1238,1163,700;47;F
7281;685;45;F
7290;660,539,1041,1623,274,250,1240,1550,925,963,1699,685,739,1720,677;37;M
7316;539,739,244,685,1490,660,573,868,119,1720,1240,1238,925,544,422;5;F
7318;1442;55;M
7325;897,274,1666,221,1238,1236,1623,286,1153,446,544;36;F
7338;650,685,1240,897,1550,1238,925,1628,963,1666,1236,1442,244,440,567;51;F
7355;626,169,660,440,539,127,1623,1016,274,1240,221,1236,739,286,531;31;F
7369;780,1217,633,739,660,440,1199,1381,1623,1240,221,1238,1163,1075,286;30;M
7378;1199,1623,780,1016,1240,1550,1288,1238,154,894;39;F
7388;422,180;42;M
7404;539,1623,422,180;12;M
7414;339,1199,1381,1234,1093,119,337,1720,1414,897,221,1238,925,1163,700;18;F
7426;925,434,1075,963,1041;35;F
7431;626,739,1149,660,539,1381,925,97,1628;38;F
7483;780,1240,1238,422,286,57,97,685;40;F
7490;1199,1234,1240,1238;38;F
7527;274,221,1550,1238,1163,700,339,633,170,1720,1628,544,286,1153,97;25;F
7533;650,1217,626,442,1623,250,274,909,286;23;F
7551;57,434,1666,567,1550,539,440,660,739,1720,221,1238,925,544,286;46;F
7577;440,685;45;M
7580;339,260,626,660,553,440,539,868,1628,544,109,1075;32;F
7596;1381,626,1628;34;M
7599;1217,244,739,1221,169,660,440,442,539,1016,1240,221,1163,286,531;46;F
7622;660,1217,650,539,193,274;39;M
7638;650,626,1623,1016,567,897,1628,335,909;35;M
7640;1628,925,868,422,442,459,446,553,193,1381,337,1550,1238,544,461;41;F
7653;440,193,868,119,337,109,1075,180;39;F
7661;339,446,1381,119,221,1238,925,1628,335,286,1149,260,544,97,1153;36;F
7664;925,434;47;F
7670;739,553,440,567,1720,1414,335,544,109,1075,180,909,286,531,97;51;F
7682;1149,626,1442,553,868,119,925,335,422,180,1153;51;M
7707;539,739,1199,193,1720,780,221,1550,1238,1163,1628,544,286,700,1666;32;F
7717;739,1720,1623,1550;22;F
7733;1217,660,221,422,459,739,626,553,1628,180;46;F
7759;1240,440,660,169,739,633,650,1217,1221,567,1199,1720,1623,897,909;86;F
7785;739,660,539,1623,780,1240,221,1628,544,459,909,286,321;39;M
7831;1234,337,925,286,434;12;M
7856;55,739,539,1199,193,1720,1414,1623,1238,109,1075,909,286,57;63;M
7869;1149,1221,626,440,539,193,127;50;M
7871;440,539,193,897,1153,286,963,274,1149,127;48;F
7880;169,868,1550,925;34;F
7883;739,1217,539,193,1623,274,1240,221,925,109,286;24;F
7899;700;69;M
7908;650,446,442,193,1628,337,221,286,894,97,1666,1236;76;F
7926;660,260,739,339,553,193,1720,1238,925,422,1075,180,909;48;M
7939;685;6;M
7949;685;66;F
7956;97,539,573;39;M
7977;422,193,1720,894,925,1163,97;53;M
7978;286,1628,221,1016,1623,1720,337,868,539,573,440,660,1217,739,1236;47;M
7992;700,1153,660,1238,286,1236,1163,221,1240,674,739,1149;36;M
7996;660,739,440,539,193,1093,119,1623,780,1240,221,1238,544,286,894;27;F
8003;626,1628;48;F
8025;1153,660,440,1623,1720,1550,221,286,544,446,97,1149,1628,674,700;34;M
8039;274;28;F
8072;650,739,626,1720,221,1550,1623,422;41;M
8136;1016,250,897,1550,1288,1628,335,422,154,963,1075,531,1699,1236,286;33;F
8137;539,337,1720,1414,1623,221,1238,544,109,286,700,739,1381,531,321;39;F
8143;700,674,1628;38;M
8157;626,567,250,897,1628,434;31;F
8181;531,539,567,1720,1623,780,221,1238,1288,544,109,459,286,97,700;35;F
8219;539,127,1720,1414,1623,780,274,221,1550,109,422,1236,1238,925,1163;13;F
8227;925,1236,286,1238,1720,1163,1623,127,170,1414,1550,169,109,894,1666;36;F
8230;739,660,539,567,422,553,193,1381,1720,1163,1075,909,894,57;40;M
8248;440,274,250,57,459,780;30;M
8261;459,193,461,440,1628,286,739,626,660,553,539,1720,1623,1238,925;44;F
8287;127,1623,286,567,909,897;20;M
8302;539,1720,677,1016,422,894,739,244,1199,193,780,1240,1550,1163,1236;36;M
8314;539,442,660,739,650,685,170,260,1442,274,1240,925,109,286,894;46;F
8346;221,650,739,660,440,539,193,1720,1623,1163,894;64;F
8362;446,442,260,544,109,97,1153;68;F
8373;677;65;M
8375;1199,440,739,660,539,1720,1623,780,1016,1240,1236;49;F
8406;674,660,440,539,567;52;F
8413;660,633,170,169,1199,127,1720,1623,1550,1238,1163,286,894,531,1236;49;F
8425;127;24;M
8431;925,434;44;F
8440;739,660,539,544,553,567,897,221,1550,925,1628,909,286,1236;37;F
8460;553,193,626,337,180,894;40;F
8462;739,539,1623,1240,221,154;36;M
8473;1217,660,440,1623,274,780,1016,221,1238,335,422,459,180,286,57;39;F
8478;1217,567,909,894;32;M
8494;170,55,1720,780,274,1550,925,963,286,531,57,127,169;44;F
8508;650,274,897;31;F
8525;170,633,1217,660,1623,274,250,1240,909,531;46;M
8540;337,677,1623,274,1240,221,925,459,685,286,57;36;F
8550;539,221,459,461,1234,422,909,286,337,1238,260,626,868,1623,109;41;F
8552;442,626,1490,339,633,539,1720,1238,544,422,660,1623,221,925,286;37;F
8557;1199,567,539,573,442,440,169,1221,446,739,1490,339,1217,633,685;46;F
8564;925,1238,221,1623,1720,119,193,1199,539,660,260,633,739,339,1699;49;F
8570;650,170,739,660,868,1720,422,894;47;M
8638;1623,440,626,244,633,544,286,531,1217,739,539,1720,221,1550,1236;66;F
8658;567,739,1720,1236,193,1199,1414,677,1016,274,1240,1238,154;34;F
8672;339,169,442,127,221,1238,544,109,286,531;30;F
8691;244,1442,1016,459,286,531,1236,1699,633,660,539,1199,1623,250,221;50;F
8704;260,868,677,925,685,1238,963,1236;42;F
8710;1550,1238,894,1236,539,739,1217,260,660,440,1720,1623,221,286,531;55;F
8715;260,109;50;F
8734;1199,567,442,660,339,170,55,539,1381,337,677,1016,1240,1550,286;29;F
8737;1214,260,660,193,925,461,553,180;62;F
8754;539;63;F
8761;925,1163,1628,544,422,109,1236,739,539,1199,1720,1414,780,1550,1238;29;F
8769;660,440,539,119,1238,286,739,567,1234,274,1240,221,1628,544;36;F
8789;1623,1240,1628,335,544,1075,700,442,539,127,337,1238,422,109,894;43;F
8801;739,660,260,1199,780,1238,1442,109;37;F
8816;169,660,1199,440,1234,221,1288,1238,1628,109,286,1550,339,170,127;33;F
8821;1240,260,1238,780,1236,1720,677,685,57,1153;46;M
8830;1214,339,650,1217,260,660,553,539,1199,193,1720,221,925,180,286;62;F
8843;422,180;45;F
8846;739,660,1199,1720,274,897,221,1238,925,1628,544,286,434,531,97;25;M
8851;531;78;M
8881;1699,1093,274,909,567,897;23;M
8891;650,660,909,274,221;40;F
8906;739,626,660,440,539,567,221,544;31;M
8913;1217,339,539,567,1199,119,1720,274,1288,925,909;45;F
8916;1016,1623,539,440,660,674,170,650,169,1550,1163,286,894,531,1699;33;F
8926;260,1153,660,193,1234,1093,1720,1623,274,221,1550,544,286,434,1199;34;F
8948;626,1199,1234,1720,286;43;F
8952;685,1238,422,109,286;44;F
8995;1016,1623,1720,440,674,446,321,170,55,660,539,193,221,544,286;32;M
9034;119,1490,626;34;F
9039;169,650,633,1217,739,660,539,1628,286,221;50;M
9044;1199,868,1623,780,1240,897,221,925,459,963,286,531,57,1699,1236;27;F
9057;1016,1240,1238,1699,1666,1236,739,660,539,1623,221,1550,544,286,531;53;F
9061;337,1720,1623,780,221,1628,422,459,909,286,894,339,1490,626,1238;40;F
9075;1149,1221,674,660,440,539,221,1628,97,700,1153,1199,544,286;38;F
9101;55;16;M
9104;660,440,868,739,442,539,1199,119,337,1720,1238,1628,335,544,1666;38;F
9114;1238,1628,894,422,544,1623,440,1442,739,660,1199,127,1550,925;37;M
9123;531,660,260,739,633,442,1234,221,1238,925,286,1666,1199,1720,544;40;F
9133;685;38;F
9134;626,539,250,1240;35;F
9150;685;23;F
9158;97,180,1238,1550,337,553,446,339,739,169,127,544,286,531;35;F
9162;894,321,739,660,440,442,1623,221,1550,1628,544,909,57,531,286;53;M
9167;1699,1666,1236,1217,169,1442,660,1041,274,897,221,1238,925,286,434;41;F
9174;650,1217,626,660,553,567,1199,193,274,897,1550,1288,925,180;41;F
9175;1221,274,650,925,422,434;39;F
9188;1414,1623,1720,337,1199,170,1217,1214,169,127,1550,1628;46;F
9208;674,660,221,544;35;F
9227;339,1217,685,1234;37;F
9237;909,531,434,1666,221,1720,1199,567,539,442,660,553,1238,1288,286;29;F
9253;250,1199,193,1720,1623,274;33;F
9271;739,660,440,539;31;F
9285;567,1217,1240,1163,1550,544,674,700,1628,127,1623,286,1720,221,321;34;M
9287;119,868,567,539,339,1238,442,1720,1041,1623,221,925,109,909,1666;32;F
9288;274;35;M
9304;1221,169,674,539,119,1720,1238,531,660,440,1623,221,1550,544,286;28;M
9306;440,660,321;35;M
9316;739,169,674,660,440,539,193,1720,1623,274,221,1238,544,963,286;36;F
9363;780,1623,539,553,339,739,337,1628,1153;37;F
9386;685,739,244,660,539,1199,1720,677,780,1623,1240,221,286,1236;50;F
9403;1221,260,1720,1238,925,909,1214,422,553,109,1075,567;34;F
9441;963,897,677,244,440,127,1623,780,909,650,1628,894,1217,1214,567;46;F
9470;685;34;F
9503;660,260,446,1149,339,1490,674,868,221,1238,925,335,544,109,700;35;F
9509;1666,573,442,660,260,1199,193,1234,1720,221,1238,1163,1075,286,1623;39;F
9513;539,1199,1234,1623,780,274,1240,1628,909,286,1666,1217,1720,221,544;25;F
9545;685;8;F
9550;1221,1442,97,739,660,440,1720,780,925,1628,422,286;50;M
9553;1217,739,660,1016;30;F
9555;193,1016,221,925,544,154,286;26;M
9562;339,739,539,1199,119,1720,1238,531;28;F
9573;422,97,1149,446,1442,337,780,925,1623,221,286;39;M
9580;442,539,567,1199,1234,1093,1623,1075,531,1720,221,1550,1238,544,1666;35;F
9581;739,539,274;34;F
9584;1238,573,685;43;F
9591;739,660,553,868,1240,97,1623,109,894,1199,780,925,544;41;F
9601;170,1199,868,119,780,1016,1550,1238,925,335,544,109,963,1075,894;40;F
9610;685;6;M
9617;1381,539,440,660,674,739,633,1199,193,1720,221,1238,925,544,286;40;F
9663;553,897,567,57,1221,1720,894,250,909,650,1217,868,1699,1041,274;30;F
9665;685;37;M
9667;440,337,780,1240,925,963,739,274,250,685;41;F
9684;739,660,539,1199,337,1720,1623,1699,170,335,180,567,274,221,1238;27;F
9685;1381,739,633,1414,780,1628,531,1199,1720,1623,1016,1240,1550,1238,1236;46;F
9696;1234,1075,1153,1217,1199,1381,1163,1628,1720,1623,1016,1240,1550,1238,1236;19;F
9734;180;41;M
9740;909,180,1628,567,739,685;36;M
9757;1234,868,1720,1623,780,897,544,335,422,109,1075,286,97,700,1153;38;F
9775;339,739,1720,1623,286;22;F
9778;685;42;M
9780;685,1238,1699,244,660,440,221,1628,286,531,1550,250,1720,539,739;22;F
9833;1199,868,119,1041,897,1238,925,459,286;31;F
9834;339,446,119,573,868,1720,780,1550,1238,1628,335,544,422,531,57;41;F
9849;193,1623,780,57,539,440,660,626,633,1041,1720,739,897,422,909;20;F
9875;1623,633,739,539,1720,1016,1240,221,1550,109,459,1075,286,57,1236;49;F
9878;660,440,119,1720,677,1623,109,286,739,244,539,1016,1240,1550,1236;37;M
9889;1016,531,1236,544,461,244,260,193,109,1666,1240,1163,286;49;M
9912;193,1623,1016,1240,1163,422,109,286,1236;15;M
9921;260,97,1153,674;41;F
9925;660,1720,780,221,1628,286,531,57,1623,1550,1163;50;M
9930;244,1221,321,1236,544,1217,440,539,1720,739,446,660,221,286,531;28;M
9938;260,739,660,539,1234,868,1720,1016,250,1240,221,1238,286;47;F
9965;97,650,339,1221,1623,780,1016,1240,221,567,193,1628,180,57,1236;49;F
9998;925,1163,1236,685,170,739,440,539,1199,1720,1623,1016,1240,221,286;32;M
10023;170,1442,193,868,119,337,1238,1628,335,422,461,180,1666,286,127;28;M
10028;660,553,440,221,909,531,286,700,1240,567,539,674,1221,1214,1217;48;M
10049;633,660,539,1381,221,909,286,1699,650,169,440,739,1720,1623,274;41;F
10060;1240,1550,1666,553,1163,1623,1720,286,260,193,1199,1238,1288,925,109;42;F
10068;685,1720,1288,221,1238,1163,544,286,700,1236,442,553;49;F
10075;1238,739,221,286,894;37;M
10097;674,539,567,1720,1236,221,1550,1238,335,544,1075,286,531,321,700;30;F
10108;1442,1199,739,1490,260,626,553,539,868,1720,221,1238,109,180,286;35;F
10130;868;37;F
10137;127,1628,539,626,1623,650,739,660,440,274,221,286,567,894,1720;27;F
10138;1163,335,461,180,286,894,1236,221,1240,1016,868,1381,553,1217,193;24;M
10150;274;39;M
10155;685,626,119,868,780,274,221,1238,1628,109,459,963,286,57,1236;13;F
10168;339,169,1623,544,1666;44;F
10187;170,260,1199,1234,1720,1623,221,544,109,286,1236;40;F
10192;1234,1381,539,260,244,739,626,442,1199,127,677,1623,154,459,1075;24;F
10208;650,339,119,1623,221,925,335,544,109,97,1666,1199,1381,1238;31;F
10232;1381,1666,1217,739,660,440,539,1720,1623,221,1550,1238,1628,544,286;38;F
10243;260,539,440,573,1234,119,1414,780,925,1628,544,422,434,57,1236;22;M
10268;1236,286,660,539;54;M
10313;1217,739,626,553,539,1093,1720,780,1628,544,180,57;56;F
10330;1199,440,1442,446,1623,221,1238,925,544,286,531,739,169,1550,1628;34;F
10354;1234,868,221,925,544;35;F
10411;780,1238,925,1075,894,700,1153,1149,553,1623,1628,544;40;M
10424;1217,739,626,660,440,539,1623,1016,274,1240,221,286,1699,700,1236;41;F
10437;739,626,169,660,440,539,1623,250,1240,221,1550,286,531,434,321;20;M
10454;739,1240,897,544,422,894,1236,339,1490,1442,573,119,1550,1238,925;37;M
10462;1623,897,335,650,868,1016,250,1240,221,925,1163,109,286,434,1236;44;M
10463;1149,55,274;28;M
10484;1623,1163,286,894;52;M
10488;660;37;F
10498;650,685,674,440,539,193,1720,221,1238,925,1628,544,422,97,700;32;F
10501;260,553,1238,539,127,868,119,337,1016,1240,221,1550,925,422,109;41;F
10526;1550,925,544,422,180,894,1666,260,1234,1093,868,1720,1238,109,1075;49;F
10531;1240,1550,894,434,1236,660,1041,1623,274,250,221,1217,539,909,567;25;M
10564;1240,544,1149,286,1238,739,260,660,442,1199,1720,221,109,1075,1666;15;F
10631;1238,1628,335,109,286,531,97,170,169,127,868,119,1550,1163,544;43;F
10662;1442,442,1623,780,1550,221,286,1666,1236,1628;39;M
10690;1623,780,1016,1240,335,544,1075,1666,193,442,1381,1234,1238,422,154;32;F
10743;1217,626,567,193,221,459,180,553;33;M
10778;244,1041,1623,897,1666,868,260,440,109,461,1075;67;F
10799;422;76;M
10804;339,440,573,539,1381,337,1041,567,1720,221,1238,422,286,57,909;35;M
10849;169,650,739,660,440,567,539,1720,274,221,1238,1075,109,180,286;25;F
10854;446,1236,221,154,650,544,274,674,700,1153,1720,286,1623,127,1628;29;M
10855;1550,925,422;10;F
10918;55,650,170,1217,739,660,539,567,1720,897,221,1550,544,909,1628;42;M
10925;633,739,169,440,539,286,660,127,1720,1623,221,1550,1628,544,531;46;M
10928;1550,109,909,321,57,221,286,531,1623,1236,739,660,193,1720,544;19;M
10938;739,660,1240,1550,1163;37;M
10989;446,1550,339,1623,286,1628,1153,1149,97,221,700,674,544;38;F
10990;909,1720,660,1217,1221,260,567,1623,1075,109;72;F
11001;170,685,650,193,1381,127,1720,1240,1550,925,1163,1628,544,461,531;43;F
11041;286,1236,1217,739,169,660,440,539,567,193;35;F
11049;1490,1288,440,442,539,1199,119,1414,1623,1240,897,221,1238,531,1666;24;F
11083;422,925,1240,1623,1381,442,260,739,660,1016,1238,109,1075,1236,1550;62;F
11101;1217,660,221,422,1234,1016,1623,1240,1236,286,1550,1238,1628;21;F
11102;260,1016,286,1623,221,440,660,739,539,1720,1240,1550,422,109,1075;40;F
11109;539,1381,1720,1414,1623,250,221,1238,544,422,109,650,1234,274,1163;45;F
11113;337,1041,1016,274,925,57,1720,677,1623,780,1240,897,221,286,154;33;M
11150;739,260,250,109,286,440,573,1381,1093,1238,544,1075,442,1720,1666;25;F
11159;1623,925;36;M
11178;1163,544,459,180,286,739,660,567,193,1720,1623,897,221,1238,909;28;M
11183;894,1288,1550,1623,1381,1442,1234,1720,1414,1238,1628,109,963,531,1699;20;M
11194;1214,650,674,553,567,127,909,1153,446,544,169,531,286,626,1628;38;M
11207;1490,739,260,169,1442,127,1550,925,1163,544,422,1075,286,894,531;41;F
11211;180,97,1628,626;32;M
11214;894,909,567,897;27;F
11228;1041,1217,739,660,440,567,539,274,221,925,909,286,531,434,1699;29;F
11246;1381,1442,626,1221,739,677,1623,1016,1240,221,1238,925,154,1075,286;47;F
11252;567,544,539,739,660,440,1623,221,286,180,57,1217,553,193,1720;44;F
11262;180,422,1288,1199,739,567,553,909;57;M
11266;1153,274,626,169,1550,1236,544,1163,700,674,1628,531,286,221,321;37;M
11278;1238,1628,544,1075;24;M
11291;739,660,440,539,1720;39;M
11300;446,1199,337,1720,1238,335,544,461,1075,286,531,434;47;F
11302;539,169,739,660,440,1199,1414,780,221,1238,544,286,531,321,700;39;M
11304;154,180,1442,440,442,573,1720,1238,909,286,1666,260,739,1490,633;19;F
11311;650,868,274,1163,286,127,1238,1236,739,660;49;M
11315;660,1442,169,260,244,739,1217,633,685,1623,193,677,1240,1238,1236;33;F
11316;169,1381,127,1623,221,1628,544,894,1234,1550,286,531;45;F
11325;539,337,677,1041,1623,1016,250,1240,221,335,154;47;M
11327;339,1666,169,1550,1238,1199,286,1623,1490,1720,1163;35;F
11339;260,442,1381,868,119,1720,925,544,109,97,700,1666,1149,446,674;39;F
11347;660,531,539,567,1623,1240,221,1550,1628,422,963,286,321,169,127;21;M
11364;1221,169,286,633,739,660,440,539,274,1240,221,531,434,700,1236;29;F
11378;1720,685,274,286,544,221,567,1628,739,244,660,1016,1240,1550,1236;28;M
11388;539,567,1093,119,337,1720,1414,1623,221,1238,1288,335,422,109,1666;27;F
11399;780,1016,221,544,97,1236,650,674,1720,1240,1550,1163,1628,286,700;28;F
11423;894,897,1720,1199,169,1217,650,55,660,440,539,567,221,286,909;36;M
11475;180;18;F
11479;339,573,337,221,1550,1238,925,1628,544,180,909,286,434,97;21;M
11490;1720,434,700,1149,1623,1238,221,97,1153;38;M
11496;780,1623,260,244,739,660,868,1720,1240,925,286,1236;42;M
11545;1628,1153;42;M
11588;544,1153;57;M
11607;544;48;M
11631;221,925,459,57,1234,1720,1550,286,1236,677,1623,780,422,1041,1442;44;F
11634;169,1153;47;M
11641;1214,1217,685,739,553,539,337,422,909,1221,660,1720,221,286;43;F
11663;1016,1550,544,57,539,660,739,1720,780,1240,1628,459;57;F
11680;567,193,897,1238,544,909,1153;26;F
11688;97,1238,1381,1442,446,739,1214,339,1490,260,868,422,335,925,963;33;F
11690;685,633,626,553,868,1720,1238,925,335,422,180;38;F
11745;1442,1490,339,119,1238,422,286,1236,1666;27;F
11765;440,1234,1199,1623,1240,250;24;F
11771;539,780,180,434,1699,1153;31;F
11822;221;34;M
11859;685,1238;42;F
11865;660,1217,55,193,221,531,440,1720,1550,1628,544,909,286,57,1153;21;M
11867;1666,1075,57,250,1238,109,660,1199,193,1623,553,925,180,1699,1153;48;F
11887;544;41;M
11902;567;44;F
11903;1217,446,660,221,553,1381,1238,97,868,1720,422,459,109,894,1628;44;F
11925;739,1217,650,660,539,1199,1234,868,119,1623,274,221,422,286,894;35;F
11930;626,553,539,1199,1381,119,274,1550,925,1075,909,434,97,57,1153;30;F
11931;1199,274,1236,1666,57,286,221,1240,1623,677,1720,660,685;71;F
12002;170,1234,868,337,739,221,1550,1288,925,963,286,1016,660,1442,260;39;F
12006;244,1163,1236,633,739,660,440,539,193,1720,1016,1240,221,1550,286;49;F
12051;244,868,1623,422,1240,925,963,1236,685,650,660,1720,780,274,1041;42;M
12058;1666,244,660,119,1720,1016,1240,544,286;41;F
12064;780,1381,567,539,440,553,660,633,650,446,1720,1623,544,286,57;47;F
12066;544,1381,739,339,55,170,260,1234,1623,1240,221,925,109,1236,1199;35;F
12074;925,739,244,660,440,539,1720,1623,1016,1240,221,1550,544,286,1236;39;F
12095;440;49;M
12102;119,221,1238,1288,925,1163,335,286,170,868,1550,1628,109,1075,894;33;M
12114;1236,1550,250,1199,440,633,677,244,539,1720,274,221,109,531,286;56;F
12127;1221,221,1628,531,1236,250,1623,1041,193,567,539,660,626,739,650;43;M
12130;925,434;42;F
12131;868,337,1720,1016,1240,221,1238,335,544,1075,286,531,1236,1442,1550;34;F
12146;1234,1623,422,739,260,1720,1041,221,1238,925,109,1075,286,434,57;45;M
12156;119,434,260,868,1238,109;33;F
12167;339,739,539,567,1628,544,1666;45;F
12194;339,260,1075,57,221,925,434;42;F
12223;553,422,1720,180;38;M
12241;1234,1093,1238,109,531,97,660,553,193,1623,925,286,440,1628,422;46;M
12266;1236,685,170,633,244,1442,539,1199,1720,1623,780,1016,1240,221,1550;53;M
12282;674,1720,544,700;50;F
12306;739,626,660,193,1623,221,925,1628,286;35;M
12312;1240,1550,925,1628,1075,97,1666,1720,221,1238,335,544,109,286,321;35;F
12314;567,1240,274,1199,446,739,626,660,440,539,1623,221,1628,286,434;30;F
12325;446,626,674,660,440,1199,127,1414,1623,544,109,459,1075,286,700;42;F
12334;1234,1720,1240,1288,1628,1666,1236,531,286,739,539,1199,221,1550,1238;26;F
12347;685,1153,442,739,339,677,1016,1240,897,925,335,154,1075,57,1236;48;F
12376;626,739,170,650,193,677,1623,1016,1240,1550,1628,963,180,909,286;29;M
12425;260,897,221,109,180,286;36;M
12434;674,1153,700;38;M
12443;544;51;M
12444;553,567,1199,119,1550,925,544,422,180;35;F
12474;660,868,925,544,97,626;51;M
12484;700,57,531,446,1217,650,1490,626,660,553,868,1238,1628,335,286;37;F
12485;1041,260,1234,531,286,1628,274,1016,539,169,660,440,1238,909,1093;35;F
12500;925,434;47;F
12517;925;43;F
12550;422,544,335,119,868,1381,1199,339,685;25;F
12581;1214,260,660,553,442,567,119,1720,221,1238,109,180,909,286,1666;62;F
12609;1381,1153,700,909,544,1628,221,1240,1016,193,1199,660,674,1442,626;40;M
12616;925,434;44;M
12621;1381,193,1199,567,539,442,553,660,1442,169,739,1214,1217,1666,677;43;F
12647;1550;25;M
12650;422,459,169,539,1623,780,1016,274,1240,221,1550,700,567,1628,909;40;M
12697;1149,446,674,1628,544,700,1153;31;M
12698;544;49;M
12727;739,1217,1234,1414,1238,544,422,286,97,531,434,57,1699,700,1666;20;M
12741;650,739,660,440,539,567,1199,193,1720,1623,274,250,221,925,286;38;F
12770;660,1238,422,459,1075,286,894,57,739;33;F
12771;1217,193,1720,1163;61;F
12772;274,1623,1163,1550,909,553,531,1666,55,650,1217,221,109,440,119;62;F
12776;109,868,1381,1199,567,1720,1221,1238,539;36;F
12800;1199,1414,1238,544,97,57,700;23;F
12804;1628,180,685,170,446,567,193,1238,626,553,868,1720,1623,422,894;31;F
12818;321;45;M
12823;170,660,1720,1414,780,1623,221,1550;63;F
12829;440,339,170,1236,1238,1163,739,660,539,193,1720,221,531,1550,286;38;F
12833;1490,573,274,119,1238;34;F
12839;539,567,1199,193,119,1623,897,925,1163,544,909,1699,700,1666,1236;33;F
12843;925,154,459,180,1628,335,544,422,1075,286,57,1666,446,260,626;32;F
12851;1217,553,567,127,868,119,337,1016,1240,221,335,180,321,286,894;41;M
12855;626,660,180,894;38;M
12859;221,925,1075,286,531,321,700,127,1720,1550,1163,1628,109,894;37;M
12867;739,674,660,440,221,1550,1628,544,286,531;33;M
12879;626,339,1490,260,553,442,539,1199,193,1550,1238,422,109,180,894;38;F
12902;868,335,1075,286,1163,894;38;F
12904;739,539,1720,1623,1550,700,650,1149,674,553,567,1240,544,909,180;46;M
12914;1217,567,897,925,544,97,1153;39;F
12917;685;38;F
12929;739,440,539,1234,1720,1623,780,221,1238,1288,544,109,531,286,1550;35;F
12941;739,169,660,440,539,127,1623,221,1550,1163,544,286,531,321;33;F
12988;1623,221,1550,925,544,286,531,97,1666;31;F
13003;1699,897,1041,1720,660,685;60;M
13005;260,1214,193,1041,1623,780,925,1163,1075,286,573,1238,1628,1381,1720;38;M
13033;544;30;F
13066;1699,567,1199,1720,1041,1623,221,1550,1238,1288,544,286,434,321,1236;37;F
13095;660,1016,1240,221,286,739;30;F
13098;260,169,127,1234,119,1414,1550,925,335,109;24;F
13139;286,1720,1550,170,1236;16;M
13162;169,440,539,567,119,1623,274,250,1240,221,1628,180,286,531,1236;24;F
13165;446,544;46;M
13193;260,337,925,109,434;50;F
13211;739,440,442,573,539,1381,868,119,337,221,925,335,422,286,894;35;F
13217;260,868,1550,925,422,1153;36;F
13231;1217,1221,660,440,539,567,337,1720,1623,221,925,909,286,422,180;44;M
13272;660,440,539,1720,1016,221,925,459,286,1236,739;40;M
13274;339,274,221,567,925,909;28;F
13281;119,1550,894,544;76;M
13292;434,1153;73;M
13318;170,660,193,1720,1623,1550;51;F
13368;685;49;M
13390;539,739,286;31;M
13440;660,553,180,1217,442,925,909,57;41;F
13443;1199,1628,335,739,119,1623,109,286,685,260,868,677,1238,1240,925;43;F
13451;539,442,260,739,660,567,1720,780,1240,1238,1628,109,459,909,531;35;M
13466;1628,1238,1550,1414,1234,1381,1199,442,553,1442,260,446,244,1490,339;47;F
13485;925,434;26;F
13486;1442,169,260,244,739,539,1199,119,1623,221,1550,925,109,286,1236;44;F
13515;446,674,660,868,1550,335,321,1666,260,221,544,422,109,286,531;38;F
13524;1217,1623,780,339,440,1093,422,1442,1199,119,868,337,1238;31;F
13528;1628,1240,274,739,660,539,567,1623,780,221,909,286;35;M
13538;1442,660,1199,1720,1240,925,544,963,286,434,1236;15;F
13561;180,422;43;F
13562;260,1414,1550,1238,650,1214,739,539,780,274,1628,422,109,1075,531;40;F
13564;422,909,286,1666,925,434;12;F
13572;660,440,539,193,1623,1240,897,544,286,1236,97,1149,422;18;M
13599;1217,739,660,440,539,567,780,1016,1240,221,1550,925,286,894,1236;41;M
13612;1041,909,660,286,963,544,250,274,780,1623,567,440,739,650,1699;40;F
13632;925,909,286,434;34;F
13636;337,1414,1623,780,221,1238,1628,459,286,553,1720,897,544,335,180;23;M
13663;925,1163,180,909,434;38;F
13668;1720,221,1550,531,321,660,685,1442,925,544;43;F
13705;244,339,685,539,193,1234,221,286,1666,1236,739,633,1240,422,180;33;F
13709;633,1217,169,1623,221,1628,544,531,1236,739,660,440,539,1550,286;32;M
13729;446,539,1199,1093,677,1016,1240,1163,544,1075,321,440,1720,221,286;39;M
13743;894,1381,1628,57,963,193,909,1623,1720,567,553,868,1214,539,1221;30;F
13762;1442,169,260,1221,633,739,446,660,1623,925,440,193,221,544,97;17;M
13764;1442,1016,1623,1238,1720;30;F
13793;109,459,1628,1238,1550,780,440,660,1221,739,1149,553,539,422,180;39;M
13810;700,1442,244,1238,286,97,1666,660,739,633,539,1623,780,1016,1240;36;F
13813;1149,674,544,97;42;M
13869;442,1199,1720,422,1075,180,894,868,1041,1238,109,286,1666,925,434;44;F
13884;1236,1016,633,539,440,660,1217,1234,1240,221,1550,286,780,1666,739;31;F
13918;909,286,685,739,626,539,567,1041,274,1699,650,250,897,1550,109;40;F
13935;897,250,459,57,1041,1490,650,567,1199,193,1720,1238,1699;28;F
13946;909,286,57,1699;44;F
13953;739,440,1041,1623,274,1628,434,650,660,539,567,1199,897,1238,909;26;F
13958;339,119,1217,1214,544,221,897,274,780,1623,868,660,739,260,1720;41;M
13963;739,539,119,1623,544,286,97,57,1666,1236,685;39;F
13965;544,963,180,97,321,1236,1153,127,1163,169,1550,221,1623,286,531;29;M
13974;1442,539,1199,193,1623,250;31;M
13976;260,553,868,897,1238,109;31;F
13979;1666,1699,531,1075,1623,1720,119,1093,442,660,626,339,1238,335,544;32;F
13987;1550,1234,1199,539,660,685,739,1217,633,286,925,1623,1720,221,544;31;F
13991;119,1623,1240,1550,180,274,925,1041,567,897,909,434;33;F
13993;894,1163,925,897,193,440,170,739,660,539,1016,1240,1550,1628,1236;33;M
13994;1381,677,1623,925,1236,1217,739,1221,553,567,868,335,180,909,1490;34;F
14010;544,739,1666,633,660,440,539,1199,1234,1623,221,1550,109,286,531;68;F
14015;660,260,909,1041,1720,925,567,868,434;34;F
14018;633,739,660,539,780,1016,1240,221,286;36;M
14021;660,1041,221,1240,1236,963,1016,677,286,1720;66;M
14036;440,1153;71;M
14057;1381,1234,1093,868,119,1623,780,221,1238,335,925,544,422,109,1666;41;F
14138;250,780,274,1414,154,1623,221,1238,286,567,925,434,909,1720,1041;32;M
14157;55,170,1217,567,127,1720,677,1240,221,925,1163,335,459,286,700;22;M
14161;339,739,660,442,539,1199,1720,1623,1016,221,286,1666;42;F
14173;193,1153,1217,1149,553,1381,274,221,1550,1075,57,286,1720,1628,544;32;M
14203;1217,1490,739,1221,553,567,1381,868,677,1623,925,335,180,909,1236;37;M
14207;925,1623,573,539,674,660,446,119,1234,739,1149,1490,544,97,1153;5;F
14220;685;39;F
14237;650,1199,1234,119,1720,1623,250,1240,539,440,685,780,221,286,677;39;F
14244;539,440,1217,660,626,127,1720,1623,1016,274,250,1240,221,544,909;51;M
14261;170,633,660,193,1381,127,1623,1240,1550,531,1236,169;61;F
14277;739,660,539,260,868,221,109,1075;39;M
14281;544,286,1628;43;M
14285;170,1199,127,868,119,925,544;27;M
14296;1163,544,1236,780,739,677,674,660,650,193,109,1720,1623,1240,1238;32;M
14298;339,442,539,567,1199,193,119,337,1623,1238,1288,422,109,286,894;28;M
14325;626,660,553,567,127,1240,1163,1628,459,321,700,674,539,1720,1623;33;M
14329;119,1720,1550,739,868,1240,1238,925,109,286;54;F
14355;260,674,1199,1381,1234,868,337,1238,925,335,544,459,286,97,1153;2;M
14362;180,909,531,1666,1236,1153,1623,677,1720,539,674,1442,650,925,97;28;M
14364;260,119,1238,739,1666,544,1623,868,1234,1199,339,660,531,221,286;29;F
14365;660,539,1720,1240,221,925,1075,109,286,894,531,440,544,1153,97;39;F
14368;221,925,1236,1153,274,650,677,1623,739,567,909,780,1699,250;25;M
14387;1221,660,440,573,868,119,337,544,1236,1217,1199,1414,1238,221,286;45;F
14394;1149,739,626,674,660,539,1199,119,1720,221,925,544,909,286,700;32;F
14407;633,739,244,660,539,1720,677,1016,1240,1550,963,286,531,1236;43;F
14428;339,1214,739,660,193,677,780,1016,221,925,422,459,286,57,1236;45;F
14453;539,1623,780,1016,1163,963,1236,650,660,250,109,459,286,57,1699;36;M
14457;422,180;8;M
14462;868,1623,250,1240,221,1238,180,286,434,925,1041,274,909,897,567;37;F
14469;739,626,660,221,909,286;31;F
14481;57,539,440,650,660,780,221,1628,286,1240,739,1041,909,1623,154;26;M
14523;169,660,1199,127,1234,1720,1623,221,1550,925,544,286,894,531,1666;50;F
14528;335,109,1236,57,286,544,154,221,1240,1414,539,440,660,739,909;28;M
14552;321,700,1666,1490,674,440,1381,868,119,1238,1288,544,109,1075,286;29;F
14571;1628;36;M
14584;1381,553,739,633,1199,1238,335,1666,1236;30;M
14607;339,685,193,868,1238,335,109,459,286;43;F
14622;1623,1093,1381,1199,1628,739,1236,1720,539,440,286,531,221,660;37;F
14654;685;34;F
14656;925,434,1153;54;F
14662;274,1381,739,1490,1236,1699,434,963,650,1149,567,119,1041,897,1238;27;F
14706;1381;39;F
14718;660,440,1199,1093,1623,1016,221,109,286,1236,739,539,1720,780,1240;30;M
14779;660,1016,1240,221,1550,925,1163,286,780,1628,422,154,739,1041,1623;40;M
14782;894,660,440,539,1199,1720,1623,1016,274,250,1240,221,1238,739,339;29;F
14789;925,1163,894,1236,739;39;M
14818;119,553,260,739,442,1442,539,1199,1234,868,1720,544,109,286,894;39;F
14829;660,440,1623,539,868,119,1414,1149,739,1199,1153,221,544,286,97;26;M
14835;170,440,286,739,633,169,660,1199,193,1623,1240,221,1550,1163,109;45;M
14836;169,1442,539,1199,1236,339,1217,650,739,660,440,1720,221,1238,286;23;M
14838;660,440,539,1199,193,1623,897,221,925,422,894,1550,169,286,1163;53;F
14843;461,260,1217,650,1149,674,660,442,1381,221,925,1628,544,286,553;44;F
14856;660,1199,868;62;F
14865;1217,739,660,440,539,567,780,1016,1240,221,1550,925,286,894,1236;5;M
14870;650,539,1381,677,1623,1240,1628,544,286,1236,739,660,925,1016;32;M
14883;55,868,119,1238,925,544,97;39;F
14886;868,119,250,1163,109,1238,925,434;40;F
14890;909,1666,1217,633,660,442,539,193,677,1016,274,221,1163,461,1075;43;F
14944;1236,434,1153,633,1149,739,660,567,250,1238,531,440,539,274,1163;43;M
14947;1666,1221,633,739,260,660,440,539,567,1720,221,1163,109,909,286;51;F
14966;169,260,1214,739,660,868,119,1720,1623,221,925,335,109,286,434;49;F
14974;1623,780,274,925,1628,909,531,674,1720,221,1550,1238,544,286,700;36;F
14980;739,660,440,1199,1016,1240,1550,221,1238,1288,109,1666,1236;52;F
14997;573,193,1234,868,1414,1623,780,221,286,1666,925,660,260,1163,1288;29;F
15012;260,674,442,1381,1720,1414,1623,221,97,700;49;F
15021;1442,1720,1550,894;22;F
15067;339,1720,170,260,780,1016,1240,1550,1238,925,1163,422,109,286,1236;49;M
15073;1628,459,461,1075,97,700,260,674,539,868,1720,544,109,57,1153;57;F
15135;1720,660,335,260,1221,739,1214,339,685,119,1414,221,1238,286,109;43;F
15149;422,180;68;F
15151;567,1623,274,180,909,286,894,434,57,1234,109,685,260,440,193;47;M
15152;260,674,221,286,321;39;M
15173;1163,660,739,1221,440,539,567,1720,909;81;F
15203;660,868,1720,1016,1163,180,1075,286,894;43;M
15207;57,422,1628,1016,1240,1238,660,1442,244,739,633,1550,1236,286,700;36;M
15210;335,422,180,660,553,1093,119,221,1238,109,909,286;41;F
15216;446,442,337,780,221,1550,1666,286,1238,1623,119,1381,539,660,260;31;M
15217;260,650,1666,897,925,1075,434;2;M
15221;286,170,739,169,539,1199,193,127,1234,1720,1414,1623,1550,1238,1628;23;M
15234;422,180;51;M
15237;1016,274,1550,1238,925,1163,1153,739,660,539,1234,1720,221,544,286;29;F
15262;339,337,1623,1238,925,1628,544,422,286,894,97;44;F
15320;109,459,97,57,553,626,660,193,1720,1623,221,1238,1628,286,894;47;F
15327;422,180;46;F
15335;573,339,633,119,868,1234,1199,442,553,660,1490,260,193,109,286;59;F
15339;57,544,221,626,660,193,1238,1163,286,127,169,1720,1623,1550;24;M
15348;660,1016,250,925,434,1199,1236,1623,894,650,567,897,909;28;M
15401;339,1214,1442,193,1234,1623,780,1240,1238,1163,422,109,459,1075,57;48;F
15418;1550,434,57,339,739,674,1199,1381,1720,1240,925;30;F
15433;260,1442,660,440,868,1240,221,119,780,925,335,544,422,109,685;40;F
15446;442,1666,170,339,739,1149,260,1199,1093,119,1238,925,286,221,1550;29;F
15473;674,1720,1414,1238,1163,55,170,626,127,1628,544,109,97,700,1153;46;M
15496;650,633,739,244,660,440,539,780,1628,422,700,1236,685,1623,1240;38;F
15556;573,539,1490,339,1221,119,897,335,650,442,567,1238,909,434,1666;44;F
15587;573;31;F
15610;925,434;38;F
15632;260,440,1234,1623,250,109,1699,1236,650,739,660,539,1720;50;F
15636;244,286,1414,539,573,442,440,169,633,1720,677,1623,1016,1240,1236;43;F
15641;260,193,1240,925,461,286;62;F
15656;97,339,674,1720,700;29;F
15657;221,337,1381,567,573,440,553,169,660,868,119,1041,925,335,434;39;F
15665;244,1221,660,539,677,1041,221,1550,1628,459,963,286,57,1236;41;M
15690;434,925,1041;41;F
15712;925,434;38;F
15724;127,567,440,1442,169,739,1214,1217,539,780,897,1550,1628,286,57;31;F
15750;422,459,909,1699,1236,739,660,440,868,1041,897,221,925,286,434;33;F
15752;335,422,909,1699,1490,626,440,573,1199,868,1628,286,894,97,57;36;F
15772;1720,1238,925,1628;39;F
15773;925,446,1623,544,97;46;M
15810;1628,544;61;M
15823;674,700;69;F
15829;321,440,553,260,739,660,539,567,1720,1623,1628,459,180,909,57;45;M
15871;1214,1234,1623,1240,1288,1163,1628,700,1666,339,1199,1720,1238,109,57;43;F
15894;1288,335,57,286,442,260,221,1093,660,650,1238,109,119,339,1666;39;F
15904;633,339,739,660,539,1720,677,1041,1623,1016,1240,897,1288,1628,154;23;F
15908;260,539,567,193,422,109,459,461,180,57;44;F
15923;633,739,660,539,1199,1720,1623,1016,1240,221,1238,286,1236;52;F
15928;250,1240,459,337,1623,1016,221,1238,286,57;23;F
15934;553,739,1214,894,660,119,780,925,335,459,461;36;F
15952;434,925,57;15;F
15955;1720;53;F
15962;739,674,1234,677,868,221,1238,335,544,109,1075,180,286,700,1666;73;F
15969;553,422,180,57;40;F
15971;739,660,442,539,1199,1381,1238,925,1666,1720,1623,250,286,531,434;49;F
15992;780,1016,274,250,1550,1238,1628,544,459,1720,909,1623,221,1163,286;38;M
15998;57,909,180,459,1628,1623,1720,567,539,660,739,109,553,440,321;79;F
16003;894,650;45;M
16011;925,434;86;F
16024;244,685,446,739,626,1041,1414,1550,1238,925,1628,544,422,97,700;15;M
16036;539,434,553,660,739,650,260,1623,109;45;F
16063;180,553,221,422,57;12;F
16068;739,660,544,1041,963,650,925,274,567,897,909;45;F
16073;1217,180,422;42;F
16085;446,1214,339,739,440,1720,422,1628,660,1217,573,544,459,286,57;27;F
16092;780,1550,1623,1238,925,531,739,260,660,1720,221,544,109,286,321;47;F
16097;1240,1720,660,539,544,440,1153,531,894,221,109,1075,925,286,97;36;M
16098;553,422,180,57;11;F
16136;553,422,180,57;8;F
16149;339,626,567,868,337,1623,780,1628,459,894;38;F
16153;553,422,180,57;6;M
16165;925,434;9;M
16170;1442;59;F
16174;553,422,180,57;3;M
16185;193,1199,1720,221,1550,1238,925,109,963,1075,286,57,1666,1236;40;F
16187;925,434;63;M
16209;1236,286,1163,677,739,244,1414,780,1016,1240;39;M
16213;660,539,567,119,1623,897,221,925,909,286;20;F
16219;169,660,440,780,925,1163,1628,461,1217,1221,539,567,1199,193,1623;53;F
16220;685,1720,677;42;F
16232;925,434;63;F
16240;442,674,544,700;72;F
16256;633,244,440,1623,1016,1163,677,1240,544,286,531,1699;31;M
16260;119,193,626,286,434,1149,446,674,1550,1163,1628,544,97,700,1153;39;M
16261;925,434;31;F
16296;1240,434;31;M
16297;739,1217,446,660,440,539,868,1414,221,1238,1163,1628,180,286,531;39;F
16303;739,660,221,1550,286;40;M
16304;626,1234,1093,1720,1628;47;F
16312;1490,739,660,573,539,567,337,274,897,1238,925,335,422,1075,909;36;F
16323;1240,780,119,442,660,539,1720,1623,1016,221,1238,1288,909,286,1666;41;F
16329;780,1623,119,539,674,1221,446,739,633,1217,221,1628,544,459,57;42;M
16361;739,660,440,1720,1041,1623;34;M
16413;553,440,119,250,1238,1628,1153,97,1623,1550,335,544,660,221,286;35;M
16429;1720,154;31;F
16436;650;42;F
16437;1234,677,633,739,339,260,660,1199,868,1720,1236,1238,925,109,963;24;F
16439;1153,700,544,446,674,1149,97;29;M
16444;868,1234,1381,193,1199,539,573,442,440,660,1442,260,739,1490,633;1;F
16465;1217,567,909,193,1075,57;43;M
16491;1699,897,909,925,567;35;M
16503;573,539,1199,193,1381,1234,868,1720,780,221,1238,925,109,286,57;8;M
16519;963,1623,193,868,677,685,1075;36;M
16520;553,700,1217,739,674,274,1075,909,567,1442,260,1221,1214,1238,109;56;F
16547;250,154,1236,650,739,169,660,1623,897,1550,1628,286,925,434;51;M
16557;1490,868,119,274,250,1238,925,180,434;37;F
16560;459,286,57,1550,244,1623,633,1240,1236,1163,1016,925,739,660,1699;34;F
16576;868,1238,335,109,963;37;F
16581;250,1240,221,1550,461,193,539,440,660,169,1221,739,1217,925,434;9;M
16605;1623,274,1163,1699,57;22;M
16612;1075,1238,1414,539,1442,739,660,1199,1720,677,1623,1240,221,286,1236;79;F
16620;1234,1149,446,260,674,442,1720,221,1628,544,109,97,700,1666,1153;37;F
16627;553,335,459,461;35;F
16631;633,1217,169,660,539,193,1016,274,250,1240,221,286,1236,925,434;11;M
16634;274,1016,1720,127,193,660,674,626,1214,633,650,685,1163,1628,544;44;M
16636;650,1149,446,260,1442,553,1381,1414,925,335,963,180,97,109;41;F
16652;221,677,1628,626;42;M
16673;286,1153;29;F
16678;739,55,170,1720,780,274,1550,925,963,286,531,57,1666,169,127;42;M
16684;1016,1240,739,660,1236;50;M
16694;221,1238,925,1628,1149,446,260,674,553,1381,544,109,1153,97,700;7;M
16701;169,660,442,127;65;F
16710;539,1041,250,180,434,1236,650,567,1623,274,221,897,1238,909,1699;23;F
16712;1414,780,897,1550,57,1442,567,1199,1720,337,925,1628,544,422,459;11;M
16726;339,553,440,539,567,193,1623,221,1238,459,180,286;30;F
16732;567,221,180,909,286,894,531,321,57,1699,1666,1236,1153;53;F
16749;700,544,260,660,539,1163,1623,440,442,119,1720,221,286,109,321;55;F
16790;868,193,1442,260,244,1236,127,780,894,685,633,739,1720,1623,1240;33;F
16800;1238,335,544,109,180,422;42;F
16801;97,1442,1381,119,1720,1238,335,461,286,1414,339,1666,1163,544,193;23;M
16817;1221,260,633,459,963,434,739,660,1720,1623,274,897,925,109,909;47;F
16822;55,1381,1236,1149,1214,339,1217,633,685,739,260,440,539,1628,286;25;M
16833;553,193,1720,1623,1217,739,539,780,1240,1238,109,180,286,57,1236;35;F
16854;553,674,169,339,1666,170,739,260,127,1550,1238,925,544,109,1075;50;F
16857;633,544,286,1236,894,925,660,244,1720,677,1623,1016,1240,1550,1163;61;F
16860;250,1550,335,544,422,109,963,909,286,321,57,1666,1236,221,1720;48;M
16873;1041,780,221,925,660,567,337,1623,897,422,909,286,434,57,1699;32;F
16914;539,1217,1221,660,567,1720,1623,780,221,459,909,286,57;28;M
16925;544,626,1628;33;F
16940;739,660,1720,1623,1240,221,459,1628,674;34;M
16942;573,1199,1720,897,1238,925,109,1075,434;42;F
16966;274,1041,221,660,440,650,567,909,897;39;M
16970;1699,650,925,1221,909,897,221,274,567;31;F
16989;739,274,660,440,221,1550,286,780,1238,1041,1720,897,909,1623,567;29;M
17010;544;67;M
17017;925,434;47;F
17029;739,339,1217,1240,925,1628,544,286,660,440,539,193,1720,221,57;55;M
17062;674,1149,700;49;F
17075;739,650,674,193,127,221,1550,925,544,909,97,700,531,1628,1153;30;M
17096;739,1149,1720,1550,544,1236,1240,1414,868,221,1238,109,1075,1666,286;28;M
17115;1623,1217,739,260,660,440,539,193,221,1238,1163,109,286,1236,434;21;M
17128;909,567,339,1221,660,440,573,539,1623,221,434,193,119,897,1288;40;F
17129;274,250,1238,544,650,567,337,1720,1041,221,925,909,286,531,434;49;F
17131;339,1442,442,1666,573,1623,780,1238;37;F
17141;1240,1550,1628,544,109,97,650,1149,674,1199,1623,221,286,700,1153;29;F
17164;1149,1163,97,1153;42;M
17202;739,169,626,539,544,459,434,553,1720,780,1628,422,286,57,700;42;F
17255;868,119,1720,925,335,109,286,434,97,1666,442,1199,221,1238,544;63;F
17270;925,335,109,1075,286,57,1666,339,446,260,660,1199,544,97,1153;52;F
17279;339,1199,119,1016,221,1238,925,154;46;F
17280;286,739,446,660,440,539,1240,221,544;30;F
17307;127,1238,894,531,1221,169,1720,1550,1163;52;F
17310;1075,1381,193,1199,539,260,739,1214,1623,286,674,700,446,221,544;23;M
17341;55,660,440,119,868,221,109,286,1699,1490,539,274,250,925,422;33;F
17365;1016,1240;54;M
17374;1075,1217,339,739,660,553,567,1720,1623,221,1238,925,180,909,286;48;F
17403;1720,1550,1623,1240,739,660,626,531,286,109,1217,539,1041,434,909;20;M
17407;170,169,442,127,1720,897,221,925,544,109,286,434;90;F
17437;660,1016,1240,286,1163,1236,633,739,1199,925,1623;41;F
17450;739,119,1720,1240,434;57;F
17451;553,660,339,170,1217,1490,1234,868,1623,780,274,1240,1238,109,685;46;F
17462;1153,544,925,674,700;33;F
17514;244,1221,422,567,1623,780,221,909,286,894,193,57,1720,459,553;46;F
17536;1550,193,553,739,1720,1623,1240,221,1238,422,180;28;F
17551;446,1720,1623,1016,221,1550,1163,1628,335,544,422,109,1075,286,97;59;M
17554;170,650,626,1442,674,660,553,440,442,573,539,1414,250,169,1199;29;M
17563;739,1442,1234,1623,780,1016,1240,1550,1238,925,1163,1236,422,335,1628;37;F
17583;1381,193,422,461,685,169,1720,274,897,1550,1238,925,1163,894,434;46;F
17599;260,868,337,221,109,57,446,674,1628,544,700;35;F
17600;446,1288,97,1153,1720,544;41;F
17609;1153,1628,1720,674,739,440,286,531,321,660,539,1199,1623,221,544;54;F
17614;739,539,567,780,925,335,57;34;M
17622;440,539,567,780,531,170,739,169,660,127,1623,274,221,1550,286;44;M
17634;677,1041,1623,250,221,1075,434,1699,260,553,127,274,422,109,894;35;F
17636;925,434;13;F
17638;539,1199,1217,339,442,1381,337,1720,221,1238,925,109,1075,286,1666;47;F
17642;461;42;M
17648;894,685,650,170,633,244,1016,1550,1236,1623,1199,1720,1240,221,286;48;F
17652;170,780,459,674,660,442,193,1628,1720,1623,544,700,1666,1153;45;F
17653;660,739,244,260,1442,1199,1414,780,1016,1240,1238,109,963,925,1236;31;M
17656;739,1442,1234,1623,780,1016,1240,1550,1238,925,1163,1628,335,422,1236;8;F
17671;925,434;10;M
17679;1199,1623,422,286,1666,1075,250,1016,1414,260,539,1628,1236,1238,1163;22;M
17694;925,434;71;F
17704;1623,109,1720,925,739,1550;29;F
17708;1236,677,1720,1623,1016,1240,1163;48;F
17709;739,1442,1234,1623,780,1016,1240,1550,1238,1163,925,1628,335,422,1236;4;F
17716;57,660,440,539,274,221,1238,909,1217,626,553,567,1720,1623,1628;32;F
17717;1217,739,446,539,1623,221,1238,544;36;F
17722;925,434;71;M
17742;1414,459,109,335,1288,1238,221,1720,339,739,1075,894,57,1666,1236;33;F
17797;1238,1720,868,1199,539,440,1149,170,739,260,660,677,1623,1240,109;70;F
17815;1217,1720,1414,1288,1163,894,321,660,193,868,274;53;M
17828;440,1221,446,244,1214,1217,739,119,1623,925,544,422,286,1720,221;32;M
17836;567,573,440,1221,260,739,1490,170,685,1442,660,868,677,1016,1240;34;F
17838;337,1288;54;F
17839;442,573,567,1414,780,1666,1214,193,127,1720,1550,1238,1628,286,1623;31;F
17844;1628,544,97;31;M
17867;434,685,169,193,1381,1720,274,897,1550,1238,925,1163,422,461,894;13;F
17888;1238,1163,109,286,531,127;40;F
17896;868,1240,1238;31;F
17913;193,1720,286,97,1217,339,573,553,1199,1666,539,567,1414,897,1238;25;F
17914;1075,260,109;43;F
17916;739,660,539,544,221,1550,531,286;37;F
17927;1720,925,434,260,109;40;M
17928;739,660,221,1550,286,531;36;M
17945;685,169,1199,193,1720,274,897,1550,1238,925,1163,422,461,894,434;15;M
17963;685,169,193,1381,1720,274,897,1550,1238,925,1163,422,461,894,434;6;F
17974;650,553,573,1199,1238,1234,868,337,250,897,925,335,422,434,1699;38;F
17980;650,260,553,573,1381,868,119,250,897,1238,925,335,422,434,1699;8;F
17984;169,685,193,1381,1720,274,897,1550,1238,925,1163,422,461,894,434;52;M
18000;925,434;37;M
18007;573,442,1490,339,260,1234,868,1414,1238,335,109,1075;68;F
18022;1236,440,1221,260,1217,650,1214,1149,739,553,1199,780,1628,109,459;41;M
18046;650,780,1628,459,57,1041;51;M
18052;221,677,337,868,1234,553,660,739,339,685,244,260,1238,109,1236;49;F
18064;221,1550,1163,1628,335,544,459,1075,180,286,894,97,57,1666,1153;63;M
18067;1381,868,1016,1238,1699,1623,1199,539,660,650;46;F
18105;1199,674,1442,446,170,626,1720,1163,544,461,180,909,553,567,193;52;M
18123;461;40;F
18125;57,963,1075,459,335,1628,1238,221,780,539,674,169,626,739,650;28;F
18133;925,335,109,459,180,286,894,57,650,626,553,1199,193,868,1163;40;F
18136;461;10;F
18142;1628,739,1238,1075,119,539,553,1720,567,1221,1214,909;36;F
18152;1720,119,868,1381,650,544,286,894,97,339,739,260,1414,1238;52;M
18177;260,1016,1240,1550,544,109,1236,963;34;M
18183;909,925,567;43;F
18189;925,434;4;F
18191;925,434;41;F
18192;925,434;11;M
18222;1666,925,434;38;F
18224;925,434;30;F
18230;1490,539,1199,1093,868,1414,1623,274,1550,894;29;F
18237;274,1550;31;M
18240;286,1666,909,1217,1221,660,553,442,567,1720;75;F
18263;286,1442,660,446,1149,260,674,1720,925,1628,544,109,97,700,1153;35;M
18284;55,440,626,739,339,660,553,1199,193,1720,1623,221,544,180,909;46;F
18286;925,434;42;M
18289;925,422,434;10;F
18301;567,909;45;M
18313;1623,250,1240,1550,1075,1666,650,339,739,127,1238,1288,925,894;49;F
18316;739,1442,1234,1623,780,1016,1240,1550,1238,925,1163,1628,335,422,1236;38;M
18319;925,434;60;M
18326;539,1720,1153,339,739,446,660,221,1550,1238,1623,544,1628,700,674;32;F
18332;567,925,909;13;F
18342;650,1214,442,1199,1623,780,544,909,57,700,1221,660,567,1238,925;24;F
18356;567,925,909;15;F
18402;685;42;M
18415;337;44;F
18422;250,1240,154,442,440,739,339,626,660,221,1238,1666,544,909,286;29;F
18428;169,868;34;F
18430;1666,109,260,660,442,221,1075;45;F
18458;1149,660,440,221,544,193;49;F
18465;260,440,660,1041,925,434;39;M
18484;339,674,700,626,739,1490,1217,868,1381,1238,925,1628,180,286,894;37;F
18502;1221,446,650,1217,260,660,440,442,567,1234,868,780,274,422,109;36;M
18513;650,1720,274,250,544,1699;39;F
18531;539,567,909,1041,925,434;44;F
18534;442,221,286,531,109,1720,660,553;68;F
18538;925,434;47;M
18542;685;46;F
18574;739,1217,1623,1016,221,925,1163,1628,335,286,1236,1153,539,440,685;43;F
18582;739,660,539,193,1234,1623,221,1550,925,461,286;44;M
18594;1288,1628,1666,739,660,440,539,221,1238,286,321;33;M
18596;1149,567,1623,780,700,97,286,650,1214,739,626,1442,127,925,909;38;M
18613;169;35;M
18629;739,1016,1236,1240,1720,677,1623;38;F
18631;1199,925,434;47;F
18634;1217,739,1221,660,440,1623,274,221,1550,544,286,1236,539,567,909;31;F
18635;1217,1221,739,440,660,1623,274,1550,221,544,286,1236,539,567,909;32;M
18647;260,169,442,127,868,1720,221,1550,1238,1163;71;F
18690;1163,459,180,909,57,739,260,660,553,539,193,1623,780,1238,109;46;M
18691;193,539,660,1221,244,739,677,1623,1016,1240,1550,1238,925,1163,1236;34;F
18701;1623,544,286,531;26;M
18705;1234,1199,1240,221,1550,1163,461,1236,633,739,660,539,193,1720,1623;53;M
18719;925,434,1153;42;F
18742;1093,339,260,442,119,1238,1236,1666,739,244,573,1199,1720,1234,1240;45;F
18751;1623,1381,868,440,674,260,1149,1720,1628,335,544,422,109,97,1153;42;F
18753;544;45;F
18768;650,339,446,274,1238,1628,544,109,286,531,1153;21;F
18790;567,1666;64;F
18797;119,868,1234,127,193,1199,567,539,573,440,1149,685,1381,1628,544;52;F
18806;339,553,440,567,1381,119,337,1720,1238,1288,544,422,459,461,57;48;F
18821;260,739,1214,119,221,909,1217,1221,539,567,1288,925;40;F
18825;894,650;56;M
18842;553,442,567,868,119,221,1238,925,1628,335,422,909,286,531,1666;61;F
18845;440,1442,1221,739,260,660,442,539,677,1240,221,1238,109,459,286;42;M
18853;1217,553,567,925,544,286,909,180;21;F
18856;1236,1240,1016,1623,337,440,660,739,244;40;M
18870;739,660,539,1199,1381,868,1720,780,1016,1240,221,422,459,1236,286;37;F
18877;422,544,335,1628,1163,1720,1149;33;F
18884;440,660,1442,169,626,1217,739,925,1628,459,286,57,780,221,1238;36;M
18892;963,739,1234,260,553,1199,1720,677,1240,221,1550,1238,544,109,1236;36;F
18953;553;30;F
18968;440,539,1199,1623,780,221,1238,544,459,868,1720,925,97,57,1153;45;F
18969;780,221,422,180,286;42;M
18974;169,660,440,193,1623,1016,274,250,1240,221,909,286,434,57,1153;27;M
18987;250,1550,544,461,286,1666,626,193,567,127,677,1623,221,1238,1628;29;F
18996;897,221,1628,531,57,1149,446,1720,780,1238,544,286,97,700,1153;34;F
19007;1490,260,1199,1381,1234,868,119,337,1623,221,1238,335,544,109,1075;36;F
19015;1490,553,193,1234,1414,1238,925;34;F
19020;1217,739,660,553,539,1199,193,119,337,1623,780,221,1238,925,180;35;F
19028;909,57,1381,573,660,1490,553,868,337,1238,925,335,422,459,180;39;F
19069;868,1093,1199,573,260,1214,633,553,1381,1238,1628,335,422,180,1666;45;F
19106;274,539,1550,1628,221,780,1623,1720,1199,440,660,626,446,739,1217;16;M
19128;633,685,1149,446,626,674,442,1093,868,1720,1628,335,544,97,1153;32;F
19215;925,434;26;F
19223;274,1153,1236,1240,170,660,539,780,1016,250,221,1163,286,894,1699;46;F
19227;1550,1238,1720,337,868,1199,440,739,660,260,1016,1240,109,286,1236;59;F
19228;339,446,660,1720,221,544;37;F
19230;553,739,1221,660,440,539,127,1623,274,1240,221,1628,109,180,286;39;M
19233;925,434;26;F
19288;193,119,1623,780,1238,925,434,57;8;F
19290;119,780,274,221,925,434;40;F
19321;440,660,446,1149,55,700,626,539,193,1628,335,544,180,286,97;36;M
19342;925,434;47;M
19371;531,1623,440,660,539,286;58;F
19376;925,434,1153;47;F
19394;925,434;15;M
19396;531,1236,650,660,539,567,1720,1016,1240,1628,422,1041,909,780,739;44;F
19408;925,434;10;M
19409;193,221,1550,286,531,1221,553,539,567,274,897,925,422,909,434;33;F
19443;286,1288,57,1666,1041,780,221,1238,925,1628,544,459,109,422,434;40;F
19457;739,660;26;M
19459;180,1217,1214,626,660,119,868,1720,544,422,650,260,109;40;M
19461;650,1217,1214,1221,260,553,868,1623,274,1238,925,544,109,1075,180;39;F
19464;925,434;48;M
19479;1199,1234,868,119,1414,1623,274,221,1238,1288,925,422,109,286,434;11;F
19483;1442;47;F
19490;660,1199,1442,1628;50;M
19493;286,909,459,109,422,1163,780,1720,1234,193,567,553,660,260,739;49;F
19497;339,1214,1442,1381,780,925,1628,422,531,1234,544,286,97;26;F
19519;674,1199,868,337,1238,544,422,1442;46;M
19524;1442;6;F
19530;55,1217,339,1214,260,553,442,567,193,119,286,909,780,1221,1442;45;F
19531;674,660,700;43;M
19541;685,633,169,1442,539,337,677,1163,1016,1550,544,286,894,57,1236;44;F
19549;1442,274,925,909;44;M
19550;1490,440,539,567,1199,1381,1720,1623,221,1238,1628,909,286,1153,57;32;F
19573;170,739,1490,685,339,868,1720,1240,109,169,442,1199,127,221,286;33;F
19584;925,1442;43;F
19588;335,894,170,633,1442,193,127,677,1016,1240,544,1075,286,434,1236;7;F
19592;180,422,1628,1442,739,650,109,1550,539,442,660,260,169,127,1163;39;F
19593;170,739,442,1199,1720,1623,335,544,109,127,780;35;M
19637;1221,1442,553,442,573,567,193,119,780,925,544,459,909,286,57;80;F
19653;553,442,193,868,1720,1238,1163,544,459,461,180,894,57,700,1666;75;F
19655;539,567,193,1623,780,1628;43;M
19658;1628,925,1550,897,250,1240,274,1623,1199,440,286,544,221,539,660;37;F
19663;1442;38;F
19664;925,1149,1442,119,337;13;M
19671;567,909,1442;41;F
19691;442,573,1234,868,119,1238,1442,567,193,1288,925,422,109,909,57;13;F
19702;1623,626;45;M
19704;1381,1550,531,633,1016,739,1199,660,868,1623,1240,422,434,1236,925;35;F
19707;739,660,544,169,274,1214,1217,626,57,909,567,1628,553,422,180;69;M
19708;1442;39;M
19715;1442;36;F
19721;1041,925,434;41;M
19735;1442;51;F
19738;440,539,780,1016,250,339,1199,337,1720,1623,1240,1238,544,925,434;19;F
19748;1442;12;F
19752;1221,1214,339,1217,909,422,925,1288,1238,1234,573,567,193,553,1442;49;M
19784;1666,1236,442,660,260,339,440,337,1720,780,1238,925,422,109,963;33;F
19786;1442;9;F
19802;925,434;13;M
19804;1442;6;F
19821;739,660,544,169,626,274,1214,1217,1628,909,567,553,422,180,57;68;F
19825;109,286,531,97,700,1236,739,660,440,442,539,1623,1016,925,1628;57;F
19836;119,1041,897,109,260,1199,1093,868,337,1238,335,1075,1666,925,434;41;F
19847;567,909,1442;13;F
19860;1442,244,1623,1550,1163,286,531,321,221,1149,97,1153,674,446,544;39;M
19865;1238,335,109,1236,739,244,660,193,119,1720,1623,1016,1240,1550,1666;26;F
19868;260,1217,1666,221,1238,335,109,1075,286,1234,442,660,339,925,434;12;F
19870;1442;35;M
19871;335,1149,674,544,97,1153;36;M
19874;260,446,650,868,250,1238,925,1163,544,109,1075,434,1699;44;F
19877;685,1217,739,193,1623,544,97,57,1016,553,1720,925,422,909;44;F
19886;650,1041,1238,335,109,894,434;44;F
19891;567,909,1442;16;M
19900;193,221,1550,531,1217,1214,660,539,567,1199,1720,1623,1238,909,57;33;F
19905;119,337,1623,274,1240,925,434;37;F
19908;539,567,909,1442;47;M
19921;221,925,422,868,119,180,1153;40;M
19929;286,57,1666,170,339,1199,868,119,780,1016,1240,1550,1238,925,422;39;F
19933;274;36;M
19938;1442;12;M
19962;1217,739,660,440,539,1623,221,1238,1075,286,260,626,1628,544,109;42;F
19982;446,674,660,1199,193,1720,1628,544,286,97;42;M
19990;434;33;F
20005;660,440,539,1720,1236,286,531,739,221,1628;36;M
20010;544,1666,739,260,660,440,442,573,1234,1623,221,1238,109,1075,286;38;F
20037;1699;27;F
20070;1217,260,169,674,1720,1623,221,1550,1238,1163,1628,544,109,286,1153;76;F
20077;925;41;F
20099;55,1093,1720,221,925,434,57;52;F
20124;868,1720,1041,221,925,434;13;F
20145;422,700;36;M
20152;1720,1217,739,260,1075,109;42;M
20154;1041,221,925,434;72;M
20173;434;13;M
20176;677,567,650,626,1217,780,1550,1628,1093;29;F
20184;193,868,1414,1623,274,1238,1163,109,1075,894,434,1699,739,250,1720;41;F
20191;1149,868,337,1414,221,925,1163,1628,335,459,286,1238,1720,193,626;33;M
20224;193,660,440,539,1720,1414,1623,221,1238,1163,1628,544,286,894,531;33;M
20226;780,221,109,286,553,193,925,1628,544,894,1666,739,1234,1623,1720;41;F
20229;925,434;42;M
20232;925,434;8;M
20271;434;15;F
20274;55,739,1720,1623,1016,1240,221,925,154,286,780,337,1041;34;F
20286;677;71;F
20294;434;52;M
20295;739,660,567,1199,1623;43;F
20297;674,700;69;M
20307;446,260,1221,244,739,170,1199,868,1720,1238,544,909,286,321;34;F
20327;650,127,1016,1240,1550,1628;31;M
20335;193,1414,1550,1628,109,321,286,544,221,1623,660,169,260,339,170;43;M
20336;650;89;F
20342;567,553,260,446,650,339,442,1199,337,1720,221,1238,459,286,1666;32;F
20346;925,434;47;M
20348;1236,1238,250,1016,337,119,868,1234,573,442,553,660,260,650,1442;46;F
20364;440,660,260,339,193,1238,109,909,286,57,685;41;F
20375;925,434;37;F
20379;868,119,337,897,925,335,286,434;38;F
20396;674,700;95;F
20400;660,925,434;52;F
20405;925,434;45;F
20413;1720,925,434;45;F
20422;925,434;12;F
20448;650,660,193,1016,250,221,286,1442;47;M
20452;677,260,739,170,1199,1041,1720,1623,1016,1550,1238,1628,97,1666,459;24;F
20454;434,925;47;M
20457;260,1093,119,868,274,1238,1163,109,1075,286,1288,925,434;40;M
20460;925,434;40;F
20473;1234,868,1016,1240,422,1236,894,286,109,1163,1238,660,169,127,1550;36;F
20474;539,1199,1016,1240,1550,1238,544,57,700,1666,1236;31;M
20478;925,434;9;F
20481;1238,1381,193,1163;35;F
20494;434,925;15;F
20495;446,868,337,544,97;47;F
20500;1720,925,434;44;M
20501;925,434;41;M
20502;260,1221,739,626,660,440,539,1720,1623,221,1238,1075,909,286,894;45;F
20507;544;17;F
20508;925,434;5;M
20512;1720,925,434;14;F
20520;1720,1550,1163,1666,1153,1238,1628,544,286,894;42;F
20532;925,434;39;F
20539;1720,925,434;14;F
20555;55,339;15;F
20556;925,434;39;M
20565;1214,868,1623,422,1699,1221,567,1041,274,897,1238,925,909,434;43;F
20566;925,434;42;M
20567;1442,1550;39;F
20577;1217,626,169,660,440,567,193,1041,1628,154,459,739,250,963,909;43;M
20586;925,434;12;F
20587;925,434;10;M
20594;1442,1238,286,57;38;F
20604;909,650,925,434;41;F
20611;925,434;49;M
20614;925,434;9;F
20620;925,434;14;M
20623;925,434;7;F
20633;1238,1720,925;45;M
20634;925,434;39;F
20635;1442;41;M
20637;1720,1234,422,1075,286,925,434;77;M
20639;925,434;47;F
20648;925,434;12;F
20651;660,440,539,1720,1623,1016,274,1240,221,1550,925,544,286,531,1236;39;F
20652;1442;13;M
20659;244,633,1234,221,1240,1238,422,109,335,925,286,434,97;71;F
20665;925,434;40;F
20666;650,260,660,1234,897,422,109,459,1075,286,894,1666,1236,925,434;12;F
20667;925,434;12;F
20668;925,434;43;F
20673;925,434;44;M
20675;567,1720,897,221;29;M
20679;925,434;9;M
20689;434;40;F
20692;909,260,1041,925,109,894,434;43;F
20696;1442,1199,1720,1238,925;49;F
20699;925,434,1153;49;M
20702;1041,897,221,1238,925,909,531,434;44;F
20709;260,1381,119,868,337,1720,1414,1240,1288,925,335,461,97,434,1666;10;M
20713;925,434;46;F
20728;446,544;59;F
20730;1628,909,250,109,286,1236,434;19;M
20738;925,1490,1381,1199,868,1414,335,109,434;42;F
20740;260,109,1075;73;F
20741;193;20;F
20759;221,440,1720,1623,1550,286;40;F
20762;335,544,1442,1234,119,677,780,250,1238,925,422,109,459,1075,434;34;F
20764;739,539,1199,1720,1016,1240,925,1236;48;F
20771;925,434;15;F
20772;260,109;67;M
20776;925,434;45;F
20785;925,434;47;F
20786;1238,925,335,109,434;12;F
20790;1153,461,909,286,531,1699,650,739,337,1623,780,897,221,925,434;37;M
20793;339,925,1016,335,109,963,1075,434;44;M
20795;434,1381,868,250,925,286;43;F
20806;434,925;40;F
20812;274,1238,925,434;34;F
20815;700,1666,1199,169,1217,633,739,660,440,539,221,1163,286,925,434;14;F
20820;650,539,868,337,1041,1623,250,897,221,1238,335,1075,286,925,434;43;F
20822;925,434;38;F
20837;925,434,1153;49;F
20838;1720,1041,1623,925,1628,434,57;51;F
20851;442,573,1093,868,119,337,1041,1238,1666,1075,109,422,335,925,434;42;M
20853;660,531,1414,1623,1550,1163,544,286;28;M
20854;925;17;M
20858;925,434;33;F
20859;1214,1217,55,127,1234,119,337,897,925,1628,544,109,434;38;F
20860;434,925;36;F
20863;925,434;50;M
20865;925,434;34;F
20868;925,434;12;M
20877;434,925;14;F
20882;925,434;16;F
20894;925,434;11;F
20895;434,925;47;F
20896;1041,1623,925,1163,109,1075,894,434,1153;12;M
20904;925,434;41;F
20905;925,434;16;M
20907;925,434;15;M
20908;925,434;15;M
20909;925,434;15;M
20910;434,925;15;M
20923;925,434;36;F
20930;260,1041,925,1163,109,1075,909,894,434;8;F
20936;925,434;40;F
20939;868,1041,434,925;45;F
20952;925,434;44;F
20954;434,925;47;M
20958;1075,1288,221,780,1720,1234,539,260,339,1217,660,193,1238,109,286;28;F
20960;925,434;40;F
20964;925,337,1720,1041,1240,1238,1075,434,57,1236;43;M
20969;925,434;42;M
20970;925,434;14;M
20977;925;45;M
20978;170,633,1720,897,1238,335,422,109,1075,925,434;42;F
20980;868,119,925,434;38;F
20982;633,739,446,674,660,1199,780,221,1238,925,1163,544,459,97,286;51;F
20984;925,434;38;F
20989;434,925;50;M
20994;440,1720,286,660,1623,1163;43;F
20995;650,685,1381,119,1623,780,274,250,1240,1238,925,1666,109,909,434;38;F
20998;925,434;6;M
21001;925,434;12;M
21006;626,553,440,127,1720,1628;39;F
21009;868,337,897,925,434;37;M
21010;1238,925,434;38;F
21017;925,434;41;F
21019;925,434;35;F
21020;925,434;43;M
21022;897,434,925;46;F
21024;440,539,119,337,1623,55,739,660,221,925,180,286,894,626,650;39;M
21029;925,434;8;M
21032;446,539,1199,119,337,1238,925,335,544,1075,286,434,97,1666,1153;47;F
21039;674,440,1199,1381,868,119,337,1414,1238,1288,335,422,109,459,434;42;F
21044;925,434;10;F
21045;897,925,434;11;M
21056;925,434;7;M
21062;925,434;40;F
21066;925,434;44;F
21070;442,1199,868,337,1041,780,1238,925,335,422,109,286,894,434,1666;42;F
21071;925,434;65;M
21073;925,434;60;M
21077;1666,440,660,244,685,739,539,1720,925,109,1075,434,1699,1236;52;F
21083;868,1199,573,260,339,685,193,677,286,274,1238,925,544,1075;46;F
21085;1221,446,244,1149,170,337,1016,422,109,286,1236,868,1238,925,1075;33;F
21087;685;45;F
21091;434,925;48;F
21092;925,434;10;M
21094;193,868,119,337,1720,1623,1240,221,925,1075,286,531,97,57,1153;44;F
21097;925,434;91;F
21099;925,434;10;M
21104;925,434;40;M
21109;868,119,337,897,925,434;8;F
21111;868,119,337,897,925,434;5;F
21118;925,1199,868,119,337,1238,109,1075,286,894,434,1666,1153;8;M
21121;925;41;F
21125;925,434;3;F
21128;925,434;8;F
21141;925,434;44;M
21142;1381,119,1238,925,109,1075,434;36;M
21145;1381,897,925,109,1075,434;8;F
21146;459,925,1075,434;41;F
21150;925,434;3;M
21158;1442;35;F
21163;925,434,1666;30;F
21165;925,1199,868,337,1238,335,422,109,1075,434;12;M
21167;925,434;8;F
21174;925,434;39;F
21175;925,434;42;M
21177;925;9;F
21181;925,434;64;F
21195;925,434;39;F
21199;868,434,1041,925,909;6;F
21200;925,434;38;F
21204;434,925;48;F
21207;685,1699,1075,461,154,544,1720,244,1199,677,1016,1240,1163,109,963;41;F
21211;925,434;47;F
21212;925,434;9;F
21213;925,434;44;M
21218;925,434;63;M
21219;868,337,1041,925;1;M
21224;925,434;47;F
21231;925,434;5;M
21233;925,434;12;M
21244;434,925;40;F
21245;544,531,97,700,1666,1153,1075,109,567,119,1720,1041,221,925,434;51;F
21252;925,434;86;F
21267;925,434;7;F
21270;925,434;45;M
21271;925,434;41;M
21283;1623,780,221,1238,925,335,434;44;M
21291;1550,544,109,1149,739,674,127,868,1623,925,1628,422,286,97,700;35;F
21294;260,1199,868,337,1238,925,422,109,1075,894,434;44;M
21296;170,1623,674,446,119,1720,1550,1163,260,660,442,221,544,109,700;65;M
21299;925,434;39;M
21306;1550,193,650,55,244,1234,1016,1163;44;M
21307;925,434;39;M
21310;925,434;39;F
21311;925,434;10;M
21319;909,1238,260,650,700,544,1163,1550,1623,1720,193,539,626,739,55;26;M
21326;1217,553,868,422,180,894;41;M
21327;260,739,780,1240,1238,335,422,109,1236,57;35;F
21332;925,434;48;M
21338;925,434;8;M
21342;434,925;52;M
21343;55,170,660,193,868,337,677,925,434;18;M
21344;925,434;45;M
21348;1381,286,339,1490,260,1234,868,119,337,1720,1623,221,1238,109,1075;36;F
21363;925,434;74;F
21367;925,434;42;F
21370;925,434;12;M
21373;434,925;11;M
21381;925,434;16;F
21389;335,109,434,925,1236;41;M
21402;925,434;70;M
21406;925,434;14;F
21411;925,434;14;F
21420;925,434;9;F
21424;925,434;83;M
21433;925,434;46;M
21444;434;63;F
21454;434,925;11;M
21481;685;40;F
21490;925,434;35;M
21493;925,434;70;F
21502;1236,286,1623,677,539,1041,780,1240,221,544,154;45;M
21505;925,434;35;M
21511;925,434;34;F
21514;422;10;M
21517;221,1628,531,894,286,180,459,539,567,1720,274,650,897,909,1041;38;M
21525;660,739,650;48;M
21543;660,440,221,1238,544,286;30;F
21544;1550,1236,685,221,1623,337,1199,193,739,1217,660,442,1238,286,1666;48;F
21550;539,57,434,250,780,567,660,531,894,286,909,180,1238,221,274;35;F
21554;1288,335,909,1153,1490,260,553,868,221,1238,109,1075,180,286,894;30;F
21558;127;49;M
21567;925;45;F
21568;57,1153,700,459,422,1628,221,780,446,260,660,1199,1623,1238,544;49;F
21574;633,739,1221,440,1623,539,1199,1234,250,1240,221,286,1236,422,180;15;F
21583;1240,1217,739,660,539,1199,193,1720,1623,221,1238,1628,109,286,434;85;M
21605;1720,1016,274,1240,1238,1075,909,286,1699,1666,55,170,1217,339,260;38;F
21606;894,1199,337,1414,1238,925,335,1236,260,1234,1720,677,1240,109,1075;67;F
21607;1623,894,97,55,685,739,260,1720,677,1240,1238,544,109,1075,1236;71;M
21611;1240,909,739,169,660,286,531,221,274;22;M
21612;925,434;7;M
21616;1240,897,1238,909,531,57,1699,685,650,1217,1214,1221,539,567,925;42;F
21617;677,780,685;45;M
21621;925,434;3;M
21627;925,434;1;F
21644;1236,739,539,677;25;F
21647;925,434;37;M
21664;109,1075,339,1236,1240,1720,244,677,1234;32;F
21666;442,440,660,739,339,169,127,119,677,897,221,1628,286,894,57;43;F
21672;434,925;47;F
21689;1550,221,127,553,169,1221,739,660,539,1381,1720,544,286,97,1153;47;F
21691;700,221,193,1199,660,674,442,119,544,1666,1153;69;F
21695;925,434;14;M
21706;1623,221,1628,544,286;38;F
21707;925,434;21;M
21711;677,1414,1623,274,446,674,1720,1016,780,1240,1163,544,422,97,700;25;M
21720;739,339,260,539,1199,1234,1414,1238;20;M
21725;119,868,1381,567,1199,442,553,169,626,739,650,573,539,1720,1238;44;F
21728;674,440,539,57,1666,286,1623,1163,650;33;F
21741;422,459,286,1699,894,57,650,339,660,442,573,1623,780,221,250;28;F
21762;685,1217,1214,739,660,553,440,539,1720,250,221,286,531,700,1236;29;M
21809;1041,335,97,57,650,1149,739,260,1442,1234,119,1720,544,1075,434;13;M
21815;685,109,573,1199,193,1234,1238,1016,337,260,250,1414;41;F
21828;1699,909,154,1628,250,780,1041,127,539,567,193,244,739,1214,650;23;M
21839;154,1550,739,244,440,1093,1720,677,1623,780,274,1240,1238,963,1236;29;F
21866;544,335,925,868,1442,739,339,633,260,1234,1720,1414,1016,1240,1238;43;M
21873;1550,1240,1016,1199,1217,1149,221,1238,286;38;F
21876;1238,1093,633,739,1199,1720,677,1623,1550,1240,154,963,909,286,1236;30;M
21884;660,539,119,1720,221,286,739,442,573,57;56;F
21891;1442,337,1720,1666;47;F
21900;339,221,1240,1217,739,660,440,539,1199,1238,1628,286,1236,531,434;22;M
21906;660,274,221,897,1238,925,286,894,434;37;F
21910;553,1550,109,286,531,1236,1699,1217,739,660,567,1720,1623,221,274;28;F
21911;553,925,1163,461,97,1414,1720,119,868,1093,1381,1199,1442,1238;23;F
21919;925,434;9;F
21924;1442,660,250,1016;9;F
21984;925,119,1214,446,1199,1720,1238,1075,1153,700,544,335,1550,868,674;38;M
21986;1381,1238,286,97,660,1149,1217,544,57,1153,700,1628,221,1623,1720;28;M
21993;57,1214,1199,193,1623,780,1238,1163,286,97,544,700,1720,1381,446;34;M
22009;109,260;64;F
22011;573,553,660,1442,260,1217,193,1623,1240,221,1550,925,544,422,286;34;M
22019;1149,1199,119,440,1238,925,286;38;F
22032;1199,1550,1236,650,739,244,660,442,1623,1016,1240;43;F
22054;1381,553,260,446,244,739,1214,1199,1490,1238,1163,1628,1075,1666,109;55;F
22060;119,1720,1041,1414,1623,1238,1288,335,544,109,1075,180,286,894,434;22;F
22093;260,109;64;M
22104;1199,1381,127,1550,286,1666,339,260,337,1414,1623,221,1238,1628,544;36;F
22116;739,1490,1217,553,567,1199,1381,1234,1093,868,250,1550,1238,894,57;31;F
22117;1666,1041,573,286,780,1240,1288,1623,1720,739,1199,1550,1236;22;F
22119;739,169,660,1623,539,127,1720,1016,1240,221,1550,286,531,434,1236;41;F
22136;339,1149,925,1628,1153,97;38;F
22137;685,868,1720,677,1623,780,335,422,459,894,963;28;F
22151;1153,700,97,286,335,1623,1720,119,260,1381,1238,925,1628,109,1075;28;F
22158;1217,660,440,127,1720,1016,1550,422,1666,1236,1153,1442,442,544,531;31;F
22170;1217,339,567,260,539,119,1623,221,1288,1628,544,1075,909,286,109;35;F
22171;567,868,1238,1163,925,434;45;M
22172;221,1550,1288,1628,544,422,97,1236,1153,567,677,1041,1414,925,286;48;F
22191;626,685,674,169,446,1221,739,1490,339,660,1720,1623,221,459,286;40;F
22203;868,1720,274,1238,925,335,321,97,1666,339,446,1414,1628,544,422;36;F
22214;260,650,1217,553,434,539,567,909,1153;38;F
22227;250,221,1238,337,1214,1490,1221,868,119,897,925,422,109,909,434;32;F
22239;739,660,539,221,544,286,1236;33;F
22256;274,909,1217,339,739,1221,260,660,539,193,1414,897,221,1238,286;29;F
22258;739,260,674,539,127,868,1720,780,221,1238,1163,1628,544,97,57;36;M
22263;1442,553,1199,193,868,1016,1163,544,180,700,1236;37;F
22270;260,109,1238,422,1720,567,1041,897,925,909,434;10;M
22272;221,286;32;F
22301;1149,446,1199,193,1628,544,894,700;49;F
22309;567,539,660,1442,626,244,739,193,1720,1623,221,1238,925,335,1075;26;M
22334;1075,1199,442,660,739,1149,626,674,1720,1550,544,286,700,1666,1153;36;F
22339;260,553,180,909,193,127,868,119,1720,1238,1288,925,1163,109,1075;38;F
22350;286,1490,739,260,660,440,539,868,1720,1623,221,1238,544,109,446;37;F
22357;339,1442,1199,1720,780,1016,221,1550,286;33;F
22368;1149,674,221,925,1628,544,422,286,531,321,1153;38;M
22380;544,180,1075,909,286,531,57,1217,260,660,553,539,119,925,109;35;F
22390;260,553,567,1199,1381,1234,868,119,337,1238,925,422,109,1075,180;35;F
22408;531,1221,1217,221,1550,1628,286,1149,446,674,337,1720,544,97,700;36;F
22425;567,1199,193,1041,274,897,1238,422,461,909,286,434;26;F
22482;422,180;55;F
22503;1442;36;F
22518;660,1221,739,1217,650,260,539,1623,1240,1016,221,1550,544,286,1699;38;F
22520;739,539,1199,1041,1623,1628,1016,1240,459,180,286,434,321,57,1236;24;F
22525;286,1214,1217,567,250,1550,650,244,897,274,1221,553,1016,422,909;26;F
22533;544,739,170,1381,1414,1623,1016,1238,1666,1236,339,1199,1720,1550,1163;30;F
22536;650,1217,660,1720,539,1623,780,274,221,1550,1628,544,909,286,57;36;F
22549;626,1628,459;34;F
22580;1217,633,739,660,442,1720,1623,780,1238,1628,544,909,286,531,1666;32;F
22585;897,221,925,335,286,434;41;F
22587;1288,925,1628,1149,674,1720,1414,221,1238,544,422,109,97,700,1153;55;F
22591;1163,1628,57,1236,650,1217,553,567,193,274,1240,897,925,461,909;66;M
22600;633,286,1623,221,531,55,1720,339,1381,1238,422,109,434,97;23;F
22613;1214,739,660,442,567,337,1623,780,897,909,286;43;F
22647;739,1199,868,677,1623,780,1016,1240,897,1238,925,335,422,154,1236;38;F
22649;286,57,1699,1666,169,626,1214,339,1199,274,250,925,1628,544,459;28;F
22673;422,180;41;F
22676;169,1623,780,274,250,1288,925,1628,57,1153,909,180,459,422,286;27;F
22699;286,531,1236,170,685,1217,446,660,539,274,1550,739,440,1623,221;42;F
22707;1666,286,180,109,1720,337,1093,1234,1199,539,440,660,1217,650,739;47;F
22724;1217,55,567,1041,1623,274,1240,897,1163,925,1628,461,909,286,1236;67;F
22731;567,739,339,660,1199,1234,119,1623,1414,897,1238,335,286,1666,1153;19;F
22767;1414,1623,700,544,221,1236,1550,925,909,674,1720,1381,553,626,1238;28;F
22773;109,335,1628,1238,1414,119,1234,1199,573,442,553,1442,446,339,1490;56;M
22804;573,1238,193,1720,567,339,1217,1623,780,1240,897,422,459,909,57;24;F
22828;868,1288;5;F
22838;180;44;F
22852;739,1217,650,339,573,539,337,925,154,1720,221,1238,1628,180,286;36;F
22860;1149,1153,674,539,127,1016,1628,544,422,1075,286;30;F
22888;1234,868,1720,1623,1550,1628,1075,1490,1149,1238,544,422,286,1153,97;36;F
22917;339,739,567,1234,119,1414,780,221,1628,286,97,57;26;F
22945;1623,1381,442,660,260,1221,1217,339,1214,169,553,539,567,1199,897;28;F
22947;633,739,660,440,539,1623,1016,1240,1238,925,154,894,1236;32;F
22958;1149,674,1720,1623,1414,1238,1288,925,1628,544,422,109,97,700,1153;61;M
22978;650,633,1217,739,660,539,1041,1623,780,274,221,1628,544,567,909;35;F
23010;1238,925,335,1236,1199,1234,1550,1240,1720;32;F
23011;1288,1238,274,1666,1221,660,1016,531,440,539,1623,1720,221,286,739;22;F
23021;1238,109,434,169,1199,1720,1240,660,1221,1217,539,1234,1550,1628,1623;18;F
23070;1623,539,660,1442,739,1550;37;F
23071;1236,250,440,650,739,660,221,286,1623,539,567,909,897;28;M
23087;1550,221,250,260,1041,650,193,1720,1623,897,894,739,274,1238,909;34;F
23089;780,250,1240,1628,544,739,539,567,1199,1093,897,1550,221,286,531;31;F
23096;286,531,321,57,1217,1214,739,660,1442,567,1720,1016,221,544,459;59;F
23105;1016,1550,925,1628,109,461,894,700,1236,440,1720,221,544,531,321;41;F
23106;1442,260,739,339,1234,1623,1238,1288,925,1628,544,109,894,97,57;49;F
23138;660,539,1623,274,250,221,1163,422,286,531,321,700,1236,1153,434;13;M
23148;650,539,1199,1720,1414,1623,780,1238,1288,925,1628,544,422,286,459;18;M
23182;573,442,626,1490,339,1199,1381,337,1720,1238,925,335,154,180,286;26;F
23202;337,1381,1199,539,442,660,739,1490,633,221,1550,1238,925,286,1666;38;F
23215;321,963,127,244,1217,1041,909,1628,544,897,1623,567,1221,650,1236;20;M
23248;660,539,567,193,1623,221,1238,1163,909,286,57;19;M
23259;170,553,573,193,868,1720,897,1238,335,434,57,1666,626,1414,909;27;F
23277;739,660,221,925,544;33;F
23308;1550,221,1623,119,868,539,633,739,1442,660,677,1016,1240,925,154;46;M
23311;1442;66;F
23326;1214,674,780,544,700,459;43;F
23336;660,567,1093,1720,1623,1550,1149,739,446,674,539,1628,97,700,1153;32;F
23341;539,244,739,650,660,1623,780,1240,221,286,685,1720,677,154,963;37;F
23348;1442;53;F
23361;1381,1016,274,897,1550,1628,154,1720,286,531,321,739,440,193,461;44;M
23369;868,539,553,660,739,650,260,1199,1381,1234,925,109,1075,286,434;46;F
23378;539,868,1623,221,1550,925,544,422,109,1075,180,894,1666,260,1234;40;F
23390;925,434;40;F
23393;244,739,1442,660,539,127,1720,677,1623,221,1628,286,434,1666,1236;32;F
23403;1288,1163,1628,461,180,531,1666,339,1199,193,1381,868,1238,925,963;52;M
23404;286,868,1623,274,1238,335;36;F
23410;1149,446,674,660,440,193,1623,221,544,97,700;43;F
23412;739,660,539,221,1550,544,286;19;F
23416;1238,1414,1199,573,442,1442,260,1490,339,335,544,422,109,1075,894;6;F
23423;925,434;40;M
23434;925,434;15;M
23436;868,119,337,544,1442;47;F
23440;925,434;11;M
23446;339,442,567,1720,1288,925,544;30;F
23447;573,1199,337,1414,1016,274,1238,925,1628,335,422,109,894,1666,1490;4;F
23460;109,335,1628,925,1238,1414,1041,337,1199,573,553,1442,260,339,1490;68;M
23464;286,1075,544,335,1240,780,1623,1720,119,1234,539,660,739,1214,633;40;M
23469;539,1041,1016,1240,221,286,1236,339,626,1199,337,1720,1238,1163,335;40;F
23482;335,1628,925,1238,1016,1414,1041,337,1199,573,553,1442,260,339,1490;70;F
23483;440,573,1381,868,119,780,897,221,1238,1628,544,422,109,286,894;47;M
23509;1153;40;F
23512;674,660,442,1199,1234,119,337,1720,1016,221,1238,1288,544,109,286;40;M
23518;422,531,461,700,739,1149,1217,1221,660,539,567,119,221,909,286;46;F
23551;531,1720,700,674,1149,1153,97,170,1550,169,1163,221,1623,1628,286;47;M
23552;544,1442;43;F
23562;339,260,553,442,119,1720,109,180;74;F
23563;180;48;F
23574;739,626,674,660,894,57,700,539,1720,1238,544,422,109,286,1628;34;F
23575;446,260,539,274,1240,286,739,674,660,440,1199,1623,221,1238,1628;31;F
23576;685,335;46;M
23583;553,440,539,1381,221,1238,286,1623,868,1041,1550,1628,544,434,97;37;F
23605;925,434;8;F
23606;1550,221,440,1221,1217,739,626,660,539,567,1199,1720,1623,1240,544;37;F
23617;1016,1666,633,925,660,422,1236,154,1041,677,193,1720,1240,1238,894;38;F
23623;925,434;26;F
23624;539,442,440,660,1221,739,1214,633,780,1550,1238,544,461,286,1666;29;F
23627;925,434;73;F
23639;539,1234,119,1720,1288,739;26;F
23654;1628,897,780,1720,119,539,442,660,260,1041,1623,1238,109,286,434;28;F
23658;1149,739,674,660,442,539,1199,221,544,97,700,1666,1153;65;F
23663;925,434;15;M
23667;660,1442,739,685;41;F
23670;685;45;M
23671;925,434;11;F
23673;1628,154,1075,286,1666,633,739,539,1199,119,1240,1238,544,97,1236;26;F
23676;700,739,446,674,660,440,539,1720,1623,1240,221,1550,1628,544,286;40;F
23677;868,221,1628,909,700;47;F
23681;335,434,1381,868;46;F
23689;1720,221,1163,909,286,1153,700,739,674,660,440,539,1623,925,544;53;M
23712;739,660,553,440,193,1623,780,221,1628,459,1075,57,1236,909,286;31;F
23718;1550,1240,1623,244,1016,739;38;M
23722;685,868,677;35;M
23735;434,321,57,55,650,626,660,193,1720,1623,274,221,1163,544,286;32;M
23738;422,963,1153,1236,1666,57,286,925,1240,1623,1720,677,1234,539,660;51;F
23762;1217,650,660,780,250,1240,1288,1628,1720,1623,1016,274,925,1666,1236;40;F
23778;1149,1720,1238,544,97,1153;27;M
23789;1217,339,626,539,1199,193,119,1720,250,221,1238,925,1163,286,531;31;F
23793;1550,739,660,539,531,440;43;M
23798;446,674,553,1720,1238,180;37;F
23805;1720,1041,909,925,434;41;M
23818;1149,260,440,1381,1720,544;38;F
23859;739,1442,539,1720,677,1238,544,1236,1199,1381,868,119,1623,1016,1240;24;F
23880;925,909,434,1699,1236,1153,650,739,1442,660,193,1623,1016,250,1550;46;M
23882;1442,1153;43;F
23889;193;55;M
23921;339,674,660,193,119,1720,221,1238,1288,544,109,286,626,1628;38;F
23925;1442;13;M
23947;1163,573,170,660,539,286,894,739,169,1199,544,1720,1623,221,1550;35;M
23968;739,553,539,1623,274,250,897,1550,1238,925,1628,109,180,286,1236;34;M
23978;55,1217,339,660,193,1720,677,274;27;F
23979;1149,739,446,1720,1628,180,286,97,57,700,674,660,221,925,544;47;M
23981;1628,1153;40;M
23995;221,909,660,440,1623;25;M
24000;169;72;F
24005;626,169,660,553,539,567,1623,1217,274,897,221,925,109,909,286;36;F
24014;1623,1238,925,1628,544,1153,97;31;F
24022;685;84;M
24030;440,1199,1623,221,1628,286,446,442,119,1720,544,1153,700;72;M
24037;440,660,650,1217,442,539,1720,1623,274,1238;28;F
24047;1199,780,1628,909,97,739,446,626,440,539,1720,1550,544,109,700;44;F
24050;650,119,1623,274,250,897,1238,544,422,109,459,286,434,57,700;31;M
24053;739,674,1093,1623,1238,700;20;F
24058;553,180,422;44;F
24059;685;84;F
24061;446,674,440,337,1720,1623,274,1240,925,1628,422,57,700;33;F
24070;868,119,1720,1041,1623,780,274,897,925,434,539,1199,337,221,1238;38;F
24098;685,274,250,925;68;F
24108;650,780,739,660,539,1720,1414,1623,1240,250,221,1238,544,286,434;20;M
24113;539,1623,544,286,1236,1217,1490,739,446,660,1381,1720,221,1238,422;38;M
24114;440,193,868,1093,1163,1490,260,660,442,1720,1623,109,97,1414,1238;41;F
24117;339,674,440,1623,1550,1238,925,544,1075,909,286;28;F
24125;685,337,274,250,925;68;M
24145;660,339,337,1238,335;46;F
24148;685,250,925;12;M
24166;685,250,925;8;M
24179;119,1381,440,660,626,739,1217,1214,1221,567,1199,274,1238,925,909;33;F
24188;1720,1550,925,1236,1238,1075,339,660,539,1623,250,221,544,286,434;18;F
24194;633,1414,1623,221,780,677,442,739,244,660,1199,1720,1016,1240,1238;33;F
24207;685,337,274,250,1240,925,963;44;M
24223;909,286,894,531,434,321,57,1699,700,1666,1238,335,544,422,97;36;F
24227;1199,260,170,55,544,337,868,440,339,1442;50;F
24232;170,739,567,193,1623,1238,1628,909;42;M
24241;461,1075,286,57,700,1666,739,170,193,127,1720,1016,1240,1550,1236;29;M
24264;739,1442,660,193,119,1016,274;49;M
24277;739,1075,1217,1238,1236,1199,660,274,193,260,109,169,1720,650,1623;26;F
24286;1199,897,894;29;M
24289;660,1381,1720,1623,221,1550,1288,1163,544,321,1199,1238,286,531,1699;23;F
24303;1720,1041,1414,1623,274,897,925,544,109,434;48;M
24306;446,674,1623,221,544,97,700;44;F
24308;221,1238,119,660,169,1221,739,1490,1217,633,170,925,286,434,531;43;F
24313;1238,1442,633,1623,539,739,660,1016,1240,221,1550,925,286,57,1236;49;M
24317;337,274,1240,894,909,1075,1217,169,221,180,286,1666,260,109;39;M
24335;868;35;F
24342;1075,1163,1720,193,626,739,1149,1214,260,660,1234,221,925,109,286;70;M
24368;274,925,780,1623,660,1666,1236,221,250,1240,1288,170,1550;38;M
24385;739,567,286,434,660,1041;49;F
24387;459,894,531,700,1381,539,1442,1149,446,337,925,544,422,286,57;15;M
24394;1153;41;F
24396;422,193,109;32;M
24400;260,650,55,57,1666,1236,339,1442,1234,1720,780,274,221,925,459;44;F
24406;339,685,244,573,1199,119,1016,1240,1550,1238,1288,925,544,109,286;48;F
24421;274;16;F
24430;250,1240,221,1238,544,180,286,531,434,1236,170,739,660,440,539;40;F
24433;1623,780,274,250,221,1288,894,1666,739,1720,897,1238,109,909,286;34;F
24460;97,894,544,335,1550,1414,674,446,170;64;M
24461;260,553,573,1199,1381,868,119,1238,544,422,109,459,180,97,1666;44;F
24463;553,221,539,274,925,909,700,1217,660,567,193,1720,1623,1238,544;37;F
24464;1234,1550,626,1628,335,422,544,1720,1381;40;F
24469;244,1093,739,1240,1016,780,1623,677,539,660,1442,963,286,57,1236;42;F
24482;660,440,539,567,1199,1720,1041,1240,897,1238,925,909,434,1699;29;M
24503;539,925,544,97,57,1217,1221,260,567,1199,1238,1163,109,1075,909;28;F
24512;660,1199,193,1381,422,1238,1163,286,894,1628,1153,1149,97,544,1720;49;M
24519;335,1666;36;F
24521;286,531,1490,339,1217,633,170,55,1381,1720,274,1238,544,1075,894;32;F
24531;1075,109,544,1628,1414,127,567,539,169,1666;27;F
24549;909,1550,1217,739,1221,626,660,539,567,1623,1240,221,544,286,531;36;M
24570;739,1623,221,286,700,674,544;76;F
24573;1699;19;M
24580;544,674,700;73;F
24596;567,1720,1623,221,925,1236,739,650,260,660,1240,897,109,909,434;35;M
24610;335;36;F
24611;1490,1217,339,446,1221,442,1381,1234,868,119,1720,1628,97,57,1666;30;F
24620;539,1199,1016,250,1240,221,1238,925,1628,1075,909,286,894,531,1236;30;F
24635;1240,739,1236,677,567;39;M
24636;446,626,274,221,1238,925,1163,335,544,459,286,321,1699,700,1666;50;F
24641;221,1238,422,180,286,1699,250,1628,909,650,739,660,1041,925,434;39;F
24643;1236,286,544,1550,221,1240,1016,1623,1720,440,539,660,739,925;19;F
24650;1217,674,539,567,1199,127,897,221,1550,1238,1628,544,461,57,700;19;M
24672;1236,286,544,1550,221,1240,1016,1623,1720,539,660,440,244,739,925;65;F
24680;868,119,337,925,544,1666,700;17;F
24682;339,868,337,1238,925,894,626,553,193,221,544,286;53;M
24684;1240,1623,337,119,127,1199,442,650,339,739,1442,250,1238,925,335;37;F
24688;1442,633,221,1236,286,1414,894,1199,1238,1550,170,1623,169,1163,127;28;M
24697;109,1075,169,650,633,739,244,260,1199,1623,1016,677,1240,1236,286;62;F
24700;440,1149,446,674,1199,337,1720,1414,221,1238,1075,286,894,531,700;43;M
24713;260,1238,868,544,57,700,109,1720,1381;37;F
24728;335,337,1234,1199,446,739,674,660,539,1720,1623,221,544,286,700;69;F
24735;650,660,539,567,1199,1093,119,337,1720,221,1628,422,459,286,97;20;M
24750;250,274,739,567,1720,1623,221,1550,422,1628,57,544,180,909,286;24;M
24751;1149,1623,925,1163,1628,544,97;24;M
24753;221,1666,339,626,553,440,442,193,337,1720,1238,925,544,286,894;57;F
24781;260,925,1163,1628,422,180,531,739,660,1623,286,221,1550,1238,544;53;F
24798;286;42;F
24801;650,1628,1699,1016,440,1623,963,250,1442;35;M
24838;1442;10;F
24894;127,1720,1623,780,260,674,660,221,1238,1628,544,422,109,531,700;41;M
24933;1381,193,1199,339,650,260,626,1720,1414,1238,544,1075;38;M
24945;780,221,1550,1628,1217,739,660,127,1720,1623,1016,1240,544,109,1236;33;M
24951;1442;15;M
24952;1442;13;M
24957;260,1490,339,674,442,1199,119,221,1238,925,544,109,1075,700,1153;70;F
24995;925,434;54;M
25030;553,169,260,1221,244,1217,739,660,440,539,1720,221,1238,286,531;43;F
25033;1381,553,260,55,650,1217,1221,1214,674,567,274,897,1550,1628,544;51;F
25042;339,660,539,567,1199,193,1234,1720,1623,221,1550,925,909,57,1699;31;F
25047;1666,1236,544;42;F
25053;909,1623,422,180;47;F
25058;459,1075,909,286,57,739,260,193,1720,544,109,180,626,553,1628;41;F
25064;780,1623,868,660,260,739,633,244,677,1016,1240,925,109,57,1236;42;F
25068;677;83;F
25069;1149,446,674,440,1199,337,1720,1414,221,1238,1075,286,894,531,700;39;F
25077;339,1666,193,1238,544;28;M
25084;286,626,660,193,1720,1628,909;44;M
25090;660,1623,221,422,180;51;M
25094;1217,739,660,440,539,193,1720,1623,274,250,1240,221,286,531,1666;27;F
25095;567,894,1217,739,1720,1623,1240,221,1550,544,909,286,626,127,1628;34;F
25134;1149,446,674,440,1199,337,1720,1414,221,1238,1075,286,894,531,700;8;M
25137;1075,339,1199,337,1720,925,434;43;M
25142;170,1217,1221,169,660,553,1720,1623,1550,1163,57,260,109,1075;39;F
25148;109,894,170,633,260,626,674,780,1240,1550,1163,544,1236;32;M
25152;1149,446,674,440,1199,337,1720,1414,221,1238,1075,286,894,531,700;3;F
25159;274,193,1199,674,626,446,739,650,55,1720,1238,335,544,97,700;25;M
25169;1149,446,674,539,1199,337,1720,1414,221,1238,1075,286,894,531,700;12;F
25172;685,868,925,739,169,567,1628,1217,660,440,221,286;55;M
25178;780,321;18;M
25192;221,1236,1666,57,544,897,925,1628,274,909,739,685,422,459,286;49;F
25222;170,739,868,1016,1240,1288,544,109,1075,894,321,57,1236;34;F
25239;739,660,674,1234,1720,1623,274,221,1238,544,109,1075,909,286,700;47;F
25280;650,250,109;41;F
25282;868;38;F
25289;925,434;41;F
25293;250;65;M
25314;894,1075,909,286,1217,739,660,440,539,1720,1623,1016,1240,221,1628;34;F
25341;119,286,1666,1236,739,260,660,1720,1414,1623,1016,221,1238,925,109;44;F
25354;170,339,739,1199,193,1234,1720,1623,780,1016,1240,1550,1163,109,1236;66;F
25358;739,1720,567,1221,1214,1288,925,109,909;51;F
25361;221,925,897,1623,337,868,1381,567,539,440,739,660,1238,544,434;40;F
25365;925,434;35;M
25368;1628,909,57,531,440,539,221,127,1550,1163,286;35;M
25373;193,335,739,1720,780,221,1550,1238,925,286,894,57,1666;32;F
25376;685,1623,221,459,286,97,57;46;F
25445;553,1623,221,544,180,286,1153;77;M
25492;539,1234,677,1623,780,1240,1238,925,1236,739,1199,1720,1628,544,963;36;M
25514;660,440,221,321,1666,1238;31;F
25516;660,337,1628,544,1221,440,650,1217,1720,1041,909,567,1623,925,434;37;F
25536;925,434;38;F
25547;1238,422,221,440,335,660,544;42;M
25565;925,434;3;F
25588;1199,1720,274,221,894,97;57;F
25596;1240;63;F
25603;674,700,544;57;F
25619;674,193,119,337,1720,1414,221,1550,1238,925,335,544,97,700,1153;39;F
25621;897,221,109,1075,909,1699,1236,739,1490,339,440,573,1623,544,286;31;F
25622;1217,739,660,553,440,539,567,119,1720,221,1628,180,286,193,544;51;F
25627;660,440,221,1238,335,544,422;42;F
25658;1442;45;F
25683;170,97,442,1199,193,868,119,1720,1238,925,544,1666,1153,674,700;53;M
25702;633,739,539,1016,925,1236,459,780,57,127,244,1240;35;M
25713;739,660,221,1550,1628,544,286;22;M
25715;739,446,674,567,780,221,925,1628,544,109,286,260,660,440,539;49;F
25732;739,221,1238,925,685,531,286;23;F
25745;1623,1016,897,339,739,660,539,1199,1240,221,544,963,286;32;F
25769;170,1414,544,109,660,1234,1720,1550,1238,286,1236,633,739,573,1199;68;F
25770;685,633,739,660,440,1199,119,1234,1720,1623,780,1288,925,544,109;49;F
25778;573,440,660,260,1442,170,1720,1623,221,1550,1238,544,109,286,97;51;F
25782;55,260,660,440,221,1238,335,544,422;9;M
25786;1149,446,442,193,868,1720,170,674,1199,1238,544,97,700,1666,1153;49;F
25805;260,553,539,567,1199,1720,1623,925,335,544,109,180,909,57,97;9;M
25830;1217,1221,868,909,1214,567;46;F
25839;1221,539,567,909,1214;44;M
25848;660,440,221,1238,335,544,422;7;M
25860;685,274,1550,925,894,1699,446,674,660,221,544,286,531,321,700;71;F
25876;286,169,446,1149,1623,1720,539,440,660,739,260,221,925,544,321;43;M
25877;674,1149,1628,97,700,1153;45;M
25883;1442;39;F
25884;1699,422,1628,250,894;43;M
25890;446,739,650,539,677,1016,1240,1238,925,154,963,180,286,57,1236;51;F
25906;1550,544,170,660,539,193,1720,1623,1016,221,1163,109,286,57,1236;34;M
25917;1288,660,440,539,337,1720,1238,170,339,1490,1199,1381,1414,1623,925;30;F
25928;1442;38;F
25931;780,442,339,170,739,260,1199,1381,868,1720,1414,1623,1550,1238,925;34;M
25950;1442;10;F
25961;1442;3;F
25963;446,1149,442,1490,339,1238,1288,925,1628,335,544,459,894,57,1666;22;F
25972;531,674,1149,260,660,1720,1623,221,1238,925,544,109,286,321,1153;44;F
25975;1217,1214,1221,539,567,868,909;69;F
25986;109,1221,1666,339,442,1381,868,1238,422,1075,1217,553,1720,180,909;33;M
25990;1442;45;F
25992;1623,335,909,1699,180,286,894,1490,573,1381,868,337,1720,221,1238;55;F
26008;335,925,1288,1238,337,119,868,1093,567,1199,442,260,1490;51;F
26022;1199,440,739,1214,1217,1221,260,660,539,567,1720,221,109,909,286;54;F
26040;260,1199,1093,1234,1720,1414,1238,1163,335,109,461,1075;41;F
26048;1442;47;M
26058;1153,1442,1623,700;37;F
26061;1720,1217,1149,674,660,1199,1381,1623,1550,335,544,1075,97,700,1153;48;F
26089;1666,1238,1199,685;46;F
26136;685,677,274,221,1628,422,963,286,97,1666,1236,739,1381,1238,925;45;F
26152;434,1699,1240,1720,539,660,260,109;53;M
26178;1720,780,286,260,660,109,1075,531,925,1238,1623,440,567,868,221;38;M
26179;446,739,260,440,573,539,119,337,1414,1238,335,544,531,97,57;44;F
26225;1240,1238,544,461,909,1153,1628,894,1550,321,1623,531,127,286,925;40;F
26249;422,109,97,1666,260,1442,573,868,337,1720,1623,1238,925,1163,286;46;F
26264;442,925,909,274;73;F
26268;1217,442,739,660,440,539,1720,1414,221,1550,1238,335,286,531,169;24;M
26275;170,1623,221,909,286,894,1236;53;F
26278;434,1236,963,1238,1240,274,685,739,539,1199,1720,677,1623;73;F
26282;422,180;39;F
26283;925,685;42;F
26307;660,650,739,260,1199,677,1623,1016,274,1240,221,925,1628,109,1236;37;F
26324;868,1381,442,440,660,633,339,260,1199,1720,1238,422,109,286,97;33;F
26343;633,1550,1016,1720,539,260,739,660,1240,221,109,1075,286,531,1236;51;F
26349;422,180;61;F
26359;1442;29;F
26361;422,650,660,539,567,677,274,1240,897,909,286,1236,685,1628,739;21;F
26362;193,868,337,1041,925,434,1153;50;F
26383;170,650,434,531,1240,250,274,780,1381,1221,244,339,1217,739,440;18;F
26386;97,461;42;F
26389;685;10;F
26390;461,1490,337,109;69;M
26396;1628,925,221,897,274,1414,55,1199,1623,1238,544,109,1075,286,57;19;F
26403;1234,1623,221,1699;25;F
26415;459,539,1221,1214,422,109,461,909;43;F
26419;539,1234,169,1221,1214,1217,739,660,1623,221,1699,335,459,286,57;25;M
26453;1623,1041,677,337,119,193,539,442,440,660,260,244,739,339,685;54;F
26471;650,1214,677,1041,1628,539,221,1288,1623,154,780,422,459,57;45;F
26496;674,567,274,286,531,553,539,1381,221,1550,925,1163,1628,422,963;64;F
26503;221,544,1720,1149,674,1628,97,700,1153;66;F
26545;685,553,440,567,193,1414,221,1163,335,422,180;44;F
26559;170,55,650,897,1628,909,286,434;55;M
26592;422,180;76;M
26618;422,180;62;F
26638;531,127,739,260,169,660,440,539,1199,286,221,109;33;F
26685;286,337,1720,925,897,434;42;M
26721;909,1041,1720,925,434;43;M
26723;434;41;F
26738;650,660,677,1623,780,221,897,925,97,286,422,1628,274,739,685;12;M
26766;925,434;9;F
26789;422,109,1075,335,1628,925,1238,337,1199,573,553,1442,739,1490,339;45;M
26794;1234,573,660,260,739,339,442,119,1628,544,909,286,1666;51;F
26797;1240,1238,459,461,286,97,57,739,660,567,193,221,1628,180,1236;14;M
26801;925,434;46;M
26804;97,1153,55,780,1628,446,260,1199,337,1623,221,1550,1238,544,286;41;F
26827;1550,286,868,119,337,1720,1288,531,700,339,739,539,221,1075,1236;52;F
26837;925,434;6;F
26860;260,337,1163,422;53;F
26890;446;42;F
26899;1550,1163,1628,544,461,894,260,109;56;M
26904;260,553,337,422,109,461,180,1153;11;M
26916;1199,573,442,660,1217,339,1214,1490,1221,260,553,567,1234,337,109;46;F
26917;650,739,1221,260,1199,1381,1720,1041,1623,1240,1238,422,109,1075,909;44;M
26923;1628,274,1720,1214,1217,739;38;F
26924;573,539,567,221,286,894,1153,1149,1199,119,1238,925,544,109,1666;45;M
26941;1623,868,440,260,660,442,925,1238,539,1720,274;23;M
26966;260,553,567,868,337,1163,109,1075,180;16;F
26993;539,660,260,1199,221,1550,1238,925,1628,422,544,109,1075,286,531;48;F
26996;868,1720,337,1041,274,897,221,1550,894,531,339,925,286,544,700;42;M
27012;221,1550,1238,286,1666,626,1720,897,909,321;33;F
27023;260,739,650,1217,440,660,553,539,868,337,1720,1623,925,422,180;33;M
27027;446,739,1149,674,260,337,1720,780,1238,925,335,544,286,1666;52;F
27034;221,925,286,434;44;F
27041;1041,1720,650,739,260,660,567,1381,1623,1240,1238,422,109,1075,909;8;F
27051;553,442,193,925,461,180;67;F
27059;660,170,739,1442,1550,1666,1199,1234,109,1240,260,868,119,1238,422;47;F
27070;337,1720,544,97,700;41;F
27074;221,925,286,434;19;F
27095;286,221,660,925,434;7;F
27121;660,1240,221,925,286,434;9;M
27127;868,119,650,1217,1221,260,553,573,193,221,422,180,909,440,109;37;F
27140;250,422,459,909,1699,700,650,633,739,677,1623,1016,221,1550,1628;22;M
27144;925,434;71;F
27146;1149,442,1199,119,1153,446,674,573,868,221,1628,544,422,97,700;38;F
27150;286,531,1628,221,1623,1234,567,539,739,1217,1238,1414,1720,1199,339;21;F
27157;260,442,1234,119,337,1720,221,1238,1550,335,544,109,1075,286,97;28;M
27218;553,567,1199,193,1720,274,221,1238,925,544,422,1075,180,909,286;39;F
27234;660,539,193,1414,1623,1238,1288,925,1163,335,109,286,531,1666,1153;71;F
27281;674,170,650,1214,260,626,567,780,897,335,109,459,1075,57,700;24;M
27313;573,539,1381,1623,221,286,57,1666,1238,780,1199,660,442,446,1490;27;F
27318;1628,169,1221,650,633,1217,739,440,539,1720,1623,1240,221,531,1236;24;F
27336;57,739,1720,1623,1238,1628,1550,963,1075,461,109,674,260,685,1414;30;M
27337;1666,544;41;F
27372;1149,446,674,660,442,539,1199,119,1720,221,544,286,700,1153,97;36;M
27373;55,633,660,442,1234,1720,1623,1240,221,1550,1238,925,544,422,286;40;F
27375;57,97,286,1628,925,260,626,1720,221,109,1075;42;M
27380;553,109,260;46;M
27419;260,626,1442,531,57,286,1238,221,1623,337,119,868,440,660,925;38;F
27436;650,1217,260,660,567,1720,1623,1016,250,1240,1238,963,286;28;M
27465;739,169,660,539,193,127,1623,221,1163,1628,422,963,286,894,57;52;F
27484;674,1381,1720,1238,544,286,531,97,700;36;F
27492;909,650,1217,1199,274;39;M
27508;1149,674,221,1628,544,97,700;28;F
27526;1240;31;F
27538;660,337,1720,925,335,1075,286,894,434;42;M
27540;1075,685,260,660,127,221,1550,109,286,531,321;46;M
27579;780,1016,1628,531,633,1217,739,660,539,1720,1240,221,925,544,286;42;M
27621;446,626,1414,1238,544,97;41;F
27635;567,1199,193,1720,1238,909;25;M
27645;553,109,339,1217,1214,1238,422,459,461;46;F
27652;674,1628,422,700,544;57;M
27665;1442;56;F
27677;739,339,193,1623,1016,1240;39;M
27706;169,626,1217,633,1490,567,1381,1234,1093,868,1238,109,1075,909,286;30;F
27748;260,739,660,440,539,1199,193,274,221,1238,544,909,434,1699,1236;52;M
27766;531,780,1623,119,1217,339,739,660,440,539,1016,1240,1628,286,221;53;F
27774;650,170,1720,897,1163,286,1699,57;44;M
27796;925,422,459,446,1720,780,1550,1628,1153,1149,674,544,97,57,700;42;M
27797;531,57,1236,1199,573,339,1217,739,539,119,1720,780,1238,434;42;F
27822;1381,461,660,567,109,925,1666,1075,894,97,1490,1288,1221,1217,422;38;F
27829;1550,925,544,909,286,434,57,1153,1720,1628;37;F
27834;180,650,339,260,1442,660,553,573,868,337,1720,1414,250,544,422;37;F
27846;1442;41;M
27863;553,180,461;49;M
27867;1623,780,221,1550,1238,544,1490,1199,1163,1628,109,57,193,1720,422;41;F
27868;660,440,539,1199,1720,1414,1623,1240,221,1238,1628,335,286,531,1236;33;F
27880;169,446,739,1217,170,650,55,539,193,868,1623,1240,221,1238,963;21;M
27893;339,1149,442,193,119,1720,1240,1550,1288,925,1163,422,461,894,97;35;F
27899;1238,925,321,739,660,440,539,1199,119,337,1623,1550,221,544,286;41;M
27901;633,660,1720,1623,1016,250,221,963,286,531,1236;34;M
27904;1442;9;M
27928;780,1628,422,1075,909,894,1666,1149,567,193,1041,1623,897,109,434;43;M
27929;446;35;F
27930;459,553,180,461;43;F
27938;1442;5;F
27946;1093,1234,193,539,339,244,1238,925,1153;24;F
27951;700;38;M
27953;1217,553,1623,925,422,180;46;F
27954;553,119,1240,221,422,286,170,739,260,660,127,250,1550,1238,925;39;M
27992;1221,440,567,1720,274,250,925,286,434,1442,573,1238,544,963,909;31;F
27993;909,1238,1221;26;M
28012;339,739,1149,674,442,573,1234,780,1628,286,1238,97,1153,1720,461;44;F
28029;1217,739,221,1623,553,660,626,461,180;85;M
28047;544,1666,286,531,260,660,674,440,221;48;M
28048;544,1238,274,1234,633,440,1720,780,1163,1217,660,539,1623,1550,286;28;F
28101;1550,1240,221,1221,739,169,660,440,539,1016,544,286,531,1236,1699;25;M
28117;193,925,1163,1720,274;40;M
28126;1628,109,1075,1236,260,1720,274,897,544,1199,1234,868,1240,925,422;57;M
28132;573,1414,567,1234,780,97,337,1720,274,1238,925,544,963,180,909;11;M
28157;446,1221,626,674,539,567,1199,337,780,274,221,925,422,459,868;41;F
28159;422,154,461,909,700,55,1217,339,739,660,193,1623,286,221,1628;43;M
28178;1238,1288,925,422,553,868,193,1221,119,1214,1217,909;43;M
28185;1442;45;M
28191;57,739,193,1720,1041,1623,780,221,1550,1238,925,1163,109,286,434;53;F
28196;739,1234,1720,1623,1490,440,442,119,1666,221,1550,1238,335,544,286;23;F
28199;780,221,531,339,442,1199,1623,1016,1240,1550,1238,925,544,286,1666;28;F
28201;739,868,1720,1240,1550,1238,422,544,109,894;39;F
28207;446,674,660,868,337,1720,544;56;F
28219;1381,193,1093,127,1623,780,1016,1240,1550,221,1238,925,1666,57,286;40;F
28226;1628,925,180,286,531,57,650,739,660,539,193,1699,1236,1240,250;30;M
28237;739,660,539,221,544;34;M
28249;674,440,1720,1623,274,250,221;26;M
28256;544,660,440,539,1623,221,1288,1628,286,531,674,1199,780,1016,97;49;F
28266;1217,440,573,1442,193,1381,127,1093,119,1720,221,1238,925,1628,544;26;F
28270;868,897,422,1236,633,1214,739,660,440,539,119,1016,1240,544,286;43;F
28290;422,109,1075,1490,674,1381,868,119,925,1628,335,544,97,700,1153;44;F
28314;321,633,739,660,539,1623,274,1240,221,422,286,531,1236,1016;45;M
28324;1442;12;M
28325;260,1016,1240,127,1720,1238,109,660,221,1550,1163,1628,544,286,531;37;M
28348;1442;9;F
28349;1199,909,119,260,1075;50;F
28350;1623,1075,894,97;26;M
28357;442,553,1666,626,440,286,567,1720,1381,1199,1238,193;23;M
28361;1442;39;F
28404;674,1623,1550,1163,700;32;M
28413;1217,339,1214,1221,442,567,1093,119,1720,1550,1238,1163,544,909,1153;44;F
28415;119,1199,539,573,440,660,739,193,1623,250,221,1238;28;M
28421;567,274,1240,1628,57,1236,650,250,925,909,434;43;F
28423;539,626,221,1238,925,335,422,180,286;39;F
28425;1720,567;31;M
28437;1240,1163,422,286,1236,677,127,539,660,169,739,685,260,1550,109;34;F
28444;339,739,244,660,440,539,1199,677,1623,1016,1240,221,1238,925,1236;26;F
28449;446,780,897,1238,925,335,544,459;55;F
28456;1217,739,1221,169,674,660,539,1623,274,1240,221,1550,286,700,544;47;M
28459;1016,260,626,660,1720,1623,221,1550,1238,1628,1075,286,700;53;F
28470;1442;44;M
28474;109,260;43;F
28480;339,260,626,674,925,422,109,286,446,544,97,1149,1153,700,1623;48;M
28492;531,1442,963,544,1163,925,1238,1240,1623,1720,337,193,1199,244,685;45;F
28493;1381,650,221,1628,422,286,1153,674,700,97,170,1149,260,1550,109;39;F
28494;868,422;40;M
28501;221,925,544,170,660,539,1623,286,1550,1720,677;57;F
28505;442,567,119,1720,1414,1238,909,180;68;F
28516;339,1490,660,442,1234,119,1720,1414,221,1238,109,925,434;21;F
28521;169,739,1217,660,1016,286,57;44;M
28532;1041,626,650,127,1720,1628;52;M
28545;250,274,539,1221,925,422,1699,260,1442;46;F
28559;897,925,434;34;F
28561;286,909,894,119,868,567,539,660,739,339,1720,925,1163,544;23;F
28575;544,97,1149,446;35;F
28588;260,1238,925,544,1490;41;F
28645;1699,539,440,633,739,169,660,221,286,531,434,1041,909,897,567;46;M
28652;97,1442;12;M
28664;260,109;41;M
28670;739,1199,193,1234,1720,1623,780,1163,422,109,260;44;F
28674;674,544,700;28;F
28681;925,1163,422,1442;44;M
28687;1238,925,1199,1381,868,119,1016,221,335,109,1075,573,739,894,1720;38;F
28690;674,127,1414,1550,700,1153;45;M
28709;1623,221,909,286,739,553,573,567,868,119,1720,925,335,422,180;43;F
28710;660,260,739,339,170,1490,119,1414,1623,1550,1238,1288,1075,894,57;42;F
28723;1442,1214,1217,339,1221,553,1199,1381,868,1238,925,335,422,180,97;37;F
28748;739,260,1234,1720,1016,1240,1075,119,544,109,1238,180,1288;44;F
28783;1153,337,119,440,660,739,260,868,1720,221,109,674,544,286,700;47;F
28787;660,677,1016,963,894,1236;46;F
28809;221,286,57,1236,1623,780,1016,660,739,1442;45;F
28810;97,339,446,553,868,1720,1238,1288;34;F
28833;963,894,434,1236,650,626,1442,1199,337,1720,780,274,1238,925,422;39;F
28840;626;38;F
28841;169,260,739,1217,650,1720,1041,780,274,897,894,97,57,925,434;43;F
28851;337,1238,109,1699,1666;39;F
28858;55,650,660,567,1041,1623,897,221,925,909,286,531,434,1699;22;M
28868;674,660,539,1234,1720,677,1623,221,1550,1628,544,286,531,321,1236;22;F
28876;180,422;46;M
28881;650,531,180,1490,446,1381,127,868,1016,221,1550,1238,925,422;34;F
28883;1153,739,660,440,539,1720,1240,221,1550,544,459,1236;29;M
28892;442,660,1623,925,1236,170,739,169,539,1199,193,1720,1550,1238,1163;46;F
28901;1623,544,650,170,739,626,660,539,1720,97;25;M
28928;169,127,1550,1238;47;M
28945;739,55,1217,1214,193,1221,626,553,539,567,1381,1720,221,544,909;52;M
28957;1238,531,55,1217,739,660,553,1381,274,897,544,109,909,1221,567;34;F
28958;660,440,1720,1199,1623,221;44;M
28960;55,260,553,193,1720,109,180;63;F
28978;337,1623,1238,1288,109,434,1214,1221,1442,780,221,459,909,286,57;47;F
28987;461,193,335,1666,633,1199,1238,169,1163,1720,1623,170,1550,531,286;34;M
28992;909,250,685;41;M
29010;544,154,109,461,963,1075,909,894,531,434,321,1699,57,1236,1153;27;F
29030;1666;66;M
29039;339,739,660,440,539,567,1623,221,286,97,1666,626,1238,1628,57;39;F
29082;1199,193,221,1240,274;29;F
29085;633,739,660,440,567,677,1016,250,1240,1550,909,1699,1236;41;M
29096;739,260,660,440,539,1199,1720,221,1238,286,57,650,1217,1623,1628;43;F
29121;739,660,440,539,1199,1720,1623,1238,1163,1628,544,286,97;24;M
29123;180,422;36;F
29124;925,434;39;F
29129;339,660,193,1234,1720,677,1240,1550,1238,925,109,461,1075,1199,573;40;F
29148;925,434;8;M
29151;868,274,250,925,335,422,459,461,434,1699,1236,1720,1623,1238,894;76;F
29156;677,1720,1234,633,1623,321,1666,1414,1550,221,531,170,286,1238,1288;42;M
29179;925,434;12;M
29186;1217,1221,1214,626,909,567,274,963,1699,1623,739,650,660,1720,925;26;F
29197;925,434;3;M
29208;650,1149,442,250,897,925,1628,544,109,1075,97,57,1666,1442,1238;22;F
29211;660,677,1623,1016,1240,1153;51;F
29212;339,260,169,660,440,442,1720,1623,221,1550,1238,1288,1163,544,286;56;F
29223;1149,339,567,1199,1720,1623,1550,1163,1628,544,459,180,531,434,1153;37;F
29247;274;30;M
29250;739,567,780,1623,422,109,909,539,1217,1414,1214,1221,1720,1075,57;59;F
29266;660,169,1550,544;51;M
29278;544,221,1623,260,339,1214,1221,567,1238,925,909,286,57;41;F
29289;1442,925,335,422,286;38;F
29303;422,180;44;F
29326;660,193,1623,674,274,925,321,1149,1550,286,97,700,1153;30;M
29327;567,909,539,1217,221,250,274,1623,1041,660,1236,434,894,1550,1240;25;F
29330;170,660,1199,193,780,1016,1240,221,1550,925,1628,422,286,434,1236;36;F
29356;1214;43;M
29361;1221,553,868,119,337,925,1628,335,422,109,909,180;36;M
29362;963,685,260,1234,868,109,1075,57,1699,1666;65;F
29385;1149,446,674,660,1199,1720,1623,221,1628,544,422,109,1075,286,1153;47;M
29433;685,677;80;F
29437;660,1016,274,1240,897,221,544,963,286,894,127,169;33;M
29469;567,1234,1153,700,119,339,1149,739,1623,221,1238,544,109,286,97;52;F
29504;260,1234,1720,1623,221,1238,1075,286,97,1666,674,544,109,321,700;69;F
29539;422,180;42;F
29541;446;54;F
29545;1217,119,1221,57,909,1075,461,459,553,109;34;F
29578;1149,446,674,1628,544,97,700,1153;44;M
29595;119,868,127,1221,685,1217,244,677,1623,1240,154,1699,1236;61;F
29610;739,1221,660,440,567,221,909,531;61;M
29642;260,1199,868,780,1628,97,1236;35;F
29645;1699,739,244,169,660,567,1623,1016,1240,221,1550,544,909,286,1236;28;F
29651;422,1666,650,1214,739,440,660,442,1720,1623,780,925,335,1699,434;65;F
29662;739,244,1236,1240;51;M
29668;1381,339,1149,660,119,221,1238,925,335,544,422,109,97,700,446;37;F
29680;446;45;F
29685;446;47;M
29712;553,1720,461,897;15;F
29718;1240,274,1623,677,119,442,339,1199,1234,1550,700,1666,1153;21;F
29740;1163,1240,539,685,633,739,660,677,221,544,531,1666,1720,1623,286;37;M
29746;446,1238,1199,1381;36;F
29754;544,97,1075,446;44;F
29769;1490,1149,446,1199,1381,1720,1238,544;41;F
29777;1720,925,544;45;F
29794;1240,1550,286;74;M
29795;1221,660,539,567,1381,868,897,221,1238,909;36;F
29817;1381;44;F
29825;650,170,739,660,1199,677,1414,1623,1240,221,1238,963,286,531,1236;36;M
29833;650,1217,440,567,1041,897,1628,909,1720,1414,170,1623,127,169,1163;33;F
29844;127,1628,1381,1720,1550,1163;42;F
29876;446;36;F
29887;1217,1221,442,539,1199,193,1234,868,1720,925,1666,650,1214,553,274;42;F
29892;274,1550,1217,1221,260,440,539,1720,1623,1240,221,544,109,531,286;42;F
29949;660,446,674,193,1093,1550,1163,1628,442,1199,1720,221,925,544,700;69;F
29970;442,335,1666;63;F
29981;221,553,1238,1628,544,422,109,459,461,180;42;F
29993;1550,422,337,1623,544,286,170,221,1628,1381,1720,925,1153,97,446;42;F
30010;909,894,440,660,1221,739,339,1217,567,1623,274,1238,286,1075,180;39;F
30015;97,1238,739,422,446;36;F
30036;1234,335,260,1442,1720,677,1550,1163,1628,109,1075,286,1666,170,1199;28;M
30042;459,461;57;F
30059;1240,1550,1163,700,1236,739,660,544,440,286,1666,1720,1623,221,1238;53;F
30084;1442,1149,1221,119,250,1153,1217,440,539,1016,274,1240,221,286,1236;29;M
30087;286,894,531,221,539,440,660,1221,1149,674,1628,544,97,700,1153;37;M
30104;434,700,440,1442,260,1221,446,1214,685,739,660,1234,286,57,1236;25;F
30118;1217,260,127,274;52;M
30131;1550,446,660,193,221,461,286,531,674,1720,1623,1240,544,97,700;72;M
30166;1221,1217,1214,221,909,567,286,539,180,1628,1199,626,553,440,422;40;F
30201;1623,1550,963,650,1217,739,567,1199,1381,868,274,1238,925,1163,422;37;F
30248;1550,1666,1236,1153,1288,677,337,1093,442,626,1490,339,1217,170,55;17;M
30272;626,169,55,1217,650,286,1238,221,780,1623,539,440,660,739,274;37;M
30306;894,650,1217,1442,660,677,1041,274,250,1240,897,1550,925,963,434;37;F
30345;446,897,109,1075,97,700,1153;47;M
30384;739,1442,660,553,539,868,119,780,1238,925,335,422,180,286,894;37;F
30394;274,286,531,739,1217,660,1623,1240,221,1153,1236,539,897,909,567;23;F
30395;459,700,674,1699,739,244,539,1623,531,650,1214,567,780,1628,422;15;M
30399;97,1236,1153,674,1221,1149,633,170,650,1199,1720,1623,925,544,286;25;F
30410;553,567,539,1381,337,1623,221,1550,1238,544,109,180,909,286,700;30;M
30424;1720,553,660,1221,567,1623,780,221,925,422,909,57;46;F
30431;626,660,567,221,544,909,286,685,1236;73;M
30433;626,1623,286,674,700;41;M
30442;739,1720,1623,286;38;M
30509;567,1093,337,650,1217,339,739,660,1414,1623,780,1238,1628,700,459;21;M
30525;660,539,1016,274,1240,286,1236;79;M
30529;422,180;62;F
30557;567,337,221,1628,909,286,1666,422,180;65;M
30564;335,1623,626,660,553,539,1720,925,221,422,180;6;M
30568;446;12;F
30581;442,193,1041,250,221,1550,1238,544,286,1699,1236,57,434;55;M
30587;446;47;F
30601;1628,544,459,286,1666,1217,553,1199,1381,1720,1623,1550,925,180,909;62;F
30613;633,739,446,442,674,1217,573,440,660,1490,897,221,1238,1666,1153;23;F
30619;446;44;M
30645;650,544,963,286,1236;29;M
30653;1623,442,339,1199,1093,1238,335,286,531;35;F
30661;1221,1623,1240,335,544,1666,1236;25;M
30671;286,221,539,440,660,739;31;F
30677;868,119,1623,1016,274,1240,925,221,422,459,909,434,1236;27;M
30678;660,539,567,1720,1623,780,1238,461,459;45;F
30688;1199,1381,127,1234,544,1153;52;F
30693;169;54;M
30699;567,1720,250,1240,1238,1075,1666,780,1623,1234,1381,1199,539,440,660;24;F
30708;339,1442,539,1199,193,119,250,221,925,963,286,531,1699;48;F
30709;660,739,169,1720,274,897,221,925,1628,459,909,894,434,1236,57;9;F
30750;674,700;83;M
30764;868,1414,422,434,1238,193,1623,1163,544,286,925,1236,1240,1234,1720;14;F
30808;685,1153;79;M
30812;335,1238,422,963,1075,286,539,442,660,739,339,1720,1041,925,434;11;M
30815;739,539,567,221,1238,260,660,109,909;49;F
30817;925,434;57;F
30842;700,674,193,1199,1720,544,286;18;F
30844;1666;68;F
30848;1442,1199,1720,1414,1623,1016;49;M
30857;1288,337,685,339,260,442,119,677,780,1016,1240,925,1163,109,97;57;F
30866;440,567,1720,1628,286;26;M
30873;1234,1075,780,1414,573,1238,685;40;M
30880;1666;75;M
30890;650,1217,1490,1214,442,539,868,119,1240,897,335,109,459,894,1666;36;F
30892;1288,660,1217,339,1221,260,442,539,567,1623,1238,109,909;43;F
30898;440,1720,633,1217,739,660,539,1016,221,286;40;M
30911;1720,1381,440,97,446,544;38;F
30935;422,180;76;M
30939;553,337,1628,1075,180;47;M
30947;1442;39;M
30948;674,700;73;F
30976;553,461,1214,1093,1238,260,109;39;M
30984;1442;8;M
30985;119,1623,250,1240,221,109,286,894,531,434,1236,1199,539,739,650;30;F
31003;1442;7;F
31010;422,180;75;F
31055;544,286,1628;31;M
31069;260,553,567,1093,1720,925,109;31;M
31110;925,1442,553,567,544,422,180;40;F
31160;1199,119,1623,274,221,286,434,674,1414,925,544,109,97,1153,700;24;M
31163;1666;73;F
31182;446;40;F
31186;446;43;M
31231;925,909,567,897;39;F
31237;446,221,97,700,1153;43;F
31249;739,626,539,193,1234,1720,1623,1016,1240;21;F
31272;1442;49;F
31276;180,422;11;M
31277;193,127,1163,434;17;F
31306;221,1628,154,459,531,321,57,674,1720,780,1550,1238,544,286,700;29;F
31307;1016,274,1240,925,459,180,1666,1236,1214,567,1199,780,1238,909,57;30;F
31308;1442;56;M
31312;780,1623,119,1093,1234,193,1199,539,573,440,660,260,739,1149,1238;25;M
31314;674,660,553,442,539,1199,868,119,221,1238,544,286,97,700,1153;54;M
31322;1016,1623,119,440,1442,260,446,739,339,1234,127,567,660,169,109;57;F
31350;1153,739,626,660,440,193,1381,1093,1720,221,1238,1163,544,1075,286;54;F
31374;1217,1214,1221;41;F
31378;422,180;45;F
31393;422,180;42;M
31409;422,180;12;M
31418;660,553,440,539,1623,274,221,180,909,1153;54;F
31425;1666,1628,780,119,446,442,1199,97,700,1153;35;F
31430;1550,1016,1720,539,660,626,446,1149,170,674,193,1238,544,97,1153;46;M
31431;422,180;7;F
31443;1199,868,109,1666,1238,1075,1699;44;M
31503;1217,739,660,539,1199,868,1720,1041,780,221,1238,925,544,286,434;40;F
31520;1199,1234,1720,780,1016,1240,221,925,1628,286,531;31;M
31539;1221,339,119,868,1666,1149,446,674,553,925,1628,544,97,700,1153;45;F
31543;1666;65;F
31553;739,660,440,1414,1623,1217,626,1199,193,1093,221,1238,925,909,286;45;M
31571;1666;92;F
31586;55,260,660,868,337,1238,109,1075,286;42;M
31592;109,55,685,440,1623,894,531,739,169,660,127,221,1550,1163,286;49;F
31604;339;48;F
31614;446,244,660,440,1153,539,1720,1414,1238,109;26;F
31620;1217,567,1234,868,337,1238,544,109,1075,909,57,1666,1153;44;F
31641;422,180;51;F
31648;193,180;64;M
31651;685,660,1199,1093,1720,677,1623,780,1016,274,1240,1550,544,963,1075;39;M
31654;660,440,539,567,1234,868,1720,1041,780,274,221,459,286,434,57;13;M
31658;1442,442,1288,1238,221,180,1093;41;F
31697;422,180;36;F
31716;539,567,868,544,909;35;F
31719;55,739,660,440,539,1199,677,1623,1016,1240,1550,925,963,286,1666;64;F
31723;1666,963,335,925,1238,780,337,119,868,442,660,260,685;43;M
31733;1217,1221,260,660,539,567,1623,109,909;66;F
31734;780,1041,1720,440,55,1217,567,1623,909,739,660,539,221,286,434;43;M
31735;1381,1163,1075,1217,739,260,660,193,1623,780,250,1238,925,909,1236;17;M
31769;1217,539,1550,1236,660,440,193,1720,1623,221,925,1163,544,286,119;31;F
31771;337,274,1550,434,1666,1720,339,1217,539,1199,1623,897,1238,925,57;32;F
31815;553,193,221,109;31;M
31821;221,1550,1238,544,434,626,1221,739,339,633,440,539,1720,286,531;43;F
31831;1666,1153,739,660,539,567,1623,221,925,544,909,286,1720,626,1628;34;F
31848;1199,780,1550,1238,1163,909,894,1666,1236,660,1234,925,1720,1623,1628;47;M
31851;894,109,1238,1240,274,119,1381,260,434,963,422,335,925,677,685;40;M
31856;739,221,1238,1163,286,894,1666,685,633,539,337,1720,677,1240,1236;38;F
31860;57,250,1240,109,539,1199,1217,739,660,440,1720,1623,221,925,286;50;F
31865;660,626,446,244,274,1240,1623,1381,539,440,674,1149,739,1016,544;73;M
31866;650,446,674,1623,97,1288,274,1238,1628,109,660,1720,780,700,544;56;F
31896;170,1016,1240,1236;47;F
31928;1666;75;M
31942;442,193,1550,1238,335,422,180;70;M
31953;1628,434,1666,440,868,1720,1041,250,1163,335,544,422,461,180,909;68;F
31955;1699,685,1414;38;F
31972;739,260,109,544,221,119,660;71;F
31973;539,573,339,260,660,1199,1234,1093,1720,250,1238,109;20;F
31984;221,286,650,1214,739,660,539,1720,1041,780,1238,1628,459,434,57;48;M
31985;553,193,119,422,109,459,461,1075,180;45;M
31998;1238,1075,1666,57,422,180;44;M
32003;440,442,868,780,1238,925,335,963,739,260,685;10;M
32019;700;78;F
32022;650,1149,127,1041,1214,459,909,57,1628,567,1623,780,553,539,1221;40;M
32024;1214,1217,170,650,739,660,539,567,193,119,1016,250,1238,1628,544;30;F
32030;553,539,567,193,1238,925,422,459,461,1075,180,909,286;13;F
32043;677,1236,544,180,127,1628,626;39;M
32055;894,897,1628,1623,127;41;M
32073;260,109;72;F
32082;339,1490,868,1238,925,335;29;F
32094;422,180;37;F
32095;685,739,1442,780,109,57,286;44;M
32108;539,440,553,660,169,260,739,1217,459,1075,909,286,894,57,1699;31;M
32124;260,553,539,221,1238,925,1628,544,422,109,180,909,286,97,1699;38;F
32142;55,739,260,660,553,567,221,925,544,109,1075,180,909,286,57;42;M
32146;553;34;F
32150;119,868;40;F
32153;1442,1199,1381,337,1414,1550,335,1666,868,1720,780,422,339,1238,925;36;F
32154;57,700,1236,221,1288,1238,434,97,1153,1666,739,660,539,286,531;39;F
32157;925,780,1199,573,868;34;F
32173;1666;53;F
32176;553,193,461;56;F
32187;1720,1442,553,422,1214,1221,894,567,897,909,650,1075,1238,274,626;37;F
32209;868,739,440,573,539,1199,119,1623,221,286,531,1550,1238,1628,544;43;M
32212;1199,925,154,894,97,780,1240,1623,1238;25;M
32214;286,539,660,685,739,169,440,127,1623,221,1550,1163,109,894,531;15;F
32215;440,1628;31;M
32218;1238;22;F
32221;674,868,925,321,700,260,193,335,544,109;44;F
32223;1720,1041;68;F
32224;221,925,1628,180,909,286,531,1217,739,1221,553,567,1623,897;38;F
32225;868,1041,1550,925,1163,909,286,660,193,274,1288,335,97,1238,1720;21;M
32237;1199,1720,1016,1240,221,1550,1238,335,109,459,1075,286,531,57,1236;33;F
32248;539,260,739,1442,674,660,193,337,1623,221,1238,925,544,422,446;48;F
32251;170,633,739,244,660,440,539,1720,677,1016,1240,1550,925,109,1236;46;F
32264;1217,1149,739,674,660,1720,1623,1550,1238,1163,544,286,97,700,1153;23;M
32271;1236,170,1442,660,1199,1153;26;F
32286;440,1199,193,1381,1234,1720,1623,1238,1163,1628,335,109,1075,434,1666;35;F
32297;180,221,897,780,1381,539,553,739,660,544,1236,440,925,286,531;39;F
32301;1666;54;M
32309;434,1666,1234,1381,339,539,1199,193,1623,274,1288,1153,1720,573,1238;20;F
32317;700,286,459,422,1628,1623,539,660,674,739,446,440,1720,221,544;37;M
32324;780,335,459,1075,894;29;M
32326;260,739,1490,339,170,169,1199,127,868,119,1720,1550,1238,335,894;33;F
32334;1217,1214,1221,553,193,1234,337,1720,1414,180,57,459,461;41;M
32340;685,739,169,660,440,539,127,1623,221,1550,1163,109,286,894,531;49;M
32341;660,674,1414,1623,1288,1238,1163,1666,339,1199,193,1720,260,109,1075;53;F
32351;925,434,1153;11;M
32377;925,434;25;F
32379;1149,446,1199,1720,1163,544,97,1153;48;F
32382;422,180;39;F
32387;274;24;M
32409;925,434;30;M
32421;180;43;F
32436;925,434;32;F
32446;459,1236,650,1217,1149,739,260,660,539,567,1041,1623,221,531,1238;23;M
32453;1149,446,1199,1720,1163,544,97,57,1153;10;M
32456;925,434;31;F
32474;925,434;36;F
32475;1236,1550,925;42;F
32484;674,1442,260,739,446,539,193,337,1623,1238,925,544,422,180,97;45;M
32485;109,1720,440,685,739,169,660,539,127,1623,221,1550,1163,286,531;18;M
32494;335,544,286,531,97,700,440,442,539,553,446,1153,660,674,1628;28;F
32502;925,434;35;M
32510;221,1238;41;M
32511;573,1199,1238;52;F
32514;1550,1236,925;39;M
32518;925,434;12;F
32527;244,442,539,1199,1093,868,119,1720,1623,1240,221,459,286,531,1236;61;F
32532;925,434;6;M
32536;55,539,335,1666,440,626,739,339,1217,1199,193,1720,1623,250,286;32;F
32538;339,1199,544,286,109,1550,221,1623,1720,1234,539,660,260,739,650;63;F
32549;897,1238,1288,925,894,1236,169,127,1720,1623,1550,1163,1628,544,109;35;F
32577;170,260,1720,1623,1163,109,1075;64;F
32582;339,1199,193,1414,434,700,1238;22;F
32589;925,434;44;F
32592;339,660,1720,221,335,321,1666;58;M
32618;286,1163,1720,119,553,339,193,1381,1623,221,1238,925,422,461,180;27;F
32627;660,440,442,119,1240,221;71;F
32629;660,539,780,221,286,1236,154,1623,274,909,1720,434,925,1041,567;42;M
32630;274,1240,221,1550,909,286,1699,1236,739,660,539,1016,1628,544,57;26;M
32632;193,1720,544;64;F
32649;700,440,260,244,339,660,1623,780,1016,250,1240,1238,109,1699,1236;35;F
32676;626,553,440,1199,193,868,1720,1550,925,1628,459,180,286,894,57;39;M
32681;1199,1149,260,660,539,1234,1623,780,1288,925,434,1217,567,1238,109;49;M
32692;674,626,1221,339,1217,1490,442,539,567,1199,1238,109,1075,180,909;33;F
32713;567,909,286,57,459;36;F
32721;539,274,459,1240,1550,221,1238,1288,925,544,422,461,286,180,1153;52;F
32722;1199,1234,677,221,1238,1288,963,286,57,1666;67;F
32733;170,739,244,442,1720,1623,1240,544,1666;39;F
32753;169;70;M
32784;57,1666,1236,685,170,260,440,339,244,1199,780,1238,925,109,963;24;F
32785;739,169,674,1234,274,221,1628,700,1153;42;F
32790;925,221,1623,193,539,660,626,739,170,1199,1720,677,1240,154,1236;42;F
32796;650,739,221,544;24;M
32797;274,1550,1238,544,97,1236,650,1217,739,677,1016,1240,1075,1163,109;49;M
32801;539,1236,1666,1075,1623,1240;30;M
32813;1238,925,422,260,339,573,539,1199,1234,868,250,897,109,1699,1236;29;F
32814;739,459,286,1490,260,553,193,337,1720,1623,221,1238,925,422,180;36;F
32835;1381,119,780,1550,1628,963,286,1236,660,440,1199,1720,1016,1238,544;25;F
32841;1149,339,650,685,442,193,1093,119,221,1238,925,1163,544,894,57;56;F
32859;925,434;40;F
32866;925,434;45;M
32875;925,434;10;F
32881;925,434;8;M
32888;925,434;7;F
32892;1442;38;F
32896;567,1199,337,1238,286,180;50;F
32911;633,55,660,567,1720,1623,780,1628,422,459,180,909,286,434,57;36;M
32947;531,127,780,221,1550,1628,286;40;M
32992;1217,739,660,539,868,1720,1623,221,1238,109,459,286;44;F
32993;193,567,539,553,674,169,1214,1217,626,127,780,1628,544,459,57;41;F
33004;650,170,1217,339,660,539,567,1381,780,897,1238,925,531,57,1666;24;F
33016;57,1666,260,1221,446,1234,1720,274,221,1238,1628,544,109,909,286;39;F
33033;897,660,169;36;M
33051;1623,221,674,660,1720,1550,1238,1628,544,286,700;32;M
33063;1238,422,459,909,180,286,531,894,434,97,57;22;F
33108;739,660,440,539,567,1016,221,286,97,127,1163,1628,531,700;46;M
33110;339,685,1217,1214,1442,260,868,119,1720,1238,109,1075,894,57,1153;44;F
33162;339,660,119,868,1720,780,1550,1238,335,544,459,321;45;M
33164;459,422,553;36;M
33184;1199,677,1623,1240,1550,1238,459,286,57;35;F
33195;677,1217,169,660,1720,221,1238,286,531,1153,97,739,440,539,1623;15;F
33197;1075,925,1238,897,1623,1414,1221,1214,1217,539,567,868,909;43;M
33217;567,127,321,1628,909,286,440,660,244,1149,700,674,1153,169,221;51;M
33218;660,440,539,337,221,925,286;36;F
33221;660,1628,1153,674,221,700;59;M
33231;422,1217,553,193,1720,109,180;77;M
33252;339,55,677,1238,1234,868,1163,109,170,685,1623,244,260,539,1199;47;F
33265;1238,909;43;M
33269;446;40;F
33272;1666,544,1623,1720,321;38;M
33287;539,1381,1720,1623,221,925,1163,544,286,700,1149,440,1628,97,1153;44;M
33291;440,1217,660,626,260,339,442,573,567,1199,337,1623,1238,1288,909;28;F
33310;1623,1720,119,1093,440,660,1221,1217,739,539,1381,868,337,1016,1240;30;F
33329;1666;74;F
33332;274,1623,677,119,553,1221,244,739,1149,1217,650,685,442,539,1199;35;M
33360;1217,1720,1221,119,567;45;M
33362;567,1720,1041,1623,780,1016,274,459,109,1699,1075,909,286,894,57;38;F
33363;1217,567,897,1628,909;30;M
33396;660,539,127,1623,780,221,1550,544,286,1236;40;F
33397;544;51;M
33406;531,434,739,1720,1016,221,286,1699,1238,894,274,1490,250,650,1442;37;F
33427;180,459,461;49;F
33444;660,780,335,544;35;F
33463;459,461,925;46;F
33465;422,459,461;37;F
33468;660,539,650,1628,567,909,1217;29;M
33485;1217,553,193,1720,422,109,180;71;F
33487;119,868,1442,260,442,1199,1016,1240,1238,1628,109,1236;62;F
33497;109,544,97,1666,626;22;F
33518;739,1490,339,442,539,1199,1093,1720,1414,1238,1288,335,544,286,1153;64;F
33538;685,739,539,544,286;48;F
33549;660,739,339,1217,539,567,1720,1623,274,1240,221,1238,700,909,286;33;F
33567;1149;48;M
33576;339,335,544,442,1550,925,1238,1442;39;F
33606;169,1199,127,868,1720,1550,1163,1628,109,286,894;31;F
33609;274,925,544,422,459,909,286,57,1153,1628,780,127,119,221,1550;29;F
33640;780,1381,193,1442,440,660,739,539,1720,1623,221,1550,1238,925,286;31;M
33666;685,677;74;F
33674;169,894,1720,127;34;F
33716;660,440,539,193,1240,109,963,1699,1236,1041,1217,250,434,1720,154;50;F
33734;739,1149,1381,1623,1550,1666,1153,531,286,544,1628,1238,221,1720,660;27;F
33747;260,739,660,539,567,868,1041,897,109,909,286,894,434;30;F
33756;154,109,909,434,321,1236,685,339,739,660,1720,1240,221,1238,286;30;M
33757;1221,868,286,1214;31;M
33775;1442,1238,335,422;37;F
33790;1149,674,660,1199,1720,1240,221,1238,925,1163,544,286,97,700,1153;42;F
33811;1490,539,868,1623,780,274,894,434,925,422,1041,109,567,909;37;M
33837;1628,286,894,531,1199,127,897;43;F
33838;544,1666;65;F
34003;446,674,660,440,539,1199,1720,221,544,286,531,1666,1153,1238,1628;55;F
34008;55,1217,739,260,660,440,539,193,1623,221,1238,544,109,286,531;32;F
34011;1199,573,660,260,170,739,127,1623,221,1238,1163,544,286,894,169;34;M
34033;553,1234,1720,1041,57,1238,1153,531,909,539,1623,1550,1628,544,700;39;M
34075;459;14;M
34085;1217,925,422,1075,286,1666,1236,660,1234,1623,544,459,57,780,1628;51;M
34116;685,1381,260,1628,459,221,660,193,109,286,440,1238,897,1075,1236;29;F
34122;909,1217,660,567,1720,1623,780,1238,109,1214,1199,868,335,544,422;49;M
34146;339,1628,1666,1153,700,97,544,925,780,127,1199,442,674,446,1149;52;M
34160;274,1240,221,1238,335,1628,739,260,660,539,1720,422,109,1075,286;41;F
34167;1234,1623,274;39;F
34171;685,650,1442,553,1199,127,250,1238,925,335,109,286,434,1699;44;F
34205;1075,260,109;56;F
34222;339,1149,674,553,1381,868,337,1623,221,1628,335,544,286,97,1153;36;F
34228;339,109,1666,1699,1288,674,1163,1720,193,1199,1075,274;44;F
34251;1623,567,739,250,1240,1550,221,1163,1628,544,459,909,286,894,531;22;M
34252;321;44;F
34253;1623,221,544,422,909,286,531,97,700,567,127,1550,925,1628,321;37;M
34264;1016,1240,1163,335,544,180,339,169,660,127,1720,1623,221,1550,286;44;F
34273;459,650,1217,573,539,221,57,739,660,567,1414,1623,780,1238,1628;29;M
34277;446;26;M
34289;925,434;42;F
34291;739,260,660,553,539,567,193,868,1720,1041,250,897,335,909,461;42;F
34302;1550,193,660,339,97,260,1149,1234,119,1623,109,461,221,1238,1288;76;F
34353;1199,1217,674,897,221,925,544,422,286,531,700,650,739,440,567;32;M
34355;633,660,440,539,567,1414,1623,221,1550,544,1217,739,1221,1720,1238;30;F
34358;1199,1381,1234,1093,1623,1016,250,685,633,1720,1288,109,1075,57,1236;41;F
34360;660,633,739,221,335,422,286,434,154,897,567,909,925,1720,1041;40;M
34366;1217,1442,660,553,567,127,337,1623,1240,221,544,422,180,909,286;45;M
34374;170,739,1550,1240;36;M
34386;170,55,339,1149,739,193,119,337,1623,274,897,1628,544,461,286;21;M
34393;573,440,660,260,739,339,55,553,539,193,180;75;F
34395;567,1381,1240,1442,1550,1163,1623,221,1238,1628,1699,1666,626,1720,700;52;F
34427;544;34;M
34431;739,446,539,1199,193,1414,221,1238,1163,1628,544,109,1075,286,531;30;M
34441;1016,221,1628,1075,286,57,1236,1490,260,1442,1623,1238,925,335,109;41;F
34446;544,274,1720,539,440,685,650,1217,1214,739,660,1623,897,567,909;38;M
34460;1093,119,1720,1041,1414,461,434,1217,1221,260,1075,1238,1288,109,909;45;F
34480;1199,1234,1720,780,221,1628,335,553,193,1381,1238,1163,109,459,461;39;F
34525;446,1623,221,544;40;M
34573;1240,780,1234,1217,626,193,660,567,909;42;M
34596;1236,169,567,1199,1217,739,626,660,539,119,1720,221,1550,1238,544;52;F
34625;780,1623,539,660,739,567,127,1016,250,221,1550,1163,1628,286,1699;38;M
34626;553,1381,119,1720,1238,1288,925,335,422,1214;46;F
34635;109,1075,650,660,1381,193,422,180,1238,1221,1214,1217,868,119,925;37;F
34667;567,119,1238,1628,544,422,109,909,57,1720,193,1214,553,925,180;45;M
34697;1149,446,674,553,119,925,1628,335,544,109,1075,531,97,700,1153;9;M
34709;459,1075,1238;39;M
34722;544,1442;44;F
34726;650,440,539,868,1199,1720,677,109,1236;76;F
34740;685;45;F
34754;685,677,1016,274,1550,1163,109,963,1236;39;M
34785;1623,677,685,286,154,1240,1016,1214,633,1442,1720,1550,925,894,1236;47;F
34788;1163,894,626,650,260,169,660,127,1720,221,1550,544,109,700,286;52;M
34797;1221,739,260,1093,1623,868,1217,442,539,567,119,1288,109,909,1666;65;F
34834;660,440,567,193,1623,221,422,909,286,57,539,1221,553,274,1720;47;M
34840;553,685,180,422,626,1720,440,1666,337,109,1075,1550,260,461,459;47;F
34851;660,1720,274,221,422,459,1149,674,925,1163,1628,544,97,700,1153;40;M
34857;909,700,660,626,739,286,440,567,193,1720,221,1550,1238,925,544;44;F
34858;660,440,539,260,57,180,109,1628,1238,897,1414,567,553,739,1217;28;F
34875;1442;49;F
34878;626,739,1217,193,1720,1623,1016,1163,544,909,260,553,539,461,180;52;M
34879;567,274,221,1550,925,422,446,553,544,459,180,909,286,97,57;33;M
34957;446,1153;42;F
34963;109,660,539,567,193,1720,1628;44;F
34978;109,700,1236,626,660,539,221,1628,286,894,531,1153;36;M
34988;244,1149,633,459,57,700,539,440,660,739,170,221,544,286,531;33;M
34994;339,909,739,260,660,440,539,193,1234,1623,780,1628,109,180,553;30;F
34995;1199,337,1414,1623,1238,109,1075,894,739,339,422,1720,1381,553,180;52;F
35002;260,553,868,337;52;M
35006;780,1217,1550,1163,1628,1149,193,1720,1041,1623,1240,461,894,434,1236;63;F
35037;260,553,119,1720,544,109,180;31;F
35073;260,1490,1238,1414,1234,1381,1199,739,1217;29;F
35080;442,169,339,260,660,539,1199,193,1093,1720,1623,221,1550,1288,109;42;F
35081;180,286,531,57,97,434,422,925,119,868,1234,1381,1199,1149,1153;36;F
35088;1442;48;F
35100;442,1720,1623,780,1016,1240,1550,1238,1288,335,544,109,1075,894,1666;33;M
35122;1217,739,260,660,553,440,539,567,1623,780,221,1238,925,1075,909;41;F
35126;539,660,739,685;71;M
35129;1199,660,260,1623,1720,677,154,109;74;F
35139;909,531,1666,442,459,1214,57,650,567,780,925,1628,544,422,180;48;M
35146;1149,626,674,1720,1550,1628,544,97,57,700,1153;46;M
35147;925,434;23;F
35171;1666,286,180,1238,1623,119,539,442,440,553,1217,1720,461;49;F
35181;1234,1720,1238,57,1214,1221,553,1550,925,109;36;F
35183;221,539,440,169,739,633,170,660,1623,780,1550,1628,286,531,1236;44;M
35184;660,440,539,221,1238,685,739,260,1199,1234,868,677,1623,925,109;38;F
35199;739,221,1628,544,286,660,553,440,539,567,1720,1623,274,180,909;18;M
35225;925,909,650,739,660,440,442,539,567,1381,868,337,250,1238,422;70;F
35230;335,1199,567,539,660,1490,260,553,1720,250,1238,422,109,1236,180;34;F
35238;685;88;M
35269;660,674,739,650,339,1199,250,221,1238,925,422,1075,286,1699,1666;42;F
35272;1628,1550,221,250,274,780,1381,660,1720,650;64;M
35281;633,739,169,660,440,539,1199,193,1720,1623,1016,221,1238,286,1236;30;M
35285;274,1153,286,1163,925,221,897,55,170,739,169,660,1550,539,127;28;F
35292;260,674,1238,422,109,97,700,339;40;F
35333;544,660,868,274,1240,1628,434,1699,650,567,1041,897,925,286,909;27;F
35335;567,1623,1163,909,674,1720,925,1628,97,700,544;29;M
35336;780,221,335,109,459,1075,286,57,1666,1236,260,274,250,1238,1699;31;F
35352;739,260,553,868,1238,925,335,544,109,1075;41;F
35368;660,260,1149,633,739,1221,459,57,780,422,1217,567,1623,1628,909;33;M
35374;337,1163,1623,221,109,286,531,442,1720,1238,894,1666,339,260,567;53;F
35385;1217,660,539,1720,1240,1550,700,221,553,674,626,446,739,544,97;35;M
35390;685,170,633,660,539,1720,1016,1240,221,1550,1628,544,286,57,1236;29;M
35421;1720,739,660,193,1234,677,1016,897,544,539,1199,1240,1550,1238,1236;33;F
35423;1041,1016,925,1075,1666,1236,739,442,1199,1381,1720,1414,1623,780,1238;27;F
35431;119,909,1720,567,127,1550,1238,446,674,544,97;43;F
35491;739,170,169,539,127,1720,1623,1550,1163,109,286,57;38;M
35512;461,459;43;F
35530;260,193,1381,1234,1016,1163,109,461,1075,1720,1240,1236;47;F
35541;260,339,1217,170,650,685,1234,1720,677,1016,1240,1550,1238,544,109;51;M
35570;244,685,553,1381,335,963,700,1236,650,1221,442,1199,250,897,1238;34;F
35573;119,677,1623,1016,1550,1238,180,127,1720,221,1163,544,286,700,1236;37;F
35597;1240,221,1628,459,286,894,57,1236,539,909,1623,925,567,434,1041;30;F
35604;154,544,1163,1217,650,55,674,553,567,1041,1238,1550,1628,894,700;19;M
35632;170,539,660,567,1199,1414,1720,780,221,1238,925,1628,286,97,57;31;M
35648;626,127,1628;42;M
35686;119,1153,1628,1720,739,1442,539,193,127,1414,1623,221,1238,544,286;44;F
35693;1628,1153,1217,660,539,1016,1240,221,1550,531,1236,739,193,1720,1623;37;F
35707;674,1149,442,1093,868,221,1238,925,1628,109,531,1153,97,1666,700;71;F
35711;1288,422,1238,1414,337,868,1199,442,553,260,739,650,286,434,1236;46;F
35725;461,459;7;F
35758;894;4;F
35766;1217,1414,1623,1238;27;F
35771;169,1199,1238,1163;22;F
35775;446,674,660,539,1720,1623,221,1550,925,544,286,531,97,700,1153;31;M
35776;459,461;13;F
35785;221,1238,925,1666,660,1221,1217,539,1720,1414,1623,739,633,1163,286;45;F
35808;1199,868,1414,1163,286,531,1666,633,442,127,1623,221,1550,1238,1628;73;M
35819;1217,868,193,221,1238,109,1075,180,909,286;63;F
35820;274;36;F
35823;1217,739,660,440,539,1199,127,868,1414,1623,221,1238,1628,909,286;34;M
35840;963;48;F
35845;440,1149,531,1238,286,1628,650,739,674,660,127,1720,221,1550,544;31;M
35852;1149,446,1199,1628,461,286,1153,700,868,1238,1163,422,1075,97;40;F
35900;221,109,1075,286,1236,963,925,1238,1550,1016,1720,539,660,739,1442;46;F
35949;1217,650,55,339,119,337,1623,221,335,109,1075,909,894,1666,1238;27;M
35981;650,1016,274,422,963,286,57,1699,1236,539,567,1041,780,897,909;33;M
35986;446,260,674,660,539,1234,868,925,1628,700,221,1550,1163,544,286;42;F
35995;180,1720,1623,1550,1217,1016,739,660,633,626,539,440,286,274,221;44;F
36000;250,1075,739,1217,1236,1240,539,440,633,660,1720,1016,221,109,286;34;F
36004;739,650,1217,339,1149,260,660,567,193,1234,1720,221,109,909,286;28;F
36022;925,109,963,1153,1236,531,286,250,1016,119,868,539,440,660,1442;7;F
36043;739,660,539,567,1623,221,1238,925,459,909,286,97,57,1666;59;M
36054;442;70;F
36065;739,660,1238,221,1199,539,440,674,1720,1623,1153,700;59;F
36068;650,442,335;70;M
36090;250,274,1016,1623,868,539,660,169,739,244,260,1442,1217,650,685;62;M
36096;1550,221,1623,1199,440,260,739,660,539,868,1720,1238,286,894,1442;66;F
36120;260,461,244,1214,1217,55,339,553,1720,1238,459,894,321,180,531;41;F
36135;567,274,221,1628,459,461,909,286,1236,739,660,440,539,127,780;39;F
36144;897,553,1236,127,1628,685,544,57,1214,909,274,1041,650,1699,250;34;M
36145;97,1628,1550,1238,1414,119,573,1442,260,1149,1490,1214,339,170,57;24;F
36164;1217,260,442,193,109,909,1666;72;F
36171;1442,274,925,909;4;F
36183;440,539,193,221,544,154,894,321,1623,531,1238,339,1666,286;32;F
36193;1236,739,1217,626,660,539,1623,897,221,1550,544,286,909,1720,531;29;F
36200;1217,567,544,422,459,1075,868,1163,193;67;M
36202;1666;54;F
36235;1149,1214,650,244,567,1199,1720,1623,274,1163,544,109,1075,909,286;36;M
36243;650,170,739,1442,539,127,119,677,1623,1016,1240,1550,925,422,1236;46;F
36248;1016,1238,335,422,1666,339,260,169,868,1720,1240,1550,109,894,1236;36;M
36258;660,193,1720,1623,897,221,1550,1238,925,1628,544,286,97,700,321;25;M
36261;1414,422,894,286,180,1238,1720,1199,553,626,1221,1149,1490,1214,1217;43;M
36268;660,440,193,1550,1163,422,459,260,553,567,1720,925,109,1075,57;37;M
36269;739,274,1240,544,531,1236,339,660,440,539,1720,1623,221,286,321;49;F
36281;169,1041,434;44;M
36283;660,539,567,1720,1623,274,1240,897,221,1550,909,286,1238,422,180;49;F
36295;1214,1149,260,567,119,1041,780,274,1238,925,335,422,109,1075,909;41;M
36302;55,1149,739,446,1442,660,1623,221,1238,286,422,97;39;M
36327;1550,170,739,539,1199,1623,1628,286;38;M
36328;739,539,119;27;M
36371;170,650,339,626,573,1199,1381,337,1238,925,1628,544,461,180,286;38;F
36413;739,553,440,221,422,180,286,434,274,909,119,963,1442,461,1628;39;M
36433;909,1628;35;M
36444;221,1163,531,909,539,567,440,660,739,1217,553,180,1720,57,193;48;F
36455;544,660;66;F
36470;925,1381,539,440,674,739;45;M
36479;897,925,567,553,660,739,286,57,1699,1381,1199,909,434,1041,1238;35;M
36485;567,868,337,925,180;70;F
36496;440,674,260,739,446,660,539,868,119,337,1414,335,109,286,531;39;F
36500;260,1234,286,109,1075;70;F
36507;567,1221,1214;39;M
36529;660,650,1240,250,274,57,1214,567,1041,897,925,335,1075,909,434;31;F
36540;868,337,1240,1238,221,925,434;60;F
36555;633,739,440,1016,1240,221,1236,1720,567,909,1217,1221,660,442,539;52;F
36576;1442;41;M
36592;650,674,539,1720,1623,250,1075,700,1236,1153,286,660,440,321,544;42;M
36608;169,1221,244,339,650,55,739,260,573,539,868,1414,1623,1550,109;12;F
36611;925,434;34;M
36627;1442;44;F
36630;780,1016,1240,925,1236;32;M
36637;925,434;38;M
36639;260,1442,442,1163,109,1236,286,1234,539,660,739,1720,1623,221,1550;52;F
36641;739,660,1234,868,1720,1623,250,221,1238,335,544,286,894,925,434;89;M
36643;626,674,422,57,55,170,127,1623,1550,925,544,286,97,1153,1628;32;M
36646;221,1075,286,894,1153,1221,1149,674,1550,97,260,169,127,1720,897;50;F
36650;685,55,739,1217,193,119,337,1720,1623,274,221,1238,925,422,286;47;F
36676;1442,1623,274,1238,335,461,446,1381,1720,925,1628,544,97;41;M
36677;626,260,674,660,539,1623,897,221,925,1628,109,1075,909,286,894;32;F
36687;660,1442;42;F
36701;544,1075,286,531,1666,1163,1550,677,633,170,739,1720,1016,1240,1236;37;M
36726;1238,1163,544,422,459,461,909,57,1666,55,1217,660,1623,221,286;31;M
36735;1381,1623,780,221,544,459,180,286,193,1214,1628,57,119,553,274;44;M
36748;633,660,442,1199,193,1720,1016,1240,1153;48;F
36752;674,442,544,180,700,1153;75;M
36759;739,674,660,553,1381,1720,221,169,1153;36;M
36760;633,339,1490,244,1221,119,660,567,193,897,422,894,434,1153,1666;26;F
36772;739,1041,1623,221,459,286,1699,1075,250;45;M
36782;440,925,1628,221;39;F
36789;531,1217,739,660,539;66;M
36793;170,260,442,127,1720,1550,335,1666;69;F
36803;170,539,868,1720,1623,1016,250,221,1550,1238,925,544,461,894,434;35;M
36855;567,539,337,868;33;F
36858;677,127,567,539,440,660,169,626,1221,739,650,1623,1628;40;M
36860;1238,1414,337,119,169,626,260,339,1217,170,650,544,109,286,894;29;F
36882;260,660,440,539,567,1199,1234,1720,1623,250,1238,1628,109,286,531;45;F
36885;700,260,626,660,440,1199,1234,1720,221,925,1628,335,109,1075,97;76;F
36886;260;77;F
36911;1442,1016,1234,169,1236,544,221,650,1217,739,626,660,539,119,274;31;M
36923;1442,674,1720;36;M
36950;674,1720,109,221,1238,544,286,97,700,1666;69;F
36972;1221,626,553,567,1381,868,119,337,780,274,180,909,57,1666;66;F
36976;55,170,660,539,1016,221,1550,1163,963,739,286,1236,127,1720,650;58;F
36977;180,909,97,1236,650,1217,626,660,539,1623,221,1550,1238,1628,286;39;F
36986;700,440,674,544;33;M
37004;1623,1199,169,1217,660,440,337,250,897,221,1238,1163,286,1699,685;44;M
37032;739,442,337,677,660,440,1623,221,1628,286,531,170,539,1550,1238;28;F
37033;539,567,1381,1720,1623,780,1016,1550,1238,1288,1628,154,1075,531,57;26;F
37036;1699,1720,1628,274,1623,1075,650,1238,567,909,1041;35;M
37046;1666,700,531,1075,1623,539,660,674,260,626,337,221,335,109,544;43;M
37058;434,925;9;M
37078;434,925;5;F
37083;1666,274,1217,633,739,660,539,1623,221,909,286;49;F
37087;57,461,1153;55;F
37090;339,442,1199,868,1623,57,286,335,925;48;F
37091;446,660,440,567,1199,119,1623,274,1238,1628,286,909,221,674,544;41;F
37093;434,925;2;M
37107;739,339,119,1288,925,1628,544,109,286,1666,1234,660,440,567,909;55;F
37113;685;38;F
37143;739,660,539,1623,1016,274,1240,221,1550,544,1217,339,567,1720,1238;28;F
37147;260,674,440,539,1234,119,1623,1550,700,109,442,221,544,286,1666;71;F
37159;660,539,1199,337,1720,1623,780,221,1550,1238,925,544,422,286,894;39;F
37200;626,127,286,660,1093,119,337,1041,539,1199,221,531;54;F
37249;1016,1240,221,286,1236;68;F
37261;260;76;M
37279;335,337,339;12;M
37283;650,1442,1720,1238,109,894;36;F
37306;1238,544;50;F
37333;660,539,1720,677,1623,780,1240,286;39;M
37338;925,434;43;M
37351;1093,193,1075,339,260,1199,1234,868,1414,1623,221,1238,925,544,109;17;F
37369;626,660,553,440,539,193,221,109,180,909,286,531,57;32;F
37377;1153,286,1623,539,440,660,674,1093,221,544;46;F
37410;925,434;44;F
37417;221,1238,660,440,539,109,1217,739,553,1199,1720,925,1163,422,180;41;F
37422;1238,180;46;F
37429;650,739,1623,925,286,894;52;F
37443;897,442,660,685,739,544,1442,1381,1720,1016,1240,1238,925,963,97;49;F
37451;57;53;F
37472;650,260,660,1720,1623,461,180,1214,553,539,567,193,1163,1628,422;50;M
37489;286,677,780,1240,221,544,660,739,650,925,1628,422,909,274,685;50;M
37494;1666;61;F
37498;1720;59;F
37505;925,434;13;F
37509;544,221,250,1240,1016,193,539,660,626,650,739,1623,925,286,894;14;F
37517;221,925,1628,335,109,459,180,286,339,567,1238,909,531,97,1666;47;F
37519;868,119,677,1041,1623,274,221,422,963,286,434,1666,442,1153;70;F
37525;109,286,1666,1217,660,553,440,442,539,1720,1623,780,1238,909,567;38;F
37528;1214,440,868,1236,260,1442,660,1720,1016,221,925,335,109,1075,286;39;F
37533;1214,739,1221,660,553,539,193,780,544,459,909,286,567;49;M
37542;422,180;41;F
37544;925,434;11;F
37556;1217,739,660,553,440,539,1199,1720,221,1238,925,1163,422,109,180;9;F
37558;422,180;71;F
37576;1217,739,660,553,440,539,1199,1720,221,1238,925,1163,422,109,180;7;M
37599;553,909,180,1153;45;M
37610;1490,422,180;39;M
37616;660,531,109,1623,1238,1163,286,1490;34;F
37629;442;31;F
37638;260,1442,440,868,1238,335,109;38;M
37650;1240,221,1550,925,544,739,660,440,539,1720,1623,1628,286,434,700;52;F
37658;677;44;F
37662;1238,422,180;12;M
37678;650,1442,553,868,925,422,894;38;F
37679;434,925,1041,567,897,909;34;F
37685;1240;29;F
37698;1238,422,180;10;M
37702;1199,1720,1240,286,1236;51;M
37709;780,109,1153,97,434,286,544,440,660,539,422,739,446,221,1628;38;F
37737;260,567,1720,1628,909,1666;53;F
37741;650,1442,337,1238,925,544,894;38;M
37751;1720,1234,539,440,674,739,1217,660,1199,221,1238,1628,286,531,1236;26;F
37805;739,660,539,868,119,1720,677,1623,1240,221,1238,335,286;52;F
37809;57,1075,339,1149,446,221,335,422,97,1153;44;F
37829;260,1720;48;F
37853;446,260,1623,544,674,97,700;60;F
37874;650,739,1199,274,1240,221,1550,544,531,700,180,685,626,127,963;55;F
37879;1623,539,440,660,739,1236,780,1240,459,286,97;92;F
37917;894,1153,55,739,660,440,539,193,1623,674,1720,221,97,700,544;33;M
37932;55,567,442,1381,1720,1623,1016,897,1550,1238,925,422,109,286,894;27;F
37942;1149,446,260,674,442,1234,1628,544,109,700,1666,1153;57;F
37949;154,894,700,1075,459,544,1623,1720,660,170,674,127,1550,1628,286;37;M
38000;674,1093,1720,1238,1628,544,700;47;F
38019;739,626,1720,674,660,567,544,1666,1217,442,539,1016,221,286,1236;47;F
38027;461,1199,573,440,260,739,1217,221,1238,180,286,660,553,539,1153;48;F
38032;119,337,1288,1628,544,422,109,459,1075,57,339,221,925,335,286;44;F
38051;925,119,442,339,1149,446,674,567,1199,1628,544,286,97,700,1153;52;F
38055;553,1199,422,567,440,1214,739,335,221,459,180,286,660,539,1628;49;F
38072;337,335,339;40;M
38076;1163,286,1720,1199,660,169,260,739,170,442,539,1623,1550,109,1666;61;F
38081;1217,1214,1149,1221,553,567,337,909,260;47;F
38091;337,119,868,539,440,260,446,339,1217,170,739,660,442,544,894;39;F
38134;337,1720;52;M
38140;109,1221,650,1214,260,553,567,193,1623,1238,1163,1628,422,461,180;48;F
38141;1217,1149,553,539,1623,1238,925,180,422,193;41;M
38176;446,1381,1623,221,1238,1628,422,459,286,531,57,1153;38;F
38177;1720,337;51;F
38180;442,544,1628,780,1720;71;M
38215;1214,553,567,1238,180,909,286;39;F
38216;1214,626,553,422,180,700,1153;50;M
38257;1234,1628,1016,1240,1550,286,55,650,170,244,660,1199,1623,1236,739;45;F
38262;1666;50;F
38280;422,180;47;F
38284;1666,531,286,544,925,221,1623,119,539,1153;60;F
38289;260,97,339,1199,109,1623,544,567,539,739,440,221,286,1381,1720;33;F
38310;1666;77;F
38320;286,531,321,1236,1217,739,169,660,440,539,1199,1720,1240,221,1238;35;M
38325;739,539,1720,544;43;F
38332;660,868,1240,1550,286,1238,894,434,1236,739,1199,677,1041,1623,780;42;F
38340;925,434;45;M
38342;925,434;52;M
38380;260,109,1075;43;M
38414;260,1199,1720,274,909,894,650,127,1699;36;M
38415;274;34;M
38433;337,539,440,553,626,1221,660,169,446,221,544,286,97,57,1153;41;M
38436;339,674,1199,868,337,1238,221,335,544,286,97,321,1153;47;M
38459;286,97,57,1153,339,446,674,539,1199,337,780,1628,335,544,1666;45;F
38474;677,1240,897,221,1238,925,1628,422,109,180,286,894,1236,739,868;34;F
38483;1236,1240;66;M
38492;660,674,440,442,193,1381,1623,221,1238,925,544,286,97,1153,700;30;F
38496;1628,286,221,1238,544,422,909,274,567,539,553,660,739,1217,650;41;M
38523;446,1623,221,925,1153,1149,660,674,1628,544,286,700;50;F
38528;339,1381,442,660,440,539,1199,1234,1720,221,1238,109,286,1666,1236;41;F
38538;739,567,780,1628,422,459;30;M
38588;119,1199,442,650,339,1720,1163,335,1075,286;43;F
38596;650,1217,260,660,193,1720,1238,1628,422,109,1075,909,286,57,1699;36;M
38606;55,170,739,660,567,1720,1623,1016,1240,221,544,909,1236,1550,1163;43;M
38610;339,567,868,337,1623,909;31;F
38616;1217,739,660,553,440,539,1199,1720,221,1238,925,1163,422,109,180;42;M
38634;567,1041,274,286,909;38;M
38640;119,337,1720,1623,274,221,925,544,286,1217;24;M
38642;244,739,660,539,1041,780,1016,1240,221,1550,1238,1163,459,286,57;15;M
38665;1149,446,260,674,573,119,1720,1153,97,1075,897,1550,1238,544,894;29;M
38679;339,1199,119,337,1240,109,544,422,1236,1414,1623,1720,1238,685;42;M
38690;553;28;F
38692;250,274,1016,1550,925,109,169,1163,1238,1199,221,1623,1720,531,286;49;F
38718;1016,274,1240,221,1550,180,909,286,321,1699,1720,250,1238,1628,544;42;M
38721;119,1720,1623,1016,1240,1628,1490,573,193,1238;35;F
38727;169,660,539,1623,1016,894,286,531,700,1666,1236,1720,221,1550,544;45;F
38743;1414,1623,1016,1238,1163,109,1075,894,1236,339,1442,1720,1240,1550,1153;55;F
38775;868,1016,1217,739,660,539,1720,1623,274,1240,221,1238,909,286,531;27;F
38785;868,567,539,573,660,260,446,739,339,1217,553,1238,109,1075,180;35;F
38790;780,422;34;M
38791;422,97,963,925,1238,1240,1016,1720,1381,1442,544,739,685,660,221;47;M
38820;539,442,1720,567,909,1221;39;F
38840;446,1149,674,1720,544,1153,700;57;F
38866;685,1442;45;F
38889;337,1720,1016,1240,925,459,286,57,685;36;F
38910;459,461;37;F
38962;442,119,1666;72;F
38967;1442;38;F
38981;1442;50;F
38991;1666;67;F
38992;1628,193,553,422,180;39;F
39023;633,244,1199,193,1720,1623,1016;32;F
39025;1221,446,739,1217,660,539,1381,868,1623,274,221,925,544,286,434;34;F
39028;1442;9;F
39032;650;49;M
39051;925,434;38;F
39070;1236;47;M
39082;1442;12;M
39115;553,169,633,1217,739,660,440,539,193,1720,221,461,180,909,286;33;M
39141;286,1217,1214,660,567,1238,925,909;38;F
39151;1093,1234,170,539,1720,1623,221,1163,1628,335,1075,286,531,97,1666;44;F
39161;925,434;13;M
39167;1381,1238,1666,446,868,1075,221,57,553,544,567,1221,1720,539,909;43;M
39180;925,434;8;M
39217;1623,1041,1288,1236,739,260,660,440,442,539,1199,1234,1720,109,434;60;F
39218;260,1149,446,1199,1381,337,1720,1623,221,1628,544,109,286,97,700;54;M
39223;925,434;10;M
39285;1381,1199,260,339,1234,1093,109;50;F
39292;1236,1550,1623,660,739,170,1199,1720,221,1163,1628,544,422,109,459;38;F
39293;700,339,260,660,553,442,567,119,1720,1288,109,461,909,97,1666;68;M
39328;335,286,700,1442,674,1720,1623,221,1238,1628,109,97;30;F
39335;1628,109,286,633,739,119,1236,244,260,1623,1016,1240,1238,925,544;41;F
39391;109;58;F
39395;1149,169,894,1666,1075,109,335,1720,170,685,260,1199,1550,1238,1163;44;F
39411;1442,573,1381,180,1075,109,422,335,1238,1720,553,260,446,739,685;34;F
39412;925,434;38;F
39427;1442;59;F
39467;57,422,1442;47;F
39488;539,1623,1240,739,260,1234,1720,1550,109,1075,1236;80;F
39495;1149,446,169,674,442,193,119,337,1016,1240,544,286,97,700,1153;25;M
39498;1236;60;M
39514;925,434;8;F
39520;626,127,1699,1720,1041,925,894,650,567,274,250,897,909;55;M
39525;1442;15;M
39529;442,544;74;F
39542;1442;12;F
39546;660;68;M
39552;660,1238,286,531,1221,567,221,925,1628,1075,57,260,109,1217,1442;44;F
39558;1442;72;F
39562;1149,1199,1720,544,109,1075,286,339,337,335,97;40;F
39572;1199,567,169,739,1214,1217,660,539,193,1238,544,422,909,286,531;36;F
39579;539,1623,1016,1240,1236,169,244;42;M
39591;1623,1381,1199,442,739,1238,335,963;44;M
39606;674,780,221,925,1628,286,97,1153,700;40;F
39617;286,57,1217,660,539,1199,1628,567,1720,1381,1238,193,180,422,553;44;M
39641;1199,1093,1240,1238,335,1075,1236,442,1720,1666;35;F
39642;739,660,440,1720,221,925,1163,286,894;43;F
39643;660,193,1016,221,544,286,1153,1163;51;F
39652;434,909,897,567;41;M
39692;154,1163;48;F
39698;633,660,180,321,1214,1149,1221,446,260,1442,1381,868,544,422,109;43;F
39701;868,119,925,286,260;39;F
39706;442,127,337,274,1240,1550,925,544,422,109,461,963,57,1666,1236;44;F
39742;260,660,1234,1720,1623,780,221,1628,544,422,459,57,109;42;F
39762;169,1214,739,660,539,567,127,1623,1240,221,1236,909,1628,1163,286;39;M
39764;337,193,539,660,339,260,1442,868,1720,221,1238,109,1490;34;F
39765;1288,544,286,434,97,633,339,573,1199,193,1093,677,1238,925,109;30;F
39773;626,633,55,244,169,660,567,1720,1016,221,1163,1628,286,531,57;40;M
39781;739,660,539,567,337,1720,1623,897,221,335,459,909,434,57,685;43;F
39785;894,660,446,1217,127,1240,1238,544,650,674,1199,1720,321,700;35;M
39786;650,442,119,337,274,250,897,1238,925,434;28;F
39811;335,154,57,442,553,660,169,244,739,1214,339,170,1199,127,544;40;F
39813;1217,1221,660,553,539,567,1720,337,1238,422,180,909;69;M
39819;170,446,626,674,193,1550,925,1628,544;30;F
39822;459,909,894,97,57,1666,446,553,442,1199,1720,274,544,700,1153;42;F
39837;97,446;51;M
39847;260,531,286,909,221,1623,1720,567,193,539,440,660,1221,739,1217;50;F
39851;1490,626,440,567,539,553,193,1199,337,1238;44;F
39861;221,897,1623,868,1199,553,660,169,650,544,1720,1238;26;F
39867;685,170,868,119,897,221,1240,1163,925,154,109,459,909,1075,894;18;F
39884;868,1720,739,169,660,119,127,221,1550,1238,925,544,422,286,894;39;F
39890;739,119,337,1720,677,1016,1240,221,1238,1163,286;44;M
39892;221,925,335,544,422,109,894,531,321,170,169,127,1623,1550,286;38;F
39907;260,1041,1238,925,544,286,531,1199,567,539,553,660,650,1217,739;29;M
39934;963,274,169,1217,739,660,440,1720,1623,1240,221,1550,925,1163,286;48;F
39936;1240,221,531,1666,1217,739,1221,660,539,567,1199,897,909,286,57;37;F
39946;1720,1623,109,1075,1666,97,544,1163,925,1288,221,337,660,1442,339;47;F
39949;1623,1238,422,1442,1221,780,1628,909,531,339,660,539,1550,544,286;25;F
39954;1699,1623,739,1720,539,250,221,909,286,531,897,660,567,925,440;32;F
39962;739,660,440,442,539,567,1720,250,1623,897,221,925,909,286,531;32;M
40012;925;10;F
40082;1720,221,1628,57,1666,1217,739,1221,660,539,567,1240,897,909,286;40;M
40084;1442,573,868,119,780,1238,544,422,180;46;F
40098;1236,260,660,1199,1016,925,1628,544,109,170,169,1442,1550,1075,286;41;M
40134;539,739,626,660,440,127,1720,1623,1240,221,1550,1628,459,286,57;39;F
40151;442;69;M
40171;660,1623,780,1016,963,434,1240,925,154,286,260,109,1075;38;M
40172;544,422,97,1153,1149,700,674;27;M
40178;1199,1720,677,1623,274,221,442,539,1240,1238,925,1163,154,286,1666;25;F
40204;97,422,544,1238,337,868,1381,193,573,1442,446,1163;49;F
40229;1414;28;F
40258;544,119,442,440,660,700,674;63;F
40260;1075,868,260,1238,109,780,1240,335,422,685;41;M
40304;626,660,127,1238,1628,544,422,109,459,1075,909,286,894,57,1163;40;M
40325;1628,422,909,1699,1236,1153,739,1442,567,1199,1381,1720,1238,1623,925;24;F
40357;119,337,335,1075,57,286,1240,1623,339,660,868,1720,544,531,221;34;F
40366;925,434;39;F
40371;567,193,925,909,1041;38;M
40401;221,286,1163,531;38;M
40403;1217,1221,567,221,1238,544,109,909,286;27;F
40419;544,1623,1163,674,700;49;M
40459;660,539,1381,739,244,1199,1234,868,1016,1240,1238,335,1075,1236;49;F
40488;1016,1240,1238,925,335,154,1236,1666,650,1217,339,626,1199,1381,1720;39;F
40509;739,660,544;27;M
40533;1214,780,459,57,700,221,1550,909,286;42;F
40564;553,539,567,274,250,1240,897,1550,1628,422,109,286,685;37;M
40570;170,1217,650,739,169,660,539,1623,274,897,925,1628,544,434,1699;28;F
40582;633,739,1199,1720,1041,1550,1238,109;71;F
40607;1153,660,539,1550,925,286;37;F
40614;780,274,1288,422,1075,1666,286,1163,1550,1623,446,193,1238,1628,544;39;F
40621;339,626,1442,660,1199,1720,780,221,1238,544,422,154,459,286,1666;25;F
40624;674,700;51;M
40626;109,894,57,544,335,1238,1623,127,1628,1720,1149,97,700,1153,446;41;M
40633;739,660,539,567,1720,1041,1623,1016,897,221,154,461,909,286,1236;32;M
40636;1149,868,97,700;37;F
40642;446,685,739,1163;41;F
40659;1720,567,963,897,434,925,1041;42;M
40702;221,1163;47;F
40706;544,422,109,337,221,1628,339,286,1623,170,169,127,1550,894,1163;38;F
40769;897,780,660,674,1199,1623,221,1238,925,1628,544,286,700;42;F
40846;337,119,868,446,1214,633,442,963,180,739;36;M
40848;539,660,674,1153;50;F
40886;1550,170,1163;41;M
40895;1720,567,221,1623,1628,539,461,193;15;M
40903;739,260,442,193,119,1720,1041,1623,897,109,434;54;F
40911;1234,1628,894,1720,1199,660,739,260,1623,1240,221,1550,1238,109,286;88;F
40913;244,260,1234,1720,677,1016,1240,1238,109,1623,633,1199,1236,739,963;42;F
40933;674,700,1153;38;M
40934;57,780,1623,442,440,674,97,700;56;M
40948;193,626,739,650,660,1199,1720,780,250,221,1163,286,894,1699,1236;32;F
40970;169,1628,544,446;45;M
40973;739,660,1623,626,539,221,1238,925,1628,286;57;F
40978;1442,193,1623,1016,274,250,1240,897,1550,1163,544,286,57,700,1236;27;M
40982;674,97,700;61;F
40986;440,1414,154,1699,685,633,260,553,1720,1238,1163,109;56;F
40997;1550,1238,1288,925,1628,434,1666,1153,97,422,544,335,193,1490,868;38;F
40999;660,674,650,685,739,260,193,1016,1240,1550,1238,544,1699,250,221;76;F
41003;739,567,897,909,286;28;M
41013;925,434;27;F
41027;626,339,442,193,127,119,1238,1163,544,909,286,321,700,1666,1628;52;F
41036;633,442,1720,260;77;F
41048;260,109,180;82;M
41069;193,1163,1075;48;M
41082;650,1217,739,626,660,539,567,193,1720,1623,221,1238,909,286,894;40;M
41111;780,274,925,1699;34;F
41142;626,553,1381,1414,1238,925,335,1075,180;34;F
41189;109,897,337,119,567,674,626,650,1199,868,1238,544,1075,286,1163;41;F
41205;739,1720,1623,544,109,286,894,531,97,700,170,660,1550,1238,1628;42;M
41215;894,286,567,1093,337,1623,221,1628,909,434,97,544,1720,539,700;45;F
41266;170,440,1720,221,1238,925,544,109,1075,1550,1163,286,531;34;F
41310;286,544,55,1217,739,1221,626,440,539,1199,1720,1623,274,221,909;62;F
41312;1623,1550,1238,660,446,440,221,169,127,1414,894,626,674,544;41;M
41329;1720,780,1016,274,250,221,1550,925,544,1628,422,109,459,963,286;10;F
41330;434,531,1550,221,1240,250,274,780,440,660,739,193,1720,1628,544;26;M
41333;894,1699,660,553,539,193,337,1720,1414,1623,221,286,700,1236;20;F
41353;1442,1217,650,567,539,626,1240,260,1236,57,909,109,250,1623,739;28;M
41385;531,963,1236,700,894,286,180,1628,422,221,440,739,1217,1381,1720;38;F
41390;193,539,660,1442,567,337,1041,1199,1623,1238,925,335,286,434,1699;39;F
41415;685,260,440,1623,1238,109,1236,1153,57,286,925,660,539,1016,1240;28;F
41421;1720,1236,244;55;M
41439;1442,1381,1414,780,1075,1217,1720,1623,1238,925,1163,1628,700,1153,544;27;F
41472;531,440,539,1016,1217,169,660,1240,221,1550,286,700,1236;36;F
41482;1217,739,169,660,440,567,1623,274,250,221,544,109,286,531,1236;31;F
41519;925,434;73;F
41521;925,544,1666,1490,739,1199,1720,780,1628,109,459,1075,286,531,57;29;F
41553;925,434;47;F
41577;274;35;M
41608;1381,1623,780,897,1288,544,459,909,1666,1217,1490,739,1414,1238,925;24;F
41643;1163,1720;42;M
41645;1199,1720,1414,274,221,1628,544,422,459,286,894,57,700,1666,1236;39;F
41648;925,434;25;F
41659;739,260,660,442,193,677,1016,221,109,1075,1666,650,1720,1623,1240;41;M
41663;1199,1720,1623,780,1016,1240,109,286;40;F
41664;1149,868,544,422,97,1153;34;M
41665;459,1240,1234,1199,963,925,780,685,677,633,539,109,1720,1238,260;61;F
41703;250,1720,274,1238,109,1075;38;F
41711;109,1075,1153,660,170,739,442,1623,286,1666,339,221;35;F
41720;1217,446,260,567,539,1720,1623,335,286,109;30;M
41731;685,1217,739,339,660,440,442,539,868,1720,221,1550,1075,286,700;77;F
41752;286,221,127,260,1153,674,440,119,1550,544,109;44;F
41772;1288,633,244,1199,1234,1720,677,1623,780,1016,1240,1238,925,154,109;60;F
41776;180,1628,1550,1041,553,567,1720,1623,925,897,1238,109,909,1699,434;46;M
41777;1234,868,119,1041,1623,780,1238,1666,260,897,925,109,909,434;44;F
41784;1221,442,119,57,1217,660,553,539,567,274,221,1238,925,335,909;33;F
41787;1149,97,544,446;37;M
41835;339,739,660,442,1199,1720,780,221,1238,335,544,109,286,1666,1153;73;F
41843;925,109,626,660,544,180,286,193,531,1550,244,633,739,1016,1240;15;M
41881;1075,260,109;40;M
41885;335,422,109,339,260,868,119,337,1720,925,434;41;F
41909;440,539,1720,274,685,1442,660,567,1381,221,1550,925,544,286,321;45;M
41913;446;46;F
41918;1199,127,1234,868,119,337,1720,1414,221,1238,544,109,286,894;30;F
41926;250,1623,1720,539,169,1217,1221,626,440,660,739,650,1214,1628,422;32;M
41955;650,339,1442,119,337,1720,1414,1623,250,1238,335,544,109,894,1666;48;F
41961;442;85;F
41968;440,780,1628,544,127,1623,286,1720,1381,1238,221,674,700,446,1153;45;M
41978;660,221,1163,544,286,97,1149,674,1623,1238;37;M
42036;1217,660,539,567,193,127,780,274,1240,221,1628,544,459,286,57;26;M
42037;55,170,650,1149,626,1442,660,440,677,1623,250,221,1550,925,544;17;M
42077;1199,193,221,925;46;F
42092;1240,1016,633,440,1623,250,434,1217,660,539,1720,274,221,1550,286;51;F
42101;739,1163,154,221,1623,539,660;45;M
42113;780,119,1234,567,442,553,1442,539,1238,1288,459,180,909,97,57;14;F
42120;1234,1623,1016,1240,897,459,1075,286,434,57,1236,685,170,677,963;56;F
42142;633,685,170,674,1414,1238,531,286,544,221,1623,1720,1199,169,260;24;M
42147;1149,674,544,109,97,700,1153;28;F
42177;1149,446,674,1442,660,442,925,544,700;66;M
42185;868,567,539,440,260,739,1214,1041,1623,780,1628,422,109,286,434;40;M
42203;660,539,1199,1720,1623,897,1238,544,286,531;24;M
42232;674,193,221,544,286,700,97;50;M
42278;1699;67;M
42280;674,700;45;F
42281;260,1199,337,1720,1414,1623,1238,925,109,335,739,221,544,286,531;71;F
42291;193,897,1214,780,1550,1720,1240,677,739,1623,221,274,539,567,909;29;M
42339;685,677;42;M
42345;739,339,650,1221,440,573,567,1238,925,109,1217,180,422,1075,909;43;M
42355;154,1236,1666,633,339,739,660,442,119,337,1720,677,1240,1238,1288;36;F
42360;925,434;39;F
42382;193;59;M
42389;739,1016,1240,531,1236,539,660,442,1199,1381,1720,1623,221,286,1666;76;F
42401;567,1199,193,221,1550,422,180,909,286,57,700,1153;26;M
42426;446,260,674,442,544,57;66;F
42427;260,660,1720,221,544;46;M
42433;1149,1666,1153,544,1238,674,700;69;F
42437;1628,626,553;41;M
42440;1381,1720,1414,221,1550,1238,335,868,1628,440,739,539,286,531,97;27;M
42475;440,170,1163;27;M
42478;1666,440,260,739,660,170,1234,1623,780,1240,221,1550,1163,286,531;22;M
42480;1628,626,553;38;F
42485;422,180;34;F
42489;685,1442;47;M
42495;1217,1442,127,868,119,1720,221,925,286,1666,1623,909,1238;29;M
42534;700,677,1163,544,650,739,660,1720,1016,250,1240,221,925,109,1236;52;F
42538;660,440,539,337,1720,1623,221,1550,1238,335,544,286,97,321,1153;36;F
42549;660,440,442,539,1199,1381,1234,119,1720,1623,1016,274,250,1550,544;58;F
42553;674,1720,1214,780,1628,459,57,700;40;M
42558;260,1093,422,180;48;M
42576;260,1221,739,1214,1217,553;44;F
42588;119,1381,260,1221,1149,1490,446,674,553,1199,868,925,544,97,700;36;F
42594;1442,1236;37;F
42613;1720,1623,1016;53;M
42623;193,1199,1234,1093,868,337,1414,1238,1163,335,109,154,1075,321,339;32;F
42633;650,1623,1628;51;M
42660;335,1720,1381,286,221,440,739,539,567,544,1623,109,1199,97,260;34;M
42664;1199,1016,274,1240,1699,700,674,650,260,660,250,1720,677,1163,109;44;M
42688;1214,739,539,567,193,1720,677,1623,780,274,1240,897,221,1550,909;30;F
42706;180,109,780,1217,567,1720,1550,1628,544,260;54;M
42717;739,1381,868,1720,677,221,170,674,1623,1550,1628,544,422,286,700;35;F
42727;674,544,700;76;M
42769;250;62;F
42770;193,1163,544,531;30;M
42791;674,1720,1214,780,1628,459,57,700;6;F
42808;1214,674,1720,780,1628,459,57,700;4;M
42815;660,633,739,260,1442,925,544,109,286,894,170,1550,127,1163,169;36;F
42824;170,739,660,440,567,1623,780,221,544,1720,909,286;50;F
42863;633,739,660,1720,1623,221,57,539,1016,1240,1236;45;F
42872;685,963;25;F
42905;1414,442,169,963,1236,739,1199,1623,573,57,553,1720,894,650,626;32;F
42907;440;30;M
42938;780,1238,1628,286,650,925;48;F
42966;286,1236,274,660,1623,1075,109,1234,57,1238,539,1720,422,909,193;48;F
42986;739,633,1217,660,1199,193,1720,1623,1240,221,1238,1075,909,286,1236;64;F
43010;1075,1666,1236,1623,539,963,660,244,170,685,739,260,1199,677,1240;73;F
43037;674,97,700,1153;46;F
43078;1238;42;F
43109;250,1149,1720,1414,1623,780,1016,274;54;M
43140;1214,1221,442,119,1238;47;F
43149;650,553,660,1442,626,1214,55,286,1075,544,1238,1720,1217,1221,442;45;M
43154;1720,170,1217,674,1550,1163,739,440,539,700,1236,660,221,544,286;39;M
43156;221,274,677,660,739,286;46;M
43158;170,685,1217,442,1093,1041,274,1550,1288,1163,909,894,434,97,321;17;F
43166;868,335,109,459,1075,57,193,422,461,180;38;F
43173;274,1623,1199,442,446,170,868,1720,1240,221,925,1628,544;49;F
43178;650,1214,55,1720,544,1623,337,119,446,1149,422,97,1153;15;M
43179;660,442,1288,1163,286,1666,544,1238,221,260;41;F
43219;1217,633,650,739,660,1381,1720,780,925,1163,544,109,1075,894,57;43;M
43220;685,1442,660,539,1720,274,221,1550,925,544,286,97,321;12;M
43246;1720,250,1153,1236,1149,660,539,274,221,1288,925,422;43;F
43268;193,868,335,422,109,459,461,1075,180,57;9;M
43300;193,868,335,422,109,459,461,1075,180,57;5;F
43353;446;40;F
43380;544,97,169,660,221,335,1163,109,461,1075,339,674,1238,286,700;57;F
43413;440,660,1214,1217,739,626,1623,780,321,434,286,909,459,154,1699;25;M
43419;544,1288,1238,1240,274,780,193,1199,739,633,1234,1720,1623,97,1016;23;F
43426;626,339,1217,1149,674,544,700;36;M
43429;674,1149,446,440,544,97,700,1153;45;M
43430;1234,1199,1149,260,1442,440,442,539,1720,1238,335,544,109,459,97;41;M
43432;1442,573,119,337,260,1381,868,1550,925,109,1075;37;F
43456;868;34;F
43464;446,286,1153;68;F
43467;446;40;M
43475;1490;56;F
43479;1550,109,963,180,286,685,650,260,660,539,127,1720,1628,544,1699;29;M
43509;274,1720,925,567,897;32;F
43524;1234,1720,1623,274,250,1240,544,1236,1490,573,1199,1414,221,1238,97;33;M
43532;739;44;M
43570;1149,1442,553;37;M
43574;544,567,440,660,739,55,170,169,539,127,780,221,1550,286,894;71;M
43579;170,633,1214,244,1720,1623,780,1550,1238,925,1163,109,1075,286;29;M
43587;55,1221,567,1720,274,1628,109,909,286,57;39;M
43615;1623;76;F
43616;660,626,685,868,1720,1240,221,1238,1075,180,286,531,1153,154;52;M
43623;868,925,434;42;F
43642;739,260,660,440,539,1199,193,1720,1414,1623,221,1163,422,461,286;48;F
43677;660,442,539,868,119,1720,274,221,1238,1163,1628,544,109,1075,286;51;F
43682;1238,897,250,274,1041,567,539,442,440,1221,650,739,626,1628,286;37;F
43720;442,274,739,446,539,1041,1623,544,422,180,909,97,57,700,1153;42;M
43723;422,461,459;43;M
43724;1381,650,633,739,660,440,539,1720,677,1623,1240,1238,925,154,1236;24;F
43729;446;37;M
43734;650,250,221,1238;30;M
43740;739,626,660,539,1199,1720,1623,1628;33;M
43743;221,1550,170,539,650,1221,1217,1199,739,286,626,1623,685,1236,1720;34;M
43745;1234,1236,633,739,660,539,1199,1720,677,1623,780,1016,1240,925,286;34;F
43746;633,440,539,1720,1623,1240,1550,221,286,963;36;M
43759;897,1093,193,567,650,1623,780,1163,1628,963;38;M
43784;1075,531,1153,674,553,1199,868,1550,1238,925,544,422,109,97,700;39;F
43790;274,1720,539,440,660,1221,739,221,925,434;41;F
43800;897,925,422,1153,700,674,440,1628,544;49;M
43803;422,286,700,539,1628;40;F
43826;1149,739,674,193,1623,780,221,1163,700;40;M
43831;1217,739,1442,553,440,539,274,250,1240,897,925,544,459,180,894;31;F
43880;739,1217,1214,1490,553,539,1720,780,1238,925,422,109,1075,909,1699;33;F
43913;446;41;F
43914;674,1199,1234,1093,119,1720,1238,544,109,461,1075,286,700,1666,1153;63;F
43939;1221,553,567,1381,868,119,780,1628,1699;39;F
43957;1163,459,461,1075,739,660,1720,677,1623,1016,1240,221,1238,286,57;48;F
43980;660,193,119,780,1699,274,1720,567,539,553,739,1623,925,544,97;23;F
44054;274,544,286,180,1238,1623,1720,1093,539,660,553,193,221,434,1666;79;F
44062;1442;12;F
44094;55,650,739,539,567,780,1623,274,250,897,221,925,909,286,434;52;M
44096;739,660,440,539,337,1623,274,1240,221,1238,422,531,97,193,1163;53;F
44105;1442;39;F
44114;180,1214,57,119,1221,868,260,1217,650,1720,274,1238,544,422,109;8;F
44129;1217,626,660,567,1720,1016,897,221,1550,335,109,1075,909,286,1236;39;M
44149;685,1442,1199,1720,780,1016,1238,925,1163;45;F
44156;626,1550,1628,894,97,57;40;M
44162;440,539,1238,1236,1240,1016,677,868,1199,739,244,442;71;F
44177;57,963;66;M
44179;260,553,1199,193,1381,1720,1238,1163,422,109,1075,286;48;F
44212;660,442,119,1623,1016,1240,221,925,544,286,1666;62;F
44218;868,1240,1623,1016,1550,57,1236,739,170;31;M
44234;700;70;F
44241;1153,57,531,422,1628,274,440,674,739,660,539,221,1550,544,286;53;M
44245;739,169,660,440,539,1016,1240,897,221,1238,286,1236;54;F
44251;442,539,1093,1720,1623,274,1240,221,461,963,909,286,531,321,1666;23;F
44277;567,1234,1414,925,909,739,539,1199,1381,1720,1623,780,1238,335,1666;26;F
44288;119,1623,1550,650,868,677,1720,1041,1238,925,963,180,909,894,434;36;F
44303;868,1720,1221,193,1214,1075,567,119,1238;38;M
44311;1163,339,169,739,660,440,1199,1720,780,1550,1238,459,531,1628,286;30;M
44318;244,260,1720,337,677,1016,1240,544,422,461,1442;31;F
44320;650,169,660,1234,119,1623,780,1016,274,250,1240,1550,909,1699,1236;24;F
44355;739,674,567,1199,1414,1238,925,1628,544,909,286,97,700,1666,1153;32;F
44360;260,626,553,539,1041,1238,1628,544,1240,1093,1720,1623,1016,250,274;26;F
44362;1414,1623,1240,221,1238,1288,335,544,286,434,1666,1234,193,170,440;14;M
44389;1199,1720,1016,1550,1238,1163,544;28;M
44396;1720,286,193,1153,1550,1163,544,700;48;F
44405;127,1381,446,626,193,1093,1720,1623,221,1238,925,1163,1628,544,97;44;F
44424;633,739,660,1199,1720;29;F
44430;440;49;F
44438;260,440,539,1199,221,1238,459,286,1699,250,1153;46;F
44443;544,1550,250,274,780,1623,440,1221,1217,739,660,1720,221,286,531;41;F
44444;97,544,1288,221,1623,337,119,1234,1199,260,739,1720,1550,1238,925;29;F
44462;286,221,567,1217,650,739,626,442,539,1720,780,459,894,531,1666;33;F
44467;434;40;F
44485;1199,567,539,660,626,260,739,339,446,221,674,1720,544,97,700;25;F
44505;567,897,925,434;37;F
44507;434;13;M
44529;553,1199,1720,1623,1550,1238,531;25;F
44537;897,925,434;40;M
44550;434;7;M
44551;337,925,1075,1217,1221,440,567,119,221,909,1666,339,193,442,1720;62;F
44554;1075,1236,660,573,780,1016,1550,1238,1288,1163,1199,1381,1234,1720,1623;32;F
44563;434;39;M
44564;440,660,567,57,1153,1217,539,1720,1623,780,221,1550,1238;26;F
44568;925,897,434;68;F
44575;567,1199,193,337,925,335,544,1490,674,1720,1414,1238,1075,286,700;26;F
44578;897,925,434;7;F
44589;1442;14;M
44596;1442;14;F
44600;1442;14;M
44604;685;47;M
44605;897,925,434;68;M
44618;897,925,434;63;F
44621;169,1221,446,244,339,1217,685,1199,1240,97,1666,1236,660,442,531;30;F
44630;700;74;F
44632;897,925,434;68;M
44642;539,193,119,1720,422,459,461,180,57,700,127;42;M
44647;897,925,434;23;F
44664;660,1720,1238,544,286,260;56;F
44667;1238;58;M
44672;739,1221,169,539,193,1234,459,286,97,650,1214,1149,1442,660,544;46;M
44690;260,660,868,677,780,1016,1240,221,1238,1628,544,422,1075,286,1236;38;M
44702;1666,193,1234,1163,1628,109,461,1075,57,700,286,260,660,221,544;55;F
44720;660,539,1623,1016,1240,1163,1628,739;42;M
44723;1149,674,286,446,260,442,109,700,1666,1153;65;F
44732;1075,894,170,1149,446,674,660,1720,1623,221,925,544,97,700,1153;58;F
44774;1623,221,286,894,97,739,674,1550,1288,925,1628,544,57,700,1153;49;F
44785;650,925,221,260,1149,169,660,440,539,127,1623,780,1016,1240,1550;36;M
44793;660,1623,274,1240,897,221,544,286,1236;39;F
44800;170,446,660,440,1720,780,221,286,260,674,1628,544,109,1075,321;39;F
44828;260,1016,1550,1238,1240,127,286,925,1720,1041,1199,169,1623,434,1236;32;F
44834;169,660,539,127,1623,1016,1240,221,1550,1628,422,963,286,531,1236;25;M
44851;260,109;59;M
44857;169,1149,127;21;M
44858;109,260;27;M
44861;109,260;53;F
44877;626,660,650,739,1623,925,286,894;53;M
44880;685,868,337,1720,925;38;F
44890;1699,739,1236,650,169,660,193,119,1720,1414,1016,1550,1238,925,1163;38;M
44915;660,544,531,286,1699,1238,739,868,1720,1623,1016,1240,1550,1236,244;45;F
44932;660,169,260,1221,739,1217,339,674,221,1238,909,286,700,1666,1153;36;M
44961;685;48;F
44966;868,274,897,780,1240,1238,422,434,1217,660,539,1623,925,909,567;35;F
44973;700;72;F
44977;169,660,567,1381,1093,119,1720,1623,221,925,544,909,286,531,1666;36;F
44994;250,1240,221,286,531,434,193,119,573,440,339,1288,1238,650,1628;26;M
45013;894,531,1149,674,660,539,1623,274,221,1238,1628,286,97,1153,700;34;M
45099;780,1016,1240,221,1238,97,739,1199,193,1720,1041,544,286,57,1236;35;M
45102;780,1240,1623,897,221,1381,442,1199,1666,339,193,1238,544,286,321;32;F
45109;1217,55,339,739,626,660,440,539,567,1720,221,909,286,193,1623;23;F
45146;739,660,539,193,868,1720,221,422,1075,260,553,567,1238,109,180;32;F
45149;626,335,422,180;4;M
45167;1153,1623,544,780,868,1234,1381,553,180,925,422,57;44;F
45170;739,1217,626,193,337,1414,897,221,1238,339,544,286;16;F
45214;169;75;F
45227;127,286;27;M
45234;1381,868,337,1720,221,544,422,1666,339,573,1238,1288,925,335,97;37;F
45282;1623,1550,1238,1628,422,739,260,1199,868,119,1720,925,109,894,1236;39;F
45292;868,660,626,446,739,1093,442,553,1442,260,1149,1217,650,1238,1163;55;F
45316;1442,1149,339,1490,739,169,119,337,1623,780,1238,925,1628,422,286;39;F
45349;1234,1720,1623,274,1550,1238,1288,544,109,1666,339,660,1199,221,286;40;F
45352;1217,339,739,626,660,440,539,1720,780,221,1628,422,459,286,57;51;F
45356;1238,925,1236,626,539,567,868,193,1163,1628,109,180,909,894,1666;53;F
45368;459,1075,286,57,660,739,446,674,221,925,1628,544,109,260,1153;22;F
45406;1016,221,335,531,1075,109,422,1163,925,1238,780,868,739,260,660;39;M
45427;685,868,1238,925,544,894,700;38;F
45429;925,909,57,650,1149,1442,553,1199,127,119,1720,1238,1628,335,544;54;M
45433;531,221,1217,633,1041,274,909,660,1414,780,1238,1628,1163,286,97;31;M
45435;193,442;38;M
45475;250,1238,925,1666,739,660,440,539,1199,868;30;F
45480;739,626,674,539,1234,1720,1628,544,286,531,700,1153;39;M
45485;461,109,154,1041,1381,1199,626,739,1238,1163,909,567,780,1628,459;44;F
45496;1163,700,55,739,626,674,660,539,1720,1623,221,1550,544,286,894;65;F
45497;1550,180,700,1236,780,650,1720,1016,250,221,544,459,286,57,894;35;M
45501;553,221,1550,1238,180,909,286,57,274;48;M
45505;925,434;49;M
45508;567,539,440,446,650,739,674,660,127,221,1550,925,1628,544,286;86;F
45527;925,434;43;F
45542;127,1720,1623,221,1550,1238,1628,544,286,531,700,97,1149,674,1153;31;M
45552;1217,339,573,567,1623,539,1199,1720,221,1238,544,1075,286,1236,1666;29;F
45587;422,180;50;M
45589;1217,633,739,169,660,539,1720,677,1623,1016,1240,1550,1238,286,1236;26;F
45654;1442,260,1490,1217,1149,1234,1093,1720,1238,925,335,544,531,97,1666;23;F
45659;925,434;42;F
45663;650,739,539,567,780,1016,1240,1550,221,544,909,57,700,1236,1628;42;F
45673;685,660,1720,1623,897,1550,221,925,544,286,1236,894;35;F
45674;544;33;F
45675;170,633,739,244,660,1720,1623,1016,1240,925,154,57;59;M
45714;925,434;45;M
45716;169,127,1163;51;M
45719;660,260,739,339,1149,446,674,221,1238,925,544,286,531,97,1153;28;F
45742;109,286,894,531,440,739,169,539,337,1550,221,780,1623,127,660;52;F
45791;780,1041,868,1199,553,260,650,244,339,170,1234,1623,677,1720,925;37;F
45807;170,660,1550,925,531,1236,1628,1153,1149,97,544,1623,286,1720,221;36;M
45828;1217,339,169,660,440,1623,739,442,539,1720,221,1238,286,531,1666;31;F
45838;1490,739,1221,553,539,567,868,119,897,335,109,180,909;30;F
45852;780,1075,894,700,674,1238,422,109;37;M
45870;544,1238,97;50;M
45904;440,1217,739,660,539,1623,221,286;24;M
45910;1550,57,925,1628,459,700,650,1623;47;M
45943;170,685,244,677,780,1240,963,1236;35;F
45961;1442,567,193,1288,1628,461,650,897,1666,1153;34;M
45978;1217,180,544,1238,1720,193,553,446,1153;62;M
45982;925,434;46;F
45989;674,1234,1720,1623,221,1550,1238,1163,1628,544,909,286,700,1236,1153;26;F
45992;660,780,1236;49;M
45996;567,1041,1240,897,925,909,286,434;50;M
46025;925,434;50;F
46026;221,1238,286,925,434;41;F
46035;1720,1623,780,1016,544,180,894,286,57,1236,1240,274,626,660,221;33;F
46044;739,660,1623,274,221,925,434;48;F
46055;660,119,780,221,925,286,434;16;F
46065;650,55,626,739,339,1623,274,250,221,1238,1163,544,335,1442,1153;20;F
46068;440,539,193,925,544,963,1666,1199,1720,1623,221,1238,1628,459,286;40;F
46070;274,1240,221,286,894,531,925,434;14;F
46076;1238,925,434;11;M
46086;1628,1238,250,1442,260,650,1217,539,531,739,169,286,660,440,221;21;F
46091;446,1623,1238,1163,109,97,700,1666,544,1628,221,1720,539,660,739;68;F
46094;539,868,1041,1623,221,109,286,57,1666,650,626,1240,1628,544,1238;37;F
46101;1149,660,337,1623,780,339,868,119,221,544,422,97;41;F
46109;170,739,1199,868,1720,1016,1240,286;40;M
46110;660,221,925,459,286,434,57;14;F
46117;925,434;13;F
46152;339,897,221,544,286;30;F
46169;660,1623,221,925,459,286,434,57;44;M
46172;739,660,539,1720,1041,897,221;32;F
46190;337,55,260,1442,1381,925,422,109;41;F
46199;1623,169,739,1720,193,442,1550;38;F
46206;1016,780,1623,1041,868,119,127,1381,739,660,1240,221,1238,1628,286;25;F
46209;446,1149,674,1238,544,97,700,1153;31;M
46217;1623,221,925,459,286,434;41;F
46220;626,660,539,1720,1623,780,221,1238,1628,422,459,286;59;F
46231;539,1720,677,1016,1240,925,109,1075,1666,1236;30;M
46242;97,1666,1414,119,868,1199,440,1490,339,660,553,335,422,1075,1381;36;F
46260;685,97,180,193,553,567,897,1628;29;F
46298;1149,260,674,440,1199,1720,221,544,109,97,700;35;F
46312;442,170,1199,1234,119,109,1075,180,544,1550,193,626,1149,55,894;42;M
46347;909,1214,660,539,567,1720,1041,897,1550,286,894,1238,1666,868,442;62;M
46357;250,221,286,1234,1720,677,1550,244,1623,1236,1240,739,1016,633,1199;34;F
46369;1442;40;F
46371;650,170,633,1217,440,567,119,1720,1016,274,250,1550,1628,1699,909;18;M
46372;250,274,1016,1623,677,1720,1199,539,739,897,221,1238,1628,422,286;49;F
46375;544,1288;53;F
46388;1720,1240,1016,739,685,539,544,260,221,180,169,127;21;M
46389;1720,925,531,260,660,539,1234,193,1623,221,1550,1163,109,286;46;F
46400;925,119,1199,567,685,1214,442,1075,1666;68;F
46414;170,925,739,446,442,221,335,539,1234,1720,1414,1550,1238,544,286;31;F
46422;780,1016,274,1628,1075,1163,440,660,626,539,1093,221,544,97,700;33;F
46455;633,626,660,440,539,567,1720,1623,221,1075,286,739,1238,1628,544;43;F
46470;221,1075,909,286,650,1217,339,567,1720,897,1288,422,97,57,119;35;M
46471;274,250,221,1288,1163,335,459,909,531,321,1075,109,154,422,180;38;M
46476;739,567,1623,193;67;M
46499;739,660,440,442,539,1720,221,1238,544,97;24;M
46507;963,909,925,1550,1240,567,739,1041,1720,154,434;46;M
46508;1236,221,274,1623,1720,539,440,553,739,1217,685,650,660,442,286;69;F
46512;1288,544,434,1699,650,442,1199,193,127,250,221,1238,286,97,1666;28;F
46517;1550,434,1236,660,1238,422,286,1623,677;33;F
46518;1720,650,1623,780,544,1217,1214,1221,539,567,1199,1550,422,109,57;41;F
46519;739,539,1199,1623,780,1016,1550,1238,925,1163,1628,335,544,109,286;42;M
46526;1238,1550,250,1016,539,440,660,674,626,739,1217,633,170,650,127;28;M
46528;1490,260,553,567,1199,193,1016,1163,544,109,1075,180;84;F
46542;925,434;22;F
46551;221,1240,274,1016,1623,677,567,539,440,660,1442,244,1221,626,739;31;F
46563;925,434;43;M
46589;1442;14;F
46614;626,567,1199,1238,909,57,180,553,1720,1217,260,109;37;F
46654;531,1153,660,539,1234,1720,1623,780,1238,97,260,221,544,109,286;26;F
46666;925,434;42;F
46689;544,1153;28;M
46709;553,274,544,1075,180,909,286;38;F
46710;1666,1163,1288,1238,1550,1623,1234,1381,650,1093,1720,1016,1240,925,1236;46;F
46718;339,1490,1199,127,1238,97;39;F
46735;660,553,1093,119,1720,1623,1288,544,422,459,461,180;52;F
46744;221,1240,1016,119,868,539,440,660,1221,685,109,963,286,1236;46;F
46763;193,442,739,1149,339,685,868,337,677,274,422,109,180,1666,1236;49;F
46775;1442,700,57,459,897,1240,1016,1414,780,1163,685,739,1236;37;M
46779;685,446,422,459,461;37;F
46792;780,567,1720,1240,109,97,1153,170,1628,1238,1623,221,286,544,446;28;F
46794;260,109,739,660,440,119,1550,1238,169,221,286;29;F
46816;626,660,442,539,1623,274,1240,221;70;M
46821;221,539,440,660,674,169,739,55,193,1720,1623,544,286,1236,700;17;M
46829;286;23;M
46832;193,1720,1288;68;F
46842;544,1550,1240,1016,1623,127,567,660,169,739,1628;38;M
46872;567,539,626,739,650,660,127,1720,1623,1016,1240,221,1628,335,1236;33;M
46905;868,1199,539,1149,446,674,573,1234,221,1238,544,286,97,700,1153;33;F
46906;286,434,119,1236,1240,909,539,1221,1623,626,660,1720,274,339,1288;44;F
46911;337,119,1381,1199,442,244,339,739,660,539,1720,1623,1016,1240,925;51;F
46919;170,1199,1234,1414,1238,1288;36;F
46925;531,434,1666,1381,442,244,446,1217,633,626,739,260,1238,286,685;77;F
46945;1041,1623,897,221,925,434;40;F
46954;868,434,119,339,260,442,573,337,1720,1414,1238,544,109,909,1666;33;F
46958;1720,1623,1016,109,660,286,685,422,925,1240,193,739,244,1550,633;11;F
46964;650,739,660,539,1041,250,221,1550,1238,274,286;40;F
46992;339,260,1199,193,1234,119,1720,780,1238,1288,1628,109,97,57,1666;31;F
47016;544,1288,440,660,442,1720,274,250,221,109,286,1699,1666;62;F
47032;650;68;F
47040;539,1153;49;F
47041;739,193,1623,780,250,221,925,109,461,286,57,1666;63;F
47053;1666,531,180,422,539,739,660,440,1381,127,1720,1623,221,1238,286;56;F
47069;1236,1623,1720,244;11;M
47100;442,119,1720,1016,221,1238,335,544,180,286,434,1666,1153;72;M
47118;109,97,57,1236,422,274,244,286,1240,1163,925,739,1550,193,633;11;M
47127;193;34;F
47139;193,1720,1163,286,894,57,1699;75;F
47147;97,57,1236,1153,650,660,539,1623,1016,335,422,154,925,567,909;48;M
47149;1217,1623,897,544,286,321,1699,700,1236,739,539;35;F
47161;925,434;50;M
47170;1381,337,221,1550,1238,925,422,109,1666,339,119,1720,1414,544,97;17;F
47190;339,1234,1414,1075,1236,1623,1240,244,660,1016,1238;50;M
47200;539,1199,1381,780,1628,909,57,700,1153;32;F
47201;339,626,442,1199,1234,119,1720,1623,780,221,1628,109,459,286,57;37;F
47212;55,1720,221,1163,154,461,286,894,1699;77;M
47215;221,544,286;35;F
47230;739,1720,1199,539,244;13;F
47238;1699,337,119,1666,539,1623,339,573,440,1199,1234,250,739,1238,1414;26;M
47251;650,221,531,1699,1236,286,1628,1240,567,1217,739,660,440,539,1623;20;M
47256;539,868,677,1623,1016,1240,221,925,1163,544,109,1075,286,57,1236;44;F
47258;739,260,553,539,1381,677,1623,1238,422,154,109,1240;47;M
47269;1238,539,1214,1221,1075,1720,1666;36;M
47290;422,1153,1234,868,1720,925,1163,1628,97,700,154,544,221,660,674;76;F
47292;260,553,442,539,868,119,337,1240,1238,925,335,180,57,339,1442;50;F
47294;650,1234,244,1240,739,169,1163,1236,170,339,539,1623,780,1550,925;22;F
47300;119,1720,1093,868,1666,286,1623,321,626,1442,1238,250,1236,274,221;35;F
47315;1238,660,739,780,274,1240,221,286;63;F
47317;1720,909,286,57,1628;42;M
47321;660,739,440,1199,1381,868,119,221,1238,925,335,459,286,97;27;F
47324;1217,739,660,440,539,567,1199,1720,1623,274,221,1238,1288,1628,109;26;F
47345;57,250,780,459;31;F
47349;446,221,544,1075,286;37;M
47364;739,1490,337,119,573,660,339,868,1623,1550,1238,109,963,286,1236;46;F
47370;739,1217,626,660,539,780,897,1550,1163,1628,909,531,434,321,1153;29;M
47391;1381;42;M
47422;1234,780,539,1221,339,660,193,1041,1623,221,1238,459,286,434,57;36;F
47428;539,119,1163,1666,650,739,260,193,1720,780,250,897,1238,925,109;33;F
47444;685,446,260,897,1550,1628,422,109,170,127,780,544,459,57,700;38;M
47508;442,1016,544,422,1236,1238,1240,1720,119,193,1199,567,660,739,1666;36;M
47537;539,1093,868,780,274,109,1149,1153,925,446,250,544,97,335,434;38;F
47552;633,739,626,660,440,539,567,1720,1623,221,1238,1628,544,1075,286;50;M
47559;1075;53;F
47574;553,573,193,109,1075,180,286;50;M
47580;739,660,1720,154,286,1623,1016,274,1240,221,109,1550,1153;61;F
47592;633,170,339,739,260,1199,193,1720,1016,1550,1238,544,109,963,1236;27;F
47609;739,244,660,440,539,1720,1623,1016,1240,1550,221,1238,154,286,1236;27;F
47623;244,1720,544,57,1153,260,440,1199,1381,868,119,337,1238,1288,335;37;F
47654;109,260,1236;60;M
47676;1288;51;F
47677;339,1199,1234,1093,925,422,109,1075,180,97,459,1720,1238,650,553;36;F
47680;1550,1238,335,57,1236,650,685,170,739,260,169,660,440,193,127;56;F
47706;321,274,1628,531,1666,660,1381,1199,1016,1623,1550,1238,1075,286,57;40;F
47721;1238,1199,97,1153,1149,446,1381,868,925,1628,335,544,422,700,674;43;M
47746;739,1221,660,440,539,567,1093,1720,1623,1240,221,1238,909,286,434;42;F
47757;909,461,1720,193;51;M
47764;260,339,685,739,193,1623,221,109,1075,286,250,1238,567,925,434;31;M
47782;544,1550,221,274,1016,780,1623,193,567,539,440,553,660,626,739;47;M
47866;260,925,109,434;52;F
47883;660,193,1720,1623,780,274,1240,221,925,1628,109,459,286,57,1666;24;F
47884;422,109,909,97,57,1236,260,169,567,119,1238,925,544,286,531;28;F
47889;170,650,55,1623,221,894,434,1666,339,739,169,442,539,1199,1550;58;F
47890;894,739,925,1238,1550,221,1240,1016,780,544,1236,286;40;F
47891;109,544,1238,337,1234,1199,440,260,674,446;34;F
47901;1623,250,154,97,739,539,1199,1041,1414,780,221,1238,1628,286,531;26;F
47904;1238,868,193,1075,1214,1490,446,1442,573,335,180,909,567,119,1217;37;F
47905;193,1234,1093,119,1288,109,1236,339,739,1199,1720,1623,780,925,286;33;F
47920;573,440,169,739,685,650,1490,660,1720,1041,1016,221,1238,544,286;33;M
47935;339,1149,244,1199,1720,1016,1240,897,1238,1163,109,1075,894,1666,1236;36;F
47939;925,422;39;F
48009;1550,963,221,119,1199,442,660,1149,674,539,1628,544,531,700,1153;62;F
48015;221,1288,925,700,1666,193,335,109,868,260,1550,1238,544,422,434;64;F
48035;925,1163,286,1217,55,1623,1414,894,626,567,909,1720,897,1238,544;37;M
48041;339,1490,260,442,567,1199,337,1414,274,897,925,335,109,1075,909;29;F
48049;539,119;44;F
48051;221,1550,1628,925,1149,1720,1238,544,109,286,97,1153;26;F
48053;1016,221,544,461,170,169,660,1199,1720,1550,925,1163,286,531,1236;66;F
48079;1221,780,274,1240,221,1238,544,286,1236,97,1623,1720,539,440,739;25;M
48087;1234,193,1199,573,739,1149,1490,339,221,1550,1238,1288,925,1666,109;25;F
48094;127,1720,1623,1016,274,1240,221,1550,925,1163,544,461,286,531,1236;10;M
48107;660,169,127,780,221,1550,1628,544,459,286;49;M
48146;170,660,260,1623,440,221,1550,1238,109,286,531;42;F
48171;1490,1163,739,660,539,1199,1381,1623,780,1238,925,335,109,97,1666;29;F
48181;1153,1041,422,963,339,573,1381,1093,1075,260,868,1720,1238,925,109;49;F
48193;260,440,1720,1016,544,109,739,170,193,1442,1414,1623,1163,1075,531;40;M
48201;739,650,1217,339,1550,440,567,1199,1720,1041,1238,544,909,894,1666;39;F
48204;1153,109,868,553,260,1221;43;F
48233;422,626,57,650,1217,1214,1221,260,868,119,1720,274,1238,544,109;6;M
48245;539,1720,274,1238,221,1623,193;55;F
48290;544,1238,1550,97;55;F
48319;244,650,1217,1199,1016,1240,221,1550,1238,925,335,544,286,57,1236;38;F
48325;739,660,442,539,1199,193,119,1623,221,1550,1238,544,286,894,1666;68;F
48341;700,660,1628,461,1153,1149,446,674,1199,1720,221,544,286,894,97;46;F
48344;1666,539,660,1149,446,674,1199,221,1628,544,461,286,97,700,1153;14;M
48370;321;26;M
48385;567,337,909,1238,335,422,868;41;M
48394;1623,321;28;M
48407;650,1699,553,1720,1041,897,221,1628,335,544,180,286,434,97,57;30;M
48418;780,1041,539,260,739,1214,650,339,531,434,868,274,925,422,1153;36;F
48421;739,260,660,539,221,1238,544,286,1666,1163,1628,1720,1623,127,1550;46;F
48430;1093,1623,780,109,1666,170,440,1199,1720,1414,221,1238,335,544,1153;40;F
48433;567,170,127,1550,925,339,674,1199,1234,337,1720,1238,544,700,650;53;M
48454;55,626,193,1720,1288,335,1075,321,1666;44;M
48457;193,1720,1623,1016,1240,221,1550,1238,1288,925,544,422,963,286,1236;24;F
48478;660,193,1720,274;31;F
48488;193;48;F
48492;1288,1075,1699,1153,1236,1666,544,1628,221,1240,1623,440,660,260,1199;40;F
48513;1217,1214,626,422,274,1238,544,1381,1221,1075,180,260,868,1720,109;3;M
48534;339,1381,119,337,1720,1623,1550,1238,1288,925,544,531;28;F
48568;1550,780,127,169;45;M
48571;335,544,109,1075,434,97,119,539,1217,626,1442,1623,1238,925,1628;45;M
48598;650,739,260,193,1381,1720,1238,109,531;40;F
48631;434,531,1550,897,674,685,739,1221,250,660,440,1199,221,909,286;33;M
48635;260,193,1623,109,1075,1666;63;F
48664;539,1199,1623,544,894,97,1236,169,193,127,1240,1550,925,1163,57;46;M
48696;1623,1016,274,897,925,544,321,1236,1153,180,461,221,909,1221,335;26;M
48706;1093,1623,1016,1240,925,1628,434,57,674,1720,221,544,286,97,700;30;M
48720;1623,1628,221,286;34;M
48729;660,553,440,573,567,1199,119,868,337,1720,1414,1238,422,180,894;45;F
48735;339,1490,739,660,573,1623,1217,1442,1199,1234,337,1720,1414,1238,109;20;F
48738;925,335,544,459,894,55,170,339,1442,119,1550,1238,1075,286,57;39;F
48744;440,567,337,1720,1623,894,286,180,422,1628,1238,221,1199,1221,1217;10;F
48761;1720,909;32;M
48771;1149,440,660,193,1720,1238,286,1153,1221,674,221,1163,1628,544,700;40;F
48778;894,459,1288,1238,780,1720,1199,442,674,446,739,1149,170,339,544;33;M
48786;286,221,1720,1221,739,1214,1217,440,1199,337,1414,1238,422,180,894;8;F
48811;422,180;8;M
48832;1153,1217,531,700,1236,633,739,446,660,539,1093,868,221,544,286;34;F
48843;1214,260,868,337,1041,274,1550,1238,925,459,180,894,531,434,1699;4;M
48859;650,339,539,1199,677,1016,897,1240,544,154,963,1236,700;38;F
48860;544;36;M
48864;633;29;M
48873;544;5;M
48924;633,260,1623,1016,780,897,1240,685,677,925,1550,335,109,963,1075;36;M
48949;422,180;29;M
48959;544;34;F
48975;1240,1550,1163,286,894,1699,221,1623,1720,539,660,169,739,1217,170;34;F
48984;1238,1288,894,1217,1666,1720,1550,1623;31;F
49015;250,335,1550,1238,909,1699,650,1217,739,567,193,127,1720,1623,274;24;F
49026;685,422,1490,677,1550,1238,109;41;F
49030;1414,1623,1163,544,97,868,1199,539,739,685,1720,1550,1238,894,531;40;F
49035;1217,260,442,109,1666;78;F
49038;119,339,660,650,274,250,1238,925,1163,544,422,963,894,97,1699;35;M
49039;650,739,573,119,1720,1623,1238,925,1163,1628,544,109,286,321,1236;23;F
49056;109,909,553,1442,260,739,1149,674,1623,780,544,286,97,700,1153;27;M
49057;674,1628,180,1153,700;38;F
49098;422,180;42;F
49114;925,422,180;47;F
49129;739,127,1623,221,180,422;61;F
49141;422,180;41;M
49142;170,260,169,539,1199,1234,868,119,1016,1240,1550,925;37;M
49145;1699,57,626,170,1720,274,250,221,286,894,567,650,1217,1623,897;24;M
49167;1163,422,180;8;M
49190;650,739,446,626,674,660,440,539,567,127,1623,221,1628,544,909;39;M
49193;440,1550,1217,1236,739,660,539,1199,1720,1623,1016,1240,221,286,531;40;F
49201;1236,531,286,909,1550,1240,1623,1720,567,539,440,660,739,1217,1288;22;F
49210;1234,1490,260,868,1016,335,1236,1041,1240,685,1199,1720,677,1238,1550;36;F
49218;700,1149,1720,97,1153,1623,531,626,660,925,1628,221,544,286,321;37;F
49223;221,925,1628,180,422;5;M
49227;1199,1666,1163,1238,337,1093,193,442,260;65;F
49232;1217,739,660,440,539,1623,1016,250,1240,221,286,531,434,1236;22;F
49248;780,1236,170,244,633,660,677,1240,1238,1199,1550,739,1720,154,1623;29;F
49263;1628,180,57,700,1153,97,286,422,544,1720,1381,553,674,446,1149;41;F
49267;660,440,539,567,1199,127,221,1153,446,1720,1041,1623,1238,1628,97;31;M
49277;446,539,567,1199,127,868,337,221,925,1628,544,286,1666;37;F
49282;544,274,1623,1720,440,660,169,739,674,539,567,221,1238,1628,286;26;F
49285;700,286,422,335,1623,1720,337,539,440,674,739,868,119,925,544;36;M
49295;1381,1623,260,250,1238,925,1699;39;F
49304;567,677,250,1550,544,422,109,1236,739,1093,1623,221,909,286,57;31;F
49319;260,119,1720,1075,286,674,660,440,539,868,1623,221,335,544,109;47;M
49320;660,1720,1623,221,1550,286,1628;33;F
49326;1149,633,170,685,337,1075,544,1720,1153,97;36;M
49333;339,260,440,1199,193,1381,1234,1238,1153,650,274,250,109;34;F
49346;1153,1217,674,1720,274,1240,1550,286,739,660,539,567,1041,1623,925;36;M
49349;109;55;F
49365;539,544,1217,1628,909,1041,1623,321,339,1666,1720,286,1238,221,1414;23;M
49370;170,169,260,440,1720,221,544,109,1199,1163,1550,1623,286,1238,127;52;M
49394;1149,446,674,553,1381,1720,1628,544,422,180,286,97,57,700,1153;6;M
49402;633,221,1238,531,109,422,1240,440,660,260,335,1016,286,894,1236;37;F
49410;1149,626,674,660,1623,221,925,1628,544,422,286,97,1153;29;M
49412;274,1236,650,739,446,674,567,1623,221,1550,1628,544,909,286,531;37;F
49414;1153,700,57,97,286,180,422,1628,1720,1381,553,674,446,1149,544;5;M
49415;1720,1199,539,739,660,440,442,119,221,1238,459,286,531,57,1666;34;F
49416;1628,422,109,894,531,650,446,440,1381,1720,1238,544,97,1666,1153;36;F
49444;1149,446,674,553,1381,1720,1628,544,422,180,286,97,57,700,1153;3;M
49452;97,700,1153,544,221,1623,337,119,567,553,660,626,260,1149,446;11;M
49462;567,1623,1550,1628,909;35;M
49494;650,1217,260,1199,274,897,1238,894;39;F
49497;1550,544,674,97,1153,1628,1149;32;M
49503;1442,1221,1217,650,739,539,1199,1720,1016,250,221,1238,925,1628,286;25;F
49514;193,909,55,1217,1214;45;M
49526;180,422;8;F
49545;925,434;37;M
49564;169,1217,440,739,339,650,539,567,1199,1720,1623,274,221,1288,909;33;F
49602;260,674,440,539,1381,1414,925,1628,335,544,109,286,97,700,1153;36;F
49612;422,180;5;M
49616;1628,221,1016,1623,1720,539,440,633,170,739,660,780,1240,57,1236;47;M
49650;739,260,660,539,1234,119,1628,1075,286,1442,1238;29;M
49665;440,868,1623,544,422;43;F
49667;1414,1238,97,894,1075,422,1490,442,573,1234,339,1720,1623,1628,1666;27;F
49670;193,1720,274,221,286,739,1442,660,1623,780,1016,1240,1238,1666,1236;48;F
49674;739,250,221,260,109;58;F
49680;1221,674,677,1550,321,1236,544,739,1240,1016,626,1623,286,539,660;28;M
49684;1153,97,544,1628,868,446;48;F
49688;660,539,193,1720,1623,1240,221,1550,1238,544,459,963,909,286,434;32;M
49701;780,1628;29;F
49751;544,154,700,1236,626,539,567,127,1720,780,897,1628,459,909,286;29;M
49777;660,1199,1414,1238,544,260,442,539,1234,1720,677,1623,109,286,1666;67;F
49796;909,1163,553,626,925,193,739,650,1217,1720,97,1628,109,260;43;M
49801;626,1149,446,660,440,221,539,567,337,1720,1628,335,544,286,97;49;F
49814;221,422,461,1149,446,674,1199,1381,1623,1550,1628,286,97,700,1153;35;F
49819;1628,97,567,739,260,1442,440,193,1623,1016,1240,1163;46;F
49824;660,1217,739,553,539,193,286,180,461,422;74;F
49825;780,1240,1238,925,1163,1628,544,459,963,894,531,434,97,57,1236;21;F
49832;544,1238,1217,739,660,440,780,1016,1240,221,1550,925,286,894,1236;8;F
49850;780,626,446,739,1490,1217,868,1623,221,1238,1628,335,286,700,1153;32;F
49864;1623,780,459,434,739,260,1234,337,544,335,109,286,531,1075,1414;16;M
49885;260,553,461,180;66;F
49904;1016,633;44;F
49907;339,1623,1236,97,531,286,109,221,1720,660,260,1016,1628,544,650;37;F
49927;1623,660,780,633,739,539,1234,1720,1236;36;M
49930;1628;28;F
49946;1238,553,193,1381,446;37;F
49948;567,1628,1041,633,739,660,539,1623,780,1016,1240,221,1163,531,286;37;F
49951;55,170,868,1623,1550,925,335,553,567,193,127,119,1238,57,909;29;M
49952;1016,1240,1238,925,544,894,531,1236;23;M
49964;1240,1550,544,154,531,1236,633,739,660,440,539,1623,221,909,286;28;M
49967;422,180;7;F
49976;1381,539,739,1217,633,260,660,440,442,274,221,109,286,57,1666;59;F
49985;1238,925,335,109,1075,909,286,434,1236,739,1149,1217,1214,1221,422;40;F
49990;422,180;4;M
49999;1628,119,539,553,442,1217,685,925,180,57;48;F
50009;1623,221,335,1666,440,339,660,868,1238,544,109,1075,260,1199,1234;40;F
50013;1666;60;M
50055;685;68;F
50067;544;43;M
50068;539,1623,260,109;64;F
50074;446,626,868,335,1628;41;M
50085;739,677,1623,780,1016,221,1550,1628,544,286,894,434,57;55;M
50100;1016,1238,459,57,700,1720,1623,1214,244,780,1199,739,1163,1550,1236;26;M
50153;1214,260,567,897,109,57;44;F
50154;633,339,260,660,539,1623,1240,109;41;F
50155;260,674,109;72;F
50165;170,739,660,1199,1381,1234,1623,780,1550,1238,925,1163,544,109,1666;37;F
50180;1666,1628,1016,1149,119;18;M
50183;339,286,440,660,169,739,539,119,1623,1414,221,1550,1238,544,321;43;F
50196;459,57,1666,1236,544,1288,1238,780,119,442,1628,461,260,109,1075;52;F
50208;260,109,1075;76;M
50223;1550,221,1628,286;50;M
50256;193,567,539,442,440,660,626,739,1214,1217,339,260,780,109,57;42;F
50260;1442,567,1720,274,250,897,925,422,909;32;M
50269;1414,337,335,461,539,274,221,286,446,780,250,1153,119,422,459;7;M
50271;925,1238,274,119,553,633,55,193,1199;48;F
50309;1217,739,660,1199,193,1234,1623,1163,461,1075,286,1666;64;F
50323;1016,440,660,1149,674,1623,780,221,1550,1628,544,109,286,97,700;34;M
50329;1442,626,1217,739,446,660,553,539,1550,221,544,180,286,909,97;43;F
50361;339,442,567,193,1720,1288,109,180,909;55;F
50363;422,925,1240,1623,1093,868,567,1199,1381,193,539,440,739,650,250;24;M
50383;1163,1720,1093,567,539,440,633,780,1016,274,963,1699,1236,250,739;25;F
50402;660,1720;23;M
50418;553,440,539,221,544,422,97;35;F
50472;1214,539,1199,193,1720,1623,780,1163,1628,544,109,531,97,1153,57;37;M
50484;1666;29;M
50490;553,660,1217,339,1214,260,539,567,1199,868,1720,1238,335,544,1666;33;F
50501;909,567,1093,1041;50;F
50511;674,539,1720,1075,531,739,660,221,1550,1238,1163,109,286,894,700;48;M
50513;446,739,685,1149,260,1628,109,180,894,531,97,1666,1153,1442;47;F
50525;170,685,553;45;F
50528;440,539,1720,1238,1628,909,286;28;F
50543;633,440,739;39;M
50550;55,894,170,127,169,1623,1550,286,531,660;36;F
50561;1666;23;M
50568;1442,660,440,119,1623,250,1240,221,1550,1238,1288,925,109,286,1153;51;M
50593;674,440,539,1720,1623,221,1550,1163,544,109,1075,286,894,531,700;10;F
50598;1666;63;F
50626;422,925,531,97,700,55,1217,1214,739,1221,660,440,539,567,1093;79;M
50627;260,633,685,739,442,1381,1720,1623,221,1550,109,1666,1238,544,286;66;F
50628;626,553,868,337,1414,1238,335,1075,180,700,650,1628,897,422,894;37;M
50647;567,1623,909,154;53;M
50657;660,169,1149,446,626,674,440,1234,221,1628,544,109,286,97,700;51;F
50667;539,1199,1093,337,1720,677,1623,780,1240,1238,335,109,1075,1666,339;50;F
50669;539,1623,109,286,260,674,1199,1234,1720,677,1238;25;F
50674;650,633,700,1666,434,1075,154,1288,897,1720,1199,553,1221,193,1163;28;F
50686;739,660,1238,1163,544;52;F
50690;897,422,650,626,553,868,337,1414,1238,335,1075,180,894,1699,700;8;M
50693;1623,337,868,193,1199,539,573,446;55;F
50697;1442;40;F
50707;650,626,553,868,337,1414,897,335,925,422,1075,700,894;5;M
50717;1550,109,57,1234,1381,1199,573,660,339,193,1720,925,1075,909,97;24;F
50730;446,660,1199,1623,780,544;49;F
50806;1075,109,1238,1199,567,1221,339,337;58;F
50809;339,573,193,1381,119,337,1414,1238,925,97;18;F
50824;544,1199,674,446,170,700;71;F
50832;739,1381,221,925,544,1075,531,1666,339;28;F
50838;1628,1238,337,868,567,539,442;64;F
50842;633,1234,260,1217,193;36;F
50844;739,260,567,1381,1093,1720,1041,274,925,335,109,1075,909;33;F
50853;739,660,440,442,221,1288,286,1666;71;F
50857;1217,339,626,1720,1623,1238;32;F
50870;1093,1720,109,1075,909,925;35;M
50875;553,1199,1381,1234,1720,1623,1240,1238,1550,1288,109,1075,180,1236,1666;21;M
50877;446,1217,1149,674,660,440,539,868,1623,1240,221,925,1628,544,286;54;F
50882;1628,422,180;40;F
50927;1238,1381,193,1217,553,57,422,180;48;F
50943;1217,1221,1214;41;M
50961;1666;57;F
50964;1666;37;M
50979;1720,119,1381,442,440,660,260,739,339,553,193,868,1238,461,180;71;F
50989;422,180;10;F
50999;531,286,221,1623,660,739,633,894,1163,1550,127,539,169;38;F
51000;739,169,539,677,1623,221,1240,286,1221,567,626,250,434,1720,274;36;F
51004;440,442,573,1199,1234,1093,119,337,1414,1623,780,1016,1240,1238,925;27;F
51012;1623,1238,57,1666,1153,553,1381,221,422,180;9;F
51026;660,539,567,1623,925,1628,909,1217,553,1199,193,1238,422,180;45;F
51038;339,539,1199,1414,1240,221,1238,544,459,109,531,434,321,700,1666;29;F
51045;339,1490,442,573,567,1720,274,1238,925,1163,544,109,1075,321,1666;27;F
51057;650,250,897,1550,1199,154,963,780,1236,1240,1016,739,677,1623,909;25;M
51067;539,193,1234,1093,119,1720,1041,1623,250,221,1238,1628,422,109,286;28;F
51075;1666,335,1240,221,1623,337,868,1234,442,660,1442,626,260,339,685;38;F
51079;1550,244,626,442,1016,1238,633,739,260,1720,677,1623,1240,154,109;68;F
51082;109;61;F
51094;1221,1217,633,650,660,567,119,1623,274,897,1238,544,109,1075,909;29;F
51108;1041,1414,1550,1628,422,109,1666,660,1623,221,1238,544,286,531,97;39;F
51114;553,1628,1550,1442,1214,626,567,459,446,180,154,127,1720,1149;49;M
51136;650,626,660,539,193,154,531,739,221,1163,544,286,1623,567,909;24;M
51155;685,739,660,539,677,274,1240,221,925,335,422,459,286,531,57;43;F
51158;700;73;F
51162;544,1075,335,109,531,739,1236,286,925,1240,677,868,539,660,685;76;F
51163;1217,1221,660,440,442,539,567,119,1720,1240,221,909,286,531,1666;63;F
51177;700;73;M
51188;1623,1720,440,660,260,739,626,539,567,1199,1288,544,109,909,286;65;F
51215;700;64;F
51228;700;63;M
51240;434,221,1699,169,553,544,1550,1163,321,57,1623,1093,260,909,461;20;M
51250;660,1199,1381,868,1720,1623,1238,925,1628,544,286,531,97,1153,700;41;F
51263;1238,1550,221,897,1240,274,1623,1720,119,193,567,660,626,1221,1214;27;F
51272;660,440,539,1199,193,274,221,1238,925,544,109,286,434,1236,1623;48;F
51292;434,925;49;F
51303;440,442,221,633,660,1016,1240,1550,422,1236,1199,1720,1238,925,109;34;F
51312;1217,339,1490,1149,446,260,1720,1238,1628,544,109,286,97,57,1153;49;F
51314;434,925;73;F
51319;925,434;12;M
51320;925,1288,700,1153,97,1149,674,1199,1381,1628;28;F
51322;221,685;69;M
51326;553,1623,221,531,1221,539,127,1234,1288,925,1214,567,119,897,909;33;F
51328;57,1153,55,339,1149,573,459,700,97,544,868,1234,1199,446,1442;46;F
51333;868,119,677,1041,925,434;21;M
51349;1490,442,539,1199,193,1234,1623,250,925,1163,109,909,894,1666;70;F
51353;1217,193,1720,461,909,97,1153;70;M
51355;925,434;55;M
51385;573,337,1720,1550,1628,335,109,286,1236,1666,339,442,119,1414,1238;28;F
51407;1149,674,660,193,1381,868,1163,1628,544,97,1153;40;F
51421;335,739,339,55,1217,1214,260,193,1720,1238,422;46;F
51431;868,1199,539,440,660,260,739,1214,633,685,119,337,780,925,963;36;F
51443;925,434;33;F
51456;446,553;38;M
51470;57,909,459,677,1041,1720,127,567,539,660,739,1214,780,897,1628;41;F
51482;1666,434,339,739,660,442,539,119,1720,1623,780,274,250,1288,925;64;F
51486;739,260,539,1041,109;62;M
51491;119,1217,567,442,274,193,57;39;F
51497;544;71;M
51499;1666,422,1550,780,739,660,1623,221,1238,544,286,531;37;F
51522;1163,1236,677,963,1238,685,1623,780,274,1240,221,925,422,459,286;33;F
51534;260,109;47;F
51539;553,193,446,1153;9;F
51549;274,739,260,660,544,434,1041,539,109;64;F
51550;553,446,97,1153;11;F
51574;442,193,553,446,1153;68;F
51579;868,1238,286,97,339,169,127,119,677,1623,897,1550,1163,1628,335;36;F
51583;1623,1240,1217,909,660,650,553,531,446,440,286,274,221,180,169;20;M
51585;339,674,440,573,337,1720,1623,221,1238,925,1628,544,109,97,700;39;F
51593;442,193,119,1623,250,1238;25;F
51602;660,1442,1221,1199,1623,1016,1240,221,531,1236,109,1720,539,739,1217;30;F
51616;660,1720,780,260,1623,109,434,1041;30;M
51618;674,567,1016,544,286,539,1623,221,909,321,1236,626,1720,553,193;40;M
51628;1149,446,674,97,700,1153;28;M
51630;1221,260,553,193,1217,925,434;45;F
51646;660,1623,1016,1240,221,1550,544,422,286,57,1236,1442,1720,780,1628;38;M
51650;573,337,1414,1238,109,1221,1217,739,539,1720,1623,221,1628,544,422;42;M
51673;1199,1238,1217,544,626;38;F
51685;1490,55,868,739,193,1623,1238,1550,925,1628,544,109,286;34;M
51701;339,169,1199,193,1238,1288,286,434;28;F
51702;685,339,260,1442,868,1720,1041,1238,925,422,109,963,1075,434,1236;45;M
51713;925,434;52;M
51720;127;76;M
51748;221,274,1016,1720,1381,539,1442,1217,1236,1628,1288,1240,780,1623,1149;20;M
51750;1217,925,434;76;M
51754;739,660,539,193,127,1720,1041,1623,1240,221,1238,1288,925,154,286;46;F
51761;553,1234,633,1163,780,909,573,274,1623,193,1199,1240,1238,1720;26;F
51773;660,446,1214,339,553,193,868,1720,221,1550,1628,1075,286,894,531;37;F
51774;1214,442,440,739,339,260,660,868,1238,544,286;36;F
51783;674,193,1720,544;63;M
51798;57,286,459,1623,1041,1720,660,925,434;44;M
51800;1720,1041;27;M
51814;1075,1236,1238,1217,1221,650,539,567,1381,1720,1041,1240,925,1628,909;30;F
51826;739,1217,650,274,221,1628,286,539,567,1623,925,909;48;F
51871;1093;50;M
51872;1666,1075,1623,539,440,660,260,221,1238,925,1163,422,109,286,531;39;F
51878;1240;51;M
51931;260,660,539,1199,1414,1016,1240,1238,335,422,109,963,894,434,1236;36;M
51958;1699,1217,244,1720,1041,1623,274,221,1238,1628,459,180,894,531,57;39;F
51969;1666,57,660,260,739,553,626,650,127,119,1238,925,1628,286,894;38;F
51970;660,339,1217,170,55,626,567,193,1093,1720,1623,780,274,1238,909;48;F
52018;170,633,660,1016,221,1550,1288,1236;49;F
52047;422,544,1628,925,1238,221,274,1623,337,539,573,440,660,674,446;11;M
52057;739,1016,1240,1628,1075,57,685,339,1234,1238,335,422,109,459,286;43;F
52070;633,1381,1623,531,739,660,440,221,286,544,1041;58;M
52074;250,459,909,57,1699,1236,650,1214,1221,626,553,567,868,1628;53;F
52076;553,567,1199,193,1093,1623,1016,1240,1238,909,1217,1214,1221,1234,925;44;F
52091;442,260,553,567,1199,193,868,119,337,335,109,1075,180,909,286;46;M
52095;274,909,700,1666,339,539,567,1199,1234,1623,221,1238,925,335,286;30;F
52096;459,1666,1214,339,1490,739,1221,553,868,1238,109,461,909,1075,180;36;F
52102;539,1720,1041,1414,274,250,1240,221,1238,154,963,286,531,1236,1623;24;M
52113;1381,1199,539,440,553,660,1442,626,739,119,274,1240,1238,925,97;42;F
52140;440,868,337,459,1075,434,1153;37;F
52154;1217,1214,1221,553,539,567,1041,1623,1238,925,422,109,1075,909,57;36;F
52157;573;39;F
52159;573;41;M
52162;539,660,739,1217,1234,1623,221,1238,544,1075,909,286,531,434,1699;17;M
52192;660,1442,739,55,685,339,119,677,780,422;63;F
52219;739,1199,1234,1720,274,250,894,531,97,650,1442,1016,1238,925,1163;41;F
52229;1149,1490,1153,700,97,894,544,1628,780,1720,1234,260,446,339,109;54;F
52261;339,1381,868,780,221,1238,544,1623,1199,1234,1093,1720;26;F
52293;739;49;F
52298;286,1666,1217,440,567,274,925,422,1236,739,660,539,1720,1623,1238;44;F
52329;1217,739,626,660,539,780,193;29;F
52331;567,442,440,339,660,1093,544,286,1217,739,573,539,1720,221,1238;46;F
52367;925,434;37;F
52369;660,539,567,1720,1240,221,909,286,739;54;F
52377;422,180;39;F
52380;1234,1623,250,1240,925,544,963,180,1699,1442,650;38;F
52387;260,626,1720,780,221,1628,544,459,109,1075;37;M
52420;170,1093,1288,1240,339,868,1238,1163,422,1199,1623,1550,1153;39;F
52426;119,422;36;F
52442;434,97,1628,925,221,1623,1720,539,660,626,1149,446,544,700,1153;52;M
52447;660,868,1720,780,274,1550,544,109,286,894,57,1699,685,650,250;30;F
52517;170,260,660,193,544,1628;25;M
52536;539,1199,1234,119,1623,780,221,1288,459,286,57,1666,567,897,909;35;F
52540;650,339,739,660,440,442,539,1199,1720,1623,221,1238,925,544,286;48;F
52549;1016,1075,57,1666,1236,461,1163,1238,780,193,339,260;46;F
52552;440,539,567,119,337,780,221,1238,925,459,909,894,286,57,1666;49;M
52554;1442,1199,109,1075,446,868,1238,97,1153;40;F
52594;674,539,193,1720,221,1238,925,1628,544,422,109,286,97,700,1153;38;F
52610;1623,1550,221,286,700,260,440,1234,1720,1238,1163,1628,544,1075,109;54;F
52619;868,1199,539,442,440,553,660,169,260,446,739,1490,339,1217,250;72;F
52622;1414,1041,539,440,553,660,1442,446,739,339,650,434,1699,868,250;70;M
52643;170,1720,1199,633,739,1236,127,169,1623,321,221,531,286,1550,1153;43;M
52647;1075,1238,119,442,674,169,321,1288,1163,193,260,1234,109,1149,1153;69;M
52655;260,109;70;F
52659;1442;42;F
52668;1490,339,170,650,169,442,1199,193,127,1623,1238,335,109,459,57;46;F
52699;260,660,539,1550,1288,925,109,1075,57,1236,170,1623,221,1238,286;49;F
52704;650,925,544,422,1075,286,909,1217,626,660,440,567,868,221,1628;40;M
52728;1240,1623,440,1221,1217,739,660,539,221;42;F
52748;335,442,1149,260,169,674,193,1234,1238,1288,1163,109,1075,321,1236;43;F
52751;780,1623,1199,539,660,626,739,170,1016,1240,221,1550,544,286,1236;39;F
52773;539,573,442,660,260,650,339,337,1720,1041,1238,335,1075,434,1666;49;F
52774;260,1221,109,1628,169,539,1236,674,700,286,193,1623,868,274,1217;37;M
52787;739,440,539,1199,1016,1240,1238,1628,531,660,1720,221,544,286,1666;36;F
52795;739,660,1199,286,1238,221,422,1217,1214,567,539,1720,909,1221;40;M
52807;1221,573,1199,422,531,434,321,1217,660,539,1623,1550,286,221,1720;39;F
52817;335,674,539,1623,221,1550,1628,544,1075,286,97,57,700,1153,440;28;M
52823;1149,739,1221,1442,660,539,1623,780,1016,1628,422,459,286,97,57;35;M
52825;739,633,1217,170,335,544,459,963,286,531,97,1666,260,109,1075;65;F
52829;1238,1163;38;F
52839;170,739,660,539,567,193,119,780,1016,1550,1238,925,1628,544,650;32;F
52842;1623,925,660,633,193,127,1016,1238,1240,1550,739,1236;48;F
52866;169;15;M
52869;1236,1442;33;F
52885;739,244,1199,127,1720,780,1550,1238,1163,1628,544,459,531,57,1236;38;F
52895;909,1666,633,567,539,553,274,1238,739,170,1720,1414,286,650,626;66;F
52907;739,1217,339,660,440,539,1720,1623,250,1240,221,1238,335,286,531;17;F
52916;1623,1442,739,1217,1221,553,1720,422,286,660,539;42;M
52921;531,739,1217,539,193,127,1234,1720,1240,897,221,1238,925,461,286;33;F
52947;739,660,539,1623,780,1016,274,1240,221,1288,925,422,109,286,1236;40;F
52950;1442;9;F
52973;739,440,539,1623,221,286;44;M
52989;193,1234,1240,1550,909,1199,1236,1623,531,286,170,321,544,739,660;28;M
53008;440,660,1221,739,260,539,1720,1623,274,250,221,1238,109,1075,286;46;F
53013;442,119;70;M
53023;650,567,1199,193,1720,1623,274,1240,897,1238,286,531,434,700,1236;23;F
53029;567,925,109,1075,909,286,57,1238;51;F
53032;1149,446,544,97;48;F
53048;170,1623,1550,1163,1628,700;41;F
53056;422,180;36;F
53058;539,868,1075,440,221,660,446,1628,422,180,1238,286,1720,1666,335;34;F
53069;286,1666,442;68;F
53081;422,109,1075,170,1199,1234,119,1720,1414,1238,286,894,1666,169,127;32;F
53083;650,567,1199,193,1720,1623,274,1240,897,1238,286,531,434,700,1236;54;M
53090;1490,193,339,1199,1720,1623,274,1240,897,1238,286,531,434,700,1236;53;F
53093;650,244,660,440,539,1199,1381,1720,677,1623,780,1016,1240,57,1236;44;F
53100;1236,434,169,739,660,440,1199,1720,1623,1240,897,221,335,154,286;44;M
53111;55,446,539,1623,274,221,925,544,154,286,674,700;46;M
53126;1217,739,544,286,1236,221,274,1720,442;21;M
53129;780,1550,170,1163,127,169;37;M
53152;739,260,660,440,1199,1234,1623,1016,1240,1288,925,1163,1075,1666,1236;37;F
53160;440,1238,739,260,660,539,1623,1240,221,1550,1628,544,109,286,97;43;M
53176;539,127,1623,897,1550,1238,1163,544,422,894,1153,169,286,531,97;44;F
53184;539,553,660,260,739,1720,1623,1238,544,109,286;75;F
53187;250;45;M
53205;127;69;M
53219;677,1236,626,55,739,660,539,567,1720,1623,221,1550,1628,544,286;35;F
53240;1666,461,193,180,1720,57;25;F
53242;193,925,1628,461,1075,180;32;M
53275;1238,337,1720,1414,1288,335,1075,180,894,260,553,442,925,1666,109;62;M
53281;422,180;39;F
53285;440,127,250,544,1163,193,539,739,650,674,1720,1623,1016,1550,925;42;M
53295;434,180,925,739,626,660,539,1720,1623,1240,221,335,544,286,169;10;M
53304;440,1199,119,1623,221,925,286,97;29;M
53327;544;35;F
53343;1238,909,780,1623,567,440,660,739,1217,274,250,1240,221,286,539;31;M
53345;544;38;M
53358;193,1623,539,739,674,660,442,1720,221,1550,1628,544,286;33;M
53381;1238,1414,1234,97,286,544,221,1623,1720,193,1199,539,440,660,739;47;F
53387;97,286,459,1623,677,1720,193,567,660,626,446,739,650,1149,544;16;M
53412;700,1153;47;M
53423;674,660,442,1199,1238,335,1720,274,221,1550,544,154,1075,286,700;34;F
53433;909,1075,539,650,739,169,660,127,221,1550,1238,1628,1163,286,531;32;M
53436;180,422;37;M
53437;553,442,119,1666;67;F
53446;170,739,660,442,1381,1234,1623,1016,1240,897,221,286;24;M
53460;739,626,440,442,539,1199,119,780,221,1628,544,109,286,1666;56;F
53465;674,127,1234,119,1720,780,221,1288,925,1628,544,286,97,57,700;56;F
53496;660,440,221,109,1238,1720,1550,626,1628,531,286,1623,169,127,894;38;F
53504;1149,660,440,539,1240,221,1550,1238,1628,544,286,531,434,97,1153;21;M
53528;544,170,169,127,897,1550,1163;37;F
53542;286,531,97,700,1666,660,440,442,539,193,1240,221,1238,1628,544;55;F
53556;1221,260,660,539,567,1623,221,1238,109,909,286;45;F
53562;260,440,1381,1720,780,335,422,109,180,97,700,1153;7;M
53570;442,119;65;F
53588;531,221,1016,780,650,739,909,57,1628,567,1240,1236;45;M
53593;1628,1149,1238,544,1153;36;M
53604;260,119,925,1666,739,660,442,539,1199,1720,1623,221,1288,544,286;47;F
53628;633,674,660,440,539,1234,1016,221,1550,286,97,1199,1720,1623,544;26;F
53633;335,897,250,274,1623,780,567,539,660,1442,446,739,1217,650,685;13;M
53634;674,553,1381,868,1720,1238,925,335,544,422,109,180,97,700,1153;37;F
53663;1442;36;M
53697;286,531,97,1666,650,442,1414,1238,544,1214,780,422,459,57,1628;33;M
53699;1199,1623,274,1240,1550,1238,1163,422,321,1236,1720,221,1628,544,700;33;F
53706;109,674,1720,221,1238,544,286,97,700,1666;77;M
53720;1720,1240,1238,1236,1199,1016,963,925,894,739,660,633,553,286,244;29;F
53760;1217,1214,909,1149,446,1221,674,660,1381,221,1628,544,97,700,1153;87;F
53783;567,897,909;34;M
53793;260,170,868,119,780,1550,1238,925,1163,1628,335,422,109,286,531;33;F
53809;337,127,193,660,170,925,422,286;49;F
53816;909,567,897;31;F
53830;127,1381,1199,660,739,567,868,1623,780,274,1550,1238,1628,286,894;34;F
53844;963,633,739,674,442,119,1720,677,1623,274,1240,1550,1288,925,544;75;F
53850;739,1217,660,567,539,193,221,1238,1163,286;23;M
53857;442,1093,1075,1666,97,1153,169,868,1550,335,925,544,339,127,894;42;F
53864;553,440,539,567,1199,868,337,1720,1041,1623,250,1238,925,422,180;39;F
53899;1149,539,1199,1381,221,925,1628,544,97,1153,674,700;35;F
53909;339,1490,461,553,1238;35;F
53931;539,660,739,1214,650,1217,567,1720,1414,780,250,925,1163,1628,57;57;F
53932;1236,459,461,894,531,97,1628,739,1214,1217,553,193,422,180,286;14;M
53935;119,337,1720,1414,1623,1016,1240,221,1550,1238,1628,544,109,1075,286;47;M
53945;260,739,1217,109;33;M
53947;650,1414,339,442,573,1199,1234,868,119,1720,1238,1075,894,97,1666;30;F
53952;650,633,1699;39;F
53954;1442;26;F
53956;274;25;M
53958;660,221,459,909,553,193,461,180,286;43;F
53978;1199,1381,339,539,868,119,337,1623,1016,250,221,925,335,109,286;26;F
53985;119,650,170,446,626,169,1442,674,567,897,925,335,459,57,963;43;M
53986;446;37;F
53989;963,1699,1041,127,553,626,1236,650,1016,244,1240,250,1442,677,274;39;F
54006;531,1236,1720,660,221,1550,739,1623,169,626,1149,97,674,286,1628;27;M
54016;868,780,909,286,626,660,274,1666,553,567,193,337,221,925,461;59;F
54025;274,1238,925,544,459,180,286,1666,868,440,567,193,1623,461,909;60;M
54034;339,442,573,1381,1093,868,119,1623,1240,221,1238,109,1075,1236,1153;36;F
54038;260,739,1199,1093,1041,274,897,1238,925,434;49;F
54042;1623,677,1720,193,539,660,169,739,633;60;F
54043;55,446,626,1381,1720,1623,221,1628,335,544,422,286,97,700,1153;47;M
54049;963,544,335,925,1238,677,868,539,442,660,260,739,633,650,685;46;F
54068;154,1720,539,739,633,221,286,531,660,1628;34;M
54081;446;43;M
54102;544,97,1153;43;F
54104;650,739,674,660,440,539,193,1623,274,250,1550,925,1163,57,1699;35;F
54123;633,1381,739,260,660,539,567,1414,221,1238,925,109,1075,909,97;19;F
54131;1442,894;37;F
54135;1628;37;M
54144;446,553,539,567,1623,925,1628,544,422,459,180,909,97,57,1153;38;F
54147;250;65;F
54163;221,1240,660,539,650,739,567,1623,925,544,109,1075,909,1699,1236;26;M
54170;180;47;M
54173;169,925,286;41;M
54177;1720,567,626,1214,739,660,539,1240,897,221,1238,1628,154,459,909;27;M
54178;1442;10;F
54190;1442;5;F
54234;1217,739,660,539,780,650,286,909,422,553,567,1628,57;42;M
54235;660,1550,127,1666,1720,119,193,442,339,739,109,169,544;50;F
54244;1666,335,1238,553,674,1442,260,339,685;49;F
54245;446,442,1199,544,700,1153,674,119;52;F
54262;539,1221,1217,739,169,660,440,1720,1623,274,1240,221,1550,544,286;40;F
54279;260,339,739,169,868,1720,1016,1550,1238,1163,109,1075,286,1236;46;M
54335;1628,739,1720,925;37;M
54338;1442,1153;40;F
54355;739,660,440,193,1720,1016,221,1238,286,1153;40;M
54356;1442;41;M
54367;650,127,1240,154,1236,963;57;M
54382;1442,539,567,909,57;9;M
54383;119,1199,660,260,440,442,868,335,1442,780,739,286,1550,1623,1163;47;F
54391;685,660,442,1093,1720,677,1623,274,250,1240,221,925,154,909,286;44;F
54396;446,1221,244,339,739,660,539,193,1720,1623,780,1016,1240,221,286;41;F
54411;1214,1623,442,780,274,897,221,909,286,57,1217,567,1628;46;F
54414;539,567,909,57,1442;7;M
54416;260,739,660,440,1623,780,925,1628,109,286,434,700,909,567,1041;20;M
54417;260,739,169,660,539,1199,127,1623,221,1550,544,109,286,1236,1163;59;F
54422;1199,1234,868,119,1623,780,897,925,109,97,339,1238,1628,544,700;33;F
54427;1163,894,700,1153,633,780,1442,1623,1016,1240,1628,1075,286,57,1236;28;M
54438;1442;38;F
54453;434,531,286,109,1199,1221,260,660,440,1041,1414,221,1238;24;M
54456;567,539,626,260,650,339,674,1199,1623,1628,544,109,909,97,700;40;M
54461;1442;38;M
54479;544;68;M
54484;1442;4;F
54488;544,221,539,660,739,260,169,1199,127,1623,1550,1238,1163,109,1075;81;F
54492;739,169,127,1153;24;M
54517;963;64;F
54518;1199,1238,1153;50;F
54539;193,868,1720,1041,780,1016,274,1240,221,1550,925,1628,544,57,1236;39;F
54555;963;68;M
54557;1238,660,650,539,567,1199,1720,1041,1623,897,909;50;F
54559;963,221,274,1623,539,1720,1041,897,925,193,567,109,909,286;37;F
54560;925,170,739,660,1381,1414,422,109,286,260,1199,1720,1623,780,1550;25;F
54561;170,339,1093,1238,925,1075,180,739,193,1199,1623,780,1550,335,1236;25;M
54573;440,1666,660,335,339,337;44;M
54576;567,739,660,440,539,119,337,1041,1623,221,1238,925,544,286,434;51;F
54577;1720,1414,274,221,1238,109,97,339,677,1623,780,1240,925,286,1236;25;F
54593;119,677,1041,1623,1016,274,250,1240,897,221,1628,963,286,1236,1153;49;F
54598;1623,1720,650,339,442,567,925,868,109,260,1221,1199,1238,909,1666;63;F
54624;1666;57;F
54635;1217,1214,1490,1221,660,553,567,1199,868,1720,1623,897,1238,180,909;37;F
54640;1214,553,660,567,539,868,1240,109,459,339,1381,337,1623,1238,1153;47;M
54642;1217,685,119,422,700,339,1199,1381,660,440,539,193,337,221,286;59;F
54648;739,660,440,539,1623,286;33;M
54654;739,539,193,221,1550,1163,544,1236,250,1699;38;M
54675;1199,1381,1490,446,1221,260,868,119,1720,1238,925,109,1075,909,1666;85;F
54705;553,1238,925,180,459;42;F
54737;553,1238,925,459,180;40;M
54741;286,909,897,274,1623,1720,567;20;F
54756;553,1238,925,459,180;13;F
54762;1199,1623,909,1236;58;M
54765;180,97,1490,674,573,1199,1381,119,868,925,335,544,1075,700;4;M
54772;553,925,335,459,180;10;F
54783;553,925,335,459,180;8;M
54801;553,925,335,459,180;2;F
54833;339,739,660,567,1199,1720,274,897,1238,925,544,1153;50;F
54840;626;38;F
54854;109,286,1628,1550,1238,650,97,1016,553,626,260,446,1149,1153,700;33;M
54856;700,1442,660,1490,1214,170,55,109,459,260,553,1623,461,422,180;48;M
54878;1016,1236,685;48;F
54894;97;13;M
54896;739,1240,1238,685,1442,1016,925,963,286,894,1236;39;F
54925;170,660,1163,154,286,440,1720,221;54;F
54927;660,169,440,685,1381,119,221,1238,1288,925,335,963,1075,180,286;9;M
54928;1666,1153,1623,1041,674,544,286,97,700;50;F
54940;633,868,250,1238,286,1666,739,660,440,539,567,274,221,909,1153;47;F
54951;868,1628,544,1075,700,1666,1153,1149,674,1720,1414,221,1238,286,97;50;M
54953;109,963,685,260,650,739,1199,1720,1623,780,274,250,1288,925,1699;38;M
54956;422,459,286,1666,626,553,442,1199,193,868,119,780,925,544,180;68;F
54973;650,193,1041,1623,897,434;40;M
54975;553,193,1720,544,459,461,180,57;72;M
54990;553,193,1720,544,459,461,180,57;73;F
54991;1550,1163,169,1623,127;35;F
54992;677,274,650,260,169,1442,440,221,1628,422,434,286,1214,567;36;M
55023;1217,650,739,1221,193,127,274,1550,286,700,434,909,1720,567,897;31;M
55030;286,894,531,553,660,260,1490,339,127,1414,1623,221,1550,1238,544;46;F
55034;1720,544;55;F
55043;221,1623,1041,539,440,660,650,739;52;M
55046;440,539,567,119,221,1628,544,459,286,894,97,57,1666;29;F
55050;170,169,221,1550,286,894;33;F
55085;544,422,633,739,260,660,539,1720,1414,1623,221,109,1075,286,1238;38;M
55095;459,337,221,193,127;32;M
55115;170,1699;60;F
55126;337,1414,335,1628,109,260,1720,677,1016,1240,1550,1238,925,422,1075;40;M
55129;1238,531,567,539,440,674,909,544,221,274,1623,1041,1720,660,169;32;M
55158;260;64;M
55181;1217,739,221,1628,180,286,894;37;M
55203;660,1199,1381,1234,337,1623,335,97,739,1720,1238,925,109,1075,434;22;F
55208;660,868,337,1414,1623,1240,221,925,335,544,109,1075,286,321,57;31;M
55257;633,244,739,660,1199,1234,1720,677,1623,1016,1240,154,1236;38;M
55258;57,1236,633,1214,739,244,440,539,193,1720,1623,221,1163,685,660;47;M
55265;544,894;34;M
55275;337,677,1623,1628,544,422,868,780,1016,1240,221,1550,459,286,1236;34;F
55287;1490,1149,446,260,440,442,573,1093,1623,1238,1075,97,700,1666,1153;40;F
55310;650;61;M
55317;553,1720,221,286,531;45;F
55320;660,1623,339,567,221,1238,544,286,539,553,1217,909,650,193,57;40;F
55343;170,446,674,539,1199,337,1720,1623,1238,925,335,544,422,97,700;71;F
55346;700,109,544,335,925,1238,221,677,1720,119,868,442,260,633,685;9;M
55354;109,459,780,1720,1093,539,626,739,1217,553,567,193,868,1238,1628;38;F
55366;440,660,1442,169,1221,739,650,1214,1217,626,897,1238,539,909,567;41;M
55367;221,1628,422,459,700,1153,1666,650,339,739,1381,1720,1623,780,894;25;M
55386;1153,925,780,539,1149,193,1720,1623,1016,1550,286;28;F
55409;339,1490,573,1381,1720,1623,274,1666,925,170,739,660,1238,286,57;25;F
55459;660,440,539,335,925,1238,221,677,260,685;12;F
55461;170,250;69;M
55509;739,660,127,1720,1623,1016,1240,221,1628,286,1236;47;M
55513;626,442,567,119,1720,221,1550,1628,544,286,57,1666;50;F
55519;674,1628,97,700;31;M
55546;109,909,57,286,221,780,1623,567,442,440,660,260,1221,1214,1217;46;M
55547;221,337,119,868,539,573,440,660,260,1238,335,544,109,286,321;43;F
55584;567,1199,193,1720,1240,1550,1238,925,1236;33;M
55628;553,739,1217,633,193,337,1720,1414,1623,1240,221,1550,1238,180,286;34;F
55663;221,1628,57,700,1666,442,1720,1238,544,286,531,97,321;72;F
55664;1199,1093,1623,1016,1238;24;F
55677;553,1199,1093,868,1414,1623,780,1016,1240,1238,925,1163,422,894,1236;40;F
55686;1623,1163,1075,909,57,260,553,868,119,335,109,286,1628,422,180;41;F
55688;446,260,626,553,127,1234,1720,1623,925,1628,286,894,97;65;F
55689;170,685,55,553,193,1720,1238,1163,544,180;33;M
55692;286,434,700,650,739,660,1199,1720,1623,221,1238,1628,544,422,963;30;F
55711;1199,119,1550,1238,1288,335,1075,739,260,539,127,1234,1093,109,894;40;F
55730;1234,193,739,260,1442,685,127,1720,780,1016,1550,1238,1163,109,1236;45;F
55734;1414,897,1238,544,1075,97,700;9;F
55738;260,553,868,119,1623,1163,1628,335,422,109,1075,180,909,286,57;5;M
55749;626,700,674,553,544,127,894,1628;71;M
55750;260,553,868,119,1623,422,109,1163,1628,335,1075,180,909,286,57;1;M
55751;260,739,633,1217,1238,1288,925,1163,1628,154,109,180,1075,286;27;F
55766;925,1163,544,531,1414,660,440,1720,1623,286;36;F
55790;1623,780,1240,221,1550,1238,57,1666,1153,339,170,650,1414,1163,286;36;M
55810;274,894,434,1153,1217,553,1199,193,1720,1016,897,1238,1163,109,180;49;F
55816;1381,260,193,553,626,440,1720,1623,221,1163,1628,422,109,1075,180;47;M
55819;739,1234,633,1236,221,780,1720,339,55,1199,154,1623,1414,57;29;M
55826;539,1149,868,1623,109,260,660,1720,780,1240,221,1550,544,1163,286;55;F
55828;1414,119,193,442,1442,1149,170,1720,1041,250,221,1238,925,1163,434;17;M
55830;170,286;22;F
55832;650,1217,739,660,440,539,567,193,1720,1623,274,221,1628,909,286;31;F
55837;335,868,339,260,660,1720,1623,221,544,286,894,1149,446,97,1153;58;M
55843;170;75;M
55871;1442;45;F
55873;660,539,337,57,1238,544,909,170,260,553,1199,1720,1623,1240,286;39;F
55886;1442;13;M
55901;1442;10;M
55909;1234,260,1199,1414,221,1075,894,925,1623,274,868,897,422,109,434;40;F
55913;1041,897,1550,1238,1628,335,544,154,109,1075,180,57,700,1666,1153;74;F
55923;700;77;M
55927;1442;49;M
55941;1217,1214,442,567,1623,780,274,897,221,1628,909,286,57;61;M
55946;739,660,1199,1163,539,127,1720,780,221,1550,925,544,1628,109,286;31;F
55972;660,553,1623,221,422,180,57;40;M
55984;169,674,127,221,1550,1628,335,544,57,700;28;M
55991;660,553,119,1720,1623,780,1238,335,422,180;41;M
55993;660,553,1623,274,221,1238,335,422,180;42;F
56006;1623,274,250,1240,1288,894,1217,739,626,539,119,221,925,544,286;40;M
56022;1414,1381,442,553,650,337,868,1234,260,1238,1075;37;F
56044;868,1720,339,544,1666;65;M
56074;909,446,260,55,1217,626,660,553,442,573,539,567,1093,1550,544;37;F
56123;1236,434,1163,897,780,1041,677,1720,193,1199,567,539,553,685,170;69;M
56134;567,1623,1041,897,221,1238,1628,544,109,1075,286,434,1153;80;F
56137;868,274,925,963,119,1041,1238,422,434;34;F
56142;1720,260,109;55;F
56165;1381,1623,1016,221,925,739,674,660,780,1240,1628,544,286,650,440;60;M
56171;221,1550,894,1720,1623,1016,1240,1236;37;M
56214;739,440,925,539,1720,434;50;F
56243;739,169,660,440,539,250,286,531,321,1217,1720,1623,1550,1236,1699;26;M
56244;57,193,422,180,1720,553,461;43;M
56259;739,1221,553,539,1381,1234,1720,1623,780,221,925,544,422,459,1075;7;F
56265;567,685,55,539,660,339,1217,1666,57,109,1163,1623,442,626,193;41;F
56289;442,1720,1666;62;F
56311;739,1720,1623,221,109,1075;61;M
56312;544,422,531,700,1236,180,97,57,925,1550,780,1720,553,739,1214;11;F
56313;434,57,1236,1217,244,660,337,1720,1414,780,1016,1199,897,221,1238;44;M
56316;1442,539,897,221,1238,1628,422,1217,739,660,440,1199,1414,1623,1016;78;F
56318;1720,260,109,459,1217,739,660,1199,1414,1623,897,221,1238,286,894;83;M
56328;1240,700,1236,650,739,1442,660,440,868,221,1550,1238,1628,544,286;33;M
56336;739,1238,1550,97,1666,1153,1149,446,674,1381,221,1623,1163,544,286;37;F
56340;660,221,286,434,531,1236,567,539,677,1041,1623,1238,963,650,685;32;F
56359;1163,650,739,260,660,539,1720,1414,1623,274,250,221,1238,109,1699;44;F
56369;1240,109,434,1442,739,1381,868,1016,250,221,1550,1238,925,1163,286;51;F
56370;440,1628,780,1623;33;F
56385;440,544,109,1153,700;62;M
56397;650,1720,127,286,894,446,97,1628,1550,1623,544,321,700,674,221;34;F
56406;739,660,539,1623,1016,1240,221,1550,544,531,1236,286,1720,1628,626;31;M
56409;286,633,55,650,260,660,1199,193,1720,1414,1240,221,1238,1163,109;46;M
56431;567,109,1217,739,260,626,660,539,1199,1381,127,1720,1623,221,1238;56;F
56432;286,531,633,244,739,660,440,539,193,1623,1016,1240,221,1236;33;F
56457;446,660,1199,1381,1720,1414,1238,925,1628,544,422,1075,434,97,57;41;F
56463;739,660,539,193,1016,221,925,286,1236;30;F
56472;1628,780,909,1699,650;22;M
56475;1720,739,660,553,442,868,337,1623,221,1238,925,335,109,461,180;69;F
56483;1490;41;M
56487;193,1381,1720,1414,1623,250,1550,1238,1163,1628,109,1075,909,1699,1666;51;F
56499;57,274,544,97,1153;27;F
56501;567,553,1442,1221,739,1214,685,170,260,1234,119,1240,109,963,1236;28;F
56516;260,109;29;F
56523;97,1666,1720,739,442;75;F
56528;1153,321,544,925,1720,1381,193,260,674,660,440,700;62;F
56542;739,1149,446,674,553,1199,1381,1720,1414,544,109,97,700,1666,1153;55;F
56564;553,442,1199,193,868,1720,677,1623,780,1016,925,1163,109,1075,1666;50;F
56569;119,1720,1623,1238,1288,925,544,109,461,286;49;F
56572;660,553,193,1720,1623,221,1238,1288,925,109,531,57;71;F
56603;442,1236,119,573,1234,633,739,244,1199,1720,677,1623,1016,1240,1238;53;F
56607;1442;34;F
56609;442;73;M
56615;1666,897,674,1550,97,321,57,55,626,127,1720,1628,544,422,700;35;M
56639;1442,868,119,1238,335,1153;49;F
56644;193,422,180;46;F
56653;544,459,461,894,434,1699,260,1442,1199,1381,1093,780,925,286,57;51;F
56663;925,459,434,57,1666,539,1221,739,1214,1217,660,567,221,909,286;89;F
56689;739,260,780,1550,1628,109;35;M
56694;446,1149,1628;88;M
56711;660,1442,1628,1623,1550,925,1217,1163,544,461,1238,1221,868,567,909;34;F
56716;660,539,193,1720,1623,1238,925,1163,180,286,321,221,1414,1199,544;22;M
56717;739,1221,660,539,567,1720,1623,780,221,1238,459,909,286,434,57;69;F
56732;260,539,1623,780,339,739,674,442,119,925,1628,544,109,1666,1153;72;F
56737;55,170,339,868,1041,1414,897,1238,925,459,909,894,434,57,1699;17;F
56751;244,1149,685,1217,626,660,553,440,539,567,1623,221,286,909,180;25;M
56766;894,286;71;F
56777;260,109,1075;30;F
56782;633,339,1199,119,1720,1238,1288,925,1666,274,567,1221,868,897,909;31;F
56806;700,119,868,1381,539,573,660,674,260,446,1490,1217,440,193,1238;43;F
56815;1041,1720,119,127,539,440,660,244,739,567,1016,221,1628,286,1153;43;M
56832;1234,1720,1550,1238,1075,97,1153,674;38;F
56845;539,442,440,660,739,1490,339,260,169,127,1550,925,1628,422,531;42;F
56858;1720,553,286,1149,260,674,442,193,1550,1163,1628,544,109,97,700;49;M
56873;1666,739,1550,553,1217,539,1199,1720,1041,1221,567,909,897,868,274;32;M
56874;626,567,337,660,1720,700,739,221,925,286,170,339,1623,1238,894;34;M
56889;440,446,739,1442,1149,674,1016,1550,925,1628,335,544,97,700,1153;45;M
56909;700;77;F
56910;633,567,446,442,250,180,119,1490,1199,963,1041,544,434,244,109;51;F
56942;1234,1720,1075,674;38;M
56946;221,897,422,97,739,260,339,442,567,274,1238,925,335,909,434;38;M
56952;440,660,868,894,1666,335,1381,909,170,1720,1075,422,109,274,1238;29;M
56970;633,739,260,442,1199,1381,1093,868,1623,780,1016,1240,1550,1238,1163;34;F
56978;1217,1149,739,1442,1041,1240,1238,1628,434,1666;16;M
56984;674,1234,1720,1075;66;F
57003;260,674;69;M
57022;446,739,1217,780,221,1238,925,180,909,286,894,97,57,459,461;40;F
57033;442,1720,221,925,1628,700;59;M
57041;1199,925,154,109;76;M
57050;553,1720,57,180,193,422;53;F
57066;539,321;48;M
57075;321,700,1238,925,897,339,674,337,221,1163,335,422,544,109,286;44;F
57076;1623,1238,286,339,660,539,1720,1414,1016,1240,633,739,440,1199,1236;25;F
57083;1236,169,780,1550,1163;40;M
57095;339,1442,1238;15;F
57097;274,250;40;M
57098;909,531,1699,1236,650,739,1221,260,1442,660,440,539,221,1628,286;34;F
57100;1240,1288,544,286,57,1236,685,1442,660,440,1623,780,221,1238,963;45;F
57125;55,1217,260,1720,335,544,109,1075,286;75;M
57131;55,1217,260,1720,335,544,109,1075,286;71;F
57142;963;41;F
57151;180,434,274,1240,925,531,97,1217,660,440,1720,1623,221,1628,286;38;F
57173;963;37;M
57187;650,739,1442,660,539,193,1240,1550,925,1163,1628,963,286,1236;23;M
57194;1217,1628,909,286,531,1236,539,567,739,169,127,1720,1550,894;28;M
57201;286,909,963,1628,1550,221,1240,1041,567,539,440,660,739,650,1236;58;F
57209;339,446,260,674,1199,1238,1628,544,109,459,1075,97,700;41;F
57211;650,1217,739,169,660,1699,180,1238,1550,274;29;M
57218;180,909,700,1236,286,739,539;39;F
57219;109,1628,1550,260,739;30;M
57227;260,553,193,1720,1238,422,109,459,461,180;47;F
57233;1236,650,1221,567,1623,897,544,1628,909,1041,1217,244,127,963,321;53;F
57267;868,544;40;M
57278;260,1234,868,119,337,335,109,459,1075;38;M
57285;1490,339,633,739,446,1381,1414,1163,1628,544,109,286,531,97,1153;83;F
57298;633,1442,440,1623,221,1236,109,1075,909,650,244,260,660,1016,1240;65;F
57326;221,193,422,180;39;F
57327;339,1217,1214,1221,567,1238,335,459,909,57;15;F
57328;539,739,1221,1217,1214,660,567,193,274,909;48;F
57330;260,700,739,1490,660,553,539,1720,221,1238,109,1075,180,286;44;F
57342;1217,339,573,567,1199,1720,221,1238,109,909,286,434,97,57,1666;32;F
57344;55,286,700,739,553,539,1217,260,660,1720,1623,221,109,180,1075;47;M
57384;739,1666,1236;67;M
57388;57,1236,1381,1720,109,286,894,1666,170,1442,1240,1550,1238,925,544;50;F
57399;1442;65;F
57404;925,434;49;M
57416;925,434;43;F
57418;925,434;8;M
57427;1236,169,127,442,553,897,422,180,1623,1699,274,1217,567,1221,539;43;F
57446;700,339,739,260,573,539,1093,677,780,1240,1550,1238,925,544,1699;70;F
57454;109,57,1093,339,1199,1234,1240,650,1214,780,909,1720,1041,897,434;54;F
57458;1666;71;F
57491;544,109,461,286,57,700,1236,674,446,1075,1153;45;F
57501;1442;31;M
57510;1217,660,553,193,1016,925,461,180,909,286,894;76;M
57519;1442;51;M
57525;739,539,1623,1550,531,286,674,544,1628,221,1720,321;62;M
57529;55,260,626,1628,109,180,57;39;M
57537;335,544,897,780,1623,119,1199,660,1442,260,446,244,1214,55,1666;18;M
57545;1238,1628,544,963,1075,286,1666,1153,1217,446,674,539,1720,221,321;26;F
57567;337,925,422,963,1236,1199,119,1414,544,685;34;F
57569;539,1720,422,459,674,660,1623,221,1628,544,286,97,57,700,1153;71;M
57596;57,286,180,422,1628,221,780,1720,127,539,553,567,909,1217,1221;38;M
57607;1217,260,626,660,539,193,868,1720,274,925,1163,544,109,1075,180;46;M
57615;544,780,1221,1214,339,1217,633,170,685,1442,337,1550,446,1720,1238;30;F
57616;1217,650,739,442,567,1199,1234,119,1720,1041,1414,1623,1238,894,1666;45;F
57635;739,539,1623,1240,286;29;F
57679;1666;54;F
57682;685,440,573,1199,1720,1240,221,1238,286;40;F
57690;260,674,1149,97,700,446;45;M
57700;963,422,544,925,274,1414,337,1381,1199,685,57;42;M
57722;193,1217,339,660,553,539,567,1199,1623,1720;49;F
57727;286,660,193,1720,1238,180,1666;53;F
57766;1221,897,274,868,1093,1720,539,1214,567,909;32;F
57768;286;26;F
57773;339,1149,739,660,440,442,539,1720,1623,221,925,286,1666,700,1153;50;F
57778;739,674,660,442,1623,780,221,1628,544,459,286;79;F
57781;109,677,1236,633,1381,868,1016,1240,1075,739,260,660,1199,1720,1238;36;F
57786;286;32;F
57799;539,567,1720,1238,1628,544,286;31;F
57802;674,260,650,739,626,567,127,1623,780,274,1163,1628,544,109,57;36;F
57803;1163,868,1666,1234,127,1381,442,660,169,260,1442,1199,109,1720,1550;37;F
57815;739,440,539,193,780,274,925,1163,1628,544,286,650,1240,1720,1623;34;M
57829;1666;77;M
57832;1217,339,739,660,553,539,567,193,1720,1623,221,461,1666;52;M
57835;1217,221,531,339,739,660,440,442,539,1720,1238,335,909,286,1666;31;F
57841;442,1623,335,1075,1199,897,221,544,286,321;32;F
57852;1240,154,685,739,260,1199,193,1720,677,1623,221,1550,1163,286,1236;63;F
57856;1628,925,780,127,567,650,909,286;30;M
57858;244,442,677,1414,1016,1240,925,963,1236,1666;67;F
57861;442,539,1623,286,909,434,337,1041,1720,650,1093,250,339,169,57;51;F
57865;1623,260,1628,170,169,539,127,780,1550,544,109,1075,1238,1163,925;39;M
57870;567,897;25;M
57871;650,1217,193,1234,1238,626,909;23;M
57874;339,674,337,677,221,1238,925,1163,335,544,422,109,286,321,700;6;M
57899;531,660,260,868,1720,221,925,1628,544,422,109,1075,286;34;F
57940;894,1153,1149;31;M
57941;660,440,127,868,531,650,260,539,567,1623,897,1238,335,109,909;28;F
57956;97,544,1075,1666,1149,446,1199,1093,1623,1238,1288,1153;33;F
57977;674,660,337,221,1238,1288,335,544,422,109,286,97,321,700,1153;10;M
57980;650,633,739,660,440,1236,434,154,780,677,539,1623,1016,1240;38;M
57988;1041,221,1217,1214,660,539,897,1550,286,650,1221,567,1720,1628,909;55;M
57993;286,685,1720,677,1163;49;M
57995;1199,440,169,626,1221,1217,633,650,55,739,539,1720,1623,1550,544;42;M
58009;119,1238,1288,286;37;F
58019;553,1720,180;40;M
58026;1153,1414,1720,1234,567,650,446,626,442,1199,1093,897,925,544,461;62;F
58027;119,868,567,442,650,553,193,1623,221,1238,544,461,180,1153;58;F
58051;170,55,633,1442,660,539,1628,1236,1016,274,1240,221,1288,422,286;44;F
58054;339,446,674,1199,1234,1623,1153,539,440,660,221,544,1075;53;M
58087;633,1720,1240,1236,531,286,1016,660,739,539,567,1041,1623,221,909;53;M
58111;1238,650,1490,739,260,573,539,1381,1234,868,119,337,1623,250,221;40;F
58127;539,440,739,193,1720,1623,221,925,97,1163,1628,544,286,434,57;27;F
58129;1623,250,1550,925,660,567,193,1720,1041,1016,221,1238,909,286,434;40;F
58137;1550,925,544,422,459,434,97,57,739,660,539,567,221,909,286;35;F
58164;909,553;30;M
58169;739,1381,868,119,1623,780,274,1240,1238,1288,57,286,894,1666,674;31;F
58170;567,260,1221,1217,660,539,1720,1238,925,909,434;42;M
58172;544;65;F
58194;567,1217,221,286,531,97,700,1236,1628,544;23;M
58198;97,339,1149,446,660,1720,221,1238,544,422,286,1153;51;F
58207;1666;51;M
58244;221,250,1442,650,660,553,440,539,868,1720,274,925,1628;34;M
58246;1666,1199,573,442,260,1149,1720,1414,1238,544,109,286,97,700,1153;39;F
58257;739,193,127,1623,221,1628,286;34;F
58265;660,1720,1163,422,286,1236,894,1628,531,109,193,650,739,1199,1442;42;M
58278;650,1217,739,1221,660,440,539,567,1720,925,109,909,434;8;M
58303;1666,442,567,1199,193,337,286,909,335,1238;22;F
58317;260,109,1075,250,274,909,1720;39;M
58321;57,127,55,674,1238,1628,544,97,700;28;M
58323;1623,274,1236,286,539,626,567,1720,909,1628,544;45;M
58326;1490;41;F
58331;539,573,440,685,633,739,244,660,868,677,1016,1240,1075,1236;42;F
58332;925,154,963,1075,286,57,1236,446,633,739,244,780,1623,1016,1240;37;F
58344;1442,553,1199,109,180,260;54;M
58354;925,1217,660,440,1720,909,434;10;M
58363;650,1217,1221,1720,539,1623,221,909,286;20;F
58369;1221,440,1041,1153,1217,1442,660,1199,1381,1414,780,274,1550,1238,1628;65;F
58371;1217,1199,1234,1041,1414,1163,531,1666,650,739,539,1623,221,1550,1238;25;F
58384;633,739,539,1623,1016,1240,1550;39;F
58387;339,1490,868,1093,119,337,677,1288,1666,440,573,1199,1381,1238,1442;55;F
58388;660,539,567,1720,1414,1240,221,1238,544,909,286;25;F
58398;925,434;12;F
58419;57,1623,221,1550,180,909,1217,660,553,539,567,193,897,1163,544;33;F
58444;739,169,221;29;M
58449;440,260,1217,739,626,660,539,1199,1720,1623,221,1238,1628,459,286;35;F
58458;739,442,221,544;43;F
58481;1238,660,260,221,1550,335,544,286,531;40;F
58488;1666,1550,1238,1163;46;M
58520;1234,1720,1240,221,1238,1628,335,544,422,339,260,1288,109,1075,286;31;F
58526;260,109;65;F
58529;1490,739,446,1221,660,440,337,1720;36;F
58535;700;70;F
58548;193,573,440,553,1221,1490,1214,339,169,127,1720,1550,1238,1163,544;45;F
58568;553,539,1234,1041,274,1628,109,260,567,1199,897,925,422,909,434;53;M
58594;539,440,553,1442,739,650,1217,660,868,1720,274,221,1550,286,894;41;F
58598;633,650,1217,739,660,539,567,677,1016,274,1240,221,1238,544,286;26;M
58646;897,567,925,1720,274;32;M
58650;119,1288,780,339,739,442,1093,1720,221,1238,1628,109,286,1666,1236;27;F
58663;440,660,739,1214,650,127,1240,286,626,1016,1550,459,57,780,1238;28;M
58665;170,1016,1240,221,1550,286,57,1236;41;M
58687;909,1217;24;M
58737;909,1238,221,567,539,660,739,626,193,1623,1628;27;F
58742;650,739,1199,1623,1238,286,894;37;F
58765;660,440,539,739,1199,193,1381,1720,1623,221,925,1163,544,286,434;29;M
58801;685;38;M
58802;335,1628,1238,1720,119,193,660,446,260,868,221,925,544,109,1666;38;F
58831;1217,539,1199,1093,1720,221,1163,286,531;35;F
58832;55,650,780,274,250,221,925,422,180,286,894,57,1699,1236,1666;58;F
58833;127,650,339,626,567,193,1720,1623,274,897,221,544,154,286,1699;37;M
58863;739,260,660,440,567,1720,1041,1623,780,274,897;57;M
58883;739,339,119,1381,221,1288,925,459,286,909,180;28;F
58906;1221,274,250,897,286,531,739,169,660,553,539,567,1240,221,909;38;M
58957;260,739,1149,650,97,700,1236,1442,440,539,1720,1623,1628,544,286;28;M
58985;339,1149,446,674,868,119,1163,1628,544,97,700;40;F
59003;685;45;F
59014;1041,650,274,1221,1217,1238,909,1075,567,868;37;F
59027;170,442,119,1720,274,1240,422,963,286,57,1666,1153;43;F
59041;553,660,260,244,1221,1217,442,539,567,193,119,1720,1623,286,909;66;F
59051;119,868,1236,1217,739,660,539,1720,1623,221,1238,1163,544,909,286;30;M
59061;553,1221,193,567,685,1217,626,274,250,221,109,461,909,286,1699;33;M
59097;573;44;F
59133;170,221,1238;38;F
59137;1238,274,1623,897,193,539,1720,553,119,1214,868,1221,1075,909,567;33;F
59144;1623,170,1550,1720,434,925,1041,567,909,897;36;M
59154;739,660,440,1234,1016,221,1550,963,286,1236;70;F
59171;127;33;M
59182;260,442,1199,1093,1720,1238,544,119,335,337,339;46;F
59206;1699,1623,739,1214,1490,567,1199,1234,1093,868,897,1238,180,909,434;37;F
59211;544,180,442,1720,1623,780,1240,1238,1628,109,909,286,531,57,1236;33;F
59313;221,1238,925,1163,544,154,909,434,1699,1236,1217,650,660,567,1623;48;F
59336;1093,1041,1550,1288,925,109,459,1075,909,55,1199,193,1414,57,894;26;M
59342;539,1199,1234,677,1623,1016,1240,221,1550,1238,109,1075,286,57,1236;61;F
59353;539,626,700,1414,1149,1381,1720,1666,674,335,286,221,446,97,544;39;F
59376;1149,1163,1628,109,434,97,1153,446,260,674,553,1381,1550,544,700;34;M
59381;274;51;M
59395;739,674,539,1720,1623,1240,221,1550,1163,1628,544,286,97,700,1153;32;M
59400;193,446,119,780,221,1550,1163,1628,544,422,154,461,909,286,531;52;M
59440;539,446,193,109,221,1149,260,440,674,1381,544,1628;69;F
59468;169,674,1016,544,531,1236,739,660,440,539,1240,221,286;57;F
59476;660,440,539,193,1720,1623,221,1288,544,286,1666;55;M
59511;660,193,1623,1016,1240;42;F
59512;127,1163,169,1199,685,339,1381,1623,780,221,1550,1238,459,286,57;31;F
59516;1666;73;F
59522;1623,739,221,109,286;34;F
59546;1236,739,650,1217,660,440,539,567,1720,1623,221,1238,909,286,531;51;F
59548;1041,897,925,909,567;38;M
59553;339,739,539,1199,193,1720,1623,274,1240,544;33;F
59559;1666;42;M
59575;925,1666,169,1240,1016,633,544,1163,1550,339,1623,1720,531,286,221;28;M
59583;221,286,1666,1236,650,339,739,660,440,442,119,1240,1288,925,154;54;F
59589;1490,1199,868,337,677,1238;33;F
59598;567,127,274;49;M
59614;660,1217,739,260,440,1720,221,286;58;F
59622;660,193,1720,677,1623,650,739,539,1240,544,1628,154,286,1236;28;M
59624;1199,868,1623,1238,422,109,925,909,539,567;46;F
59633;660,539,1093,1628,1550,1623,1720,442,339,1199,193,1016,221,1238,894;31;F
59654;1221,660,539,1720,1623,1016,1240,897,221,1550,1238,544,286,97,321;28;F
59663;739,1149,1214,339,446,674,335,544,459,286,97,57,1666,1153;37;F
59688;1381,1720,1414,1623,780,221,925,180,909,286,1666,1217,339,1199,1238;33;F
59704;1623,119,567,440,739,260,1442,660,539,221,109,286,925,909,434;45;M
59741;650,539,567,1041,274,250,897,1238,925,544,459,286,434,97,1153;29;F
59758;1149,1623,274,221,739,660,440,539,567,909,286;36;M
59761;650,780,660,544,459,963,286,339,1041,250,897,925,909,434,57;34;F
59769;567,660,244,1240,1041,677,1720,925,1163,1628,544,963,894;50;M
59773;446,1442,660,440,539,868,1720,1623,221,1550,1238,1628,544,286,97;36;F
59790;660,440,286,1623,321,221;29;M
59804;1550,335,1240,1623,1199,573,660,1442,633,170,1720,1236,109,1016,1238;31;F
59831;1221,260,626,553,567,868,119,925,1628,422,459,180;10;F
59889;739,422,221,925,335;36;M
59900;1221,674,1550,434,1236,531,286,909,221,1623,567,539,660,626,739;79;F
59930;963,553;33;F
59934;685,286,894,57,1153,1381,868,119;11;F
59939;442,544,422,461,1199,1234,868,1075;60;F
59941;446,739,339,674,221,544,286,97,1236;47;F
59951;180,260,442,109,1075,286,97,321,1666,339,868,119,337,1238,335;41;F
59954;321,286,1075,109,422,544,335,660;35;F
60024;1442,1199,1381,1720,274,1240,1550,909,739,1234,1623,897,1238,925,286;27;F
60031;1720,1550,321,221,1163,286,1666;48;M
60037;119,1163,544,660,539,1199,1623,109,739,260,674,221,1238,286,700;54;F
60083;169,127;51;M
60101;440,539,1199,1093,1623,274,250,1240,221,1238,544,109,1236,286,531;41;F
60107;55,1628,626,221,894;35;M
60117;1628,335,544,459,286,434,97,1153,461,1623,1149,1199,1234,1288,925;26;M
60118;1236,650,567,909,274;29;M
60135;459,170,650,1153,97,286,422,544,1628,780,1623,127,674,700,221;34;M
60164;1149,739,1221,169,1442,660,440,119,221,925,544,286;24;M
60171;567,897,1238,909;32;M
60207;337,274,1240,221,925,422,1075,660,335,894,57,1699,250,1238,650;41;F
60218;339;30;F
60221;685;51;F
60240;531,169,660,1217,739,446,440,567,221,1550,1628,180,909,286,1236;76;F
60254;286,97,700,539,221,1628,544,446,660,440;41;M
60266;109,1199,573,339,539,337,1720,1238,1240,894,1550;40;F
60289;894,739,626,660,539,1623;66;F
60296;626,1442;41;F
60297;1199,193,1093,1720,1623,221,544,109,1075,286;22;F
60302;286,1075,274,1623,169,626,1221,633,739,660,440,539,1720,1240,221;51;F
60306;339,260,660,442,868,119,1720,221,1238,335,109,1075,286,894,1666;30;M
60408;567,909;28;F
60425;1490,260,626,1199,193,1093,868,1720,1414,780,1238,700;19;M
60451;170,1199,1381,1234,1720,1016,1240,1238,1163,109,461,909,286;44;F
60473;440,660,1221,244,1149,685,446,567,119,1623,780,97,1153;39;F
60496;1720,660,339,274,1238,1075;16;F
60499;739,286,1699,170,660,1199,1720,1238,1550,1163,544,531;54;F
60500;193,1041,925,109,434;48;M
60534;221,1240,1720,539,440,660,739,633,1221,626,169,1623,274,1075,286;11;M
60547;739,119,337,1238,1288,335,544,286,434,1236;49;F
60563;739,260,660,539,1199,1720,1041,1623,221,1238,925,109,963,286,434;16;F
60571;677,1236,1720,739,633,1016;41;M
60581;660,868,1238,335,459,57,909,109,1490,260,553,193,925,422,180;57;F
60584;650,440,1550,544,260,250,221,109,1217,739,660,539,1623,1016,1240;48;F
60610;1720,868,1381,539,440,660,626,739,1149,446,674,925,97,700,1153;48;M
60616;169,660,193,1623,274,1240,1550,925,1628,544,459,963,909,286;23;M
60629;626,553,127,1550,925,180,909,57;32;F
60644;739,335,459,1217,626,553,1720,780,1240,221,1628,422,180,286,57;45;F
60645;660,1550;57;F
60651;1214,1221,660,539,1623,897,286,909,567;40;M
60666;739,127,1720,221,1550,286;64;F
60669;260,780,221,97,119,1720,1414,925,1628,109,1490,1238,1163,339,335;31;F
60670;650,633,739,660,440,539,193,1720,1623,274,221,1163,286,894,531;48;F
60687;1221,739,1149,339,170,1199,1623,1016,221,1238,1628,544,286,531,1236;45;F
60689;422,180;70;F
60690;1016,1153;45;F
60692;446;42;F
60696;1214,650,127,1234,119,1240,1238,57,1442,442,1199,1016,1550,925,1628;54;F
60710;119,780,925,109,909,57,1666,260,567,1234,1238;26;F
60771;573,442,446,1149,169,119,780,221,1550,1238,925,544,286;34;F
60809;1236,1628,335,897,677,868,567,1041;35;M
60825;1041,337,539,1221,244,650,1628,57,1623,335,422,109,286;44;M
60826;446,674,544,700,1153;42;F
60890;660,567,897,221,909,286;39;M
60912;286,739,909,170,553,1623,154;38;M
60934;539,440,660,260,739,339,170,633,1720,780,1240,1238,1075,286,531;34;F
60961;650,539,1217,1490,739,442,1199,1238,274;29;F
60964;925,1628,544,459,57,1236,553,1199,780,1490,260,1442,1550,1163,109;38;M
60965;739,660,440,573,539,1234,119,868,337,221,1238,544,109,1075,1628;51;M
60969;446;56;M
60970;339,446,260,442,1199,193,868,274,1238,335,544,109,1075,97,1666;42;F
60993;650,1217,1720,780,1628,422,57;37;F
60995;1628,544,459,180,1442,127,780,1016,1240,1238,925,422,109,1075,1236;35;F
60997;221,286,434,1217,739,440,1093,1720,1623,1240,1238,1163,1075,894,531;44;F
61029;739,170,700,1153,626,674,442,1381,1623,1628,544,1666;57;F
61033;260,553,539,1240,780,337,1720,1550,1628,109,1236;44;M
61034;440,1238,193,1720,1381,1153,335,109,97,700,1623,1236,260;53;F
61060;1628,57,909,650;34;M
61072;739,633,339,244,1720,677,1016,221,1238,925,461,286,1666,1236,1240;34;M
61073;674,660,1199,1381,1234,260,169,539,1016,221,1550,1163,544,109,286;37;M
61076;1149,446,337,1623,221,925,1628,544,97,321,57,700,1153;38;F
61081;1199,442,553,660,650,1214,1221,626,440,1720,1623,1238,925,57,1442;45;F
61082;567,1381,170,339,1016,1163,1199,193,1720,1238,544,1666;35;M
61094;250,221,1238,544,109,963,1075,531,321,57,1236,1153,1720,335,1666;42;F
61096;109,422,1199,539,660,739,650,260,1381,868,1623,274,925,461,1442;33;F
61108;260,1442,539,127,1016,1240,1550,925,1628,422,109,963,1075,286,1236;2;M
61117;221,544,700;39;F
61140;739,440,539,1041,274,250,221,286,1236,660,1628;52;F
61183;1199,260,553,539,337,1720,780,1240,1550,1628,109,1236;42;F
61195;339,539,1623,57,650,1221,660,567,193,119,1238,544,909;39;F
61200;1075,109,260;84;F
61202;339,1214,1149,1221,1442,442,1041,1414,1016,250,1240,1238,1628,1666;46;M
61208;650,660,440,539,1720,274,250;33;M
61211;780,1238,335,422,109,180,650,55,1217,739,626,553,274,434,57;42;F
61218;1199,539,573,553,1442,169,626,739,339,1214,1221,567,909,286,57;42;F
61231;739,1221,626,660,553,1623,780,1016,221,925,544,459,286,57,1442;8;F
61254;119,650,553,925,286,57,440,660,1720,1217,1214,739,1221,539,567;39;M
61270;1149,446,442,1628,544,97,1153;69;F
61275;780,1623,1234,446,739,1149,339,260,1238,1163,544,109,1075,97,1153;45;F
61276;440,193,1628,544,97,700;47;M
61282;650,260,1234,780,250,335,1628,459,1075,1699,1666;34;F
61309;1550,1628,286,57,1666,1720,539,674,244,1217,1623,1016,544,109,1236;32;F
61326;260,1041,897,925,335,422,434;44;F
61339;339,925,544,422,57,1214,1442;11;F
61347;925,1628,531,650,739,260,1442,337,250,1238,109,1075,286,1699,1666;54;F
61354;660,440,193,1623,780,286,1236,1199,1720,1016,1240,1550,1238;39;F
61400;434,1381,567,573,739,446,539,1199,868,119,1720,1238,1288,335,544;22;F
61418;335,1075,109,868,1163,1550,700,119,544,897,422,894;39;M
61420;339,442,119,1414,1238,335,544,109,459,1075,97,1666,1153;69;F
61426;633,739,539,127,1720,274,221,1628,544,909,286,700,531,660,440;40;F
61429;780,1720,539,739,660,567,337,1041,1623,221,422,459,909,286,434;42;F
61433;1623,127,1628,626,1720,442,909,897,567,221,1149,1153,446,544,97;39;F
61434;260,1199,868,339,739,1381,1720,1623,925;46;F
61454;170,660,442,539,193,1240,221,286,1666,1550,1720;64;F
61465;660,1720,1623,780;59;F
61487;739,1238,1163,422,700,339,193,127,119,1720,677,1041,1240,544,154;43;F
61512;1623,660,1720,1240,221,1550,286;44;M
61513;1623,221,897,1550,1163,286,321,674,700,544;29;F
61517;1238,925,221,274,260,193,170,127,109;25;F
61557;539,567,1720,1623,780,1016,274,1550,154,531,1217,626,1240,221,286;29;F
61566;700,1153,633,440,1093,1720,1623,221,1550,1238,1628,422,286,1666,660;39;F
61571;1666;75;F
61585;1075,154,335,193,1199,674,1720,1623,1550,894,531,260,633,650,626;34;M
61588;650,539,1236,633,739,244,1016,1240,963;52;F
61598;440,1442,1217,739,660,553,442,868,1720,925,335,109,461,180,1666;71;M
61611;339,1199,193,127,780,925,422,1153;37;F
61632;1238,544,286,1666,739,660,1720;44;M
61640;1666;58;F
61643;1214,1217,109,1221,567,909;55;F
61648;700,260,446,674,544,97,1153;44;F
61651;442,119,925,544,109,321,339,337,1720,1414,1623,221,1238,286,1666;48;F
61678;567,897,925,109,909,286;38;M
61683;446;43;F
61694;446;44;F
61700;925,1628,544,700;28;F
61752;539,553,660,674,260,446,1381,221,925,544,109,286,531,700,1666;44;F
61758;739,260,1442,660,539,1016,1240,109,1236,1217,244,440,780,1628,422;41;M
61769;660,1623,544;57;F
61786;446,119,1238;55;F
61793;925,1628,286,321;49;F
61811;335,434;39;M
61823;1623,1016,221,1628,422,286,1236;26;M
61835;739,221,925,260,442,119,337,1720,1414,1238,544,286,97,321,1666;51;M
61851;180,660,539,567,1720,1221,1214,553,1623,925,1163,626,274;39;F
61852;109,963,286,1442,440,739,660,539,1016,1240,531,1236,780,1628,422;3;M
61863;440,677,1720,119,868,1381,1199,567,553,660,626,1221,685,739,1153;36;M
61866;626,1623,221,544,909,286,97,1153,446,442,567,127,1720,897,1628;74;F
61870;553,244,260,1442,1199,1234,868,119,1720,1623,250,1163,422,109,1236;41;F
61882;119,626;26;F
61910;1414,1623,221,335,286,531,1214,868,1016,1238,422,109,1075,180,1666;43;F
61929;260,739,1217,1214,1221,1442,553,1234,1016,1238,422,180,909,286,434;40;F
61936;446,674,442,1199,1623,780,1550,1238,1628,544,97,700;46;F
61950;339,442,1199,544,1666;59;F
61953;339,685,925,221,1720,660,442,260,1199,119,1238,1075,286,894,1666;68;F
61957;544,739,633,660,440,539,1720,677,1623,1016,1240,221,1550,286,1236;56;M
61989;446,339,1550,1238,1628,1666,1153;53;F
62021;567,1442,260,193,434;37;M
62041;1236,274,1720,1381,739,660,539,193,1623,221,1550,544,286,531;21;F
62047;650,1217,339,1214,1221,169,780,1163,109,1666,868,442,567,909,1093;34;F
62048;539,544,154,531,57,1236,170,739,169,660,440,1720,221,1550,286;39;M
62058;442,193,109,1075,1666,260,1238,1623,221,1163,321,660,1016,1240,1236;33;M
62061;633,739,1163,193,244,1623,1236,1240,1016;35;M
62063;1041,1720,868,1381,660,260,739,1214,1217,221,1238,286,1199,780,109;41;M
62069;739,1214,633,660,1623,1016,1240,1550,1238,544,459,286,531,1236;31;M
62073;1016,250,1550,1238,925,1628,335,544,422,180,700,1666;18;F
62074;440,539,193,1720,677,274,250,221,925,544,180,286,531,97,1153;33;F
62076;633,339,739,660,539,1720,1623,1016,1240,221,1550,1238,1153;51;F
62078;739,660,440,539,1199,868,1623,1016,1550,1238,1628,544,109,286,1236;26;M
62091;567,1720,677,1016,1240,221,1238,459,963,1075,286,894,57,1666,1236;29;F
62115;1381,868,1699,1623,250,1236,339,1199,1093,1720,1414,1240,1238,1288,925;33;F
62141;544,193,674,446,739,1149,97,700,1153;38;M
62145;1236,446,1217,1720,674,440,539,221,1149,1221,1550,544,286,434,97;31;F
62148;446,1149,1490,339,337,250,1238,925,335,544,109,286,97,700,1666;18;M
62184;1720,677,1016,1288,1628,531,1149,660,337,780,1240,109,286,1490,1238;42;F
62188;1238,1414,573,440;33;F
62193;286,1720,127,739,650,660,440,1623,339,1238,1163,335,544,1153,97;34;M
62200;221,1550,1238,925,1628,286,1199,539,260,739,626,660,1093,1720,544;27;F
62215;539,650,660,1623,897,221,544,286,531;27;F
62217;1666,1234,1623,1016,739,1490,1442,567,780,573,1238,1236,1720,1163,169;41;F
62224;539,660,626,1149,633,1217,650,780,544,180,286,57,1236,1240;27;M
62227;660,244,633,1016,1623,539,442,339,739,193,1240,286,1236;26;F
62230;119,446,442,1720,544,1666;54;F
62236;1442;32;M
62251;244,440,442,539,1199,1720,780,1016,274,1240,221,1238,459,531,57;25;F
62261;739,440,221,286,97;33;M
62275;1236,169,440,539,1720,1199,127,119,221,1550,1238,1628,544,109,286;45;F
62276;1149,1381,1720,925,1628,544,109,286,97;32;M
62281;674,97,700;42;F
62299;539,780,221,1628,459,531,57,633,739,1720,1623,1016,1240,1550,1236;29;F
62305;1217,660,1199,1041,909,286,531,57,739,440,221;41;F
62370;1163,1628,459,461,286,434,1720,442,440,660,169,626,739,1217,1666;39;F
62373;633,1217,339,660,221,739,1490,169,1550,1238,1163,1623,127,1720,894;33;M
62384;170,127,1623,780,221,1628,459,286,57;64;M
62385;446,674,868,1163,544,97,700,1153;61;F
62393;461;14;M
62405;739,660,440,539,1199,1623,1016,1240,1550,544,633,1720,677,1238,1236;45;F
62412;650,339,739,1199,1234,1093,868,119,337,1720,1414,1623,780,221,1238;28;F
62422;660,442,539,1199,127,119,221,626,544,286,1550,739,1623,1628,169;28;F
62440;422,544,925,1288,1550,221,780,650,1238,739,894,1623,1720,127,660;53;F
62443;446,339,260,674,337,221,1238,925,335,544,422,109,286,97,700;44;M
62467;461;45;M
62477;422,286,894,97,1666,170,739,539,1199,1720,1016,1240,221,1550,1238;66;F
62491;739,440,660,1199,193,1381,1234,1720,1041,1240,897,1238,221,286,434;35;F
62493;442,446,544;63;F
62514;170,650,685,55,1442,660,440,539,1199,1623,221,1628,422,909,286;25;M
62515;739,1490,339,780,335,544,531,170,573,1199,868,221,1550,925,286;36;F
62520;170,260,660,274,1550,544,109,286;44;F
62523;1149,1163,97,1153;51;F
62526;1016,1240,1238,1163,1236;31;M
62559;1221,1628,1163,925,780,1720,337,868,1381,674,1149,1490,1238,544,1153;38;F
62573;1442,868,1016,1238,1288,925,335,422,286;42;F
62578;739,260,1234,1628,109;26;M
62580;553,1217,335,1238,1623,539,260,244,650,739,1016,1240,1550,1236;32;F
62582;1217,244,660,567,1550,1075,909,1720,1163,1628,1199,193,1016,1238,1236;33;F
62586;660,539,633,1720,274,1240,221,1550,1238,925,1628,544,422,286,894;65;F
62604;119,573,660,260,446,1149,339,685,1238,109;79;F
62605;446,544;74;M
62615;739,660,780,1016,221,459,286,57;33;M
62625;446;42;F
62626;442,1720,1550,1238,544,894,221;40;M
62667;109,544,180,531,434,1153,440,868,119,337,1720,1238,422,286,97;38;F
62668;1623,1016,1240,422,459,963,434,57,1153,685,677,221,925,286;47;F
62673;55,739,1163,1628,700,674,544,626,1153,250;59;M
62682;109,170,169,127,868,1623,1550,1238,459,286,57;37;F
62698;250;46;M
62712;660,119,780,221,1628,422,286,531,57;51;M
62715;442,1199,1234,1093,119,1623,221,1550,1288,544,109,286,531,434,1666;67;F
62723;1217,180,434,925,274,446,459,553,422,193,57,868,1075,1221,1214;38;F
62744;660,260,739,539,1199,127,119,780,1163,459,1623,1550,544,286,221;34;F
62754;1236,739,626,169,440,539,1720,250,1240,221,544,909,286,531,321;42;F
62762;250;61;F
62765;739,244,260,1234,337,1623,1016,1240,109;13;M
62826;1240,1550,459,1699,739,1214,633,650,244,780,1016,250,963,1236;35;M
62843;1217,339,1490,446,434,739,674,1199,1381,1093,1720,1623,1238,925,1628;21;F
62852;674,1720;28;M
62869;337,1720,677,1550,335,544,1075,700,260,868,221,925,109,286,321;39;F
62870;1199,193,1623,180,660,553,539,1234,1720,780,1238,925,109,57,260;52;F
62891;868,193,553,660,1720,544;59;F
62903;739,539,1199,193,1093,1720,221,250,1240,531;40;F
62928;109,894,97,1153,1149,1163,544,674,700;14;F
62944;57,339,1149,650,674,660,440,1381,1234,1623,780,221,1238,1628,700;23;F
62949;660,440,539,193,127,1720,1623,250,221,1238,925,1163,544,909,286;25;F
62956;422,925,677,260,685,170,633,1623,274,739,868,1016,1240,1550,1238;35;M
62960;739,1623,244,1240,1016,260,1234,109;45;M
62967;1075,1163,739,660,567,539,193,868,337,1240,286,1623,221,1238,335;18;M
62971;170,1550,260,1442,1199,193,1720,1414,1163,109,461,1075,894,1666,1236;70;F
62974;1442,539;44;F
63034;1623,780,1016,1550,1238,1163,963,434,1041,339,1199,1240,897,925,154;46;F
63049;685,633,660,739,127,1016,154,963,286,321,1236;37;M
63062;335,321,286,434,1236,909,660,1214,339,442,539,1720,221,1550,700;26;F
63063;286,1414,780,1623,170,169,127,868,1720,1550,1238,925,1163,109,894;5;F
63082;1442,193,1153;51;F
63085;193;53;M
63088;1199,780,1016,1240,1550;36;M
63091;1442;63;M
63092;1623,1016,274,250,221,925,544,459,461,963,909,286,1153,97,1699;90;F
63095;963,250,1016,1236,1041,780,650,739,1699,459,1550,633,1214,244,1240;33;F
63097;660,868,119,337,1720,1016,1240,335,1075,286,531,1236,539,1238,109;45;F
63127;193,337,1234,1720,1414,1623,1240,221,1238,925,1163,544,109,461,286;16;F
63139;739,440,539,1720,1041,1623,1238,925,286,894,434,1666,567,221,909;35;F
63146;633,339,739,244,260,440,442,539,1199,1720,780,1240,1550,1238,1442;37;F
63163;674,544,109,1075,446;48;F
63169;1442;59;F
63181;1666;67;F
63186;1720,250,1550,531,97,321,700,1153,660,169,739,274,221,544,286;32;M
63190;422,180;8;M
63193;193,1163,1550,339,446,674,440,573,119,1720,1628,544,286,700,1153;40;F
63285;274,553,1720,1623,1381,1217,650,440,221,180,127,1414,1238,1041,154;28;F
63286;674,650,1381,1720,274,1550,1238,925,1163,544,909,700,57,1217,1628;32;F
63289;1214,739,1221,626,660,553,440,1720,1623,1016,925,544,109,57,1442;45;M
63306;700,57,97,780,446,337,925,1628,286;49;M
63324;1236,1153;46;F
63330;1550,1016,674,660,1221,739,1623,440,539,1720,221,1628,459,286,57;44;F
63353;1240,274,1414,739,660,442,539,1199,1234,1623,780,1016,221,1238,286;39;F
63363;633,677,1720,539,660,739,1217,1199,221,1238,335;31;F
63365;650,1217,260,626,660,539,1041,1623,274,897,1238,1628,154,909,434;30;F
63380;446,119,337,1414,221,1238,335,1075,909,286,1666,260,442,1628,544;38;M
63414;567,868,119,1041,1016,897,1238,925,909,286,434,57;38;F
63422;1720,442,1217,626,553,440,539,1199,193,1041,1414,1238,461,180,321;48;F
63471;221,660,1720,1163,544,286,1236,677,1199,1016,1623,244,1240,739,633;37;M
63474;1149,446,544,97,1153;42;F
63482;531,1153,1149,446,260,674,1550,1163,109,286,321,700,544,97,1628;42;F
63503;250,544,459,244,553,626,1214,650,1199,1699,154,1550,127,1381,169;31;M
63508;1720,1163,531,1666;42;M
63535;909,1666,650,553,677,1550,544,422,1075,1720,1234,260,1414,109,180;74;M
63544;674,544,97,700,339,446;37;F
63563;685,442,553,1442,446;69;F
63599;446,660,1623,1163,1628,1666;69;M
63601;700,335,868,1199,446;39;F
63605;339,335,286;37;F
63620;221,442,660,626,339,1217,650,422,180;60;F
63648;674,1550,780,1238,1628,544,97,57,1153,700;44;M
63664;739,1221,660,897,221,422,109,180,286,57,909,1699,553,539,567;36;F
63685;446,1381,440,539,868,337,1623,221,1238,925,544,286,97,700,1153;43;M
63706;685,739,260,660,440,221,1238,335,894,97,57;45;M
63711;650,925,1628,544,459,1075,909,1666,339,567,1199,119,1720,897,1238;30;F
63713;1149,339,1217,1199,780,221,459,286,57,446,1288,1628,544;44;F
63718;780,1623,567,553,260,1221,739,1149,1214,1234,274,925,909,97,57;32;M
63725;660,868,1623,221,335,422,909,286,894,1699;39;F
63729;650,339,660,1720,1238,1628,97,1666;19;F
63740;339,739,260,539,193,1234,780,1016,1240,1550,1163,1628,109,461,1236;47;F
63748;286,1623,221,544,1149,97,1153;42;M
63770;339,1217,440,1199,119,274,1240,897,1628,909,434,1666,544,422,180;74;M
63778;119,1093,868,567,442,440,660,1490,339,260,1381,1238,335,109,1075;30;F
63789;1153,97,221,446;44;F
63797;321,127,169,422,1550,1238,1381,446,544,1623,1720,339,335,1666,221;40;F
63822;440,660,1016,286,1623,739,539,677,1240,221,154;37;M
63823;1238;29;F
63833;674,260,739,446,1720,286,544;39;F
63848;544;39;M
63851;739,868,337,1720,539,440,660,1623,221,1238,544,286;60;F
63902;221,1149,1153,97,286,544,1720,1234,1199,539,660,626,260,446,739;42;F
63904;1628,459,461,531,57,339,739,1442,193,1016,1240,221,109,286,1236;18;M
63914;446,221,97,1153;43;M
63970;440,539,193,1234,780,1016,1240,221,1550,1163,1628,109,286,57,1236;17;M
63974;170,339,739,660,440,539,1199,1623,1240,221,1550,1238,109,459,286;32;F
63980;446;42;F
64025;1550,1240,119,1288,925,286,1666,1236,650,633,127,677,1041,1623,1016;66;M
64043;1623,780,274,221,1288,1628,544,57,1666,260,674,442,1153,97,700;73;F
64049;739,1221,539,660,1623,780,221,925,1163,1628,335,544,422,1075,1666;41;F
64076;1093,335,1075,1666,1153,1490,446,674,868,1238,544,109,286,894,700;39;F
64097;739,544,1149,440,1623,97,1153;25;F
64104;1236,925,868,260;59;F
64126;1623,260,169,442,127,119,1628,544,109,461,286,531,321,1666;77;F
64127;1221,739,339,442,539,567,1199,868,1217,1214,119,337,1720,1623,1238;38;M
64140;1234,1666,1153,339,446,260,337,1720,1414,1238,544,109,1075,97,700;40;F
64181;422,544,286,674,700,909,1041,434,925,567;42;M
64187;650,1217,260,1199,1720,1041,1623,221,1238,1163,109,180,286,531,1699;59;F
64189;685,739,244,660,539,1041,250,221,1550,1238,531,1699;9;M
64200;337,221,1163,335,1720,544,446;38;M
64214;739,1075,1199,1720,1623,286,57,626,1381,1217,180,553,193,422,459;20;M
64221;1442;40;M
64255;685,1221,339,55,446,674,660,221,1550,925,154,909,57,700,544;34;M
64269;109,1240,539,739,244,660,1199,1623,1550,1238,1236;51;F
64280;539,1623,925,1153,1234,1149,446,260,868,1720,1238,544,109,1075,97;46;M
64281;260,1075,677,685;40;M
64306;442,339,170,650,1442,660,440,567,780,925;53;F
64309;1442;15;F
64321;1238,459,57,180,1153;47;F
64328;650,1217,739,1240,1550,544,1236,193,1381,1720,1623,1016,897,925,1163;28;F
64331;894,1666,339,260,442,567,1199,1720,1041,1623,1240,897,1238,925,434;41;F
64337;650,170,1217,169,567,1041,780,274,1628,422,434;33;M
64349;700,1149,1153;22;M
64362;339,633,170,55,739,169,660,440,539,1623,221,1238,286,1236,1240;33;F
64371;1442;12;F
64373;897,193,440,660,1490,260,1199,868,544,109,1075,286,700,1720,1238;32;F
64374;1221,1217,626,286,1699,539,567,193,250,544,909,1623,274,1550,221;30;F
64407;544,250,553,1490,897,1550,1628,1699,650,193,1720,677,1414,1163,1238;29;M
64412;221,459,286,57,1666,109,1075,894,1699,119,250,260,650,274,925;52;F
64426;260,660,553,442,1238,544,434,286,109,221,1240,169,339,567,909;49;F
64430;660,440,539,221,286,567,193;50;M
64432;1699,1236,1381,442,169,626,650,660,868,1041,1623,221,925,57,1153;33;F
64448;567,1199,193,1381,1093,868,119,1720,1414,1238,335,109,1075,97,1666;26;F
64470;1221,260,553,567,1199,1381,1720,1414,1623,1238,925,335,109,1075,909;33;F
64482;544,700,260;38;F
64515;909,109,1199,567,442,440,553,660,650,685,539,193,250,897,925;38;F
64543;544,1628,1238,250,739,440,1720,221,286;31;M
64558;539,660,260,1217,650,1720,1623,897,221,1238,925,1628,109,180,909;29;M
64562;1163,109,1666,1236,650,553,1075,422,633,221,531,57,780;29;F
64572;539,1199,119,1720,1623,1016,1240,221,1550,925,544,461,286,57,1236;54;F
64588;244,633,739,660,539,1199,1720,1623,1016,1240,1550,1163,286,894,1236;44;F
64615;1720,337,1217,170,55,260,626,1199,109,1666;41;F
64616;1666,446;41;M
64617;626,339,1720,544,109,1075,909,1666;45;M
64639;925,544,531,434,633,1217,739,660,539,567,897,221,1238,286,894;41;M
64660;739,169,539,909,660,440,567,897,221,544,286;30;F
64663;169;43;F
64670;1720,286,894,544,1238,221,1666;59;M
64677;544;34;M
64679;553,422,180;34;F
64682;169,1238,335,544,422,286,1628,739,1221,674,660,553,193,274,925;40;F
64708;739,626,1442,553,1199,1381,1093,119,337,1720,780,1238,1288,925,422;50;F
64727;1238,1623,1381,626,685,739,1720,221,1149,286,1153,1628,544,700,674;37;F
64728;868,739,1221,674,660,553,193,274,1238,925,1628,335,544,422,286;36;M
64733;286,544,1628,221,1623,1720,1381,539,440,553,660,674,1221,739,1217;61;F
64738;1149,1628,1153,446,674,97,700,544;48;M
64744;909,57,1666,739,440,193,1381,1720,1550,925,544,109,461,286,700;26;F
64746;650,660,119,1623,780,963,286,274,434,1720,1041,567,897,909,925;34;M
64780;739,674,868,1623,221,1238,286,97;38;F
64783;422,180;35;M
64786;674,442,1199,1720,221,544,1153,700;21;F
64793;674,446;36;M
64811;422,180;6;M
64830;553,868,109,422,180;4;F
64834;339,1214,1149,1221,119,567,1414,897;31;F
64859;442,567,1234,119,1041,221,909,286,434;45;F
64863;739,1442,660,539,1199,119,1414,1623,221,1238,1288,925,459,1075,286;14;F
64872;1490,739,674,1442,677,1720,1628,780,1240,221,1550,1238,109,286,531;34;F
64941;925,335,422,109,459,1075,909,286,894,531,97,700,260,544,57;42;F
64960;1236;25;M
64962;1699,1720,650;65;M
64974;1720,1628,1550,739,660,539,1623,221,1163,286;26;F
64981;55,1221,193,274,1163;31;M
64985;1666,1623,1414,1720,1199,573,442,660,260,244,739,1214,339,633,286;35;F
64997;685;10;M
65016;633,170,685,55,553,660,739,1217,650,674,221,1628,544,286,700;35;M
65026;1199,119,1238,109,1217,739,660,539,1720,1623,221,1628,544,286,1666;63;M
65054;780,1238,925,109,57,1699,119,337,339,650,55,1217,260,1442,1414;52;F
65096;55,1217,739,1199,573,1381,119,1720,221,1550,544,1075,180,909,286;40;F
65107;1699,1217,739,260,169,660,539,567,1234,897,221,1238,109,909,286;31;F
65111;442,868,119,337,1238,1628,544,109,1075,286,531,57,700,1666;60;F
65136;1550,1075,553,1199,1217,180,925,660,1381,868,1414,1623,221,1442,1720;54;M
65140;1381,1234,1720,1623,127,567,169,260,339,897,1550,1238,925,109,894;30;F
65141;1666,739,339,1199,868,1720,1623,1238,544;19;F
65202;260,170,55,739,244,660,539,1199,677,1623,1016,1240,544,109,286;35;F
65247;894,531,1381,1199,446,1720,925,260,660,119,1238,335,544,109,97;33;F
65267;633,553,1199,193,1720,1623,1016,1240,221,109;35;M
65275;1628,700,339,739,660,539,119,1720,780,221,925,544,286,531,57;26;F
65276;260,868,1238,925,97,1666;42;F
65278;650,739,553,539,193,221,1163,422,461,180,286,434;33;F
65346;1149,739,1442,1238,286,531,1623,780;23;M
65377;626,169,674,442,127,1093,119,1720,1414,1623,221,894,1236,459,321;58;F
65386;739,539,1199,1720,1623,780,250,1240,221,1238,1628,1163,461,286,531;37;F
65413;780,221,1238,1288,925,1628,544,422,154,109,459,1075,286,531,57;29;M
65423;739,169,539,1199,127,1234,1720,780,1240,221,1550,1238,925,1163,1628;39;F
65425;55,1623,1550,660,260;65;M
65452;1381,1234,868,1720,221,1238,544,109,459,286,531,97,57,700,1153;35;F
65482;337,221,925,422,109,97,700,446,674,544;38;F
65489;274,250,925,422,459,909;25;F
65495;553,539,274,109,1075,909,286,193,1720,544,97,1153;32;F
65506;909,567;47;M
65535;446,544;42;F
65545;446,1199,119,1720,221,544,286,97,1153;29;F
65553;1153,700,544,1628,1623,1720,1149;33;M
65562;897,193,567,539,553,169,739,650,1217,660,1623,780,274,1240,1628;31;F
65571;1153,1699,180,544,221,337,553,660,1217,650,739,440,539,250,1550;49;M
65573;626,674,660,539,567,193,868,780,221,544,286,260,553,1628,109;35;F
65595;925,544,422,531,700,1236,739,244,1720,780,1240,1163,1628,1075,286;30;F
65610;260,55,170,169,1199,780,1550,925,1628,422,459,180,286,894,57;37;F
65623;868,119,337,1720,1414,274,1238,925,1628,335,422,154,894,531,97;49;F
65630;1623,780;40;M
65671;650,567,897;49;M
65677;442,1236,894,544,1163,274,1623,1720,119,868,660,169,127,1550;47;F
65679;897,221,1238,925,422,109,459,963,1075,909,286,434,57,1699,1236;34;F
65698;567,127,1238,109,97,553,660,739,1217,626,1720,1623,780,1628,286;41;M
65743;1016,925,459,685,109,286,57;39;F
65760;250,274,1414,1041,567,897,909;31;M
65770;221,1238,339,1199,1381,1093,1720,1414,1240,1550,925,1163,1075,286,1666;33;F
65784;260,1221,739,660,539,1720,1623,221,1238,925,286,531,321;30;F
65818;567,1550,868,780,1628,1666,127,1234,260,539,1623,221,544,109,700;64;M
65840;739,440,335,544,539,780,221,1550;41;M
65841;685,650,1199,1720,677,1623,780,1016,274,1240,221,925,422,286,1236;9;F
65844;660,739,553,1720,1238,544,286;62;M
65848;544,1236,1442,626,739,660,868,1720,1623,1016,221,1238,1628,109,286;35;M
65866;1442;35;M
65884;446;42;M
65897;221,1238,925,109,57,1666,1550,1623,170,1414,127,169,1163,894,286;2;F
65905;1199,434,1236,55,1217,1214,739,1221,539,567,1720,1623,274,180,909;39;F
65909;660,868,337,260,109,1093,1720,1550,1238,1163,335,286,894,321,1666;43;M
65923;422,739,260,440,539,1720,1041,1623,274,897,1238,925,335,109,434;60;F
65950;221,1240,868,1234,193,170,739,169,660,539,1720,1623,1550,1163,544;50;F
66002;739,260,1199,1720,1628,674,442,1234,119,925,544,109,1153,700,1666;64;F
66019;739,650,1163,544,422,660,539,127,1720,250,221,1628,286,894,1699;43;M
66041;1236,531,97,57,626,1016,250,1240,1550,1238,1628,544,963,1153;35;M
66044;1490,1217,626,660,553,442,573,193,1381,868,119,1720,1238,422,180;44;F
66061;739,244,1623,1016,1240,221,1163,461,1236;48;F
66068;339,660,553,440,539,868,337,1720,1623,221,1238,1628,544,422,286;39;F
66075;260,660,127,868,1238,925,286;39;F
66135;1149,446,260,674,660,553,193,1720,1623,221,1238,925,1628,544,97;35;F
66156;97,286,544,221,1214,626,674,780,422,459,57,1628;28;M
66172;544,446,1153,1149,97;37;F
66185;544,286,531,109,221,660,260,446,674,925,1628,1075,97,700,1153;34;F
66205;539,1199,1381,868,897,422,109,894,335,57,1699,650,1720,274,925;39;F
66208;109,1234,260,868,674,700,925,544,422,97;47;M
66245;1217,539,193,1381,1093,1720,1623,1550,925,1628,544,909,97,1236,1153;22;F
66246;446,674,1238,544;48;M
66247;274,221,925,909,286,1217,1214,1221,567,1093,868,1623,1238,109,1075;31;F
66257;633,739,674,868,1240,221,1550,1238,925,1628,544,422,286,97,700;27;F
66282;1550,1236,1153,440,221,909,286,739,626,660,539,567,1623,897,1628;31;M
66290;1720,434,925;49;F
66296;1214,1217,909,260,553,567,1199,337,1238,1288,335,544,109,1075,180;53;M
66298;1240,221,925,1699,700,1153,1414,1550,119,674,339,1238,1628,544,97;49;F
66305;660,925,335,909,868;29;F
66365;1623,780,1240,221,1550,1238,925,1628,335,459,286,57,1236,1720,1199;41;F
66382;440,739,169,674,660,539,119,1623,221,1550,1238,544,321,286,1414;15;M
66416;321,55,650,739,660,539,127,1041,1623,1238,154,286,1217,626,567;38;F
66419;1623;21;M
66429;260,573,1199,119,337,1720,1414;32;F
66456;531;70;M
66461;531;71;F
66474;1149,573,1199,119,925,1628,544,422,1153;52;F
66506;442,1623,221,154;44;M
66510;442,868,119,1238,1628,544,422,1666;42;F
66547;442,1199,193,868,337,1720,897,221,1238,335,109,1075,909,434,1666;37;F
66567;1217,739,660,567,1199,1720,1623,780,274,221,1550,909,286,1163,193;50;F
66569;193,544,909,1623,221,674,700,1153,1720,1628,440;38;M
66580;1240,221,286,567,1041,1623,780,897,1238,1288,925,1628,422,909,434;30;F
66602;573,1238,539,1214,119,868,1075,442,434,1720,925,1041,909,897,567;39;M
66634;739,440,1199,1623,780,221,909,57,1217,1221,442,539,567,1720,286;67;F
66674;660,650,260,1199,1720,925,1628,422,739,567,1041,274,897,909,434;50;F
66714;274,434,897,909,567,1153;37;M
66726;337,1041,274,250,221,1238,925,422,109,909,286,57,567,897,434;43;F
66803;446,244,1217,633,685,739,660,440,539,1720,1623,221,1238,544,286;33;F
66809;1214,446,434,97,57,1666;36;F
66814;925,1628,335,97,57,1666,739,567,1199,780,221,1238,544,459,286;54;F
66820;446,626,660,440,1623,221,1153,1149,674,1720,1550,1628,544,97,700;36;F
66831;739,440,1720,286,531,221;51;M
66832;221,544,109,286,97,446;40;M
66837;739,244,660,539,567,1720,677,1623,780,1016,1240,1238,286,894,1236;41;F
66845;1214,446,674,553,127,221,1550,544,1075,321,57,700,335;41;F
66878;119,868,573,1149,170,739,446,674,660,539,1550,544,286,337,335;39;M
66889;193,422,180;40;M
66902;739,1149,446,626,1442,660,868,677,1016,1240,221,1238,335,544,286;47;M
66948;422,180;9;F
66963;1238,1414,1199,573,1490,442,1234,868,119,1623,780,925,335,109,1666;45;F
66970;1093,1381,221,925,286,97,700,1666,260,442,1720,1075,1163,1238,544;52;F
66990;274,1628,459,286,650,1217,739,260,626,553,539,1550,925,422,109;42;M
67001;97,700,1153,1149,55,260,553,1720,1414,1238,544,1381,1628,109,1075;38;F
67016;894,1628,1288,1550,221,1016,677,119,1093,1381,339,1236,170,1199,1720;54;F
67043;1442;56;M
67047;660,440,260;46;M
67050;739,169,660,539,127,1720,677,1623,1240,221,1550,544,286,894,1236;35;M
67088;1016,1240;33;F
67147;650,1217,260,1199,1720,221,109,1075,286;65;F
67188;170,339,739,660,193,1093,1720,1628,544,109,531,700;65;F
67212;1236,434,180,286,1221,660,567,274,221,1240,1550,1238,1628,544,909;28;M
67216;119,1214,553,442,193,1381,780,1016,1238,544,422,459,180,57,1666;62;F
67223;868,119,1720,1623,250,109,1075,286,57,1699,1236,1666,660,260,1238;38;M
67254;539,567,193,780,250,1163,650,1217,260,868,925,1628,422,109,286;45;M
67300;925,180,422;57;M
67303;286,422,1623,1720,626,633,260,674,442,544;65;M
67313;1234,1238,335,109,422,909,894,97,57,1075,539,567,1217,193,1093;30;F
67327;119,193,1199,539,339,55,170,739,660,440,221,1550,1238,925,286;25;F
67333;1240,274,780,1623,440,193,531,286,544,660,626,739,539,1199,1442;43;M
67343;660,440,539,1381,868,1720,1623,221,1238,1163,1628,286,531,446,544;44;F
67373;170,868,1720,221,1238,739,286,1550,897,1199,440,660,539,127,169;34;F
67406;422,553,180;39;F
67411;221,274,780,539,633,739,1442,567,127,1720,1623,1016,250,1240,1628;19;M
67415;677,180,650,440,539,868,1623,274,250,221,1238,925,422,286,531;42;F
67421;1381,1720,1041,1240,1550,1238,925,422,963,1075;40;M
67426;260,539,567,193,1381,780,1240,925,544,109,909,286;28;M
67451;1442;36;M
67458;539,109,531,1623,221,1666,1075,544,1163,1238,1720,1381,193,442,260;52;M
67465;544,909,567,446,739,660,1075,286;36;M
67472;739,1288,1199,119,221,1238,286,531;42;F
67477;1075,286,434,57,446,1149,1217,633,339,442,1199,1381,1720,1238,1666;26;F
67480;169,539,274,963,1236,1623,440,1240,677,1217,739,897,567,1238,909;42;F
67490;626,539,440,1442,446,339,685,553,1720,1238,1628,335,109,909,1075;38;F
67497;700,1149,674,1381;32;M
67557;109,544;27;F
67568;170,440,221,1550,335,544,286,531,321;42;F
67580;244,1149,339,1217,633,170,739,660,193,1623,221,925,544,286,97;22;F
67583;1666;41;M
67588;1666;39;M
67597;539,440,1149,1221,660,119,1041,1623,544;29;M
67619;1217,626,1381,119,677,1041,1550,1153,1699,894,1199,1720,1623,1016,1240;31;F
67635;1666;66;F
67661;1666;41;F
67665;677,1236,1666,1238,1550,1240,1016,780,1199,553,660,1442,244,739,633;44;M
67711;925,434;34;F
67727;1217,909,1214,1221,57,180,422;36;F
67764;660,442,1093,1720,677,1240,221,286;60;F
67783;1236,1666,286,544,221,780,1623,119,868,1199,539,660,674,446,170;36;M
67788;1238,925,434;34;M
67796;260,739,1490,339,1199,274,221,1628,1236,650,1720,1041,1623,1238,1699;27;F
67799;1240,739,868,119,109,963,422,544,1016,1199,1442,260,685,1236;37;F
67854;1041,1238,925,434;12;F
67873;97,1238,1550,337,567,553,739,868,119,274,925,1628,544,109,434;42;F
67880;909,1217,1214,1221,57,180,422;7;M
67886;1623,1238,553,909,1720;36;F
67900;553,739,1623,544;58;M
67908;440,660,539,1720,1623,780,274,221,1628,459,286,531,321,57,1236;40;F
67909;1221,260,626,660,553,539,868,780,925,422,109,461,1075,180,286;36;F
67924;1217,909,1214,1221,57,180,422;3;F
67931;1381,274,544,422,109,909,700,57,97,1153,260,868,1720,1628,1075;41;M
67955;260,739,1149,446,674,553,1381,868,925,1628,544,1075,97,700,1153;11;F
67957;440,553,660,674,260,446,1149,633,170,221,1238,544,97,700,1153;51;F
67990;339,650,1217,660,553,440,539,1234,1720,1623,274,1240,221,1550,286;37;F
68018;1442,1199,337,1623,1238,925,1236;43;F
68039;169;56;F
68053;685,1217,660,539,868,1720,1016,274,1240,221,180,909,286,434,1236;60;F
68059;868,250,221,925,335,459,286,434;39;F
68101;442,260,1720,109,1075,1666;57;F
68110;685,739,260,1442,1199,868,119,1240,1016,925,544,422,109,963,1236;8;M
68130;677,739,539,567,1623,780,1016,274,250,925,1628,544,286,1236,650;45;M
68136;685,739,260,1442,1199,868,119,1016,1240,925,544,422,109,963,1236;6;M
68178;685,739,260,1442,1199,868,119,1016,1240,925,544,422,109,963,1236;3;M
68182;894,1093,339,1666,1442;37;F
68199;169,660,274,1240,459,531;36;M
68201;1623,780,1238,109,739,1221,260,1442,660,539,1016,221,544,286,1236;38;M
68202;739,1623,868,119,57,1238,909,1217,180,193,1720,553;30;F
68214;127,422,739,1442,660,539,442,909,286,1153,626,567,221,1238,1628;35;F
68218;339,868,119,633,739,660,440,539,1720,1623,221,1238,544,286,1236;17;M
68258;739,660,1720,1016,1240,1163,1236;38;M
68269;221,1016,1720,539,660,739;34;M
68296;1163,339,440,442,539,780,1238,1623,1550,660,1199,1720,221,286,531;34;F
68305;626,1217,440,567,1623;27;M
68354;674,739,660,440,539,1381,1041,1623,1240,221,925,286,531,57,700;17;F
68361;660,539,1720,925,286,434;39;F
68369;1623,274,894,337,1240,221,1238,544,422,109,286,531,925,335,321;40;F
68371;1442,1199,119,337,339,1238,925,335,544;49;F
68460;660,442,337,925,544,1628;39;F
68473;193,286,57,1153;55;F
68487;553,1623,544,180,739,55,440,539,1720,531,626,660,274,221,286;52;M
68507;685;75;F
68516;1234,193,1199,440,660,626,260,739,650,127,1623,780,1550,544,286;32;F
68517;539,1199,1623,1016,221,544,286,531,700,1236,660,169,739,1217,650;25;F
68518;567,1199,1234,1720,286,531,1153,339,1221,260,660,119,1288,1628,109;49;F
68528;97,446;9;F
68547;274,909,1628,1163,1550,1414,169,127;33;M
68557;446,97;14;M
68562;660,567,1199,1234,57,909,109,422,544,1628,1550,780,127,260,650;44;M
68573;1234,1093,221,544,286,97,1199,260,1238;41;F
68585;170,339,422,544,894,97,674,660,193,1628,700;49;F
68587;650;46;F
68601;1153,1666,286,1288,1238,1381,539,442,660,446,1490,339,1720,544,97;51;F
68607;553,1075,260,109,897,1628,544;39;M
68614;260,127,868,1041,1238,925,286,434,1153;41;F
68652;1442;50;F
68663;442,633,170,339,739,169,573,539,1199,1234,868,1550,1238,1163,286;50;F
68664;660,677,221,286,1628;33;M
68675;434,1666,442,1288,1217,739,660,440,1221,573,539,1199,1093,1720,780;32;F
68686;244,1623,1016,1240;58;M
68696;567,1623,780,925,544,274,221,422,180,57,193,553,868,1720,1238;30;M
68698;633,1075,894,434,97,1666,1236,1199,1720,780,1550,1238,925,1163,531;33;F
68701;446,97;43;F
68715;440,660,780,1016,286,250,539,1720,1623;55;F
68754;1623,1550,894,339,169,440,1199,127,1720,1240,1163,544,286,97,1236;63;F
68758;909,963,544,897,250,1720,539,440,553,660,1442,1217,739,119,925;28;F
68771;868,1041,897,1238,925,1163,422,57,1236,221,685;9;F
68779;339,674,1199,193,1381,1234,868,1628,335,544,422,97,700,1153;37;F
68793;55,339,193,337,897,221,1238,925,1163,422,109,963,894,434,1236;51;F
68839;1623,1550,925,1163,109,909,57,1214,660,1720,780,221,1238,1628,286;38;F
68849;674,539,337,1414,1016,1240,1550,1153,1236,925,1238,650,1149,1442,1199;46;F
68854;170,544,925,1238,119,193,446,1720,127,221,1550,1623,1163,169,286;34;M
68861;169,567,337,1041,897,1238,925,335,544,109,1075,180,909,286,434;41;F
68867;1720,1414,335,286,1163,1093,1199,660,274,1075,170,244,780,1016,633;39;F
68871;1236,446,544,674,1153,97,1720,1381,57;35;M
68889;1217,1221,539,57,567,909;40;M
68892;1442;14;F
68895;685,1234,119,1163,422,544;37;M
68919;1016,544,539,1240,286,739,650,127,1720,780,1550,909,57,660,626;33;M
68945;1217,626,660,553,539,567,193,1720,221,1238,544,459,531;40;F
68959;539,660,1221,446,739,1217,1214;47;F
68970;544,700;40;F
68981;1442;41;M
68982;739,660,539,1016,633,260,193,1720,1041,1623,780,221,1238,109,963;31;F
68996;1163,57,260,1720,1623,1240,1236;43;F
69011;700;6;M
69018;650,739,660,567,193,1041,1240,221,1288,925,1163,422,286,97,1236;38;M
69022;700;41;M
69070;685,1442,1699,650,780,274,250,221,97,925,434;40;M
69096;539,1720,925,434;57;F
69112;1720,1041,909,567;43;M
69116;1217,1214,260,442;68;F
69128;1217,626,1234,221,260,1075,109;76;F
69140;260,109,1075;67;M
69165;1623,286,1153;42;M
69185;539,1240,221,286,1236,1234,274,1720,925,154,1041,1623;35;F
69191;339,260,553,573,868,119,221,925,180,909,286;39;F
69200;169,1217,1149,739,446,660,539,567,1623,274,250,221,909,286,531;38;M
69242;539,127,1720,677,1623,1016,1240,1550,894,1236;71;F
69248;626,337,1720,339,539,677,780,1240,221,1163,1628,963,286,894,1666;26;M
69263;1217,1221,260,660,440,539,567,1199,193,1720,1623,221,1163,909,286;43;F
69290;531,286,1163,1240,677,539,440,674,739,660,1623,221,1550,544,321;67;F
69297;700,127,674,260,1149,1623,221,1550,1628,544,109,286,531,97,321;41;M
69323;739,260,660,539,1623,250,221,1163,109,531,1550,1238,544,286,1153;44;F
69374;553,567,193,119,1623,1238,1163,335,544,109,909;43;F
69378;626,567,1199,897,925,1628,422,909,700,1699;69;F
69411;739,1016,1240,1628,459,286,531,660,539,1199,1623,780,221,544,57;33;F
69415;1442,1381,422,109,544,1720,660,440,539,1623,221,1238,1163,286,321;38;M
69421;335,260,1720,925,894,321,660,169,1550,1238,1163,544,109,286,531;41;F
69422;97,674,119,1240,894,700,1236,1550,1666,1238,193,1199,442,553,109;48;F
69451;335,909,1234,539,440,739,660,1199,193,1414,1623,221,422,461,180;43;F
69481;539,909,544,1720,127,567,553,660,626,1221,739,260,1075,109,180;45;M
69492;109,1720,57,260,1217,553,193;43;M
69496;544,1153,700;51;M
69522;1041,1240,335,1075,1236,286,677,434,925,1720;44;M
69524;539,1199,193,660,260,739,1217,337,1720,1414,1623,335,422,109,180;49;M
69527;260,109,1075;47;F
69541;260,169,660,440,1720,221,1550,1163,335,544,109,1075,286,531,321;43;M
69562;274,650,1720,250,1699;28;F
69570;739,1214,339,633,260,539,193,868,337,221,1550,925,109,286,531;38;F
69582;446,335,1075,573,909,894,97,1666,553,442,1381,119,1238,544,1236;50;F
69583;1623,1720,539,170,339,446,674,1199,221,1550,1628,422,544,97,700;39;M
69587;1236,685,1217,739,446,260,626,553,567,221,1238,544,109,963,286;52;M
69594;1041,1240,335,1075,286,1720,677,925,434;8;M
69610;573,1199,193,1381,127,1016,250,274,1238,1163,461,894,1666,1236,650;53;M
69613;127,1623,1016,1240,1550,894,1236;73;M
69614;1238,422,180;8;M
69620;1093,119,337,1240,897,221,925;20;F
69629;1238,422,180;6;F
69636;1666,339,739,442,1490,573,539,1199,1234,1720,1238,544,422,531,97;24;F
69645;660,553,567,193,337,1720,1623,1238,335,422,461,1075,180,909,286;9;M
69653;1149,660,440,1381,337,221,925,1628,422,335,286,97,868,1238,544;37;F
69677;337,1442;41;F
69699;626,674,539,567,1720,1623,1550,221,1628,544,909,286,739,660,440;37;M
69702;440,539,193,868,1720,780,1623,221,1550,1628,544,422,286,531,57;38;F
69707;274,442,1720,1238,1414,1041,909,897,567;31;F
69708;739,1442,440,539,677,1041,780,1016,250,1240,1628,459,963,1699,1236;37;F
69709;894,626,1238,1550,127,169,739;33;F
69715;1490,660,573,1093,868,780,221,1238,286,434;41;F
69718;633,650,1217,739,1221,660,440,539,1199,274,221,286,531,434,1699;31;F
69720;1163,286,57,440,674,170,1238,1550,1623,193,1199,539,660,739,339;49;F
69726;573;70;F
69730;446,1381,925,1238,274,780,544,422,286,1153;49;F
69744;868,1238,335,544,109,286,434,260,626,674,1199,221,1623,1720,446;39;M
69747;739,260,440,1199,337,1720,1016,1240,221,1550,109,963,1075,286,1236;48;F
69752;1442;11;F
69759;221,1550,1238,1628,286,1236;42;M
69768;567,1234,119,221,109;22;M
69783;1217,1093,1041,1623,1238,1288,459,1075,57,539,567,1720,1628,180,909;36;F
69799;97,442,337,1234,1149,1238;27;F
69855;440,539,127,1016,221,1550,544,109,286,531,1666,739,260,169,1153;39;M
69856;531,1236,169,244,1217,739,674,193,553,221,286,660,440,544,700;39;M
69862;1442;7;M
69884;739,626,169,127,1550,1238,894;3;F
69899;1240,1623,127,539,440,660,1217,221,1238,1628;28;M
69910;1217,739,446,260,1381,1016,1240,221,1628,531,286,321,335,337,660;36;F
69913;1490,1442,1720,1623,1550,1238,1288,422,109;49;F
69928;739,626,169,127,1550,1238,894;;F
69929;461,339,539,221,909,660,193,274,434,567,1720,1623,897,1238,335;31;M
69985;260,1075,626;48;M
70021;1199,260,626,446,1442,193,127,1163,544,109,1075,97,57,700,1153;47;M
70038;544,97,1442,1149,434,221,440,674,1720,1217,446;30;M
70039;1149,674,660,221,1550,925,1163,544,1075,700,739,260,109;38;M
70049;170,685,434,650,127,55,169,274,739,154,1240,1041,897,909,567;33;F
70070;1720,127;23;F
70077;286,221,1720,1199,539,440,660,531,442,119,1623,1550,544,321,1666;60;F
70087;539,193,1093,1414,1720,1623,1240,1550,1238,925,1163,544,286,1236,1199;26;F
70105;221,1288,180,339,260,573,567,1381,1414,1623,925,1238,109,286,1236;14;F
70122;440,260,739,339,170,633,1217,337,1720,1623,1016,221,1240,925,1236;38;F
70125;221,286,1720,539,440,660,739,1217,446,544;39;F
70167;193;39;F
70173;339,660,337,335,286,531,1628,221,1240,1016,1381,260,446,739,1217;3;F
70187;1623,221,925,335,109,459,446,674,1381,1238,1628,544,286,97,700;36;M
70205;539,1720,925,544,286,897,221,1238,1628,440,1442,1221,739,1217,567;25;F
70210;127;25;M
70219;57,700,1153,1490,1149,446,1199,868,119,337,780,925,335,544,97;38;F
70232;286,531,221,1240,1016,1381,260,446,739,1217,1628,335,337,339,660;8;F
70253;1221,909,650,1214,260,553,567,193,1720,1623,1628,544,109,422,180;9;M
70308;544,1075,321;53;F
70314;567,1720,1623,1016,897,1550,925,180,286,909,97,57,193,1628,461;25;M
70316;660,260,446,674,539,1199,127,221,544,700;73;M
70330;553,868,119,337,780,274,180,567,660,1221,1214,339,1217,909,57;37;F
70340;739,650,260,442,539,1199,193,1234,119,1623,274,250,109,894,1699;70;F
70344;97,1699,1217,553,442,573,1381,127,868,119,1628,894,650;43;F
70353;531,286,544,1238,1550,221,250,1016,780,1623,539,440,660,739,339;20;M
70359;221,1238,422,260,109,286;37;F
70361;1238,109,286,221,660,1149,1666,339,739,442,573,539,1199,1623,434;29;F
70415;440,739,1214,422,180,909,434,1217,339,1221,553,539,567,1720,925;28;F
70428;170,739,660,442,1199,1623,780,1016,1240,1238,1288,1628,109,57,1236;36;F
70434;119,660,1442,909,700,422,109,459,1214,170,1163,1075,1153,97,1236;38;F
70437;1623,260,1149,1214,685,286,221,1628,1666,1153,97,544,446;37;M
70441;739,1236,660,1041,1623,221,97,674,539,567,1199,1238,544,1153,700;31;F
70489;180,1442,660,553,193,1720,250,1550,1238,544,109,1163,461,894,1236;55;F
70505;1234,1720,894,909,1075,180,339,260,567,1199,337,1414,1238,925,109;47;F
70515;544,700;48;M
70516;739,660,193,1381,1414,1016,1240,1628,1075,1199,1720,1623,1550,1238,1163;25;F
70522;1666,544,286;32;F
70525;1234,109,1075,1666,339,260,925,1199,1720,1623,221,1238,1163,544,286;55;F
70590;1234,1381,539,442,660,739,633,260,339,1720,1016,1240,1550,109,57;44;F
70600;1238,739,539,1016,461,260,685,1234,244,660,1240,1550,1163,894,1236;46;M
70631;1666,337,1199,660,339,244,260,868,1414,1240,221,1238,109,1075,1236;36;M
70636;544,422,1199,1414,1234,1238,567,1720,244,633,660,1623,1016,1240;41;M
70642;685,422,660,567,244,1720,739,1238,1240,1234,1016,1199,633,1414,1623;37;F
70644;1221,1623,739,1414,780,925,274,1236,1720,422,193,553,1238,539,567;40;F
70672;739,660,553,868,337,909,440,539,567,1041,1238,925,434;41;F
70698;739,1217,633,660,440,868,221,1238,335,286,1720;39;M
70703;700,154,544,1628,1550,221,1240,1720,193,539,440,739,1163,1153;37;M
70723;1149,868,660,739,446,674,780,221,1628,544,422,109,1075,286,97;10;F
70730;1720,1414,780,221,1288,544,422,1153,1149,169,127,925,1550,1628,97;27;F
70731;1217,633,650,286,335,1623,119,260,739,539,193,1381,1720,1016,1238;32;F
70760;909,250,1623,539,573,739,1149,1490,339,442,1199,193,1720,1238,1288;38;F
70770;335,1628,221,1238,1240,780,1720,868,567,539,260,244,739,339,633;70;M
70776;660,260,446,674,868,337,221,544,422,1075,286,97,57,700,1153;8;M
70787;1041,909,446,260,674,539,567,127,868,780,1238,544,422,109,894;33;M
70788;739,260,660,539,1199,1720,1623,780,221,1550,1163,544,109,286,1666;71;F
70802;260,739,446,674,660,868,780,221,544,422,109,1075,97,57,700;4;F
70806;897,909,567;34;M
70826;55,633,170,442,567,1199,127,780,1550,1238,925,1628,544,109,459;27;M
70830;1234,539,660,1720,1442,685,1623,221,1238,1163,109,1075,894,434,1236;68;F
70861;633,1217,1623,1153,440,286,531,739,660,539,193,1720,221,1550,544;42;M
70880;1217,440,1720,1623,1240,221,1550,1628,544,422,109,180,909,286,57;33;F
70901;567,1381,1720,780,1240,221,1238,335,544,286,531,97,321,1666,1236;36;F
70902;260,1199,1016,1240,925,1163,1623,1442,963;43;F
70904;633,539,1720,1623,1240,221,286,1199;25;M
70921;1234,633,286,221,1016,539,660,739,685,677,1623,1240,1238,925,154;40;M
70922;1234,1016,221,154,109,1075,1666,1236,685,260,1199,1623,1240,1238,925;39;F
70935;650,1214,660;40;M
70945;1442,339,739,244,539,1199,1234,1720,677,1623,1016,1240,1550,1163,1236;42;F
70962;1240,250,274,1720,440,660,626,739,1217,97,286,221,1623,567,539;21;F
70966;109,1163,170,260,440;48;F
70967;650,260,1214,674,440,250,180,335,1442,553,780,221,1238,422,109;39;F
70983;1217,660,539,1666,1199,1381,1720,1550,1238,1163,109,286,894;38;F
71022;633,260,539,553,119,274,250,925,422,109,286,894,531,434,57;37;F
71034;633,1234,119,1623,459,434,57,339,244,1199,1720,1016,780,1240,1238;30;F
71042;446,1381,1550,221,286,440,531,1149,442,1199,1238,1163,544,97,1153;38;F
71046;685,633,739,244,660,567,1199,1234,1720,1414,1623,1016,1240,1238,422;2;F
71052;685,633,244,660,567,1199,1234,1720,1238,1414,1623,1016,1240,544,422;5;M
71096;674,1199,868,119,1720,1238,925,1628,335,544,422,109,1075,97,700;40;M
71124;260,685,1199,1234,868,677,1623,274,1240,221,1238,925,154,109,1075;4;M
71126;780,459,1720,1075,633,739,1414;58;M
71133;337,1442;35;F
71136;700,127,119,1720,274,897,221,1163,286;40;M
71153;1550,221,1623,1720,119,539,442,553,674,626,260,739,339,660,544;64;F
71159;335,109,909,1199,567,339,446,193,221,1238,925,544,1075,97,1666;21;F
71173;674,739,260,660,440,539,1720,221,925,335,544,109,286,321,1666;46;F
71175;422,868,180;9;F
71198;1217,1234,221,1628,260,169,440,1720,780,1550,660,539,1016,1240,109;38;F
71202;1217,440,897,286,1550,868,573,442,660,739,1720,1623,1238,1666,539;30;M
71209;446,1149,544,97,1153;37;M
71210;1163,286,170,739,442,1381,1720,1623,1550,1628,544,531,1666;30;F
71214;1163,897,660,626,739,1236,57,286,1016,780,1623,1720,193,1199,1217;35;F
71215;286,531,739,660,1199,1720,1623,780,1016,1550,925,1163,544;53;F
71221;335,1214,780,1075,422,925,260,909,1238,553,109;37;M
71273;337,544,321,1628,446,1163,1550,170,1666,868,1238,531,286,221,1623;37;F
71276;1623,1240;34;F
71278;55,170,339,739,169,1720,1550,544,1163,286;65;F
71287;170,739,169,440,1720,221,1550,925,1163,544;64;M
71292;1153,544,335,1550,1240,1016,1720,1234,1149,1199,1623,1238,925,1628,894;45;F
71332;260,567,868,1041,897,925,109,434;35;F
71338;1720,1238,660,260,544,221,1550,335,286,531;66;F
71343;1163,544,1075,57,700,109,1240,1720,119,1093,193,1199,442,260,339;39;F
71352;221,1550,335,544,286,531;39;M
71366;650,339,739,660,440,539,1199,193,119,1720,1623,780,221,459,286;49;F
71380;1550,1163,1628,459,1075,286,894,531,57,739,169,127,337,1720,1623;23;F
71385;434,700,544,1149,446,674,553,567,193,868,1720,780,1238,97,1153;40;F
71401;539,650,544,700,1236,739,674,660,897,1720,1623,1016,250,1238,1628;32;M
71454;260,567,868,1041,897,925,109,434;7;M
71464;339,739,442,573,1199,1381,109,337,1720,1414,1238,335,544,1075,1666;34;F
71471;260,567,868,1041,897,925,109,434;3;F
71485;260,567,868,1041,897,925,109,434;35;M
71487;674,539,868,1623,780,1628,553,221,180,1720,193,97,446,1149,700;40;M
71504;1238,925,1628,286,1666,544;47;F
71509;446,1163,700,459,1149,260,674,553,1199,193,1093,868,544,97,1153;60;M
71521;539,244,1623,97,55,1199,1163,531,674,440,1720,1414,1550,544,700;37;F
71537;1623,1234,573,339,539,1238,531,286,221,1720,440,260,739,1217,660;27;M
71541;286,55,422,553,193,119,1221,868,442,1163,1199,1623,1720,897,1238;35;M
71553;422,1075,739,1623,909,1666,260,567,1199,1041,897,1238,925,109,434;42;F
71555;674,1381,868,461,440,700,97,1490,553,1199,1238,335,544,180,422;39;M
71563;1153,544,440,170,650,739,1628,286,1623,221,700;22;F
71575;1240,1550,1699,1238,1199,626,1720,660,1217,739,539,1623,221,286;48;F
71587;169,739,170,55,660,1199,1016,1240,897,221,1550,925,286,57,1236;25;M
71595;286,459,1628,1550,1238,1240,1016,1414,539,553,244,1236,109,1199,1623;33;F
71618;422,459,461,1217,739,260,553,660,221,1628,544,286,180,193,57;30;M
71646;170,1149,739,1442,1720,780,1016,250,1699;60;M
71668;337,335,544,1221,909,97,700;43;F
71691;739,1221,674,1199,193,119,1720,1628,544,109,286;38;F
71736;1214,440,1288,925,335,422,459,180,894,1236,553,1442,260,1149,780;38;M
71743;739,1149,339,1217,170,650,55,1623,1016,250,221,1550,286,97,1699;25;F
71768;780,434,97,909,1075,925,897,1623,1720,1217,260,553,422,109,180;43;F
71769;337,1720,1414,1623,780,897,221,1238,925,1628,335,544,422,109,286;38;M
71780;127,260,1214,339,442,1288,459,434,1666,685,1442,553,109,1075,894;51;M
71852;260,539,193,1720,221,109,1075,286;43;F
71874;459,1628,1238,221,1623,1720,1234,539,553,660,1149,1550,925,544,1153;39;F
71884;573;55;F
71885;674,440,1234,1550,925,544,286,57,1217,739,660,539,1720,1623,221;37;M
71927;57,339,1490,553,868,337,573,1381,1093,119,1238;44;F
71933;446,1153;35;F
71940;446,544;50;F
71942;1720,274,1550,1163,1628,1153;32;F
71944;1623,1238,1288,286,925,1628,459,57,127,1199,674,446,544,97,1153;51;F
71952;1238,286,221,274,1414,193,626,739,1214,650,925,1217,1221,567,1199;28;M
71956;780,1238,109,1221,1217,1442,553,567,193,1720,1623,422,1075,180,909;10;M
71960;544,446;51;F
71964;544,1238,780,1720,868,193,1199,539,573,440,660,260,1149,446;39;F
71967;739,260,169,440,539,1720,1623,221,1550,544,109,531;47;F
71998;339,446,674,539,567,193,337,1414,780,250,1550,925,335,544,180;22;F
72010;1720,897,909,434;42;F
72046;440,274,250,1550,1238,739,660,539,1720,1623,1240,221,286,531,1236;46;F
72063;446,626,539,1199,1720,1623,780,221,1238,925,1628,335,544,286,97;51;F
72069;440,660,626,1221,739,339,633,1093,119,1720,274,925,335,446,544;41;F
72076;154,531,57,97,180,1238,1199,260,626,739,193,1720,221,109,909;61;F
72084;1720,868,442,440,660,260,339,170,1623,780,1238,925,1163,335,544;40;M
72085;1199,193,339;28;F
72097;925,1628,180,286,1666,446,674,442,221,544;43;F
72108;868,119,1414,1623,221,109,1075,1666,1153,286,1238,1720,339,544,700;56;F
72112;193,1720,544;73;F
72121;1199,1628,544;40;F
72157;633,1442,567,1199,1041,154,459,57,650,260,1628;32;F
72163;660,674,221,1628,544,286,700;62;M
72168;1623,1240,221,1238,1628,539,119,1720,274,1666,57,544,531,286,446;45;F
72173;544;42;F
72193;193,1720,1163,544;71;M
72225;1217,739,660,553,539,1720,1623,221,180,286;76;F
72243;260,573,1381,1234,1720,1623,1240,1550,109,1666,339,1199,780,1238,1236;32;F
72253;446,544;56;M
72263;567,461,180;18;M
72266;739,674,539,1199,1720,1623,221,544,286;74;F
72285;170,260,1199,1234,868,119,780,1238,1075,1666,440,897,1623;36;F
72309;1628,1075,461,1234,260,1199,1381,1720,221,1238,1163,544,109,286,321;51;F
72320;221,1623,539,660,739,1217,780,925,1075,260,109;27;F
72331;339,461,286,531,660,260,739,1075,109,1163,539,1217,193,1720,1623;54;F
72335;531,660,1199,221,1550,286,633,739,244,193,1623,1016,1240,1163,1236;36;M
72345;544,221,1240,1720,119,1381,1199,539,573,442,440,660,739,1217,650;35;F
72351;868,337,1623,274,286,739,339,446,127,221,925,544,97,700,1153;33;F
72363;650,633,1214,739,660,1720,1623,780,1240,1550,1163,963,286,1699,1236;41;F
72393;1720,1414,1199,553,260,446,339,1238,335,544,1075,286,531,57,1666;54;M
72394;446,700,1153,674,1199,544,97;65;M
72420;250;67;F
72423;446;15;F
72428;57,626,169,650,1016,1236,170,739,660,286;36;M
72433;633,1720,1016;45;F
72442;553,868,440,1199,1075,700,260,660,193,1720,221,109,544,286,97;44;F
72444;1214,1221,446,1149,674,868,1414,780,1238,1628,544,286,894,97,700;45;F
72449;531,97,1217,1214,1221,660,567,193,1720,1623,274,925,1628,909,57;40;F
72456;446;10;F
72470;1221,1238,544,660;36;F
72473;1217,1149,446,193,868,119,1720,1238,925,1628,544,894,97,700,1153;39;F
72474;544,446;13;F
72478;1666,1236,1153,1288,1238,1550,221,897,1240,250,1623,1414,1041,677,1442;36;M
72479;109,660,193,1381,221,963,1075,286,1199,1234,868,119,1238,337,685;43;F
72486;260,109,422;43;F
72505;1217,1149,674,567,193,127,1720,1623,1238,1628,544,434,97,700,1153;49;F
72517;1623,337,442,440,260,739,339,660,539,868,1720,1238,286,1666;47;F
72525;1720,1016,1240,925,1236,780;32;F
72526;626,539,193,1234,221,1550,544,909,286,739,422,1720,553,1628,567;39;F
72579;1238,335,286,650,739,660,539,567,1720,677,221,109,963,1236,1240;27;M
72599;1442,1153;33;M
72607;55,422,286,97,339,446,1199,1093,868,1238,544;64;F
72609;1075,109,1149,573,193,544,97,446,1153;39;F
72620;650,925,739,626,553,1153,339,446,1442,422,567,897,221,1550,544;34;F
72647;1550,339,442,1199,446,169,660,539,1623,1016,1240,221,1163,286,894;38;F
72651;868,119,1623,1016,1240,221,1550,894,57;38;F
72665;1221,169,660,442,440,539,1199,193,1153,1075,1234,868,1720,544,894;24;F
72682;1149,422,544,250,1221,97,1442,274,567;27;M
72684;739,660,119,868,1238,1623,221,180,1217,1221,553,193,422,461;49;M
72698;221,109,321,244,260,442,1381,1238,1163,1075,286,1236,633,1016,1240;45;F
72707;1628;33;M
72710;169,674,193,1381,1720,1623,1238,925,1153,446,127,1016,1163,544,97;54;F
72718;1442;83;F
72719;660,567,1623,925,1238,1414,119,260,553,442,573,193,868,109,180;49;F
72720;1666,109,1288,677,119,1093,1234,193,1199,442,260,339;62;F
72754;650;52;M
72764;97,1149,739,660,442,539,119,1623,274,221,1238,1288,544,286,1236;34;F
72801;1236,286,221,1240,1016,1720,567,539,660,169,739,650;58;M
72802;1699,109,677,1234,193,633,650,170,1199,1720,1016,274,1240,1550,1236;39;M
72813;1623,539,1217,897,567;31;M
72820;260,1442,1199,193,1234,119,1240,221,925,335,544,422,109,97,1153;33;F
72826;1666,1381,1550,1238,544,337,335,109,97;39;M
72836;1442;64;F
72839;1016,440,553,1442,660,868,1720,1240,1550,1628,544,459,286,894,57;43;M
72848;925,1238,1240,633,339,1720,1016,1628,544,335,109,1075,1666,1236,1199;23;F
72851;1240,250,1217,633,739,660,539,1720,1623,221,1238,335,286,434,531;33;F
72860;1217,1214,739,1221,553,193,337,119,1720,180,286,1163,422,459,461;11;M
72863;339,1442;31;F
72868;1149,446,553,925,544,422,97;36;F
72877;1240,274,1623,677,567,539,440,660,739,1217,633,650,1214,1720,780;68;F
72886;650;5;F
72907;1149,339,1217,650,1628,1075,180,909,286,531,321,57,1699,1236,1153;20;M
72924;567,909,650,897,434,1699;35;M
72933;446,1240,1720,440,1490,339,739,660,539,1199,1623,221,1238,531;32;F
72938;446;40;M
72969;1236,1699,1628,660,633,434,909,1041,1623,739,539,925,1720,897,567;28;M
72973;1199,1623,1240,335,1075,286,894,260,660,1720,221,1550,1238,925,544;28;F
72975;339,1490,337,1720,1414,780,221,660,442,544,109,286,57,700,1666;60;F
72979;868,700,169,660,434,1550,1623,780,221,544,286,739,1238,260,531;30;M
72985;1442;73;M
72990;685,1199,119,1720,1016,221,1550,1238,335,544,109,1666;38;F
72992;260,1234,1623,780,1016;47;F
73032;925,434;50;F
73043;1623,539,660,1550,925,1163,1628,422,1149,674,544,97,700,1153,446;71;M
73048;700,674,97;45;F
73060;1240,925,544;70;F
73066;1288,925,422,109,1075,434,650,1199,1381,868,1720,1623,780,250,1238;46;F
73077;739,260,660,539,1199,868,1720,780,1016,221,1238,925,1628,335,286;39;F
73084;1490,633,446,260,573,1381,1234,868,1238,925,544,422,109,1075,1153;35;F
73093;127,119,1414,1623,1075;14;M
73099;739,193,274,539,567,221,1628,180,286,97,700,1153,1236,1720,626;43;M
73101;626,660,193,274;29;F
73106;1288,1163,335,109,894,434,1666,1153,55,1240,1238,925,57,633;38;M
73111;925,434;49;M
73115;170,446,260,674,1199,127,868,1414,1550,1238,1628,544,109,700,1153;35;F
73119;55,170,339,739,260,660,440,442,539,119,1016,1240,286,57,1666;68;F
73137;573;62;F
73140;650,339,1199,1720,780,1240,1238,1628,459,1075;29;M
73159;544,1153;33;F
73161;1016,97,1217,339,1149,739,660,193,1720,221,335,539,544,531,286;30;F
73165;109,1623,1234,660,169,260,1149,170,739,446,674,1550,925,544,1153;69;F
73170;739,244,660,440,1234,1550,1623,1720,193,539,925,544,109,286,1236;27;F
73200;677,1075,335,1240,1041,1720,925,434;36;F
73201;700,97,1628,674,446,1238,1153;58;F
73209;925,434;10;F
73218;446,1720,544;38;F
73220;674,660,553,1628,544,422,97,700,1153;38;M
73222;544,1550,446,674,1041;70;M
73225;180,1163,260,660,442,539,193,221,1550,1075,909,286,1720,1414,1238;28;F
73229;909,544,1442,1221;45;M
73246;260,1442,1234,337,1720,221,1238,422,109,963,1075,286,894,57,1666;12;F
73250;544;56;F
73253;674,544;28;M
73254;925,531,434,567,1623,1720,539,553,660,739,1217,221,1238,286,97;38;M
73255;739,660,442,539,193,1623,780,250,221,459,286,894,57,1699,1666;36;F
73269;1238;28;F
73275;1490,446,260,1199,1381,1234,868,1623,221,1238,286,97,1666,1153,544;34;F
73281;339,739,573,539,1199,119,1720,337,1414,1623,780,1238,1628,109,97;27;F
73284;1628,553,422;43;M
73291;1149,97,446;42;F
73298;544,109,894,1153,1720,739,1214,1623,780,221,459,1075,180,286,909;51;M
73304;1153,1238,97,446;42;M
73313;925,897,274,567,909;31;F
73325;1666,1153,1623,1240,286,1075,339,260,1236,1234,1199,442,335,274,1217;43;M
73334;170,531,894,97,57,440,260,739,633,660,119,221,1550,544,286;41;M
73339;544;43;M
73345;739,660,440,539,1720,1623,221,544,286;44;M
73346;685,553,193,1240,1238,544,109,909,286;52;F
73351;1217,1214,1221,567,1153;32;M
73353;1666;72;F
73360;739,660,440,442,539,567,193,1720,1623,1016,221,909,531,434,57;67;M
73362;446,925,1149,544,1153;51;M
73363;119,1720,1414,1016,221,1550,1238,1288,925,1163,544,154,109,1075,286;34;F
73367;909,170,739,660,440,1550,544,461,894,1217,339,193,868,1720,1163;41;M
73408;660,650,169,567,1199,868,1041,1623,274,897,544,909,894,434;33;F
73421;739,553,442,1720,1041,1238;42;F
73422;1217,1381,1093,1720,335,544;75;M
73433;685,739,260,1199,442,539,221,700,446,674,660,1628,109,544,1153;35;F
73436;286,260,674,553,868,925,1628,335,109,97,700,544,193,422,446;39;F
73442;539,1217,1221,567,1720,909;80;M
73443;894,1153,1214,539,193,119,1720,780,1240,1550,925,57,286,909,459;26;F
73466;739,567,1041,1240,1238,109,434;28;F
73470;250;38;M
73475;1221,1442,544,909;45;F
73495;422,335,260;53;F
73506;1016,1240,221,963,286,1236;59;M
73518;1221,1442,544,909;5;M
73536;109,440,1153,339,446,260,660,442,868,119,221,1238,544,97,1666;66;F
73543;1414,1623,897,221,1238,286,180,1075,335,650,1490,446,119,868,544;25;F
73558;660,1623,221,335,459,909,286,700,1666,260,193,677,1550,1238,544;27;F
73561;1041,1016,1240,221,1628,286,1236,339,739,169,1442,1623,1238,925,531;18;F
73574;1442;39;F
73575;1217,440,660,1666,1623,1414,1550,1163,244,442,1720,1016,1240,1238,1236;35;F
73581;894,180,544,1149,446,868,1288,925,1628,422,109,1075,434,97,1153;4;F
73582;440,660,539,97,925,434,567,909,897,274;30;M
73615;1442;11;F
73628;739,169,674,1720,109,446,660,539,221,925,544,286,531,440,1623;38;M
73649;573,1238,1288,1628,422,109,459,1075,260,1490,339,446,335,544,97;36;F
73674;650,286,434,1666,274,1623,539,897,1217,660,567,1041,909;28;F
73699;1149,739,446,260,1381,909,1720,1623,274,897,544,109,894,97,1153;45;F
73737;193,1234,1199,442,221,286;68;F
73750;1217,739,169,660,1199,1720,1623,1240,221,1550,1163,1628,286,531,1236;37;F
73764;170,633,660,1628,1240,422,1236,1016,573,1623,739,260,109,1199,1442;40;F
73791;221,1288,286,339,446,674,1199,193,1623,1238,1628,544,1153,97,700;51;F
73795;1234,868,925,544;37;F
73825;739,193,1720,677,286,1236,260,660,553,539,567,868,1041,1623,909;41;F
73844;1163,260,894,335,109,1075,544,1550,1381,1199,674,446,1149,700,1153;51;M
73884;442,553,674,626,260,446,1149,925,335,544,109,1075,1236,1666,1153;79;F
73918;1666;43;F
73922;446,1149,97,1153,544;35;M
73955;339,739,660,539,1720,1238,925,894,97,1153,221,544;26;F
74052;1153,674,1149,97,1628;39;F
74062;1217,339,442,539,567,1153;44;F
74069;1016,1623,1550,1240,1236,1234,1199,780,739,677,221,274,109,1720;44;F
74072;1041,1240,925,154;52;M
74112;1666;8;M
74114;1199,260,244,739,633,193,677,1016,1240,1238,109,1075,286,57,1666;77;F
74128;674,260,660,440,868,1720,1623,221,1550,1163,544,109,286,1666,1153;70;F
74150;1720,1041,1414,250,286,739,260,1623,780,274,897,925,422,109,434;61;M
74157;1163,700,739,169,674,660,1199,1550,1238,925,544,531,1623,127,286;38;F
74187;442,539,1199,193,1234,1720,1623,221,1550,1238,544,109,1075,286,700;31;F
74204;1666;46;M
74206;459,553,440,539,567,1720,963,286,57,1240,274,780,897,544,1666;33;M
74225;57,1214,127,780,1016,897,1240,544,894,55,650,553,925,459,180;41;F
74233;1199,539,260,553,660,1490,685,739,440,868,119,221,1238,925,434;44;F
74234;55,339,739,1093,119,274,221,925,1628,909,97,57;22;F
74244;894,633,544,461,260,170,169,677,868,1016,1199,1236,1240,1550,193;34;F
74255;55,633,1720,1623,109,909,553,180;83;M
74260;909,897,274,567;33;M
74292;286,459,1238,193,440,660,339,544;36;M
74302;739,1153,1149,674,780,1550,925,1163,1628,544,109,286,434,97,700;45;F
74317;650;92;M
74319;626,539,660,1234,1720,221,1628,286,260,109,1075;61;M
74325;446,544;45;M
74331;446;49;M
74335;674,544,700;62;F
74348;1623,1442,1238,1093,1217,339,660,119,1288;33;F
74350;1238,544;39;M
74361;1442;9;M
74387;1442;7;F
74409;1093,868,274,544,963,180,894,1153,446,674,1381,119,925,97,700;35;F
74417;1442;4;M
74419;925,1720,1041;34;M
74427;442,1666;58;F
74438;1623,1217,739,446,1720,1381,440,925,1628,544,909,97,57,700,1153;39;F
74462;170,339,442,1550;61;F
74469;1221,169,674,660,553,539,1199,677,274,221,1236,1240,1016,1623,1720;31;F
74484;544,446;12;F
74494;286,97,700,739,260,660,440,1623,544;30;M
74496;1442;;F
74546;1381,539,286,422,909,925,434,221,1550,1623,1238,553,626,127,1720;41;F
74557;650,170,244,660,1016,1240,1550,286;64;M
74562;1442;41;F
74565;660,1221,1149,1217,170,55,539,1199,127,1550,1238,1288,544,286,894;38;F
74577;446,544;31;F
74592;1442;2;F
74594;539,1238,286,739,446,660,440,442,1720,1623,221,1550,544;70;F
74608;1442;10;M
74680;909,260,170,339,55,739,660,127,1623,780,1238,1628,544,286,57;32;F
74688;1442;10;M
74694;626,169,539,440,1699,1153,1236,531,459,1016,221,925,1163,963,286;30;M
74695;169,1217,660,539,567,221,1238,1628,544,154,286,700;27;F
74710;544;24;F
74719;1623,925,335,422,274,337,119,868,553,260,1221,1214,339,1217,97;36;F
74727;1217,626,674,700,1666,650,446,440,442,539,567,1238,925,1628,286;29;F
74755;1623,739,1240,1490,1442;34;F
74768;650,260,442,1199,1414,250,286,1699,1666,1236,1238;42;F
74780;286,909,531,57,339,739,1442,553,868,567,119,1720,274,1238,925;39;M
74786;446,97,544;31;M
74798;674,339,260,1199,127,1234,1016,1238,1153;33;F
74828;1234,119,442,573,868,1720,1414,1623,221,1288,1238,109,286,1699,1666;24;F
74833;685,739,1221,660,440,539,1720,1623,221,1238,544,286,531,434,1236;23;F
74852;539,897,1075,1666,1234,1720,1623,274,250,1238,422,109,286,660,193;69;F
74870;660,1442,1221,170,440,1199,1381,1623,221,1550,1288,925,544,286;25;F
74884;260,925,109,434,1238,1628;45;F
74922;739,626,660,440,539,567,1720,274,1240,221,544,909,286,894,434;44;F
74923;180,626,193,1381,1217,894,1628,539,1720,544,422,459,461,97,57;36;F
74928;1149,674,1720,1628,544,97;43;M
74931;339,442;75;F
74958;626,567,1720,1623,221,1550,1238,1288,1163,1628,909,531,434,97,1666;30;F
74966;1217,244,739,780,221,286,660,539,1720,1623,1016,1240,1236;40;F
74972;57,459,1240,780,660,446,739,1214;29;F
74973;573,442,553,1442,260,1490,339,193,677,780,1238,963,1236,57,286;32;F
75000;1442;46;M
75006;169,1240,531,633,739,660,440,567,1720,1217,539,221,1550,1238,286;38;F
75017;440,539,193,1720,1623,274,221,1550,1163,894,286,1075,461,109,335;42;M
75052;674,700,544;58;M
75056;700;51;M
75060;1720,274,221,1550,544;73;M
75061;539,567,127,1093,868,119,1720,1414,1623,221,1238,1163,1628,544,909;51;F
75066;925,1163,1236,1153,286;55;M
75095;339,337,335;41;F
75113;700;48;F
75130;1236,650,339,1490,1221,1442,442,127,1623,154,909,321,440,119,544;24;M
75153;650;27;M
75155;626,660,539,567,127,868,1720,1623,925,335,109,180,286,894,1236;36;F
75186;1550,544;34;M
75265;1163,335,461,531,1699,650,193,1414,1623,1240,221,1238,109,1075,286;27;F
75309;780,1623,193,539,660,674,1442,169,739,1214,1217,286,531,57,700;26;M
75315;1720,868,1199,442,553,1214,650,1217,1623,780,335,909,286,57,1666;27;F
75341;539,1234,119,1720,1623,1240,925,442,567,1238,1153,109,909,286,1666;38;F
75372;674,544;32;F
75382;1153;63;F
75421;544;46;F
75424;685,119,1199,1720,1016,1240,1699,1236,109,1238,250,660,1442,633,780;40;F
75430;1199,1075,1217,1381,1234,1414,1720,1623,1016,1240,109,1236,1238,1550,1666;33;M
75441;260,780,1240,1666,1236,1238,544;37;F
75480;1149,193,1414,544,700;47;F
75501;739,244,1016;24;F
75524;739,1720,1414,1238,925,109,1075,286,700,1153,221,193,1199,446,544;59;F
75539;446,1221,633,1217,1240,1288,909,286,55,170,739,567,539,442,1666;65;F
75545;1149,1214,633,260,660,250,221,925,544,109,286,434,422,650,1623;22;F
75546;440,539,286,57,739,677,780,1550,1016,1240,169,633,244;31;F
75583;1214,685,169,1442,553,868,894,434,1699,650,567,1041,897,335,909;36;F
75588;739,660,539,1234,868,1623,221,1238,109,1075,286,894,57,1666,1153;47;F
75595;1221,244,650,633,1217,739,660,539,1623,780,1240,221,1628,544,286;29;M
75602;1149,440,660,674,446,1199,221,422,544,109,286,531,97,700,1153;36;M
75607;925,909,1153;30;F
75612;1442,553,442,1163,633,1199,1720,780,1016,250,1240,1238,109,1699,1236;9;M
75637;442,440,739,244,660,539,1199,868,677,1623,1016,1240,221,1238,925;37;F
75648;1199,1234,1623,1550,1238,286;37;F
75668;260,1442,553,1199,868,119,1016,250,1240,1238,544,894,1699,1236,780;5;F
75670;963;28;M
75674;446,260,442,780,335,459,180,553,1234,1093,1628,544,109,1075,57;32;F
75676;925,434;41;F
75691;1623,1217,1163,925,434,422,274;52;F
75696;422;40;M
75711;170,1442,660,868,119,337,1720,1623,1016,221,1550,925,286,1236,633;48;F
75721;422,544,434,739,1236,244,1240,1234,1199,1414,1238,1041,963,154,677;30;F
75727;1720,925,434;8;F
75744;170,531,700,633,739,446,626,674,660,440,539,1720,1623,221,544;62;F
75745;925,434;6;M
75746;1075,1623,260,633,1720,963,660,1550,685,170,739,868,1016,1240,1236;44;F
75758;1041,274,221,1550,1628,544,909,286,1153,442,567,1199,1381,97,1666;28;F
75768;170,539,274,221,544,459,57,1236,1240,1550,422,109,1075,286,1153;38;F
75769;573,1199,780,1666,339,1238,544;28;F
75770;1238,660,422,1623,55,626,260,109;48;F
75772;422;9;M
75774;925,434;35;M
75778;626,553,1075,180;38;F
75812;739,660,539,567,1623,1240,250,274,221,1550,544,180,909,286;34;M
75819;650,739,660,539,567,193,1041,1628,909;52;M
75829;1623,440,434,1214,1041,119,1221,539,925,626,868,274,909,897,567;37;M
75831;193,700,674,339,1720,1623;73;F
75847;544;61;M
75873;169,1217,633,780,700,1720,127,244,650,660,626,739,1240,459,57;35;M
75879;650,780,925,459,286;59;M
75880;1666,286,221,780,1720,650,250,1240,1238;28;M
75884;674,660,221,1628,700;53;F
75887;339,434,650,1041;44;F
75899;274,650,260,553,109,1699,539,221,660,739,1217,1199,1720,1238,286;70;M
75901;339,1149,446,674,1199,1381,1550,1238,925,1628,544,422;43;F
75921;739,339,1217,650,221,1238,925,1628,544,109,1075,286,97,57,1153;44;F
75939;1720,119,1381,1199,567,660,674,169,626,1221,244,1149,170,650,97;52;M
75942;1163,544,109,434,321,1623,1075,1720,1217,274,650,1041,539,567,909;43;F
75962;1240,1623,626,119,1041,909;30;F
76004;1217,57,1720,193,553,260,109;71;F
76012;1163,461,335,1490;25;M
76024;700,434,286,909,544,1628,1550,221,1623,1720,539,440,660,674,739;40;F
76075;660,539,677,1623,780,1016,1240,221,1628,286,531,57,1236;31;F
76096;544,539,1623,221,459,286,531,674,1720,700;70;F
76098;1240,1041,337,1217,55,1199,897,963,894,1699,1236;25;M
76114;1153,1666,57,1075,459,1163,1016,1623,1720,193,626,170,55,633;45;M
76116;868,119,925,422,446,260,544,97;45;M
76122;963;77;M
76159;1149,446,674,544,97,286,1153,260;39;F
76161;440,1550,286,531,221;41;F
76174;1628,422,434,925;34;M
76189;1238,660,422,1623,55,626,260,109;10;M
76208;442;70;F
76243;446;42;M
76251;442,1234,119,1623,1666;66;F
76296;1623,1041,539,1442,244,1199,1720,677,780,1016,154,459,286,57,1236;54;F
76309;1442,337,1041,274,250,925,909;39;F
76316;650,626,250,221,1550,544,1075,286,894,567,1623;38;M
76321;170,544,109,1075,700,260,674,1720,1628;41;M
76325;1238,660,422,1623,55,626,260,109;5;F
76347;1699,1238,221,739,1217,650,660,539,127,1041,1623,897,250,434,57;83;F
76362;1217,553,539,868,119,1720,1414,1016,1238,1288,422,109,180,909,286;38;F
76366;1666;1;F
76369;335,286,780,1550,1238,1442,260,1234,1199,868,1016,250,925,109,459;5;M
76389;1666;3;F
76430;573,650,1217,739,260,660,539,868,119,221,925,109,1075,286,434;38;F
76433;1666;6;F
76457;739,626,660,442,539,193,119,57,459,1628,1238,221,780,1720,440;47;M
76462;1623,553,544,440,422,127,119,97,57,894,109,1628,1163,626,260;40;F
76483;335,1238,337,1199,685;51;F
76495;626,553,337,1041,274,461,180,339,1199,221,1238,544,109,1075,286;27;M
76497;553,169,339,650,544,109,180,286,894,97,700,1666;22;F
76499;573,1016,1238,1163,244,1720,677,1623,1240,154;59;F
76500;55,660,442,1199,193,337,57,1666,339,626,1381,1234,925,1628,97;16;F
76547;1550,544,286,440,553,1221,169,674,1149,1217,633,55,109,660,260;36;M
76565;260,55,442,1093,119,1720,1016,1240,221,1238,422,1075,286,1666,1236;42;F
76640;260,539,337,1414,221,1075,739,626,660,567,339,573,1234,286,1238;16;F
76647;1381,660,244,650,274,1016,1041,1720,1236,1217,739,539,193,1623,434;26;F
76652;567,660,1217,650,739,169,539,1623,1238;31;M
76654;274,1623,119,539,440,626,1149,446,660,221,286,97,544,674,739;55;F
76671;660,442,573,539,567,868,119,337,221,925,109,1075,909,286,434;8;F
76681;1381,440,169,739,660,193,539,1236,531,286,109,544,1238,274,1623;26;M
76686;1442;13;F
76697;739,539,1623,1628,109,97,1236,531,925;38;F
76726;339,660,442,1075,1666,286,221,1550,1623,1720,739;28;M
76744;1442;4;F
76762;221,633,1720,1041,286,677,1240,1550;31;F
76770;909,897,567,193,1238;24;F
76774;573,1381,868,1720,677,1240,1238,925,422,109,963,1075,1666,1236,1153;85;F
76813;739,260,660,440,539,567,868,337,221,925,109,1075,909,286,434;40;M
76815;544,780;38;M
76831;674,539,1720,1623,221,544,459,286,531,700;75;M
76833;1221,339,1217,739,567,1623,780,274,221,925,544,180,909,286,1153;27;F
76843;650,539,780,1016,1240,286,57,1236;34;M
76847;1149,739,626,539,1720,221,1628,286,660,440,1234,1075,97,1153,446;54;M
76888;1217,1041,1240,221,1238,1163,1666,739,1720,1016,1550,286,1628,544,422;50;M
76900;531,422,925,1238,739,539,1623,897;24;F
76903;446,626,660,868,337,221,1238,1628,544;49;F
76906;193,660,739,446,544;53;M
76913;97,674,1628,925,170,119,1720,221,1238,544,422,109,286,531,1666;43;F
76922;660,193,1720,1016,274,1240,1163,544,963,180,1699,1236;32;M
76932;780,335,109,57,1236,1075,1214,739,446,260,660,442,868,1238,685;40;F
76958;321,1221,446,739,337,1720,1016,250,963,339,193,274,1238,1288,286;34;F
76963;274,1153,739,1720,1240,1550,221,1288,925,1163,544,909,286,1236,1628;54;M
77003;685,677,1041,1240;46;F
77032;260,1163,544;43;M
77047;260,1016,1240,544,109;65;F
77082;660,1414,1623;46;M
77114;446;8;M
77117;553,442,567,1199,1381,127,1093,119,1720,1240,1238,1288,925,544,109;45;F
77121;573,539,1199,193,1234,119,337,1720,677,1623,221,1628,544,109,286;25;F
77160;894,170,1217,1214,925,57,909,461,109,897,274,1720,260,739,650;37;M
77166;1163,127,169,1666,1238,1381,739,1217,442,1199,1720,1414,221,286,1236;24;F
77184;1149,446,674,660,1720,1414,1628,544,1153;49;M
77213;339,739,660,442,539,1199,1720,250,897,221,1238,925,544,286,1666;30;F
77226;434,1153;52;M
77230;170,739,660,539,1199,1163,109,193,1234,1720,1623,1240,221,1075,286;58;F
77251;660,1442,1217,1628;51;M
77259;1666,57,321,97,459,544,193,780;40;F
77275;1238,1381,573,442,446,544,1550,221,1720,1093,1199,660,674,260,1490;49;F
77286;1236,1153,660,250,1240,221,1550,1238;21;M
77296;539,119,780,897,221,925,1163,109,459,626,193,1623,1238,544,286;37;F
77329;1163,335,1075;41;M
77355;677,1016,1240,244,1550,553,180,1217,1623,739,1442,1720,1414,1236,1199;36;F
77360;633,1381,677,337,925,339,685;40;F
77368;685,170,739,660,1199,193,1240,221,1550,925,1628,422,286,57;28;F
77378;1199,1238;41;F
77395;1628,909;85;F
77403;446,674,780,925,1628,544,422,97,57,700;40;M
77405;221,57,700,1163,1628,109,909,531,434,1236,274,250,1238,544,286;50;F
77432;1628,780,1414,1234,1199,567,660,739,1217,1720,1623,925,909,286,57;45;M
77440;459,1666,700,57,1628,1238,1199,442,674,339,1149,119,544,97,1153;50;F
77441;459,461,963,97,1699,1442,170,685,193,780,1628,544,286,57,1236;46;F
77449;339,739,660,567,193,1720,221,1163,544,422,909,286,57,1699,1236;25;F
77453;539,567,1720,897,221,1238,335,109,963,1075,286,434,1699,1666,1153;51;F
77460;1016,1550,1442,1623,1238,1628,544,1666,739,553,539,925,180,260,109;42;F
77465;780,1238,1163,1628,57;25;M
77489;260,626,553,440,127,119,1623,1163,1628,544,422,109,894,97,57;9;F
77494;1550,553,260,650,193,1234,868,274,1240,109,1075,180,286,1699,1666;46;M
77495;442,1720,544;59;F
77524;674,221,1550,1628,544,286,97,700,1153;56;M
77567;1236,1720;46;M
77571;260,626,553,440,127,119,1623,1163,1628,544,422,109,894,97,57;7;F
77575;1442;61;M
77576;440,221,1628,544,286,531;32;M
77579;539,573,660,260,1149,119,337,1720,780,1016,1240,221,1238,57,1236;43;M
77607;1623,221,1238,544,286,339,1217,1666,539,909,1075,868,1720,442,567;37;F
77619;446,573,1093,868,97,1666,1490,1149,442,1238,335,109,1075,286,1153;37;F
77622;221,544,286,531;33;F
77639;260,626,553,440,127,119,1623,1163,1628,544,422,109,894,97,57;7;M
77651;1666;59;M
77663;660,440,119,221,925,544,286,531,1666,260,1720,442,539,1623,1238;44;F
77665;286,539,244,274;58;M
77683;260,626,553,440,127,119,1623,1163,1628,544,422,109,894,97,57;39;M
77689;1623,337,1163,461,1075,434,260,442,1199,1720,1414,1550,1238,335,109;75;F
77712;97,57,1217,260,1720,780,925,544,422,109,1075,180,894,531,700;64;F
77722;260,109;49;F
77733;650,626,1720,1623,780,274,897,925,422,109,180,286,894,57,1699;10;M
77735;1238,169,660,1234,909,286,434,1699;35;F
77737;567,1236,57,909,180,459,335,925,780,337,119,553,1442,650,685;50;F
77756;55,339,442,1199,193,1163,461,909,894,1666;56;F
77764;674,573,1199,868,337,1414,1238,925,544,531,434,1666,221,286,321;27;F
77765;1720,544;43;F
77773;1217,1214,739,626,1442,660,440,1381,127,1234,780,1623,221,1628,544;10;M
77777;1490;47;F
77790;1240,1623,739,685,925,434;37;F
77796;193,442,286,1240,1720,1623,1234,1238;22;F
77802;650,260,193,109,553,422,1442,1236,739,685,1238,567,925,250,1699;43;M
77817;1240,1163,109,1720,1550,544,1238,286,221,1623;36;M
77823;660,553,442,119,1720,677,1288,109,180,1666,685,339,868,925,422;43;F
77831;544,442;38;M
77839;442,1666;23;M
77844;544;43;F
77914;442,539,567,1623,250,897,1238,422,1699,685,650,739,1442,963,531;11;F
77919;1623,1414,337,119,539,440,553,660,1442,260,739,1217,650,685,567;19;M
77935;531,97,260,660,539,567,127,274,925,1628,109,180,909,286,1666;47;M
77938;339,170,1016;25;F
77948;1623,250,221,1628,963,286,531,739,244,127,1016,1240,1550,1238,1236;48;M
77951;1628,544,109,459,1075,286,57,1666,739;69;F
77970;1149,739,626,660,553,440,573,539,567,193,127,868,119,1414,897;22;M
77975;739,442,1199,193,1381,1234,119,1016,1238,1288,925,1163,286,1666,1236;32;F
77993;250,780,1414,337,119,567,539,553,1442,260,1221,739,1217,650,685;53;M
78023;963;65;F
78030;633,1217,1490,739,1238,660,553,539,567,337,1414,909,286,274,221;52;F
78064;660,544;54;M
78095;1240,1623,739,685,925,434;13;M
78113;169,127,1163,1628,909,286;24;M
78119;442,539,1199,1234,868,1153,739,446,1720,1414,1623,221,1238,1628,544;48;F
78149;650,685,1214,660,339,739,626,1221,221,1550,1163,459,286,1666,1720;28;F
78152;660,925,109,1075,180,1217,1490,260,1442,553,567,868,1041,909,434;40;M
78157;1240,1623,739,685,925,434;8;F
78164;1623,274,250,286,780,422,894,909,897,221,1199,925,1234,260,109;50;M
78165;650,260,193,109,553,422,1442,1236,739,685,1238,567,925,250,1699;41;F
78198;97,57,1214,660,1720,221,286,531,700,780,1217,1623,674,440,544;41;M
78234;739,57,531,1628,1720,674,440,539,1623,1240,221,1550,544,286,1236;44;M
78235;1075,674,1149,1236,1699,434,109,446,260,868,1016,250,1240,925,544;42;F
78243;739,573,1199,1720,1240,1550,1288,925,170,660,440,531,1623,221,286;44;F
78295;1666,1221,739,339,1550,925,1163,461,286,894,434,170,1149,169,127;39;F
78300;567,459,674,127,626,1214,170,55,633,260,1720,1414,700;40;F
78305;1381,573,169,1214,1720,567,909,897,274,626,1628,127,221,1163,286;32;F
78313;1550,633,1442,868,1623,1238,1163,1628,1666,660,440,221,544,286,700;42;F
78315;1149,674,1623,97,700,1153,446,544;56;M
78331;337,677,1016,1240,1628,109,1075,1236,55,626,193,1720,221,1238,1163;59;F
78342;963;69;M
78365;442,1199,1381,1234,1093,868,337,221,1238,1288,1163,109,1075,57,1666;39;M
78371;685,739,780,1016,221,154,286,1236,660,539,1199,1720,677,1240,925;64;F
78373;221,1628,674,193,1720,544,286,97,700,1153;55;F
78386;57,700,1381,539,685,650,739,626,868,221,925,1628,422,180,286;39;M
78406;539,1381,119,1720,780,1016,1240,286,1236,544,335,221,739,1414,1238;33;F
78415;685,193,221,1238,422,459,461,963,286;25;M
78423;193,1234,1720,422,109,286,97;22;F
78433;339,260,119,109,1075,868,925,422,180;44;F
78444;1442,339,221,1628,286,1666,169,442,127,1720,1550,1238;34;M
78474;544;41;F
78476;1381,677,1238,925,459,685,963;42;F
78480;422,459,909,894,531,1214,660,440,539,868,1623,780,1238,925,434;44;M
78486;221,1720,544;50;F
78492;434,57,1699,1666,539,1236,1041,685,909,1720,1623,650,250,780,1238;25;F
78500;260,193,109;50;M
78522;868,337,780,925,1163,335,109,97,1666,1236,1238,119,193,553,442;75;F
78530;1666,544,1381,193,539,660,739;36;M
78534;1381,780,335,109,1234,1041,1238,1163,193,1720,1414,461,97;56;M
78547;260,660,539,337,1238,544,57,321,780,221,339;44;M
78560;286,531,1234,1381,539,660,244,633,685,1199,193,1720,677,1623,925;48;F
78572;446,1238,1628,422,154,434,97,700,1666,1699,1149,339,442,925,544;42;F
78581;660,539,337,1720,274,221,1550,127,446,544,97,1149,1153,1628,286;39;M
78590;335,260,633,1414,1720,1666,868,1238,925,422,109,1075;38;F
78598;339,260,626,335,1075;28;F
78618;1234,780,1240,1238,544,894,739,660,127,1720,221,925,1628,286,57;27;M
78624;446,925,544,422,57,169,1623,531,286,1414,337,1720,321,1666,1238;35;F
78635;650,1149,169,1442,674,553,539,567,1041,274,1240,897,221,544,909;28;M
78641;170,674,660,1623,221,1550,1238,286;42;M
78672;1217,553,57;47;F
78704;1041,677,868,685,1238,1236;44;M
78706;260,1720,1016,250,1240,1550,909,286,1666,221,1238,925,1163,544,109;44;F
78719;567,1720,221,286,531,739,250,274,422,1699,1628,660,539,650,1217;56;M
78736;1623,1238,544,459,1075,909,286,434,321,57,1699,700,1666,1236,1153;26;F
78748;57,286,1240,868,1414,119,1234,1199,442,650;27;M
78752;650,567,1199,337,780,1238,335,109,180,909,286,894,57,1699,1236;43;M
78759;739,169,127,1623,221,1163,286;51;F
78789;626,1234,57,1623,780,274,459,700,739,674,660,221,1628,544,286;39;M
78863;539,567,1623,897,221,1238,544,286,1236,1240,1217,739,260,626,660;19;F
78868;739,1490,1217,1214,335,274,119,868,440,1221;38;F
78871;339,1217,1490,739,626,539,567,1720,1414,221,1238,544,109,286,97;26;F
78906;1628,650,739,180,446,553,1623,1221,925,539,274,567,909,897,1153;36;M
78909;1238,1234,739,1221,626,660,440,1199,1720,1623,221,1628,544,422,1153;56;F
78917;1666,221,1238,422,109,1075,286,894,1153,1149,446,260,868,544,97;35;F
78927;446,633,739,660,193,221,1550,1628,544,286,674,700,97,1149,1153;26;M
78945;1149,339,539,700,1236,674,626,660,221,1238,1163,286,97;44;M
78955;1238,109,700,1214,260,567,193,1163,422,909,57;70;M
78958;446,739,1149,633,650,170,127,1238,286;37;M
78968;422,700,446,260,193,868,337,1720,1623,1238,925,1628,544,286,97;42;M
78977;739,660,193,868,1720,1623,221,1550,925,1163,109,286,894;46;F
79025;780,897,544,180,909,286,1699,700,1666,1217,1214,1221,660,567,1238;31;F
79061;440,337,739,660,193,868,1720,1623,221,1163,109,286;50;M
79069;1199,1666;69;F
79072;1288,925,335,544,1075,700,339,739,442,1199,1720,1414,1623,531,1666;25;M
79087;1217,739,626,660,193,1234,868,1720,1623,250,897,1238,925,1163,1628;57;F
79089;925,1623,567,909,97,446,739,660,440,539,1720,221,1628,286,1153;37;F
79091;170,660,193,127,1720,1041,1550,1628,286,1236;18;F
79135;674,442,539,1720,1623,221,1238,1628,544,109,286,531,321,700,1153;51;F
79136;1217,169,553,539,567,1199,337,1720,1236,544,461,909,286,97,57;43;F
79138;1217,567,1234,1720,1414,1238;22;F
79144;461,446,260,674,553,442,193,337,221,1288,1163,180,97,700,1666;68;F
79228;1550;43;M
79240;1234,1238,1288,544,1075,286,339,260,573,868,119,337,221,335,109;44;F
79243;193,539,440,660,446;60;M
79260;539,677,274,250,1240,221,1550,544,422,286,909,925,567,1041,897;35;F
79263;260,1442,1720,109,1075,286,1153;54;F
79269;127,567,1217,650,1214,244,440,677,1623,780,897,1628,422,963,1236;21;M
79293;446,544;54;F
79301;1153,700,97,286,180,1075,422,1238,1234,1381,446,260,553,1720,109;44;M
79310;544;79;M
79316;446,260,193,868,337,1720,1623,1238,925,1628,544,422,286,97,700;10;F
79342;422,180;2;M
79355;1490;25;M
79358;909,57,868,1234,1381,440,660,1217,286,1288,1238,1623,1199,739,1214;46;F
79361;1240,1720,531,700,1628,1288,1550,1199,440,685,674,677,1238,109,286;48;F
79368;446,260,193,868,337,1720,1623,1238,925,1628,544,422,286,97,700;4;M
79370;446,553,567,1381,127,868,1720,626,674,440,221,1628,544,57,700;39;M
79372;925,1163,109,700,1217,633,739,553,567,1720,1238,544,286,531,1153;32;F
79378;660,626,739,685,1199,1720,780,925,1163,335,544,894;43;F
79381;1199,633,1381,925,1234,1093,868,1720,677,1238,109,1075,286,531,1666;49;F
79386;650,539,739,660,553,567,193,1720,221,1628,544,180,286,894,1699;36;F
79390;739,674,660,440,442,539,1381,1199,1234,1093,1720,544,531,1666,700;58;F
79407;422,180;47;M
79412;446,260,193,868,337,1720,1623,1238,925,1628,544,422,286,97,700;41;F
79438;1666;64;F
79448;685,1236,1238,739,1221,660,440,539,1720,677,1623,1240,1550,221,286;26;F
79457;339,660,539,1199,1381,1720,1016,1240,1550,1238,1666,1236;34;M
79463;553,567,897;23;M
79470;260,1238,544,109,286,1236,739,660,1199,780,1550,1628,1153;44;F
79481;286;38;M
79485;1666;68;M
79498;1666;41;F
79499;260,573,868,1414,1623,1016,1699,650,337,1720,250,1238,109,286,894;39;F
79502;119,1381,1199,660,739,650,1217,626;92;F
79514;1666;13;M
79520;780,1238,274,57,650,260,422,109,1075;40;F
79528;1666,180,459,553,1238,567,894,1075,1628,1381,539,909,1217,1720,193;19;F
79531;1666;10;M
79555;1414,780,544,109,1666;14;M
79570;286,1240,1623,1238,127,446,1550;50;M
79596;339,739,626,553,1234,1093,1720,1240,1550,925,1163,1628,544,97,57;32;F
79622;321,700,1236,925,1238,780,1414,1720,119,193,1199,567,539,660,339;20;F
79623;685,650,739,260,1442,553,567,193,250,1238,925,422,109,1699,1236;11;F
79624;685,650,739,260,1442,553,567,193,250,1238,925,422,109,1699,1236;8;M
79631;544;41;F
79640;339,442,1199,1238;31;F
79645;1240,1217,739,169,660,539,567,1199,1623,221,1550,544,909,286,531;32;M
79647;925,1623,221,539,567,909,286,440,553,660,260,1221,739,1217,1075;32;M
79649;1623,440,660,337,1720,286,894,260,169,127,868,1550;37;F
79666;169,446,1236,531,1623,633,170,674,442,221,193,544,286,1666,700;55;F
79667;1666;21;M
79673;1666;55;M
79684;1236;16;M
79694;127,567,55,650,626,660,539,1623,250,221,286;27;M
79724;1442,1041,286,434,57,1666,1153;45;F
79763;1442,660,539,1381,1234,868,1720,1623,221,1238,335,422,1075,925,894;33;M
79785;685,1720,1623,1016,897,274,1240,925,544,422,109,1075,434,57,963;35;F
79788;1149,674,1234,1720,286,531,97,1666,339,446,442,221,1163,544;50;M
79794;567,925,909;33;F
79871;109,1234,286,1699,700,685,1214,422,459,894,531,57,244,780,1628;49;M
79888;1666,221,109,442,260,1075,286;71;F
79903;539,170,461,1217,260,567,221,1075,909,109;49;F
79924;1550,1238,925,544,109,57,1666,1075,180,909,286,894,434,97,1153;58;F
79954;674,567,193,119,337,1720,1623,274,1550,1238,544,109,286,700,1153;32;F
79962;650,1149,739,674,221,1628,286,700,1153,660,440,539,1720,1238,544;50;M
79994;897,1720,169,539,127,57;24;M
80018;1623,567,1720,1041,221,180,544,109,909,286,894,531,1699,1666,1236;37;M
80025;339,1490,1236,573,868,119,337,1720,1016,1240,221,1238,925,335,109;46;F
80070;286,109,925,1163,1720,193,539,1442;43;F
80101;544,461,1075,57,1666,169,685;41;M
80127;1666;28;M
80137;739,660,553,567,1199,127,337,57,221,1238,925,335,544,909,286;7;M
80156;1623,1628,1240,1238,739,1236,531,286,221,169,127,1163,170,1720,1550;42;M
80173;1238,221,274,660,925,1016,1163,1240,1442,544,422,1550,1623,1720,127;37;F
80197;1442;8;M
80211;55,1149,626,1442,567,1199,127,119,1240,897,221,925,1163,544,286;25;M
80248;1442;41;M
80265;1628,1217,1149,739,446,674,539,700,660,440,1720,1623,221,544,286;45;M
80266;193,1550,1163,1199,440,660,674,1720,1623,221,1628,544,109,1075,286;42;M
80271;127,1381,442,440,446,739,339,170,660,1623;23;F
80273;446,739,1490,1214,339,868,119,337,1623,1238,925,544,1153;41;F
80275;1041;43;F
80297;459,909,531,57,567,868,119,1041,1623,780,897,1238,925,422,434;37;F
80308;780,1628,422,286,434,170,169,1093,868,1720,1550,1238,925,1163,894;19;F
80312;1550,925,1163,1628,544,963,531,1236,739,244,1199,1720,677,1016,1240;27;F
80314;446,539,1720,1550,544,286,531,700;47;F
80329;1149,567,119,1041,897,544,894,700;34;M
80339;1234,440,1217,244,1720,1623,739,660,539,274,1550,544,286,1236,1153;32;F
80345;1199,1628,274,544,461,1075,180,909,286,97,660,868,221,1238,925;33;F
80375;1041,274,1240,925,422,544,1236,700,97,909,1628,221,780,660,739;36;M
80383;1234,1016,1240,1236,739,633,169,1623,1550,780,650,180,553,422,1720;34;F
80386;193;23;F
80389;1163,127,660,567,459,335,57,1016,1381,193,539,260,739,1720,1628;23;M
80393;1149,446,260,674,544,286,97,1153;5;F
80423;700;23;M
80434;539,685,1217,739,244,674,660,677,1016,274,1240,221,286,700,1236;76;M
80440;626,57,286,1628;38;F
80460;286,1221,739,1217,650,660,440,539,1199,1720,1623,221,925,544,321;26;F
80484;925,286,1699,1236,1666,677,339,739,660,573,539,1199,1623,250,1238;29;F
80485;1699,1666,1236,170,339,573,868,1199,1720,1623,221,1238,1628,1075,894;32;F
80514;260,739,339,633,170,1414,674,539,1234,1093,1720,1550,1163,909,286;58;F
80516;626,1199,868,1720,897,1550,1238,1163,335,1149,446,193,544,97,1153;32;M
80598;446,260,1381,1234,337,1041,1550,422,894,674,1720,544,97,700,1666;47;F
80607;446,1199,868,1720,1238,1628,544,422,894,97;34;F
80628;1623,909,780,1720,626,57,1628;33;F
80635;286,909,180,1163,221,1240,274,1720,193,567,539,553,660,1221,739;77;F
80640;446,1149,260,674,544,286,97,1153;6;M
80684;461,1550,286,567,868,1238,925,1628,544,459,337,553,660,260,1075;38;F
80686;1149,446,260,674,544,286,97,1153;39;M
80694;274,260,109,1236,1238,677,780,1623,685,1720,963;37;M
80701;626;32;F
80705;1214,1217,868;43;F
80724;1199,260,119,1720,1238,1288,925,335,544,109,1075,286,531,57,1153;40;F
80739;1623,1550,127,286,531;26;F
80812;260,1623,1016,1240,925,154,109;67;F
80817;1163,1016,1217,1288,1628,286,650,660,539,1199,1720,1623,1240,221,1236;58;F
80827;446;45;F
80830;544,154,1217,739,660,539,567,221,1238,1628,335,1075,909,286,57;27;F
80845;633,739,660,442,539,1199,1381,1234,1414,1016,1240,1550,1238,286,1666;37;M
80855;57,55;28;M
80858;739,244,660,337,1414,461,1016,1240,1238,1163,963,1236,539,119,1623;26;M
80859;97,1149,1153,1381,1238,1550,1720,446,544;48;F
80860;1153,531,739,660,127,1623,780,1240,1550,459,544,286;30;M
80864;1149,446,626,674,660,440,1720,1623,221,1550,1628,544,97,700,1153;48;M
80870;567,1199,553,868,1240,221,1238,925,1163,109,1075,286,97,260,1381;45;F
80885;446,553,539,193,1720,1623,461,180,286,97;18;F
80890;925,1238,897,1623,539,553,660,626,739,1217,650,909;31;F
80893;1550,544,422,434,1699,1217,1214,1490,1221,553,567,1199,1238,180,909;29;F
80916;1442;29;M
80937;119,260,244,1720,1016,1240,1628,109,286,57,1236;35;M
80956;1041,897,739;23;M
80964;1238,1163,459,57,1236,1628,553,650,539,567,1199,780,221,1720,626;34;F
80978;739,193,1623,461,97;10;F
80984;422,925,221,1240,1623,1199,567,440,660,674,1221,339,739,446,539;34;F
80985;286,422,1623,1414,446,674,544,97,700;34;M
80995;650,539,57,1221;33;M
81038;1623,221,250,1699,1041,925,1238,897,274,1720,868,567,573,442,909;29;M
81046;660,57,442,221,1238,180;72;F
81053;925,963,434;33;F
81059;260,868,1214,780,1075,109,909,434,57,1240,1238,180,894,1666,553;35;F
81060;1217,1720,1623,1550,1414,1238,1199,1163,739,700,674,544,539,531,440;70;F
81070;193,1623,461,180;77;F
81083;539,127,1381,97,739,1199,1234,1720,1623,274,1240,221,1550,1238,1628;35;F
81086;1217,739,567,1720,897,97;25;F
81115;1238,544,1236;47;F
81148;260,660,440,539,1234,780,221,1550,1628,286,531,1075,109,1238,1720;39;M
81152;626,674,1628,700,446,544;42;M
81169;660,626,446,780,221,1238,544,97;54;M
81178;1699,434,925,677,1414,1623,1016,274,250,1240,685;72;M
81197;434;4;F
81202;109,446,674,553,539,337,1628,544,700;43;F
81228;169,260,446,633,739,1041,1550,685,1666,1720,1238,1623,221,286,677;22;M
81233;925,434;11;M
81235;650,1217,553,539,1720,1623,1550,925,180,909,739,626,660,567,1238;29;F
81237;925,1550,274,1623,1720,193,1199,539,660,169,739,1217,170,55,221;23;M
81241;221,963,739,260,539,119,1163,286,339,1720,677,1240,1238,109,1236;31;F
81243;1720,1238,1153,1149,925,674,544,286,260,221,97;35;F
81261;339,260,1199,1016,1238,1628,544,109,286,57,1153;35;F
81262;925,1442,1234,780,170,1550;30;M
81291;1214,539,780,1238,335,422,459,57,1236,1217,739,567,1628,97;30;M
81296;739,660,553,442,193,677,1016,1240,897,1163,1628,459,963,1699,1236;39;F
81309;1381,1720,1628;35;M
81336;1153,1149,97;53;M
81354;567;32;M
81369;567,193,1720,1041,1623,1016,274,250,1240,221,1163,461,963,650,780;46;M
81371;250,1720,1234,1199,539,573,660,260,739,1149,650,170,286,894,1238;34;M
81390;963,1236,1163,422,1240,1016,677,337,868,539,244,685,925,434;40;F
81393;650,660,739,1041,1623,274,250,897,221,1628,422,909,286,57,1153;33;M
81425;1149,1442,193,925,544,97;35;M
81434;1623,1288,97,700,446,1381,1720,1414,1550,1238,925,1163,335,544,1153;48;F
81458;1623,250,685,650,739,127,1240,1238,335,422,109,531,57,1666,1236;44;F
81475;626,544;69;M
81498;1149,1550,335,1238,544,109,97,700;47;F
81517;260,1234,1199,1720,422,109,660,677,1240,221,1550,1238,1628,286,1236;42;F
81524;685,897,963;62;F
81541;1149,1093,700;59;F
81562;626,442,544;72;F
81569;1217,660,274,1240,221,1550,286,531,1236;50;M
81575;1153,170,244,1199,1623,780,1016,1628,544,739,660,440,539,221,286;47;F
81577;1149,127,221,1628,544,434,97,700,1153;15;M
81588;442,1093,337,422,674,868,1238,925,1075,700,1666,1149,97,1153;36;F
81597;1149,1490,685,1381,1199,1720,780,274,250,925,1628,544,1238,57,1666;47;F
81604;57,335,1490,1199,193,1234,897,1720,1041,1238,925,422,459,1075,434;41;F
81615;544,1075,286,894,700,1666;56;F
81623;1199,573,260,170,434,739,244,274,1234,1238,154,109,963,1075,909;41;F
81624;1628,1221,1442,1041,780,1240,897,1153,1149,119,1720,1623,909,1699,1550;16;M
81626;221,925,1217,633,260,660,440,739,573,1016,1240,109,1075,286,1236;57;F
81629;1153,442,868,221,1238,109,1075,650,660,1199,1234,1720,925,335,1666;39;F
81633;1238,1163,1628,1550;41;F
81635;180,109,221,1016,1623,677,127,539,440,553,660,260,1221,739,650;51;F
81651;286;29;M
81664;1217,339,626,674,567,193,127,780,221,1238,1163,1628,544,57,700;46;M
81666;1234,868,119,1720,1623,780,1238,1628,109,57,1153,221,286,544,700;39;F
81674;674,1623,1550,1628,544,57,700;77;F
81677;1238,925,894;24;F
81688;1221,169,897,221,909,57,1214;29;M
81724;868,1075,531,1550,221,1623,1720,539,440,660,169,260,739,286,109;45;F
81727;1288,1628,1075,1666,1236,633,1217,553,1199,1720,1623,221,1238,335,544;28;F
81728;677,1414,1623,274,897,925,109,1720,260,660,1016,1240,1550,1075,1236;48;M
81738;674,1199,193,1238,1628,544;28;F
81740;337,1720,1041,1016,897,221,1238,925,335,422,109,459,1075,434,57;5;F
81748;660,440,539,1234,119,1623,780,1240,221,1550,544,459,1666,286,1153;76;F
81760;650;48;F
81761;1234,1199,260,650,1217,739,660,127,897,221,1238,1628,544,286,57;20;F
81763;440,626,1221,446,1214,1217,633,170,650,660,1550,1628,544,57,1236;25;M
81770;1550;30;F
81781;1666,321,674,260,739,339,1199,1720,1623,780,221,1238,544,286,57;41;F
81782;1628;44;M
81789;446;66;F
81816;1720,1414,221,1550,1153,1149,339,1628,335,544,446,1238,739,660,440;34;F
81817;660,1550,925,539,1199,193,274,897,221,1238,544,286,531,321,1666;35;F
81827;685,739,244,660,539,677,1623,1016,1240,1628,459,57,1236;28;M
81829;1623,119,868,660,170,650,685,446,1016,1240,221,925,544,963,321;40;M
81835;1075,180,894,531,434,97,1699;42;M
81851;677,119,739,1442,1199,868,1623,1238,109,244,260,660,1016,1240,1236;33;F
81860;674,1666,1628,1217,531,260,109,1075,1234,1199,286,440,221,1720,1623;44;F
81868;739,244,260,1199,868,119,677,1623,1016,1240,1238,109,1236;42;M
81901;925,434;7;M
81919;567,539,442,739,169,660,221,925,909,286,434,1153;46;F
81931;925,434;1;F
81932;539,660,739,1720,1240,1016,1236;48;F
81942;337,544;49;M
81943;626,660,539,1623,274,1240,221,1550,1238,1628,544,909,286,321,1236;33;M
81964;260,925,434,109,739,337,1238,335;40;F
81966;446,544;28;F
81968;1075,57,97,180,440,626,739,633,553,573,193,1381,868,1238,1163;37;F
81975;1628,963;47;M
81977;1199,221,544,1381,339,1490,260,868,337,925,335,422,109,1075,97;51;M
82002;1666,1699,97,531,286,894,739,660,440,567,1623,897,909;44;M
82008;57,337,335;44;M
82025;193,1238,286;42;M
82037;260,1234,154,677,1623,685,109;41;F
82045;660,1199,567,1623,221,1238,925,1075,286,97,57,1699,1217,337,897;50;F
82065;1550,660,244,739,650,1623,1221,1217,1016,1240,677,567,1720,1628,1236;61;M
82117;539,1381,1234,1093,1720,1550,1238,1163,335,1075,1666,1236,244,1240,925;38;M
82119;274,1240,221,544,109,909,531,1699,339,1199,1217,1623,567,1238,286;30;F
82121;660,1149,193,544;42;M
82129;1442,1236,660,553,119,337,1016,1240,221,1288,335,963,180,286,1666;64;F
82162;531,1628,193,1720,1163,1550,127,1238;39;F
82178;544,894,1666,1720,780;37;M
82191;446;68;M
82195;1238;25;F
82199;553,1221,539,193,434,274,909,567;22;M
82215;1442;42;F
82252;539,1199,1240,1016,221,1550,1238,1288,57,422,459,286,894,1666,1236;57;F
82261;1442,1720,925;21;M
82310;626,573,539,1199,119,1414,1623,1238,335,109,1075,57;74;F
82312;286,544,626,1623,434,250,650,1217,1221,1214,274,909,1238,1720,260;32;M
82315;119,1199,567,1217,1214,260,626,660,539,1720,1623,221,544,286,440;31;F
82339;260,250,221,1238,335,109,286,531,1623,1163,1720;27;M
82346;1414,1016,1240,1550,1666,1288,1163,1628,1236,739,1490,1623,1238,894,1153;21;M
82356;1238,553,1628,544,286,97,626,674,660,440,897,1550,894,567,127;34;M
82374;260,109,339,1199,119,422,925,1163,335,1666,1234,1720,1238,1075,97;41;F
82382;422,1666,925,1628,539,221,674,440,780,739,1199,1720,1623,1238,544;43;M
82414;335,57,1236,1442,119,1238,339,1720,1016,1240,1550,894,260,109,1075;46;F
82456;685;8;F
82494;633,539,739,244,660,440,1720,1623,1016,1240,221,1550,286,531,1236;47;F
82499;650,1016,925,963,1236,1699,739,1442,1623,250,1550,1163,335,422,894;26;M
82511;1442;48;F
82524;1490,1149,446,660,573,539,1288,109,459,1075,286,1153,1238,544,97;42;F
82538;170,339,739,700,1163,1550,274,1623,127,539,440,660,674,169;38;M
82561;422,868,677,221,1238,335,286,674,925,1628,97,1153,446,544,700;49;F
82562;650,685,739,169,660,1720,1623,1240,221,1628,109,963,286,531,57;40;F
82583;1381,674,446,544;49;F
82584;1666,1628,422,459,57,1149,446,337,1623,221,925,544,97,700,1153;40;F
82619;739,260,660,539,1628,193,1720,1240,221,925,1163,109,1075,286,1236;46;M
82654;1217,660,539,567,894,434,531,1699,1041,1623,250,221,925,909,286;25;M
82669;868,1381,193,567,539,440,459,422,544,335,1628,1163,925,1550,221;44;M
82675;739,660,539,1240,286,1236,169,260,1234,1623,780,1016;20;M
82678;739,260,660,1623,221,1238,286;36;F
82697;633,739,660,442,539,193,1623,1016,1240,221,1163,109,286,1236,1666;66;F
82716;440,553,660,169,260,244,1217,633,739,286,1699,1075,1720,1236,1153;67;F
82733;1442;41;M
82742;677,335,339,739,1234,868,119,780,221,1238,925,1628,544,422,286;22;F
82750;193,780,1628,544,57;30;M
82751;1666;65;F
82756;894,544,1550,1240,274,539,660,169,626,1221,446,1149,739,1217,685;23;M
82769;459,531,193,660,739,169,440,539,127,1720,1623,780,221,1550,286;45;M
82785;573,539,1199,544,925,1623,1550,1238;27;F
82786;446,1288,422,1075,909;20;F
82806;739,1720,677,1041,1623,780,1016,1240,221,422,154,109,286,57,1236;50;F
82830;567,1199,1623,274,925,180,909,57,1217,660,440,539,193;30;F
82841;1199,1238,57,544,1163,700,1666,260,660,780,109,1236,739,685,1240;18;F
82844;1442;8;M
82849;1149,1442,119,250,461;29;M
82855;633,440,539,567,1199,1623,780,274,897,925,109,459,909,434,57;40;M
82861;1550,1238,925,544,1075,660,442,677,1016,1240,221,109,461,286,1236;57;M
82862;553;62;M
82879;1442;4;F
82880;660,674,1221,739,339,650,1238;30;F
82887;780,1288,1720,553,221,180;82;F
82891;650,339,1720,337,221,1238,925,1628,109,1075,286,321;45;M
82939;539,440,660,169,626,260,1221,739,1217,1236,286,1628,221,1720,1199;36;F
82944;674,780,221,1628,544,422,459,97,57,700;47;F
82948;1236,894,650,1217,1221,660,539,193,1720,780,1016,274,250,1240,897;39;M
82949;1720,119,1381,440,1217,897,1623,567,539,660,739,544,909,286,1236;28;F
82965;1623,1163,193,868,1550,544,154,286;36;M
82988;461,1075,180,909,286,894,321,650,1442,1414,553,193,626,57,1666;45;F
83005;739,660,1199,868,1720,925,434;52;F
83030;1238,109,286,531;33;F
83048;553,1720,1288,180;83;M
83052;442,440,660,169,260,739,339,633,650,274,1238,925,963,1699,1666;31;M
83062;925,180;23;F
83101;446,442,544,1666;59;M
83102;55,739,169,660,539,1199,1623,274,1240,459,286,909,531,57,1236;32;F
83105;446,660,440,1199,1163,1217,553,442,1720,119,337,1623,274,221,1238;44;F
83137;925,286,434;40;F
83141;539,1234,1720,1623,221,1163,286,1238,1288,544,531,1666,442,1199,119;66;F
83152;700,339,260,1442,660,1199,193,1720,1623,221,1550,1238,925,544,109;48;F
83155;1217,260,553,539,567,119,868,1623,780,897,1238,422,109,1075,180;8;F
83162;250,221,1238,925,1628;25;M
83163;459,97,57,1666,260,193,1720,274,250,897,1238,544,109,1699,1236;33;M
83208;539,440,244,1666,1236,650,660,1199,677,1623,780,1016,1240,221,286;48;F
83260;193,434;52;M
83264;660,169,274,1550,286,1236;40;F
83275;1221,909,221,567,1628,1214,274,57,739,1217,539,1199,1623,544,193;45;F
83283;531,739,1442,440,539,337,1623,221,1238,422,1075,286,97,260,109;13;M
83294;260,169,674,553,440,1720,1623,221,335,660,567,1240,544,909,286;30;F
83326;1221,626,660,553,539,567,780,1623,274,221,544,180,286,909,57;38;M
83339;660,244,1214,633,739,440,539,780,1623,221,459,286,57;46;M
83382;539,260,244,339,633,739,660,1016,1628,221,1238,109,286,1236,677;40;M
83389;739,660,440,539,1199,193,1720,1623,1240,221,1238,1163,544,286,700;15;F
83390;739,260,660,440,539,127,1720,1623,1016,1240,221,1628,286,1236,685;47;M
83397;674,1720,780,221,1550,531,700,1238,544;37;F
83414;925,434,544,868,897;38;M
83427;1217,739,660,553,440,1093,1720,1240,221,1238,1628,180,434,1236;31;F
83450;1720,1414,1628,1666,909,1238;41;F
83484;650,55,660,674,553,440,539,567,119,337,677,1720,739,1236,1442;66;M
83492;193,1720,1623,221,1238,286;27;M
83496;739,660,539,1240,221,544,286,531,434,57,700;29;F
83497;250,544,633,1217,739,1623,1240,286,531,1153,660,1720,221,1550,321;33;F
83502;1550,221,1016,119,868,1234,1381,170,685,260,1720,1623,544,109,321;53;M
83541;1149,440,1381,1720,274,925,321,193,97,739,660,1623,221,286,1666;22;M
83548;539,1199,127,119,1720,1623,780,221,1550,1238,925,544,459,286,57;23;M
83556;1238;21;F
83571;626;38;F
83579;1199,1075,567,1720,221,97,109,1628,286,1623,1163,1153,674,440,446;37;F
83585;1041,897;27;F
83603;1720,127,660,626,739,1217,650;50;F
83618;739,660,221,925,544,286;31;M
83631;221;43;F
83634;1240,1381,1234,1550,1720,1414,1623,897,1238,925;24;M
83658;1163,894,1666,170,739,660,440,442,539,1093,1720,1623,221,1550,1238;32;M
83678;442,573,539,1016,739,1720,925,286,440,109,1623,780,1628;38;F
83684;170,739,539,1199,1093,1623,221,1163,459,286;28;F
83690;1149,446,260,674,1199,274,925,1163,544,1153;44;F
83709;685,339,660,442,1199,1720,1623,780,221,1550,1238,925,1628,544,286;55;F
83710;780,193,440,660,169,260,1149,650,739,539,567,1623,1238,925,909;24;M
83724;897,1238,461,1075,260,868,677,1623,422,109,963,894,1666,1236,685;39;M
83754;260,567,909;44;M
83802;446,1199,1234,868,119,337,335,544,422,109,1075,97;37;F
83803;446;33;F
83824;260,109;57;F
83860;446,573,337,1414,1628,544;42;F
83861;109,286,1550,1238;42;M
83870;1199,1720,1623,539;46;M
83882;1236,1238,221,1240,250,274,780,1623,1041,1381,539,660,739,286,1699;29;F
83899;633;40;F
83909;1720,1234,739,260,660,1199,193,119,1414,221,1238,1163,109,461,286;45;F
83916;260,109,286,1199;52;F
83960;1236,1041,274,250,925,897,221,1238,335,1699,422,109,909,286,434;39;F
83978;1720,650,1699,626,544,1628,531,1236,1666,700;34;F
83981;1550,925,553,674,1217,633,1442,1016,1240,1288,544,963,180,1666,1236;11;M
84001;193,1442,553,1720,180;74;M
84004;650,553,119,1720,1238,335,544,109,180,286;51;F
84022;739,260,660,440,539,567,1234,1720,250,221,109,1075,909,286,434;16;M
84037;1720,1041,780,1016,897,1240,925,109,1075,286,1236,260,1442,868,1199;40;F
84042;321,700,626,553,440,1238,1628,894;34;F
84047;1666,1490,1720,286,97;24;F
84082;286,1149,674,97,700,1153;32;F
84107;925,1075,422,260,553,1093,109,180;44;F
84122;660,677,1623,1016,1240,154;39;M
84126;963,170,660,440,539,1623,1720,221,1240,1016,286,1236;53;M
84132;553,193,1623,925,544,109,180;49;F
84133;446,544;38;M
84134;170,660,442,539,193,1720,1623,1550,1238,286;65;F
84141;660,739,446,626,674,1199,1381,868,1720,221,925,1628,544,700;33;F
84155;459,221,1623,739,1149,660,674,127,544,97,286,446,57,1153,700;59;F
84163;1720,1550,925,422,459,894,97,321,57,700,1153,1149,674,1628,544;55;M
84176;1238,780,1236,1720,677,1234,739,1016,1240,244,1550;24;F
84182;626,660,440,1720,1623,780,221,1550,925,1628,544,422,1075,57,1153;49;M
84196;339,446,626,1199,119,868,337,1238,925,544,422,97;21;F
84216;1016,633,1550,170,700,909,1442,286,1623,1236,1163,1628,1240,780,1199;25;F
84230;260,553,1093,925,422,109,1075,180;1;M
84242;868,1623,221,1238,109,1075,446,925,335,544,422,154,286,97,1153;38;F
84274;221,1550,1628,180,531,286,434,1666,260,553,539,567,1199,1093,1238;25;M
84281;335,1236,260,1234,677,1240,1163,109,739,1442,539,1720,1623,1550,1238;29;F
84283;660,169,1149,674,539,337,780,1623,459,286,97,700,57,1153,446;63;M
84284;422,180;55;F
84298;170,539,1381,868,221,1238,286,573,1442,739,633,55,660,1623,1240;46;F
84301;1442;37;F
84302;434,169,440,1217,1550,1720,674,1199,1623,221,1238,544,286,700;18;F
84307;1149,1153;44;M
84313;650,1217,739,660,442,567,1666,260,539,1720,1623,221,1238,109,286;42;F
84318;739,1149,169,660,539,127,337,780,1623,459,97,57,446,700,1153;21;M
84343;868,1381,539,660,260,739,442,119,1720,677,1623,925,109,286,1666;67;F
84369;963;53;M
84370;1623,739,1240,1016,677;35;M
84379;539,1381,1234,1093,1720,677,780,1240,154,963,286,1236,633;32;F
84382;1720,1016,1240,221,1550,1288,925,335,544,963,180,286,1666,1236,1442;41;F
84403;567,127,1240,221,1550,1628,544;34;M
84416;1628,677,1623,286,633,739,244,660,539,1199,1720,1016,1240,1238,1236;58;F
84417;1666,739,674,660,440,193,1720,1623,221,1238,544,459,286,531,1153;52;F
84420;339,1093,925,434,544;49;F
84445;650,567,127,897;40;M
84463;260;72;F
84483;674,700;35;F
84498;700;35;M
84508;660,553,440,1016,221,1238,422,170,739,539,193,1720,1623,1550,544;24;F
84530;531,1163,1623,1720,169,1217,739,660,440,539,567,221,286,97,909;30;M
84566;1720,1414,1016,274,1240,221,1238,335,109,1075,180,286,531,97,1236;38;M
84567;221,897,1240,1016,1720,193,539,660,739,633,1623,286;30;F
84592;1628,1623,1381,1550,1238,1720;36;M
84599;660,440,539,1093,1623,274,221,544,109,1075,531,1720,1414,1238,286;25;F
84629;1238,1623,1720,119,1093,442,339;24;F
84633;1238,119,1720,1623,1240,633,1234,1016,868,1093,1075,260,109;80;F
84638;1016,1550,1628,461,700,193,1720,1623,780,221,1163,544,459,321,57;33;M
84640;55,1221,260,442,567,1093,868,119,1720,1550,1238,109,1075,909,286;71;F
84684;97,674,700,446;36;M
84737;1623,221,1238,1628,544,894,434,700,339,1149,868,119,925,97,1153;32;F
84738;1720,1199,660,1217,1414,1623,274,250,1238,335,544,286,434,57,97;28;M
84746;650,1442,442,539,868,1720,925,544,422,1666;41;M
84747;780,274,286,1623,677,337,440,57,685,700,1699;13;M
84765;339,335,739,440,868,337,1623,221,1238,544,459,1075,286,1666,1381;35;F
84768;868,1720,1623,780,274,250,127,119,925,544,459,894,57;51;F
84770;1240,1550,1238,1628,1163,544;32;M
84776;685,442,567,119,677,1623,1550,1238,925,544,963,180,909,1666,422;65;F
84784;1199,868,544;29;F
84786;1720,57,1628,193;34;M
84818;1217,260,539,868,1093,553,442,567,1623,650,573,1699,909,1153;70;M
84834;1414,339,1720,1016,109,1236,1666,1238,1550,868,1199,539,660,739,1217;26;M
84875;1414,274,1628,335,1075,286,531,97,1699,260,1199,1238,544,109,1666;32;F
84876;55,739,169,539,1199,909,1217,650,1623,170,567,1666,1720,1221;84;F
84884;780,1623,1628,459,286,57,1236,55,650,169,897,894,170,1550,127;44;F
84887;286,531,1666,1236,260,339,739,660,1199,1234,1720,1240,1550,1163,1238;24;F
84896;1199,221,1163,109,286,531,1236,339,660,1234,1720,1240,1550,925,1238;53;F
84904;221,544,531,260,567,868,1041,274,897,1550,1238,109,909,434,925;33;F
84905;440,1720,1414,221,286,1236,539,660,339,739,1199,1240,1550,925,1238;17;F
84906;434,461,1238,780,1381,1199,626,446,170,55,193,119,1041,57;50;F
84918;1236,1199,650,739,260,1238,1628,109,180,286,1163,1623,633,1550,170;31;M
84945;739,660,440,567,539,1720,250,1240,221,1550,1628,544,422,286,1236;38;M
84958;677,1016,531,321,286,1217,626,539,1623,274,221,180,1720,422,553;24;F
84988;685,539,925,109,286,531,1236,339,260,169,1199,1720,1238,1550,1163;74;F
84989;739,626,339,660,1199,868,1414,1623,780,1550,1238,925,109,180,57;28;F
85005;700,739,674,660,539,1720,1623,221,1550,925,1628,544,286,531;41;F
85025;739,1442,1075,531,1666,339,260,573,1199,1234,1550,1238,109,446,544;40;F
85051;169,660,573,677,170,1550,244,1234,780,1236,1016,1623,633,739,1240;46;M
85073;260,567,868,1041,274,897,221,1550,1238,925,544,459,909,531,434;33;M
85082;633,539,119,1238,97,1666,1153,1720,868,193,1149,446,553,440,544;43;F
85084;1442,660,440,539,567,1720,1623,1240,221,1550,925,544,286,1236,1217;28;M
85087;925,434;43;F
85093;109,963,286,1236,221,925,180,1699,539,660,1217,553,1720,1550,1238;33;F
85096;119,1623,894;29;M
85129;1236,1550;40;M
85133;567,1041,109,909,1236,1016,633,739,244,440,660,539,221,286,531;39;F
85149;1149,544,97,1153;47;F
85150;868,260,109,286,1490,1199,1720,633,780,1240,1234,739,677,1623,154;39;F
85179;685,660,539,1381,337,1016,250,221,925;42;F
85187;1623,274,221,1550,925,286,531,97,700,1149,739,446,660,544,1153;52;F
85204;260,1041,925,109,434;58;M
85235;442,1240,221,897,1238,1288,1628,544,109,286,894,97,57,700,1666;72;F
85248;1214,260,567,119,925,109;42;F
85268;119;49;F
85269;553,260,1149,685,650,1221,868,337,180;34;F
85315;1628,170,55,553,1381,868,337,1720,1414,544,422,109,180,909,1238;72;F
85336;55,539,57,459,422,544,193,650,1199,250,221,286;26;F
85355;339,1217,739,626,660,539,193,868,1623,274,1238,335,461,1075,286;41;M
85359;1217,633,739,260,674,660,440,539,1234,868,1623,221,1550,544,286;44;F
85382;339,119,1041,1414,780,1550,1238,1288,1163,1628,544,109,286,700,1666;34;F
85407;650,244,260,169,1442,193,119,677,1550,1236,1163,1199,1720,1016,1240;54;F
85438;446;69;F
85465;154,1623,1240;39;M
85474;1442;68;F
85476;544,531,321,1236,169,626,739,1217,567,193,1720,461,909,286,57;26;M
85479;633,244,1221,1240,286,1236,440,539,1550,739,1623,221,321,660;33;M
85521;1240,739,633,677,539;25;M
85526;674,119,274,221,339,442,567,1234,1238,544,109,909,286,1666,1153;25;F
85534;1149,446,119,544,97;47;M
85552;1490;72;F
85556;1720,660,739,1149,650,170,260,1623,780,1240,1550,109,1236,57,894;61;M
85564;119,1016,1240,963,1041,286,567,739,57,193,1238,553,1214,1221,909;19;M
85565;1016,244,650,633,677,1623,1234,1163,739,1720,1238,1240,1236,1199,685;39;M
85573;1442;50;M
85574;1490,97,1442,1720,1623,1238,925,544,109,531,1666,442,553,446,1381;60;F
85598;1720,567,440,626,739,660,539,221,1550,1628,422,459,909,286,531;36;F
85618;1666,660,1221,739,1217,553,1381,1240,1238,925,109,1075,180,909,286;51;F
85622;894,539,440,739,633,1628,544,1236,660,221,1550,286,531,321,1153;44;F
85694;127,1720,119,909,422,57,1217,660,440,567,1214,1221,539,868,1238;34;F
85703;868,1550,1016,1442;70;M
85738;169,274,897,1550,1238,925,434;40;M
85741;894,1666,1234,633,1623,440,170,1199;32;F
85750;1623,925,739,660,539,868,1016,1240,221,1550,1238,1163,109,1075,286;43;M
85757;109,909,286,894,1153,55,244,660,1199,193,677,1016,1240,1163,1236;42;F
85767;154,650,1414,1720,626;35;F
85785;1217,739,260,169,660,440,539,567,1199,1720,221,1238,109,286,1153;35;F
85796;1075,180,909,286,894,531,434,97,321,57,700,1666,1236,1153,1699;22;F
85805;660,1623,221,1238,925,434;47;F
85825;909;54;M
85846;193,1199,660,626,1149,170,1628,459,57,1153;32;M
85852;1236,894,286,909,1016,1093,1442,339,739,660,1199,1381,1720,1623,1238;43;F
85862;339,1720,894;39;M
85903;539,925,286,97,1720,1628,544;43;M
85909;260,660,440,442,539,119,1720,1623,221,544,109,286,531,434,1666;69;F
85918;339,1149,739,260,660,440,1623,221,1550,1628,544,461,286;68;F
85946;909,1550,650,739,442,539,1623,1628,57,1217,1214,1221,567,1720,780;46;F
85974;739,660,193,1623,221,422,180,909,286,700;29;M
85978;339,739,440,573,539,1720,894;36;F
85980;1093,544,109,1075,339,700;81;F
86011;567,660,1217,739,539,1720,1623,274,221,286;41;F
86028;650,626,127,1628;37;M
86045;339,260,1199,1093,868,119,337,1720,1414,1238,1288,544,422,109,1075;45;F
86049;442,339,739,553,567,1199,1381,1093,119,337,1720,1414,1238,109,97;29;F
86053;539,1199,193,868,119,1623,1240,221,1288,925,1163,1628,286,57,1666;34;F
86075;1217,339,1214,1490,553,1093,868;4;F
86077;685,339,739,1623,274,925,434;12;M
86100;339,440,539,193,1720,221,1238,335,544,286;32;F
86106;170,674,119,868,337,1720,1240,1550,1238,335,544,109,1075,97,1666;76;F
86107;260,446,739,539,1623,1016,1075,650,553,868,250,221,1238,286,894;37;F
86108;650,567,193,780,1240,897,221,925,335,544,286;27;M
86119;442,193,422,1442,1720,897,1490;38;F
86130;180;46;M
86140;274,422,180;38;F
86145;339,1149,446,660,442,119,337,1720,221,544,286,97,700,1666,1153;74;F
86187;1016,1623,539,440,1490,633,739,660,442,1381,531,154,1238,1720,1199;26;F
86191;170,739,660,1016,1240,221,1550;36;F
86200;339,260,169,119,337,1414,1550,1238,925,1163,335,422,109,286,97;44;F
86211;339,925,1236,286,221,1720,1199,626,650,1550,544,567,897,1628,963;24;F
86216;286,459,260,109,1623,119,1093,1234,170,1199,169;55;F
86219;260,1623,1016,221,1238,925,422,109,459,1075,909,286,57,1666,650;37;F
86221;274,1240,539,440,660,169,1217,633,1628,531,739,221,544,286,700;60;M
86237;660,1623,274,1240,1550,925,434;14;F
86266;1217,633,1214,739,1221,660,440,539,567,1720,780,221,925,909,286;74;M
86268;55,170,1217,626,567,1720,897,1550,544;30;M
86281;650,739,660,440,539,1199,193,1623,250,221,1238,544,1699,434;22;F
86286;1041,1016,221,1238,154,459,286,57,1236,739,1720,677,1623,780,1240;41;M
86302;553,925,434;79;F
86306;633,339,739,660,440,539,193,1720,221,1075,286,531;41;M
86308;97,442,1221,739,553,1199,193,337,1720,1623,925,1628,180,286,57;54;F
86309;1550,897,250,274,1623,1720,1093,674,260,339,170,925,1238,544,109;23;F
86362;739,626,660,539,127,1720,1623,221,1550,1628,422,459,286,894,97;40;M
86374;1214,553,442,567,1199,193,119,337,1720,1623,925,1628,335,422,180;46;M
86375;674,539,1199,1623,780,221,925,1628,544,422,459,286,97,57,700;49;M
86377;1623,1016,1240,109,286,1236,1217,739,260,660,1720,274,221,1550,544;32;M
86389;1381,1238,700,260,1149,925,442,193,897,1720,1442,1490;67;F
86401;109,461,1075,442,553,633,650,119,250,1240,1550,335,544,180,1442;39;M
86406;339,260,573,1234,119,274,897,1238,1288,925,1628,544,1075,1666;42;F
86412;169,539,193,868,1550,925,544,909;45;M
86415;221,274,1623,1720,1093,1381,1199,539,660,169,739,1149,339,1550,1628;53;F
86420;169,539,127,1720,221,1550;57;F
86423;626,127,1623,1628,700,539,1199,1720,1238,544,894,1666;58;M
86432;1442;62;F
86452;1214,925,544;71;M
86475;440,567,1016,1240,221,286,1236,1217,739,539,1199,1720,1550,1238,544;27;F
86479;1442;42;M
86480;925,780,1041,119,868,1234,573,660,1490,442,739,339,685,1199,1238;45;F
86488;1550,1288,925,1490,1442,1381,1720,1238,544,109,894,531,97,1666;64;M
86500;170,685,650,442,119,1623,677,1240,1550,925,963,909,286,1699,1236;79;F
86502;1199,1720,544,422,459,97,1153,1149,446,780,335;29;F
86505;739,1623,1550,1238,1163,1236,925,1153;51;F
86545;422,1217,260,553,442,1199,193,1381,1720,221,1238,109,1075,180,1666;28;F
86597;1199;40;F
86603;1442;41;F
86636;339,244,1199,193,780,1240;42;F
86637;440,221,286,1221,1217,531,739,660,539,567,1623,1699,321,1236,1720;43;F
86639;539,221,1628,286;32;M
86640;127,677,1240,422,553,539,434,650,274,1221,1041,925,567,909,897;30;M
86670;1199,660,221,260,1221,440,544,97,1149,446,1381,1720,1550,1238,1153;35;F
86738;650,909,1221,119,1214,109,626,1217,553,193,897,180,57,274;41;M
86768;193,440,660,169,55,539,780,221,1550,339,1016,244,1623,1240,1236;63;F
86793;539,1016,221,1238,286,531,1236;48;F
86821;339,1720,1666,1550,1238,1163;46;F
86830;1442;9;F
86840;650,739,553,567,127,1720,780,221,1628,544,459,180,909,286,57;71;M
86850;1149,739,446,1075,286,97,1153;55;F
86872;626,127,1720,1016,1628,544;59;M
86884;260,674,1016,1628,335,544,700,1153;38;F
86893;677;51;F
86895;897;40;M
86906;677;57;M
86916;109,260;60;F
86923;1442;50;F
86924;685,339,193,1016,221,1238,925,544,109,963,1075,286,531,1666;45;F
86925;1240;46;M
86930;335,109,180,422;47;F
86934;531,633,739,660,440,539,677,1623,780,1016,1240,544,286,321,1236;25;M
86951;739,1623,221,1550,1238,544,461,180,909,286,531,1720,553,193,1163;58;F
86991;739,626,660,440,539,193,1720,1623,221,109,286;34;F
87008;1720,1153,1236,286,154,1628,1163,1238;51;M
87046;119,868,1234,539,660,739,685,573,1199,1238,925,335,422,459,57;10;M
87049;1149,739,446,260,674,544,97,1153;15;M
87058;894,286,544,221,1623,539,440,660,739,1720;48;F
87061;422,180;9;F
87097;422,180;7;F
87117;700;26;F
87124;1442;47;M
87135;626,1221,739,1217,650,685,55,442,1199,127,119,221,544,1666,286;43;F
87136;650,1217,260,626,660,1414,221;44;M
87139;335,739,1217,685,1442,660,553,440,539,567,1199,193,1720,1623,180;45;F
87143;193,1238,925,274,1623,633,440,539,321,286,739,660,1720,221,1163;44;F
87146;250,127,567,539,626,660,573,337,1414,1623,1238,1628,335,154,339;13;F
87154;440,573,1199,337,1720,1041,1623,274,1240,221,1238,925,286,434,1236;13;F
87171;440,1016,286,221,539,660,339,1217,1163,109,1075,894,739,1240,1236;40;M
87173;1199,868,677,1041,1238,925,1163,335,422,109,963,1075,286,434,1236;33;F
87177;1238,1623,650,109,1163,221,1381,97,286,1628,1720,260,461,193,180;46;F
87178;739,660,539,1623,274,221,1550,1628,286;37;F
87186;674,1550,1238,1628,422,544,700;76;F
87188;1153,1199,868,221,446,544;45;F
87195;539,660,739,339,1149,1442,1199,1234,1628,1236,1666,286,544,1238;31;M
87203;260,442,1720,677,897,109;64;M
87209;626,573,539,1199,1381,1093,119,1720,1623,780,1550,221,1238,544,286;36;F
87214;260,1149,544,97,109;41;F
87219;1720,1199,154,1550,170,633,1236,221,1240,780,677,193,539,660,739;33;M
87222;1720,221,1550;30;M
87225;119,868,553,1214,650,685,1442;40;F
87256;1199,1238;31;F
87269;1490,446,553,567,1381,1238,1628,544,422,180,909,286,1153,97;37;F
87270;221,286,650,539,1199,1720,1623,1016,274,1238,567,1041,909,925,434;40;F
87274;1238,567,1075,909;39;M
87275;626,539,925,286,894;16;F
87281;442,1199,119,337,1720,1623,544,446;44;F
87282;1442;49;M
87311;1221,1153,567,925,1217,339,260,539,1234,1720,221,1238,1288,909,57;19;F
87316;339,1238,1234,442,1217,1720,1221,553,539,567,1288,925,544,909,57;52;F
87333;531,1236,170,339,539,1623,660,193,1720,1414,780;44;M
87335;553,539,1234,868,1628,459,461,286;41;M
87337;170,674,440,539,780,274,221,1628,544,459,286,894,57,1153,700;42;F
87348;221,440,739,260,660,1720,1623,1550,1238,1163,544,109,1075,286,97;39;F
87362;434,1666,286,180,963,109,1381,553,193,539,440,739,660,260,685;28;F
87368;440,1550,780,1442,221,1240,1016,1623,1720,660,739,633,685,286,1236;41;F
87372;286,1414,1623,1381,442,335,1238,1234,1720,193,1199,539,440,553,260;31;M
87375;650,739,660,442,221,544,109,1075,286,57,1666;69;M
87390;339,260,442,1093;57;F
87404;650,660,440,442,539,1199,127,119,1720,1623,1016,221,1238,544,286;79;F
87410;1666,286,544,739,685,633,1016,422,180;29;M
87412;1442;45;M
87413;55,461,660,567,193,337,1720,1623,221,1238,909,286;43;F
87429;1490,553,573,193,1381,1093,868,1414,1238,925,335,422,461,180;9;M
87446;1075,1238,221,897,274,1623,1720,119,1199,442,339,260,660,539,567;21;M
87447;685,440,221,660,677,1240,154,739,539,1623;27;M
87453;434,57,1236,660,440,539,677,1623,780,1016,1240,221,154,963,286;1;F
87458;897,1550,221,963,1238,274,127,1199,170,1442,250,925,1163,544,1699;32;M
87481;274,650,260,626,1442,553,1199,193,1163,422,109,1075,97;36;M
87482;1442;22;M
87511;1163,335,180,909,97,1236,660,739,1217,193;23;M
87514;909,739,567,274,539,894,660,1240,1623,221,286,1217,1720,109,1236;46;M
87520;1217,1221,539,567,1199,274,221,1628,909,286,339,119,1288;33;F
87530;57,180,193,286,459,539,553,567,739,780,909,1214,1240,1550,1628;51;M
87533;567,193,1623,780,925,459,180,909;18;M
87562;660,925,1628,1236,868,109,739,1221,539,1720,1623,221,1238,909,286;31;F
87610;544,1153,446;39;F
87619;1490,553,442,573,567,1093,868,337,1414,1238,335,422,461,180;11;F
87620;626,260,339,739,440,539,567,193,1623,221,1238,544,109,909,286;34;F
87622;1381,170,1234,1240,544,1236,1199,1016,685,260,1720,677,1550,1238,109;70;F
87627;650,250,1240,221,1550,1238,1288,1163,1628,544,459,286,57,1666,1236;55;F
87650;446,626,539,567,193,1623,1238,925,1628,335,909,286,97;28;F
87684;422,180;41;F
87694;1240,1666,1236,539,660,739,260,339,442,1234,1199,1720,1623,1163,109;41;F
87702;1238;23;F
87726;531,1628,446,260,169,1442,442,1720,780,544,1381,193,1163,1153;47;M
87730;1149,440,1720,1623,274,1550,544,531,700;46;F
87754;539,1720,1666,1199,1217,170,650,894,1550,1623,660,739,339,626,1238;33;F
87791;1238,109,274;45;F
87799;739,1221,440,1199,461,434,963;47;M
87807;1016,1414,440,739,339,1381,1234,1720,1240,1238,925,1236;33;F
87832;553,440,250,1240,335,109,286,57,1217,1221,567,1199,1623,422,909;35;F
87835;1217,660,440,193,1666,286,539,868,274,221,1238,335,1628,422,180;53;F
87848;321;49;M
87855;1217,739,1221,660,440,539,567,119,1623,221,1288,909,286,531;36;M
87883;221,1442,739,660,1720,1414,1623,1550,1238,1163,544,286,531,97,700;31;M
87886;894,531,434,1236,1153,250,274,539,650,170,169,567,1720,1623,1238;26;F
87896;1623,1041,650,739,660,440,539,193,1720,274,250,1238,963,909,434;33;F
87912;446,780,544,531,97,700,1093,1720,1550,1238,1628,109;46;F
87913;1381,127,1720,1149,97,531,1153,1628,1623,674,286,544,221,446,700;33;F
87918;674,440,539,1720,221,544,109,1075,286,1666,260,1199,1234,1623,700;73;F
87934;739,660,440,897,221,1238,925,335,1075,286,531,434;44;F
87944;780,925,1381,1623,544,109,700,1666,339,260,626,1199,1234,1238,1628;31;F
87946;337,1623,339,335,221,440,193,1720,1238,1628,544,1666;59;M
87969;170,193,868,1414,221,1238,422,97;38;M
87988;422;34;F
87995;119,1234,193,442,260,339,1149,674,1199,1093,1238,544,97,1153,700;29;F
87999;127,1550,544,286;46;F
88014;1414,119,1234,573,1199,440,170,260,868,337,1238,335,544,109,1075;36;M
88043;97;69;M
88052;650,170,1490,868,677,274,250,897,1550,422,894,57,1153;33;F
88064;193,1238;77;F
88091;440,442,119;73;F
88093;1666;34;F
88096;674,868,446,1720,544,700;79;F
88100;633,1490,553,442,573,567,337,1414,1238,925,335,422,180,909;78;F
88119;626,539,193,1623,1240,1163,544,1236,1490,440,339,1199,1093,1720,1238;21;M
88120;685,633,660,440,539,1199,1240,1163,1666,1236,1623,221,1238,286,57;56;F
88147;97;70;F
88157;339,446,442,573,1199,1381,868,1720,1414,1240,1238,1075;26;F
88159;1016,1240,1238;41;F
88170;1699,539,1221;33;F
88175;260,626,1442,553,442,1199,193,1381,127,868,1720,925,422,109,894;37;F
88176;1075,909,700,1149,446,674,553,193,1163,544,97,1153;45;M
88180;1442;41;F
88193;674,660,440,193,1234,1093,1720,1623,221,544,109,909,286,57,700;45;F
88201;1623,650,739,660,440,539,193,1720,1041,274,250,1238,963,909,434;35;M
88207;1217,553,422,180,286,97,1153;13;F
88217;925,434;15;F
88218;567,119,897,925,1628,335,544,1075,1699,1221,539;34;M
88235;434,1238;56;M
88265;97;44;M
88279;685;42;M
88286;553,1199,1381,127,1234,868,119,1720,335,422,109,1075,180;37;F
88314;57,1236,685,260,1623,1240,539,274,221,1238,544,286,739,1720,1016;54;M
88365;193,539,440,739,685,260,660,442,1199,1623,1238,1288,925,1163,1236;54;F
88369;925,434;14;M
88394;650,1623,97,553,567,193,127,274,1550,1163,1628,544,154,321,1236;34;M
88399;446,626,1199,119,1623,1238,335,422,154,909,434,97,1666,1381,1442;26;F
88409;1623,335,1075,286,894,1666,1236,244,739,339,633,170,1240,544,434;34;F
88416;1238,440,1623,221,286,660,739,685,1163,700,544,97,1153,1149;38;M
88431;286,909,335,897,250,1041,1720,868,193,567,539,553,660,260,739;40;M
88445;250,221,57,1699,1666,1153;64;F
88448;685;41;F
88462;567,1199,337,1720,1041,1623,274,221,1238,925,963,909,286,434,1666;9;F
88471;925,434;45;M
88482;674,1149,1381,660,440,1720,221,286,97,1153;45;F
88492;1199,633,260,244,1016,1240,1238,1163,109,685;40;F
88525;1490,553,442,573,1381,1093,337,1414,1238,335,422,180;49;M
88529;633,739,260,1016,244,1240,1550,1163,109,1236,685;41;M
88568;894,286,109,221,274,1623,1720,127,567,539,440,660,1217,739,260;41;F
88588;260,221,1199,1149,446,440,1550,1238,1163,544,109,531,97,1153;2;M
88602;1199,626,244,633,739,660,539,193,1623,274,221,1238,1163,544,286;47;M
88611;1238;26;F
88614;244,739,1490,650,633,660,1199,677,1623,1016,1240,1550,925,544,1236;30;M
88632;567,1199,337,1720,1041,1623,274,250,221,1238,925,909,286,434,1236;12;M
88637;650,739,244,677,1550,1628,109,780,1075,868,1234,1199,260,1720,685;41;M
88639;260,1550,544,109,1075,97,700,1153,1093;83;M
88656;780,1240;42;M
88659;1238,1666,337,339,1217,321,1720,1623,221,544,109,1075,286,531;41;F
88663;1628,1163,337,539,573,633,650,739,1199,193,1720,1623,780,685,57;42;F
88690;1623,1041,674,660,260,739,1490,685,440,868,1720,1550,544,422,434;68;F
88720;57,1238,868,260,685,553,1720,1623,1240,925,335,1075,286,1236,434;41;F
88722;260;70;F
88732;1623,780,1016,1240,1550,1238,925,544,57,1666,573,1199,1234,1093,1720;26;F
88736;633,440,677,1623,739,244,660,539,1720,1016,1240,221,1550,286,1236;46;F
88751;1720;30;F
88760;339,633,739,660,677,274,250,1240,1238,1288,1075,531,57,1666,1153;33;F
88770;1699,1240,274,1623,1093,1381,1199,539,739,1214,650,250,780,544,1238;36;F
88785;335,780,440,660,739,260,1199,1720,1623,1240,221,1550,1238,925,544;29;M
88798;337,442,626,339,446,674,868,119,335,544,422,109,894,700,1153;10;F
88808;1490,442,1199,337,1720,1163,461,1666,544;56;M
88815;1217,1221,274,1240,531,434,739,660,440,539,1623,221,1163,1550;47;M
88825;660,739,539,567,1199,1041,1623,250,1550,963,909,531,321,1699,1236;21;M
88836;97,221,260,539,286,544,674,925,1149,1153,1238,1720;33;M
88863;660,868,119,1720,1041,335,422,109,1075,180,434,260,1442,553,925;61;M
88867;1550,1628,1699,650,1217,626,553,442,567,1381,1720,1240,1238,925,909;29;F
88869;1442,440,1381,221,286,685,1149,446,260,1550,1238,1163,544,97,1153;4;F
88870;1149,170,650,1075,97,700,339,446,260,1199,127,1550,544,109,1628;41;F
88893;250,1720,1221,244,1217,633,660,440,531,700,739,539,221,1550,286;47;M
88905;739,1550;72;F
88908;685,244,260,633,1199,1016,1240,1238,1163,109;13;F
88916;422,180;46;F
88956;434,1720,1381;41;M
88964;1720;59;F
88974;685;74;F
88990;1628,544,626;39;M
88997;1381,1234,97,1628,1238,286,531,1666,739,660,539,1720,1414,221,544;27;F
89028;1240,868,1093,539,442,553,660,739,1149,339,170,1153,544,446,674;59;M
89031;780,1240,1163,544,909,531,539,1199,1720,1414,221,1238,109,286,1666;39;M
89069;1217,1490,1221,660,553,868,337,1041,1623,221,1238,909,286,1153;43;F
89070;422,337,119,573,1442,1217,339,674,1720,1414,1238,925,544,97,700;23;F
89075;685,169,442,1381,780,1623,286,539,1199,868,1720,1240,1238,180,1236;46;F
89085;633,685,1199,244,260,1016,1240,1238,1163,109;9;M
89102;193,544;34;M
89106;119,1550,1238,1236,1381,925,1288,1720,780,573;47;F
89108;739,650,1720,626;28;M
89109;193,1550,109,461,1075;43;M
89111;221,1623,286,260,660,1199,1234,1720,1550,1238,1163,109,461,1075,434;74;M
89136;169,660,440,1199,1720,1623,1238,286;38;M
89173;335,180,567,446,1214,1153,57,97,459,422,1163,1628,897,780,193;47;M
89190;674,544,97,1153,446;9;F
89192;1238;30;M
89193;685;73;F
89217;1238,337,573,335,57,685,633,660,539,1720,780,1016,1240,1163,1628;9;M
89232;1217,909;24;M
89235;286,894,274,1699,250,925,434,1720,1041,567,909;34;M
89242;434,925;13;M
89252;626,1623,1163,180,553,1720;33;M
89271;544;35;F
89302;434;49;M
89307;440,446,894,925,1149,1238,539,544,660,674,700,97;26;M
89320;260,626,169,739,660,440,442,539,1414,1623,221,1550,1238,286,1666;24;M
89321;925,434;16;F
89338;1623,335,286,119,1720,1240,221,127,1550,1238,1666,1236,1163,170,169;41;F
89371;434,925;19;F
89382;446,674,1381,1093,868,1628,335,544,109,1153;40;M
89384;250;68;F
89392;1217,1093,868,119,1720,1240,544,1075;45;F
89407;339,1093,442,119,567,1199,1720,1414,780,221,544,109,57,1666,531;40;F
89415;274,221,1550,1163,422,154,321,1149,1442,193,1623,925,1628,286,97;16;M
89416;925,434;80;M
89422;553,868,422,180;7;M
89423;446,674,1720,422,286,97,700,1153,221,544;38;F
89435;1238,221,1623,539,660,260,739,193,544,109,461,286,434,57,1699;47;F
89452;1720,221,1288,286,1236,442,544,1666,339,660,440,1199,1016,1217,1623;35;F
89461;1240,1163,1628,909,531,180,286,321,1666,739,660,1199,221,1550,544;54;F
89462;1720,1041,1628,925,434;51;M
89480;739,446,660,57,1217,553,539,567,193,1720,1623,1163,544,461,180;23;M
89482;925,335,1214,260,169,1414,1016,274,1238,422,109,1075,909,434,57;29;F
89492;1381,446,674,1093,868,1720,544,97,1153;5;F
89493;286,1720,1234,1199,1075,109,1623,780,1628,1550,677,260,739,244,685;12;F
89514;1199,539,660,1221,339,1217,650,260,1442,1234,1093,221,1238,963,286;45;F
89515;1628,553,626;31;F
89524;633;67;M
89534;1199,193,868,337,1720,1623,221,1238,925,544,109,180,909,286,1153;73;F
89565;221,250,1720,660,739,1217,633,925,1163,335,422,180,700,193,650;21;M
89575;739,339,660,440,539,1234,119,1623,221,1238,544,109,286,97,1153;54;F
89583;1442,1720,1016,221,1238,286,434,97,57;15;F
89602;119,109,1238,461,553,286,221,446,544,674,700,97,1628,1381,1153;28;M
89605;553,169,739,650,539,567,1041,274,897,1628,1075,909,286,434,57;28;F
89612;1217,339,1490,739,446,169,539,1199,1720,1238,531,442,544,97,1153;26;F
89619;1153,1149,446,868,119,780,1016,1238,925,1628,544,422,109,1075,97;39;F
89632;1217,119,1214,1221,260,1199,1093,868;38;F
89640;553,1623,1199,221,1238,180,286;75;M
89657;567,260,1217,55,650,674,193,127,1041,1240,1550,1628,180,909,700;37;F
89678;677,544,286;42;M
89682;539,193,1234,1720,1016,1240,897,221,1550,544,963,286,97,57,1236;34;M
89722;221,286,660,539,1720,1623,250;50;M
89725;567,1720,1041,274,250,925,909,286,894,434,1699;4;M
89744;1240,1016,1623,868,1234,442,553,244,1217,539,1199,1720,1550,1163,544;36;F
89766;170,339,1199,1720,1623,897,221,1550,1238,925,544,909,286,531,894;32;F
89772;633,1442,539,963,674,739,650,1199,1381,1720,1238,1163,1628,894,1236;18;F
89783;1550,1236,1163,1238,1016,539,660,244,739,650,169,1199,127,1720,1240;23;F
89799;925,1550,221,1623,1720,119,868,539,660,169,739,339,170,1075,286;40;F
89802;244,539,274,286,1442;46;M
89804;286,544,1623,1720,1234,169,633,1236,739,440,539,677,1240,221,1550;45;F
89831;1238;20;M
89864;193,337,1720,1623,780,422,459,286,57,440,553,660,739,1149,685;47;F
89871;97,461,1628,1163,1240,1720,1442,739,1236;31;M
89875;339,55,739,1149,446,674,567,221,544,286,97,1153,700,626,1628;42;M
89884;459,154,1163,1288,221,780,1381,626,1199,193,1234,1720,1414,1238,109;23;M
89907;674,339,446,260,626,1238,925,335,544,109,868,1720,1381,97,700;39;M
89913;180,909,286,434,531,739,1221,660,553,573,539,567,868,119,1238;41;F
89928;442,868,221,1240,780,1199,925,57,1238,544,459,97,286,700,1153;44;F
89935;1666,339,1490,260,442,1238,544,553,868,1720,1623,925,422,180,57;56;F
89941;446;44;F
89949;221,286,531,321;57;F
89951;1442;90;F
89984;1238;20;M
89986;127,660,55,1666,1238,1623,119,170,260,169,1199,1234,1550,1163,109;48;F
89993;553,1199,1623,221,1238,180,286;75;F
89995;909,286,321,1236,1666,1699,97,531,440,567,1199,1720,1240,221,1238;30;F
90000;1666,531,286,1075,1628,1238,1550,221,1720,660,1442,1221,739,1490,170;34;M
90027;1623,169,1153,1628,660,1720,221,1550,1238,544,286;22;F
90029;1720,221,1149,446,260,440,1199,1238,1628,544,97,1153;43;F
90034;1442;64;M
90035;1214,422,553;30;F
90050;925,434;46;M
90088;440,1623,1238,909;36;M
90090;909,434,1666,339,440,1041,1240,685,739,539,1199,1381,1238,1075,894;28;F
90091;1240,221,660,539,963,286,531,1199,1041,780,1288,1628,459,1238,685;40;M
90106;1199,1490,1214,739,650,1550,1240,1016,1623,660,685;33;F
90108;1234,868,119,1414,1550,1238,335,109,97,660,1199,1623,544,286,221;35;F
90111;1623,1288,335,1075,1666,339,1442,337,250,1238,109,286,894,57;25;M
90116;539,1041,553,660,739,1217,650,780,274,925,422;47;F
90154;925;38;M
90156;1720,897,925,1163,422,459,286,97,57,1236,221,780,539,739,1623;19;M
90160;780,1041,337,1199,660,626,539,1381,567,1623,1720,1163,422,1236,286;18;F
90162;244,685,170,1720,1016,250,1240,1550,1238,925,544,422,434;30;F
90167;1199,1238;32;M
90169;321,909,422,1550,897,250,1623,193,1199,567,650,739,169,660,539;19;M
90182;339,1490,1234,1720,260,573,868,1238,925,422,109,1075,434;40;F
90189;1149,446,260,674,1381,1234,868,1238,925,97,1153,109;38;F
90195;925,434,1153;45;F
90254;119,1217,1214,1221,260,1199,1093,868;45;M
90271;109,660,1623,1628,626,169,440,127,1720,221,1550,1238,286,894,531;3;F
90284;55,57;16;M
90321;539,1199,1041,780,274,1240,221,1628,109,180,963,286,531,57,685;40;F
90327;339,1490,260,553,442,868,1720,1623,1238,925,544,422,180,57,1666;28;F
90364;650,1442,127,1720,909,422,894;39;M
90373;260,674,553,442,335,422,180,1666,446,119,1238,1628,109,97,700;45;F
90387;650,1623,780,274,250;28;M
90389;1075,1236,1623,1240,221,1238,109,739,260,660,539,1016,286,440,119;49;M
90409;626,169,660,440,127,1720,1623,221,1550,1238,1628,109,286,894,531;2;F
90412;260,1240,544,1699,434,1075,459,461,221,897,567,1720,1041,909;39;M
90481;626,169,660,440,127,1720,1623,221,1550,1238,1628,109,286,894,531;38;M
90505;1442;46;F
90518;1666,1623,897,221,1628,335,422,180,909,97,700,1153,544,963,286;47;F
90537;1149,674,660,440,1199,1381,1720,221,286,97,1153;71;F
90542;250,1720,169,1221,1490,685,1217,739,660,440,539,221,1238,286,894;47;F
90553;446,440,780,544,422,1153;43;M
90561;440,539,567,1720,1623,780,274,1240,221,1628,544,459,286,531,57;26;M
90564;700,97,221,1550,274,1720,1234,539,660,260;55;M
90566;170,221,1550,925,335,109,286,57,700,1666,1153,660,739,339,55;36;F
90576;1699,909,1628,925,567,169,739,1214,650,780,459,434,97,57,1041;29;F
90582;739,553,440,539,1720,1623,1238,925,335,422,109,909;36;F
90625;700;67;F
90635;650,339,660,567,897,221,925;25;F
90651;674,1623,1238,544,286,700,1153;24;F
90660;1234,274,169,1217,539,1041,286,434,531,739,660,440,221,925,1628;35;M
90666;446,260,674,1381,868,780,459,700;4;F
90674;55,626,260,1381,1720,780,109,459,180,97,57,700;7;F
90690;685,55,170,339,739,660,1199,1720,1016,221,1238,925,1163,544,286;38;F
90707;739,553,1381,1238,925,434;39;F
90727;925,894,57,339,1490,1149,1720,1623,221,1550,1238,544,422,286,1153;24;F
90761;739,193,1016,1240,1550,459,57,1236,1623,780;34;M
90875;739,660,539,1199,1623,1720,1238,780,250;48;F
90969;170,169,660,539,1199,119;57;F
90984;573,1199,868,337,1720,1414,221,1238,1628,544,109,461,1075,286,700;45;F
90986;1217,1221,169,660,440,539,567,1199,193,780,1623,221,1238,459,909;40;F
91031;1234,1093,119,897,1288,925;57;F
91063;660,1381,868,1016,250,1240,221,1288,925,335,109,1075,57,1666,573;39;M
91080;422,180;35;F
91094;925,544;47;F
91109;539,567,1720,1238,1221;65;M
91111;1236,97,1238,1550,221,1240,1623,1720,1016,780,544,1628,925,1163,685;11;M
91145;286,531,700,97,1623,1720,1199,539,674,339,1149,1238,925,544,1153;24;F
91148;442,1199,1381,1414,1016,925,119,1720,677,1240,1238,1628,154,286,1666;28;F
91150;446,1490,260,674,1199,1623,221,1238,1288,544,109,286,531,700,1666;53;F
91161;1381,119,97,339,1221,260,553,1234,868,337,1720,1623,274,925,1238;34;F
91167;339,193,119,1720,221,1238,154,286,894,1666;45;F
91175;925,221,1623,868,539,660,739,650,260,626,440,193,1381,1720,1628;37;F
91201;422,180;45;M
91204;422,180;12;M
91211;677,1623,221,925,1163,1628,335,544,1236,286,1550,1240,780,685,97;9;F
91260;739,1221,626,169,660,539,1720,1623,1016,274,250,1240,221,544,286;41;F
91262;422,180;5;F
91297;119,1720,1238,531,660,553,221,544,461,909,286,440,567,1623,1628;32;M
91321;1666,567,553,446,1214,650,1149,1442,119,250,897,1238,544,925,97;24;M
91335;1288,1075,894,57,1666,1236,897,1550;56;F
91347;544;48;M
91362;442,660,446,674,337,1720,335,700;75;M
91388;650,739,260,660,539,1623,1240,221,154,109,1075,286,1236;49;M
91389;909,1163,1234,1016,1240,739,1236,1414,573,780,154,1623,677,1238,685;40;M
91393;626,1221,650,1217,1214,170,1490,868,119,925,544,422,459,180,909;43;M
91394;1093,1720,1199,339,685,1490;39;F
91435;660,286,544,1199,539,674,700;51;F
91442;544,422,461,909,286,57,1221,553,335,260,1720,109,1093,868,925;40;F
91469;544,1238,1623,677,119,1199,539,170,660,442,1720,780,221,1550,286;45;F
91472;1199,446;49;F
91478;260,553,1234,868,119,337,221,1550,925,335,109,97,1628;33;F
91486;339,739,626,169,567,1199,1041,1623,274,221,1550,909,286,1699,1153;26;F
91493;1238,1217,1623,1720,1199,660,1240,221,1550,286,97,321,700,1699,1236;64;F
91508;1442,660,1199,868,119,1720,1041,1623,274,897,221,925,109,1075,434;27;M
91509;170,169,127,1550,1163,894;49;M
91511;567,539,660,1442,1221,1490,1217,55,553,868,250,897,925,909,434;38;F
91512;221,894,169,660,539,567,1199,1720,1041,897,1238,925,1163,909,1153;49;M
91514;1199,1041,422,894,1699,1153,660,442,897,925,909,739,539,567,274;39;F
91547;1217,1214,1221,553,567,193,868,1238,909;45;M
91555;286,531,434,97,739,1214,1217,193,1720,1623,274,897,1238,909,57;38;F
91598;154,286,422,274,1381,260,739,660,553,539,567,780,1628,109,909;55;F
91603;1238,1720,539,440,780,1623,422,909,567,1221,925;31;M
91618;339,169,660,1199,868,434,109,286,650,1041,1623,780,221;24;M
91624;925,434,1153;40;F
91653;897,909;29;M
91673;925,434;8;M
91684;127;47;F
91697;660,1221,567,1199,1240,461,909;46;F
91699;739,1234,119,1720,1550,1199,660,260,633,193,1016,1240,221,1163,544;53;F
91705;286,434,925,780,1041,119,539,440,660,260,739;65;M
91707;193,1234,221,57,1666;37;M
91714;1199,1720,897,1550,1238,925,544,286,531;47;M
91730;1238,459,286,894,1236,633,739,573,539,1720,780,1240,1550,925,1163;44;F
91731;442,1093,1238,544,109,1075,97,57,1666;19;F
91745;739,660,1623,1240,221,286;26;M
91748;739,660,780,897,925,909,434;39;M
91755;440,660,169,633,650,739,244,626,567,1623,1016,1240,925,1236;44;M
91764;650,1217,244,739,553,127,1041,1016,1240,897,1628,909,1236;21;M
91766;739,193,1623;26;M
91780;221,286,1234,868,337,1414,1075,461,109,544,335,1163,1238,260,1442;30;M
91781;169;62;F
91785;1199,1623,1016,221,739,1490,1442,539,868,1720,250,1240,1550,1238,925;40;M
91794;650,1217,339,553,539,1720,221,1238,335,109,909,286,1666;37;F
91799;909,1217,660,1199,1381,1234,1093,1720,1623,1240,1238,544,109,1666,1075;33;M
91800;650,739,1016;44;F
91843;650,539,193,1041,1623,897,221,459,909;44;M
91863;1623,1720,442,660,169,739,339,1240,221,1550,1163,544,109,286,1666;38;F
91876;567,119;49;M
91877;674,260;42;M
91879;193,221,1238,925,544;33;M
91883;57,339,650,442,539,1199,1217,573,567,193,1381,1720,1623,1442,1238;41;F
91895;925,544,180,57;42;F
91907;169,539,567,193,1720,461,180,57,1217,1214,1221,553;37;M
91914;567,1149,339,650,442,780,1240,897,925,154,109;50;F
91931;221,250,539,660,169,1221,739,1217,1041,1623,274,1628,544,909,286;30;F
91961;567,1093,119,1720,780,1623,250,897,1238,925,109,459,909,97,57;28;F
91986;925,1288;10;F
91993;739,539,221;38;F
92011;1214,685,57,434,180,909,1163,925,1238,1041,1720,567,260;41;F
92017;1442;37;F
92025;335,925,567;52;F
92026;1217,739,660,567,193,1720,1240,221,461,531;45;M
92030;440,660,626,739,1217,539,1720,1623,221,925,544,286,531;23;F
92041;567,909;37;M
92043;963;57;F
92044;868,221,1238,925,109,1075,434;52;M
92048;169;68;F
92051;925,434;6;M
92060;1041,925,897,567;38;F
92066;1442;8;M
92076;274,539,567,650,660,1199,677,1623,1240,897,1238,925,544,909,434;32;M
92078;1240,1016,780,1623,1720,868,539,442,553,660,169,339,170,57,1236;45;M
92110;1720,180,553;40;F
92145;1720,1623,780,1217,739,1442,660,539,193,1381,1238,1628,180,909,286;40;M
92158;260,127;53;M
92160;1442,1016,286,57;6;M
92172;544,909,286,1217,660,553,573,193,1623,780,1238,1628,459,700,1442;20;M
92196;422,180,739,1217,339,553,127,1720,221,1238,925,335,286,894,531;34;F
92208;446;34;F
92210;539,567,127,677,1041,1016,1550,894;35;M
92233;544,1153;36;F
92253;260,553,1199,221,1238,109,461,1075,180,1236;72;F
92273;286,544,221,1623,1720,539,660,674,700;64;F
92288;1153,1236,1666,1221,739,1214,339,1016,250,221,1238,1288,925,286,1442;48;F
92327;897,422,180;45;F
92341;1221,1381,868,57,221;33;F
92343;337,1199,442,1217,650,339,739,1234,1720,1414,1238,286,894,1666,1153;28;F
92360;925,422,700,1236,1720,274,897,1238,544,109,180,286,170,260,1550;38;F
92362;422;48;F
92363;446;9;F
92373;553,1199,221,925,909,1666,286,109;72;M
92392;434,1221,739,633,1217,260,539,1720,274,250,544,286,1236,1234,193;30;F
92412;1199,868,1623,780,274,250,221,544,422,109,459,286,1236,57,1699;30;F
92429;1217,553,442,1720,221,1238,1628,335,1699;38;F
92437;260,1442;14;M
92440;1666,1238,221,1623,337,119,868,1199,539,573,442,440,660,260,339;40;F
92445;127,567,539,260,1149,1217,633,650,739,626,1442,660,553,780,1016;48;F
92450;1217,446,539,193,127,1720,221,1550,925,1628,286,97,1666;49;F
92454;1221,1149,1217,650,897,925,567,1720,1623,221,909,434;42;M
92457;446;35;M
92462;531,1550,544,170,260,868,1075,1628,1720,127,440,539,660,626,739;40;M
92473;539,567,274,897,221,1550,1238,335,909;32;F
92474;539,1199,868,677,1016,221,1550,544,97,739,127;32;M
92482;1628,1153,1149,97,446,544;66;F
92491;660,1016,286,1236;48;M
92497;868,626,674,442,1234,221,335,109,1075,321,700,1666;28;F
92503;925,434;51;M
92506;57,780,1628,422,1234,109,260,1442;10;F
92510;339,660,539,1199,1623,221,1238,1628,544,286;53;M
92533;337,1238,925,109,1075,286,57,446,544,1623,221,339,1666;43;F
92536;321,286,221,1240,1016,660,626,1217,739,539,1720,1623,274,567,909;30;F
92549;650,1217,739,660,1199,868,119,1623,250,1238,1628,422,286,1666,1236;29;F
92561;442,1666,544,700,97,1628,1238;33;F
92582;1149,674,1153,97,700;74;F
92613;1163,925,434;42;M
92620;339,739,442,573,1199,1720,1414,274,1240,221,1238,544,286,531,1666;25;F
92633;544,1163,221,1016,119,193,739,1442,660,539,1234,1720,1628,97,925;29;M
92640;633,1381,1550,963,685,1016,1240,335,109,531,1236,660,1238,154,1075;39;F
92654;963,1163,685,170,260,440,193,1234,109;52;F
92672;650,1214,539,567,909;29;M
92679;1149,674,868,97,700,1153;77;M
92681;1149,446,260,440,1199,1720,221,1238,544,1628,97,1153;11;M
92730;677,244,440,633,780,868,1016,1240,109,422,260;40;F
92731;154,1623,109,244,260,677,963,1016,1234,1240,1236;41;M
92743;660,422,286,739,244,1442,1199,1720,677,780,1016,1240,1628,57,1236;45;M
92748;1490,109,286;47;F
92749;57,700,531,650,660,440,1720,677,221,1628,1240,1016,1199,1442,739;23;M
92752;169,1442;50;F
92762;55,650,127,274,897,1550,925,1163,544,97,1666,1442;44;M
92765;531;44;F
92770;677,221,1628,544,286,531,1236,539,1199,1623,780,1016,1240,1550,925;42;F
92771;170;61;M
92773;650,739,567,780,897,1628,422;25;M
92776;1214,1221,660,567,780,274,1238,57,1666;53;F
92781;1442;43;F
92800;1550,221,539,440,169,1221,1217,739,660,1720,1623,1240,250;38;F
92827;1442;10;M
92831;459,909,57,55,1217,660,553,539,1199,1720,780,221,1628,180,1699;52;F
92870;1381,1238,925,434;9;M
92871;1442;72;F
92898;339,1490,1221,660,1238,286,422,1550,1623,539,897,868,909;30;F
92909;567,1199,1381,868,1720,1041,1623,274,897,1238,1288,925,109,909,434;32;F
92911;422,1236,440,260,660,553,539,567,1381,274,897,1628,154,909,286;55;M
92913;1442;40;M
92918;868,1414,780,1238,335,180;43;F
92923;739,1214,685,339,1442,660,539,567,868,1720,1240,925,909,434,97;71;F
92934;868,119,1720,677,1623,1016,1240,1550,925,1628,544,909,57,1236,1199;25;M
92937;1490;37;F
92940;339,274,531,1217,244,440,539,1234,1623,221,739,660,1199,1720,286;40;M
92941;780,1016,221,1550,1238,1288,544,109,286,531,434,1163,57,1236,1153;45;F
92946;442,119,544,1666,446,260,573,1199,868,1414,1238,925,1628,109,97;51;M
92968;544;22;M
92992;1490,442,573,337,1720,897,685,925,909;32;F
92996;925,434;42;F
93007;1234,1720,1623,868,250,1414,221,1238,286,339,260,193,1550,925,544;44;F
93018;1041,567,909,897;28;M
93032;1199,1381,250,1238,925,897,274,868,1221,180,422,544,553;30;F
93046;1221,170,739,1720,1623,897,1550,544,55,1199,221,1628,109,1075,286;58;M
93056;1221,274,531,1217,633,739,244,169,660,440,539,1623,1240,221,286;46;M
93081;660,337,1041,250,1238,286,894,434;41;F
93086;1236,739,660,539,1623,1016,1240,221,286;32;M
93093;193,739,674,1163,700,169,440,539,660,1720,1623,221,1550,544,286;65;F
93095;633,170,1236;23;M
93108;1414;21;M
93127;1199,127,119,1623,274,1628,544,1236,169,660,539,567,221,1550,286;33;F
93129;221,1238,286,97;24;F
93148;1163,1628,286,1550,1720,539,440,660,169,1221,739,1217,1214,780,57;31;M
93151;626,1149,170,674,567,127,1240,97,700,1153,1628,1381,544,446;44;M
93152;1153,650,244,539,567,1381,868,1720,780,250,925,459,57,1699;37;F
93160;925,434;15;M
93163;1217,739,1221,660,553,539,567,1199,193,1623,1240,925,461,909,286;14;F
93171;909;48;M
93193;274,925,1628,660,1217,739,567,909,57;33;M
93211;1442;31;F
93233;1016,1240;43;M
93247;909,1163,1623,739,626,440,539,1720,274,221,1628,459,286,97,57;31;F
93261;925,434;45;M
93262;909;43;M
93264;544,274,567,897,909;31;M
93268;221,1550,97,57,55,739,626,674,660,553,1199,119,1720,1623,544;57;F
93277;1217,339,260,553,193,1234,119,925,109;33;F
93306;459,180,633,1720,260,553,1199,193,780,544,109,286,339,1666,1238;43;F
93335;897,925,434;10;F
93337;925,459,1075,180,531,1666,674,1720,1623,780,1238,1163,544,963,700;39;F
93343;1442;47;F
93344;539,1550,544,286,925,434,567,274,1221,897;28;M
93362;1623,221,531,57,244,739,1221,660,780,1016,1240,422,459,286,1236;43;F
93386;286,1442;36;F
93441;260,868,1199,573,1623,221,286,1381,1238,109,1075,339,1720,335,1666;34;F
93456;1666,1163,1238,193,660,739,633;37;M
93464;1240,1199,440,1442,260,531,739,660,539,1623,274,1238;58;F
93465;1442;30;M
93473;1221,1628,180;40;M
93481;1236,244;65;F
93500;909,180,1075,337,119,868,1234,567,539,660,739,1214,1217;39;F
93533;1149,660,1666,57,97,459,1628,1288,1720,119,1234,193,1199,573,339;42;F
93554;446,544;74;F
93561;633,1199,1720,1240,1238,1016,685;40;F
93573;260,169,127,221,1550,1238,109,531,286;40;M
93605;1442;22;M
93606;685,660,553,1199,119,677,1623,1240,1550,1238,925,335,544,109;33;F
93608;1720,567,539,440,169,1221,244,1217,739,446,660,1628,544,459,97;35;M
93646;650,685,1490,221,1163,461,1075,286,434,1699,1666,1149,339,109,909;35;M
93659;119,925,434;34;F
93663;321,193,674,169,739,660,440,127,1720,1623,780,221,1550,286,531;38;M
93674;1720,1381,553,97,1666,660,567,1623,221,925,544,180,909,286,894;32;F
93676;897,567,1623,221,1628,909,286;36;M
93677;339,1199,1234,1623,221,286,193,1093;27;F
93690;1442,1153;42;F
93705;1666,422,250,274,337,440,1217,1221,660,567,119,1720,1623,221,1238;23;F
93718;1199;31;F
93730;193,1381,119,337,1414,1016,780,221,925,286,531,97,1720,1623,1238;24;F
93749;650,339,260,440,1234,868,337,109,57,1238,553,1720,925,422,180;44;F
93751;57,286,422,221,780,1623,539,440,660,739;43;M
93758;674,544,154,422,97,180,909,553,1214,650,274,1628,57,700,1238;41;M
93776;685,963,1199,1236,739,1720,677,633,1623,1240,1016,1234;35;M
93786;660,553,539,567,1199,1381,868,1623,274,897,221,1238,335,963,434;34;F
93800;119,925,434;5;M
93830;531,1163,286,170,1623,1550;27;M
93856;739,55,440,539,1199,1623,1240,221,1628,1075,1217,339,626,1720,925;29;F
93870;650,1720,780,1238,925,1628,539,1041,260,109,1153;26;M
93878;119,925,434;3;F
93881;660,1414,1238,780,1381,573,442,626,260,739,1490,339,1628,459,57;28;F
93891;1163,1550,221,127,193,539,440,660,260,739,1217,170,1720,1623,1238;34;M
93893;1199,1381,119,1720,780,250,221,1238,925,1163,459,286,434,57,1153;44;F
93903;274,221,260,700,286,633,660,1234,1720,1623,1016,1240,109,1075,1236;32;F
93913;567,909;31;M
93929;739,260,1240,221,1238,660,539,1234,1720,677,1623,109,286;69;F
93940;1199,169,1221,1217,739,440,286,1666,660,442,539,868,1720,1623,221;44;F
93947;780,221,286,1236,660,440,539,1199,1720,1623,1016,1240,1238,154,739;33;F
93961;531,286,544,739,660,440,539,1720,1623,221,1628,700;48;F
93979;739,193,109,461;45;F
93990;221,1623,1628,544,1720,674;27;F
93995;440,660,169,170,539,193,1720,1623,780,1550,1163;39;F
94013;660,1199,677,1016,274,250,1240,897,1550,925,1163,909,286,434,97;38;M
94029;1236,286,1240,1016,1623,1720,660,169,739;53;F
94056;633,170,660,1199,780,1016,1240,1238,925,286,531;51;F
94073;286;40;M
94074;1720,1623,1016,1240,221,1238,544,286,1236;21;F
94079;1217,170,1490,260,553,1199,1720,1238,1628,544;2;M
94098;1217,170,1666,286,909,925,780,1623,1720,567,539,553,660,260,739;41;M
94110;1217,626,660,553,1238,544,422;35;F
94112;660,440,1381,221,544,553,1720,1628,626;37;M
94121;1217,1490,260,1442,553,567,1720,337,1238,1163,1628,544,909;4;M
94154;544,446;45;F
94173;1240,250,274,440,169,1217,739,660,539,1199,1720,1623,780,544,286;35;M
94177;650,894,127,1623,170,1490,1442,739,780;41;M
94194;1221,244,739,1149,170,55,1628,894;43;M
94201;55,674,660,442,573,567,127,1720,1238,422,286,700,544;31;M
94223;1214,1217,739,169,660,553,567,1381,1720,897,221,1238,909,286,57;32;F
94226;1623,567,539,440,660,626,739,650,1217,260,1720,221,1628,109,286;63;M
94252;1199,1234,1093,677,544,109,626;34;F
94266;739,260,626,442,539,119,1720,250,925,1628,544,109,286,97,1699;63;F
94273;1720,459,963,180,434,700,1153,650,739,539,221,544,286,321,660;27;M
94278;739,169,221,286,660,1623,567,539,193,909,57;38;M
94292;650,1623,221,260,739,440,780,442,286,660,109,1666,1238,685,1442;49;F
94295;685,1490,1093,422;9;F
94299;119,337,925,335,180,434;42;M
94302;677,1041,1623,1236,650,1240,221,1550,739,660,567,274,897,909;40;M
94313;868,1240,221,963,1075,434,739,660,1199,119,1623,1238,335,286,1666;27;F
94317;674,1199,1720,780,1240,1550,1288,925,1628,544,459,57,1214,868;42;F
94330;1628,1093,660,440,539,1720,1623,1240,221,442,1550,1666,1381,1238,573;35;F
94339;446;48;M
94349;1163,1234,1442,1623,1550,422,109,260,1199,1720,1238,544,1075,321,1153;45;F
94363;260,1490,685;7;M
94372;1442;74;F
94375;446,544;58;M
94390;909,286,531,1699,170,1217,660,539,567,1016,1240,1550,925,1628,650;22;M
94391;1550,894,567,440,169,127,97;31;M
94396;154,1234,1288,1623,897,894,1238,1414,544,1666,700,1381,626,1720,1041;35;F
94406;739,660,440,1720,97,700,446,626,221,1550,1238,1628,544;48;M
94413;925,434;11;M
94419;337,868,1093,442,260,1490,339,685;4;F
94427;1240,544,1628,127,1550,221,531,286,1623;25;M
94440;97,1153;32;M
94453;925,434;9;F
94458;260,868,925,109,434;36;F
94472;650,250,1699,626;34;M
94484;446,739,660,221,909,286,553,180,422,626;37;M
94485;660,539,868,221,1550,1628,286,97;33;M
94494;925,434;5;M
94499;119,925,434;37;M
94500;1442;24;F
94567;925,434;3;F
94571;633,739,244,1016,677,1236,1623,1240;39;F
94575;1238,286,1720,1381,553,1666,221,1628,674,700,1153,1149,97,544,446;42;F
94579;1199,442,260,339,170,685,446,674,119,1720,544,57,700;61;F
94582;1149,446,260,626,674,1623,1628,544,109,97;49;F
94588;739,660,440,1720,1623,1240,221,1550,544,909,286;37;F
94590;660,539,1720,1623,221,1628,544,286;48;M
94593;1041,1628,925,567,539,909,434;10;F
94618;909;48;F
94621;925,434;;F
94634;1442;57;M
94635;677,1016,1666,286,1288,1238,221,1240,1623,539,660,739,339,170,1236;49;F
94640;1149,446,674,1628,544,109,700,1153;38;F
94643;97,1153,339,1490,260,442,573,539,1199,1093,868,337,1720,221,1238;25;F
94650;1720,119,57,909,180,422,1217,539,1221,1238,553;36;M
94656;339,446,739,868,1628,544,286,925,1550,660,539,1199,1720,119,442;33;F
94658;339,553,260,1623,109,193,119,337,1720,1238,1628,335,422,1075,286;45;F
94672;1238,685,650,739,260,1442,660,440,442,1623,780,221,109,286,1666;16;F
94692;1217,660,440,539,567,1199,1234,1720,221,1238,109,1075,909,286,1153;71;M
94696;55,170,1149,739,260,567,1199,925,544,422,909,434;40;F
94702;963,434,925;47;M
94708;553,1199,1720,221,461,286;50;M
94713;650,925,1628,97;32;M
94731;1238,685,650,739,260,1442,660,440,442,1623,780,221,109,286,1666;15;F
94734;573,260,739,539,1199,250,154,1075,57,677,1041,1414,780,1238,925;29;M
94744;1214,1217,633,739,660,539,119,1720,274,221,1075,286,531,434;28;M
94751;739,1623,780,1240,221,1550,422,260,286,531,1236,1238,193,1720,1199;42;F
94758;170,1163,193;28;M
94760;1217,739,260,539,567,1199,1720,109,909,286,1153;68;F
94765;1720,1240,286,531;46;M
94802;1720,422,660,868,221,1550,286,97,1666;33;F
94819;567,780,1199,553,1221,1214,1217,1623,925,1075,909,286,685,440,868;33;F
94825;97,286,909,180,1163,1238,780;30;M
94837;685,650,739,260,1442,660,440,442,1623,780,221,1238,109,286,1666;13;M
94842;739,660,539,567,337,1041,221,1238,925,909,286,434;46;F
94845;1217,925,1628,539,567,1221,1214;42;M
94848;221,1238,1288,544,1075,180,286,97,57,339,1149,446,626,660,1153;42;F
94853;1623,780,274,154,169,660,193,97,739,1442,1720,1550,925,1163,1628;51;M
94874;1217,739,660,539,567,1623,221,1238,909,286,321,57,1720;20;F
94876;685,1217,633,169,539,1093,1720,1016,897,221,1550,544,154,286,1699;50;F
94900;260,1442,868,119,337,677,335,544,422,459;49;M
94903;1149,553,442,1238,119,868,193,221,180,909,286,894,1623,1199,567;31;F
94914;1217,660,442,567,193,1720,544,286,180,97,1666,1238;51;M
94945;925,434,1221,567,909,897,868,274;39;M
94967;1238,335,909,434,1666,1236,1217,739,553,539,567,1199,1623,1016,1240;31;F
94997;739,626,674,660,539,1623,780,925,1628;26;F
95005;434,1699,780,1623,1041,868,539,660,739,221,1238,925,335,963,286;34;M
95007;1041,894,434,1699,1236,1217,1214,1199,459,1623,780,1016,1628,909,1666;28;M
95008;1214,339,260,573,1199,1234,868,119,780,1238,544,109,459,1666,57;22;F
95013;739,169,660,553,440,539,1199,193,1623,221,1163,544,286,531,321;31;M
95017;674,660,440,1199,193,780,1623,1238,1550,1016,221,286,700,1153,339;25;F
95039;677,633,780,1240,1623,1720,440,260,739,170,169,660,1381,127,1238;45;F
95056;739,660,440,544,531,434,1550,1240,1414,1720,119,193,339,1238,1163;26;F
95071;1199,1550,963,1236,739,244,660,193,1720,677,1623,780,1016,1240,1163;47;F
95090;1623,193,274,55,567,1720,909;48;F
95102;339,1490,1199,1238,1288,925,109;43;F
95107;1217,260,1381,193,1720,1628,109,459,57;41;F
95117;260,1093,109;43;F
95123;446,567,193,544;39;M
95134;1199,1234,1381,739,337,1720,1623,780,1550,1238,925,335,544,422,1666;39;F
95143;660,193,1163,154,286,1236,1240,1016,1720,677,1214,780,1628,459;36;M
95150;1199,1720,337,119,339,170,660,677,780,274,1163;38;M
95157;1238,286,1720,1381,553,1666,221,1628,674,700,1153,1149,97,446,544;11;F
95168;897,221,1550,1628,544,422,459,461,963,894,434,57,700,1149,1153;40;F
95170;422,459,909,553,660,1442,739,170,1623,780,1163,335,180,531,544;32;M
95175;925,434;12;M
95178;1236,1016,739,1623,1240;56;M
95185;1666,1199,193,1238,925,1163,180,57;18;M
95196;539,1699,321,1217,244,626,1720,1550,1163,1628,544,109,459,286,531;40;M
95206;244,1153;32;F
95213;739,260,660,440,539,677,1240,1238,109,1236;31;F
95220;244,1221,1217,739,660,539,1234,1720,1238,1628,544,286,1699,1236,1442;20;M
95233;567,337,1414,897,221,1628,531,1236,339,1199,1720,1238,544,909,286;33;F
95235;531,1628,1623,739,170,660,440,539,1381,925,544,286,1550;38;M
95247;650,626,1442,337,1720,1016,274,1550,1238,925,544,422,963,894,1236;16;M
95249;1623,127,626,650,739,446,660,539,567,221,1628,544,909,286,894;33;F
95273;567,909,1217,553,442,221,1288,286,97,1666,1221,339,446,193,868;48;F
95275;446;11;M
95281;925,434;8;M
95284;446,674,660,442,868,119,1720,1414,1238,925,1628,544,109,1075,97;37;F
95292;97,1153;24;M
95296;119;19;F
95301;1199,539,660,260,1234,1720,1041,1240,1238,335,544,109,1075,286,434;23;F
95309;633,539,553,1199,868,119,337,1414,1016,1240,1075,1236;35;F
95316;244,650,193,1720,1550,1163,461,894;29;F
95343;1236,739,1016,1240,244,154,633,1623;35;M
95348;539,567,1199,1381,1720,221,1238,925,1628,544,909,286,700,1666,739;33;F
95357;1550,1628,1217,1149,1442,1234,1720,1623,897,1153,1221,1199,1238,286,1699;32;F
95378;739,169,660,440,539,1199,1623,250,1240,221,1550,286;37;F
95400;1153,1217,440,660,539,193,1623,1550,925,544,286,531,1199,1720,221;34;M
95411;660,553,1381,1240,739,260,1199,1234,1720,1623,1238,109;50;F
95418;925,1238,1550,274,1016,1623,1720,337,868,1199,573,440,1442,626,963;10;F
95424;1238,544,109,459,739,660,1199,1720,677,780,1016,1240,221,1628,154;32;M
95428;1442,1381;54;F
95433;1381,221,286,339,573,1288,1163,531,109,170,260,193,1623,1016,1240;24;M
95474;286,57,1153,97,1623,1720,1093,1234,1381,193,1199,660,260,339,1217;28;F
95485;925,909,434;46;F
95488;739,1623,221,1550,1238,660,169,539,193,127,925,1163,286,894,531;43;F
95491;440,459,461;37;M
95566;1236,1217,674,660,440,1720,1623,221,1238,1163,1628,544,1075,286,700;38;M
95588;1221,274,909,567,1238,868,925;43;F
95589;1041,780,1442,553,567,1234,868,1720,925,335,422,109,1075,180,434;61;F
95605;1623,221,1236,739,1199,193,1720,1414,1240,1550,1238,925,544,963,286;16;F
95622;633,685,739,660,440,1199,1720,677,780,1016,1240,221,925,154,1236;47;F
95627;97,700,1236,553,286,1550,909,1149,626,544,422,1214,780,57,1628;26;M
95636;446,544;35;F
95645;434,1240,674,660,440,539,567,1623,897,221,1238,286,1217,925,57;28;F
95651;1236,1240,660,244;76;M
95660;1699,339,739,553,573,567,1093,868,1720,1041,1414,1238,909,1236;33;F
95661;626,674,127,1414,925,459,286,739,193,1623,1016,1240,544,57,1666;20;M
95664;1238;33;F
95672;1240,221,1550,1238,1163,335,286,700,1236,1414,626,1720,1381,544,446;34;F
95677;1628,544;43;F
95696;442,539,567,1381,1720,1623,250,221,1550,1238,925,963,286,97,109;27;F
95697;339,442,539,1163,422,1075,286,1199,1381,1093,1720,221,1238,109,1666;39;F
95702;260,1442,553,539,1550,1238,461,1236,674,1016,1240,221,1163,544,700;26;F
95706;925,434;51;F
95708;1623,109,286,57,169,739,335,544,260,127,868,1550,925,1163,422;36;F
95711;1221,739,1214,1217,573,567,337,1414,1240,897,221,180,909,286,894;48;F
95722;1720,1623,286,567,539,440,660,674,739,339,193,221,925,544,700;36;F
95736;1238,1199,780,170,1163,1720,1236,739,1016,1240,1414,685;43;M
95771;739,169,660,440,539,1199,127,1623,1016,274,897,221,925,286,461;79;M
95788;170,633,1442,1199,868,677,1623,1016,1240;40;F
95796;119,1199,1234,1720,1623,780,274,897,1550,1238,925,1628,544,286,57;34;F
95799;57,1666,1236,1217,626,1442,660,539,1199,127,1623,780,1016,1240,1238;33;M
95803;1214,739,169,660,539,567,337,1720,1623,221,1550,544,909,286,531;35;M
95821;685,539,1414,780,250,221,1238,1288,544,909,286,531,434,97,1666;42;F
95824;677,1149,660,539,1720,1240,1628;35;M
95836;626,1221,339,739,660,1199,127,1623,780;30;F
95839;1442,1199,193,1720,1623,1238,335,544,109,1075,286,57;30;M
95848;1720,1666,1628,1623,674,544,446,1153,442,1381,459,286,221,700,97;76;F
95850;1153,1217,660,440,539,221,1628,544,422,109,286,97;27;M
95863;1442;36;M
95891;739,660,539,1381,868,1720,1623,1240,221,1550,1238,1163,544,286;32;M
95907;739,337,1720,1623,221,1550,1238;45;F
95913;1381,1041,1623,274,250,221,1238,925,335,286,531,660,440,539,739;28;M
95939;897,567,909;52;F
95943;925,434;14;F
95944;169,660,440,539,1720,1623,274,250,1240,221,1288,109,286,57,1666;45;M
95953;739,674,660,539,193,1720,1623,250,1550,1238,1288,544,422,434;50;M
95954;650,422,109,459,1075,180,434,97,1666,1199,868,677,1238,286,1236;33;F
95955;633,440,1240,221,531,739,169,660,539,1720,1623,1550,1163,544,286;46;F
95965;1234,660,1442;52;F
96024;170,1720,337,868,1381,193,1199,539,739,1490,650,897,1238,909,286;44;M
96027;1623,1016,1240,221,963,286,57,1236;45;M
96044;1442,127,1720,1016,221,1550,422,286,894;40;M
96047;434;37;F
96050;1199,685,339,700,97,1163,1238,1720,193,1442,626,244,1217,633,739;24;M
96054;339,660,553,539,567,1234,337,1041,1414,1623,925,109,1075,286,434;9;M
96059;446,739,1217,633,1221,626,660,553,119,1720,1623,221,544,286,1666;69;F
96083;250,119,1221,1214,339,1442,440,337,780,925,422;40;F
96111;626,897,154,1075,894,1153;31;M
96119;650,339,1041,897,221,1238;25;F
96152;674,539,1199,109,1720,1628,97;39;F
96172;894,1236,1550,1240,1016,1720,1199,1442,650,1623,739,660,440,780;35;M
96184;422,1075,180,57,1236,539,660,1442,739,244,260,1240,925,109,286;48;F
96190;1623,1236,544,650,739,1720,1240,221,925,567,677,274,1628,909,57;41;M
96206;1217,1221,633,739,660,440,539,1720,1240,250,221,544,109,286,1666;35;F
96208;1623,1414,1720,337,119,1093,573,1490,339,1199,780,1238,925,1628,97;27;F
96209;1217,626,660,440,539,567,274,221,335,422,963,909,286,1699,1236;39;M
96222;674,660,650,626,567,1720,1623,221,1628,544,909,286,700,97,925;32;F
96238;1623,1221,1442,660,1234,1240,221,544,154,894,1149,193,1163,459,461;35;M
96243;1720,1550,894;29;F
96247;739,260,660,539,567,337,1720,1041,1623,221,925,1628,909,286,434;78;F
96266;169,1550;61;F
96270;459,286,57,1666,170,739,260,660,440,442,1720,1240,1623,780,1016;68;M
96274;339,1217,685,539,567,1623,221,1238,109,909,286,193,660,461,553;49;F
96288;1163,335,109,963,1720,119,1442,626,1199,1234,1623,1288,544,459,1075;33;M
96314;677;86;F
96318;1217,339,1442,573,1199,1093,119,1720,1041,1414,1623,274,897,1238,925;48;F
96319;260,339,660,1199,1720,1623,1238,1163,544,286,531,1666;26;F
96322;925,1628,544,422,180,286,531,97,57,446,626,1153,660,553,221;42;M
96327;1149,674,1628,700,1153;24;M
96336;193,567,539,660,626,739,1217,650,260,221,925,1163,1628,109,286;21;F
96348;337,1238,335,422,1075,286,1153,109;42;F
96359;1217,180,221,1720,567,539,626,685,553,1016,1240,1628,461,963,286;23;M
96364;1442,553,573,1720,925,1199,119,1288,1623,1628,57,1666,1221,1414,1238;47;F
96368;677;83;M
96377;97,446;67;F
96379;1214,244,780,1016,1240,1550,1238,925,422;39;F
96380;286,221,1623,868,193,553,660,626,260;43;F
96381;739,169,660,440,539,1720,677,1623,1016,250,1240,544,286,531,1153;32;M
96389;109,650,339,739,1442,119,337,1720,274,897,221,1238,1628,925,434;34;M
96392;544;41;F
96408;1720,1628;35;F
96415;567,780,897,1238,1628,422,286,925,434;51;F
96417;422,180,286,57;36;M
96419;260,553,567,1199,925,1238,894,1041;37;F
96429;1720,739,553,544,260,286,221,109;58;F
96446;894;48;M
96460;1550,109,685,1490,677,1238,422;73;F
96463;685;7;F
96472;685;5;F
96476;1628,1720,650,739,626,660,440,539,567,193,221,925,286,97,57;29;M
96487;250,925,119,1238,539,868,1221,1720,567,909;37;F
96496;567,868,335,422,459,909,57,925;47;M
96501;1217,1221,260,553,119,1623,897,1550,925,544,109,1214;30;F
96504;660,567,193,1623,780,1016,274,1240,221,459,909,286,57,1699,1666;40;M
96507;339,1490,567,1199,868,337,1414,1238,1628,335,544,180,97,57,1153;32;F
96523;567,1288,1075,539,1199,193,1234,119,1623,221,1238,925,1163,544,109;24;F
96535;739,1217,250,1288,286,1490,260,626,1199,1381,1720,221,1238,925,109;21;F
96541;1381,337,1414,335,544,109,1075,1666,339,260,440,1234,868,119,1238;24;F
96551;446,1153;44;F
96561;1720,1016,897,1240,739,260,660,170,286,109;86;F
96568;339,446,1199,1381,1720,1623,1238,925,286,909;39;F
96574;1240,531,1666,650,339,169,1442,660,193,677,221,1238,925,286,335;18;F
96584;221,286,1217,339,739,260,660,440,539,1720,925,1163,422,109,193;46;F
96589;1550,925,739,1236,1199,1234,1623,780,1016,1240,1238,1163,335,422,109;42;M
96594;567,1041,780,897,1238,925,434;53;M
96602;193,780,1628,544,894,250,1234,1199,539,440,660,739,339,633,1720;31;F
96603;1550,221,250,274,1199,567,539,739,193,1381,337,1623,1240,1238,335;25;M
96615;1217,739,660,539,1041,780,1623,1240,1628,286;36;F
96630;1217,446,660,442,539,567,119,221,1238,544,180,909;47;F
96637;1720,1016,1236,1240,739,539,1075,440,633,1217,660,250,169,286,221;60;F
96652;170,1217,739,660,440,539,1623,1016,1240,221,459,286,531,57,1236;38;F
96682;422,127,553,626,260,109;3;F
96686;1238,897,274,1720,119,567,539,660,1442,260,739,1490,650,925,434;6;F
96708;244;66;F
96714;544,925,1199;19;F
96719;660,440,539,1199,1093,1234,1720,274,221,1238,1628,335,544,109,286;51;F
96720;660,1720,274,250,1240;28;F
96724;1720,1623,1163,1240,685,1238,539,544,1075,1217,1381,260,567,339,109;63;F
96727;1442,1199,193,1234,1720,119,221,1238,1163,335,109,1075,286,57,1666;17;F
96759;422,894,97,700;46;M
96763;1217,660,897,567,909,286,434;43;F
96767;337,780,1016,221,1240,1238,925,422,109,1236,1666,1075,963,244,739;49;M
96789;1381,868,119,1623,274,897,1238,925,422,109,459,963,1699,650,260;37;M
96793;660,1442,626,1221,244,1217,650,539,193,1623,250,221,544,286,57;32;M
96801;260;80;F
96822;1221,1442,193,1720,1041,1623,221,1238,1163,544,461,963,286;14;M
96844;339,739,660,440,442,539,1199,1093,1720,221,1238,286,909,700,1666;28;M
96847;1666,97,109,1240,1016,1414,337,339,1199,1720,1236;26;F
96849;1720,1217,1221,260,660,553,567,868,119,337,180,909;49;F
96852;442;78;F
96882;677;75;F
96901;539,567,1720,1623,1016,274,250,1240,897,1550,1238,109,909,1699,1236;35;F
96923;260,1699,286,109,1238,221,897,274,650,539,567,119,1720,925,434;7;F
96938;739,626,539,567,1016,1240,286,440,1623,221,1217,660,193,1720,1628;31;F
96945;909,567;37;M
96963;339,1490,440,442,1238,544,221,650,1217,909,286,739,539,1623,1720;31;F
96974;440,539,1199,193,1623,274,1240,897,221,1238,925,1163,335,286,1236;20;M
96977;1720,925,650,626,674,539,127,221,1550,1238,1628,544,154,909,700;26;M
96981;868,57,1699,650,260,573,1234,1623,250,109,1075,894,1666,1199,1238;30;F
97009;739,660,1720,1623,925,544,286;40;M
97032;1442,674,1234,1414,1623,780,250,1238,925,544,286,434,57,1699,700;16;F
97038;660,567,897,221,909,434;44;M
97049;963,677,1234,1381,1199,685;36;M
97050;868,286,180,422;43;F
97051;339,1149,1238,1628,544,286;31;F
97060;1381,1153,1149,446,335,544,97;48;F
97075;626,1199,1238,1628;34;F
97137;633,1414,221,1288,109,1075,337,1093,339,1238,335,180,1720,193,553;48;F
97167;739,660,440,539,274,1240,1550,221,1238,544,286;21;M
97170;553,442,119,1666;75;F
97173;221,1238,1623,1414,337,567,1149,446,674,1628,544,109,286,700,1153;32;F
97205;446,422,1628,260,626,1149,1720,1623,544,909,109,459,894,57,1153;29;M
97220;1240,221,459,286,894,57,739,633,1217,660,1550,461,531,700,1628;48;M
97221;531,97,897,274,1041,660,626,650,1221,1720,1238,1628,422,963,286;14;M
97222;1720,1699,1623,440,650,274,250,109,119;58;F
97223;1623,422,337,1238,1550,335,339,286,1149,544,1153,97,446,1720,1628;25;F
97252;127,1236,260,169,1199,1623,1550,1238,1163,894;44;F
97253;1623,1238,109,335,544,286,660,440,442,1666,221,446,97,1628,244;34;F
97255;1199,1016,1240,1163,244;39;F
97262;685,260,193,1550,1236;53;F
97267;260,1217,739,660,440,539,1381,1720,1550,286,894,531,1666,221,1238;34;M
97281;553,461,180,109;71;F
97295;868,1075,650,260,626,1442,553,1199,193,677,274,1163,422,180,894;;F
97303;780,897,925,1163;51;F
97315;544;41;M
97319;539,1199,193,119,1720,677,1623,1016,1240,221,1550,1238,1288,925,1153;46;F
97324;339,660,1623,1199,221,1238,925,1666,109,1075,169,335,459,286;33;F
97327;1199,868,626,660,193,1623,1163,97,446,440,539,1720,221,544,286;60;F
97332;633,553,440,250,1240,1628,626,660,539,1199,1234,868,1720,1414,1236;25;M
97333;1623,1016,1240,739,1199,440,633,170,55;65;M
97345;925,650,1217,440,539,567,1381,274,897,739,660,1623,286,221,909;36;M
97354;1236,685,963;66;F
97377;539,1199,1016,274,57,1236,1720,739,780,1240,221,1238,544,459,335;36;M
97383;925,434;31;F
97386;1666,1288,1234,1238,553,544,461,440,1217,260,180,109,193,57,55;74;F
97391;633,170,685,339,739,260,660,442,1199,1720,1623,221,544,109,286;27;F
97392;1234,1381,193,1199,539,442,660,260,1217,739,626;69;M
97402;422,1163,221,1240,274,1623,1720,1234,193,1199,539,660,739,1217,339;49;F
97403;633,1720,1240,286,221,1217,739,660,539;29;M
97433;780,1238,1236,1240,897;42;F
97436;1623,260,539,1199,1093,1720,1041,1240,221,1238,1288,1628,544,909,286;48;F
97447;1720,1666,1623,925,1288,739,1238,544,442,1381,193,119;78;M
97451;539,868,1163,461,260,739,1381,1414,337,1720,1550,1238,1288,109,700;76;F
97453;544,925,1238,221,250,677,1381,573,553,1442,650,1490,286,57,1666;51;M
97496;1720,1666,1623,925,1288,739,1238,544,442,1381,180,193,119;79;F
97508;1381,1720,1238,544,180,57,739,567,193,1234,1623,1163,109,461,909;31;F
97510;339,109,1075,925,434;39;M
97520;1217,440,567,1623,1628,422,909;20;F
97539;1666,1414,909,868,1238,573,539,544,442,1381,567,459,660,119,57;73;M
97553;739,1490,339,260,539,1199,1234,1720,1623,1240,286,57,1666,1238,925;29;F
97562;274,1550,1238,925,1163,335,109,57,739,660,1623,544,909,286,531;36;F
97563;244,739,650,660,286;31;F
97569;1666,539,544,440,1153,337,286,700,97;75;F
97583;539,1221,434,531,925,250,780,1041,660,1442,260,739,650,1699,909;38;M
97587;739,553,925,685,1149,626,567,539,1238,1628,544,422,909,97,1153;47;F
97594;963;77;F
97615;1238,650,1720;29;M
97630;1199,925,109,434,97;12;F
97637;1240,1236,286,221,250,274,1623,1041,677,1720,539,440,660,739,1217;42;F
97651;1234,1623,1016,335,461,1075,57,685,260,1720,780,1240,109,459,894;71;M
97664;260,1093,1720,109,1666;65;F
97681;1217,650,633,739,660,440,539,567,1234,337,1720,1623,925,909,57;53;F
97683;1720,1666,1550,1414,897,573,274,1214,260,660,339,286,119,626,55;18;M
97684;1199,1720,221,1153;32;F
97700;440,1214,650,1623,780,1628;44;M
97721;685,739,260,660,539,1199,193,1234,1720,677,1623,1016,221,925,154;61;F
97724;1720,1199,567,539,440,553,660,1442,1221,739,626,221,1238,544,286;42;F
97751;1666,674,544,446,440,1149,442,337,339,700,119;72;F
97760;700,650,127,780,459,57,909,1628;33;M
97769;1550,434,739,660,440,539,1720,677,1041,1623,274,250,221,286,1236;9;M
97804;193,440,1442,626,446,739,660,539,127,221,1550,1238,1628,544,286;32;F
97809;260,119,677,780,109,963;70;F
97811;1016,1623,539,660,894,193,780,55,626,57;40;M
97817;626,260,446,1217,1214,650,55,1199,1720,780,1016,221,422,459,57;39;M
97822;422,180;9;F
97830;739,244,660,539,119,677,1016,1240,1550,700,1236,1720,1623,1163,544;47;F
97838;685,660,539,1199,1381,1234,677,1041,780,1016,1240,925,1163,963,286;40;F
97866;700,531,286,335,1238,221,539,440,553,660,626,739,1217,1236,1153;29;M
97875;677,868,193,539,169,260,244,739,1490,339,1217,650,685,57,1236;41;F
97888;260,446,739,1149,1442,127,1720,544,461,1666;42;M
97890;286,1075,567,446,544,274;34;M
97893;539,221,544,286,739,442;43;F
97897;531,544,335,1163,440,321,286,1550,221,170;2;F
97913;1217,650,55,339,1490,442,1234,1720,1623,1238,335,109,1075,321,1666;67;F
97931;1628,250,1720,539,1217,339,650,567,1093,119,780,422,109,459,57;29;F
97939;626,286,894,1628;39;F
97941;339,1214,626,1442,1093,119,1288,1628,544,109,459,1075,286,1149,1153;46;F
97944;894,434,339,1217,335,286,1628,1623,660,739,221,1075,1234,260,109;25;M
97980;1720,1666,1442,1093,925,868,1199,440,442,660,780,109,119,57,894;61;F
97983;553,567,897,909,57,459,461,1288,1217,1490,868,1238,925,422,180;36;M
97994;650,260,674,573,925,544,422,286,531,97,700,1153,1149,109,321;35;F
97995;1075,180;39;M
98006;193;80;F
98021;674,446,442,1199,1234,1238,1628,544,109,700;68;F
98026;1217,440,1623,422,1628;41;F
98034;1666;77;M
98052;442;77;M
98054;1720,1623,780,1016,1240,1238,57;36;M
98061;1666;75;F
98095;894,1720,626;31;M
98100;739,650,1720,1041,1623,250,897,221,1550,1238,925,1628,544,963,434;12;M
98102;1666,1236,1041,442,780,434,286,109,193,57,55,97,894;81;M
98121;260,1234,1720,544;73;F
98125;1442,170,1163,1238,1234,1016,739,1240,244,677,1623,1236,780,685,963;42;M
98139;1720,1442,739,677,553,544,250,335,127,109,193;47;M
98145;1016,739,660,440,1720,539,1041,1623,274,250,221,1550,286,434,1236;6;F
98158;1240,925,1628,335,1153,633,170,260,1199,1381,1234,868,1238,109,1075;34;F
98159;193,626,650,339,1490,739,442,573,119,337,1720,1623,274,250,1238;46;F
98161;1217,55,1093,1234,193,626,339,170,650,260,553,1199,1720,1238,109;31;F
98183;1414,1236,1490,1238,573,1075,461,446,1217,1381,567,780,339,286,97;78;F
98185;685,660,539,1199,1381,1234,677,1041,780,1016,1240,925,1163,963,286;46;M
98186;539,567,1720,274,1240,221,1550,544,909,286,894,434,321,1666,1236;79;F
98194;446;17;M
98222;1699,1666,1236,868,1240,739,1238,553,539,544,1199,650,1217,660,250;66;M
98239;1214,780,1628;39;M
98261;868,1234,1238,1199,339,55;38;F
98262;446;48;M
98264;169,1221,244,1149,1217,650,739,539,677,274,221,544,286,321,1236;41;M
98268;633,739,660,539,1720,1041,1623,1016,274,250,1240,1550,286,434,1236;1;F
98271;897,1240,1550,925,459,909,286,434,57,674,567,221,1628,422,544;29;F
98284;339,739,573,539,337,1414,1238;24;F
98285;260,1217,442,440,660,1234,780,221,1238,109,459,909,286,57,1666;29;F
98293;685,660,539,1199,1381,1234,677,1041,780,1016,1240,925,1163,963,286;16;M
98294;1217,739,660,1623,286,531,440,539,1199,1240,221;26;F
98295;1442,1153;41;F
98298;250,685;40;M
98301;1234,553,539,544,1041,1075,1217,260,660,127,109,119,57,55,894;74;F
98314;1623,119,539,660,1550,260,440,700,169,446,553,1720,170,221,286;38;F
98319;633,739,626,440,1240,221,286,531,1720,1217;54;M
98332;1550,544,260,170,109;84;F
98354;244,1490,1217,685,1149,739,1221,260,660,440,539,1623,221,1550,286;48;M
98360;633,739,660,440,539,677,1041,1623,1016,274,250,1240,1550,434,1236;70;F
98361;169;32;M
98362;700,1214,674,544;39;F
98368;626,739,1217,633,650,660,440,539,1623,1016,250,422,1236,531,1550;32;F
98370;1199;39;M
98379;459,57,1666,440,442,1720,739,660,567,1016,274,1240,221,1238,286;29;F
98380;739,446,660,544,531,286;81;F
98392;700;71;F
98394;1234,170,260,739,660,539,1199,1720,1016,1240,1550,1238,109,1075,1236;77;M
98403;1214,626,567,1414,780,459,286,57,700;45;M
98409;446,1214,244,1381,868,780,1238,925,1628,422;5;F
98424;739,660,1720,544,1550,221,1623,286;38;M
98440;1442,440,337,1623,274,1238,650,909,1217,180,193,55,626;36;M
98446;685,660,539,1199,1381,1234,677,1041,780,1016,1240,925,1163,963,286;11;M
98452;442,1666,1550,119,868,1093,1234,260,780,1238;43;F
98486;1442;47;M
98493;553,422,180;8;F
98500;1628;40;M
98515;925,1075,1666;28;F
98532;127,897,55,1442,274,422,650,221,894;53;M
98539;925,434;40;F
98545;193,1720,1238,1163,553,1075;68;M
98552;260,109,1075,1153;50;F
98559;660,674,1442,244,739,109,1075,286,894,700,339,1149,1221,260,446;42;M
98580;1149,193,1381,1093,544,422,1720,1628,109,553,1238,1163,459,461;40;F
98584;244,339,1236,700,286,531,154,1238,1550,221,274,1016,677,739,1217;23;F
98586;1623,422,909,567,1238,1720,434,925;43;F
98616;685,660,539,1199,1381,1234,677,1041,780,1016,1240,925,1163,963,286;9;M
98624;446,544,109,1153;40;F
98627;868,1623,274,250;54;M
98644;1149,626,440,539,127,1550,544,1153,1236,700,97,286,909,1628,193;21;M
98645;274;43;F
98646;894,660,1666,221,1238;43;F
98648;868,193,442,660,1442,169,626,446,55,1199,1381,1041,925,260,434;41;F
98682;660,567,1199,1381,1720,1414,1623,1238,1288,925,335,109,1075,909,1666;46;F
98713;739,660,127,780,221,1628,286;35;M
98716;1149,1490,339,1217,573,1414,780,1238,335,459,1075,286,57,1666,1236;23;M
98718;925,1628,544,461,660,539,193,1016,1163,286,1236;34;F
98736;1217,1240,1550,1199,925,170,573,909,1623,1041,1236,739,1238,1414,1720;15;F
98739;335,109,531,1666,1217,1221,567,539,1199,1720,1623,1240,221,544,286;31;F
98745;193,442,660,626,260,244,339,1490,739,573,1720,1414,1623,780,1238;29;F
98756;567,909;29;M
98760;1490,626,573,660,650,260,446,1381,127,868,1414,1238,544,286,1699;31;F
98775;260,1041,925,109,434;12;M
98778;274;35;M
98788;1238,925,422,894,531,1016,244,739,286,1550,221,1240,250,539;38;F
98816;553,567,221,1238,925,1628,109,461,1075,909,286,531,57,180,422;29;M
98827;1666,700,97,459,544,925,337,553,674,446,339,170,1720,739,1217;56;F
98842;339,633,170,650,1720,1623,1016,1240,221,1550,1238,459,286,57,1236;28;M
98849;339,337,1623,1236,1490,739,660,539,1199,1720,1414,780,1238,1163,422;40;M
98858;1016,739,674,660,440,539,1199,1720,1623,221,1238,544,286,531,700;65;M
98866;633,685,244,674,553,539,1234,677,260,1199,780,1550,544,109,1075;29;F
98876;567,650,739,539,868,1041,274,250,897,1238,925,422,109,909,434;5;F
98879;553,193,1163,180;42;F
98907;1240,1236,685,169,539,1199,1720,780,1550,1238,925,544,1075,286,57;41;F
98925;119,1720,1623,780,274,897,221,925,422,459,909,286,57,1699,1236;22;F
98930;660,1720,677,1623,1016,1240,925,1163,286,57;47;M
98931;244,780,1016,1240,925,894,1236;46;M
98938;739,339,633,170,55,1217,567,1720,221,925,544,459,286,894,531;22;F
98941;1240,780,1550,221,1238,286,57,339,894,1163,169,127,539,660,170;38;F
98975;633,193,1016,1240,1550;34;M
98978;1149,260,1442,1628,109;48;F
99002;909;32;M
99005;567,1217,244,1221,169,660,539,1199,1720,1623,1016,221,1238,909,286;52;F
99009;780,660,626,446,170,1628,544,459,700,1163,286,531,97;43;M
99023;626,739,1214,633,250,1240,925,459,963,57,1666,1236,539,1720,434;52;F
99032;127,193,539,573,553,1490,170,1217,739,660,440,1623,221,544,286;71;M
99058;544,1628,221,1381,169,650,1217,739,660,440,1623,1240,154,531,286;20;M
99066;244,1217,739,660,1381,1234,1720,677,1016,286,1236,1623,1199;33;F
99071;446;64;F
99080;925,434;67;M
99095;442,544,170,739,660,440,573,539,1016,1240,221,963,286,677,1623;27;M
99098;260,442,337,1240,221,925,434,321,1153;76;F
99119;170,339,739,260,660,442,1720,1623,1628,109,286,97,1153,57,1666;61;F
99125;440,650,1217,739,260,660,553,539,567,193,1623,1628,422,180,909;1;F
99128;1149,553,193,1623,1238,1163,544,422,109,459,461,1075;11;F
99156;925,286,1623,660,739,539,193,221,1236;21;F
99158;739,260,169,127,1041,1623,780,1240,1550,109;25;M
99160;1666,1153,700;80;F
99186;286,109,335,1628,626,660,674,925,700,544;41;M
99190;660,573,539,567,1199,193,1093,1234,868,1720,1414,221,1238,109,1075;48;F
99205;739,260,1442,1199,868,1016,544,894;40;F
99223;339,567,1199,1234,1720,1623;51;F
99244;1623,169,1199,193,127,1720,221,1550,1163,109,894;43;M
99249;170,1490,739,660,553,440,539,573,193,1720,1238,221,1163,544,286;71;F
99266;1234,1720,1238,286,339,1149,446,260,674,1623,1628,544,109,97,1153;44;F
99275;650,739,567,539,868,1041,274,250,897,1238,925,422,109,909,434;3;F
99279;1217,1628,286,700,1153,567,739,660,440,539,193,1623,221,544,909;43;M
99315;633,1720,780,1163,963,1236,1016;39;M
99321;1623,1550;71;M
99332;1623,274,660,739,440,567,1720,221,422,700,553,193,1163,544;44;M
99338;539,567,193,1093,119,1720,1623,1238,1288,925,1163,544,909,286,97;28;F
99352;553,193,1720,1238,1163,1075;65;F
99356;119,1199,650,55,440,539,739,1628,1442,660,1623,780,1016,1240;40;M
99359;567,442,650,739,244,660,440,539,1623,780,1016,1240,221,1236;57;F
99375;1240,1550,1236;49;F
99396;1623,1288,1628,544,422,459;33;F
99403;1666,193,1234,1720,1041,1414,897,1238,1163,335,286,894;23;M
99404;650,739,539,567,868,1041,274,250,897,1238,925,422,109,909,434;;M
99408;925,1163,963,286,539,660,1442,260,244,685,1236,1720,677,1240,1238;39;F
99412;260,660,440,442,539,170,339,1234,193,868,221,1236;24;F
99414;1238,109,1720,260,1199,1236,422,1550,1240,1016,633,660,221,442,440;8;M
99415;440,1666;49;F
99426;244,539,677,1623,1016,1240,925,57,1236;60;M
99436;539,1720,567,909;33;M
99448;674,567,1199,193,1623,221,1550,461,321,739,539,1720,1163,286,531;34;F
99450;1490,1442,1199,1234,1720,1623,1016,1240,925,544,1236,1666,1238;36;F
99454;422,109,180,286,97,57,1666,339,739,660,553,193,1238,1628,461;40;M
99460;1149,1628,97;33;M
99466;260,573,193,109,1666,1149,539,1199,1720,1623,1238,925,544,1153,97;22;M
99479;1149,626,553,193,1720,1238,1163,1628,422,109,459,461,1075;13;F
99499;539,1199,1234,868,1093,1666,700,97,1628,1238,119,660,1442,1490;37;F
99522;553,446,1550,221,1199,539,739,1149,660,440,1720,1623,1628,544,1153;52;F
99523;260,109;76;M
99532;1623,1550;72;F
99542;1623,780,422,459,461,909,286,700,925,1628,1153,221,1149,97,544;44;M
99547;1720,169,260,440,1199,119;27;F
99554;780,274,925,1628,422,459,963,57,1236,660,677,1016,1240,221,286;37;F
99570;650,739,539,567,868,1041,274,250,897,1238,925,422,109,909,434;37;M
99578;440,1628,339,739,260,539,1720,1041,1414,1623,221,1238,154,109,286;24;F
99580;1234,1720,1016,1240,1550,1236;62;M
99595;573,660,739,1217,260,321,1550,109,461,1075,531,286,1666,221,1163;38;M
99596;1550,1238,109,909,1666,660,626,1381,925,544,97,440,1623,1628,422;34;F
99599;1217,739,660,221,1238,1628,544,286,1236;26;F
99615;633,1720,780,1016,1163,1236;7;M
99631;1720,1199,1236,1550,660,221,1238,925,422,109,260,633,1016,1240;5;F
99637;1217,1214,739,1221,260,553,539,567,1199,1623,1238,109;38;F
99667;57,739,1720,650;38;M
99695;109,700,260,97;39;M
99707;739,1221,674,660,440,567,1720,897,221,1238,544,286,700,1153;31;F
99716;440,1381,868,221,1238,422,544,109,909,286,531,434,97,57,700;39;F
99720;868,660,674,739,339,446,626,553,337,1414,1238,1163,544,1153,97;31;F
99723;1236;37;M
99750;169,674,660,440,539,221,1550,925,544,963,1666,1236,1720,1238,1163;63;F
99761;244;65;F
99762;739,244,660,539,1041,1016,274,221,286;37;M
99770;1149,193,780,544,459,97,57,700,1153;38;F
99857;650,1221,660,440,1623,274,250,1240,221,1238,286,894,531,1236,739;35;M
99859;567,1199,1234,1720,1414,1623,897,1238,1288,925,544,109,909,286,894;37;F
99869;1217,1214,1221,553,567,337,1623,221,925,422,909,286,434;47;F
99871;925,700,531,440,169,1217,739,626,660,539,1623,221,1628,286,57;40;F
99877;1041,868,260,339,531,1550,1240,1016,1199,1720,1236,286,1442,1623,1234;19;M
99880;531,446,260,626,1623,221,1238,925,1075,1628,544,286,97,674,700;29;F
99891;260,1217,339,1238;49;F
99894;739,660,539,1199,193,1381,1234,119,1720,1414,925,1163,109,260,1238;21;M
99903;274,1623,119,539,440,739,660,567,868,221,1238,925,422,909,286;32;F
99934;1217,337,440,1623,1016,1240,963,1236;51;F
99936;1199,250,1163,1628,894,1236,780,650,739,660,127,1016,1240,925,57;16;M
99939;1041,1699,1490,868,1238;37;F
99953;660,539,1199,193,1381,1720,1623,1240,1550,1238,1163,544,109,461,1075;37;M
99955;739,626,674,127,221,1628,544,286;48;M
100022;544,97,1153,446;43;M
100033;286,1666,260,109;66;F
100036;925,434;63;F
100039;650,925,909,567;30;F
100045;567,221,1666,553,539,1238,925,1217,1720,1163,544,109,1075,286,894;51;F
100068;544;63;F
100069;1149,1628;31;M
100083;544;71;M
100091;221,1623,531,286,685;44;M
100104;446;46;F
100107;1623,567,573,260,1490,339,626,553,1199,1414,274,897,1238,544,109;30;F
100109;650,567,1623,1628,1217,677;50;M
100133;193,868,1720,1623,1016,274,250,1240,1550,1238,1163,109,286,531,780;28;M
100137;1720,1550,1628;38;F
100140;446,539,1720,1163,321,221,1628,700,674;28;M
100141;440,119,337,422,180;42;M
100148;442,260,739,660,440,539,1199,1720,1623,221,1238,925,286,531,434;69;F
100154;422;42;M
100177;1240,925,422,1075,286,1666,1236,1153;42;F
100183;260,553,422,109,180;7;M
100191;244,170,1234,1075,1720,1240,221,1550,1238,925,1163,335,422,286,1666;47;F
100194;1234,1240,1236;68;F
100195;422;72;M
100199;119,1041,1238,925,434;51;F
100201;1666;50;M
100202;260,1442,553,109,180;47;F
100224;739,674,539,193,1720,1414,1623,221,1550,1163,335,544,109,1075,700;38;M
100233;544;64;M
100238;739,633,169,660,440,539,193,1016,1240,221,1550,1163,109,286,1236;68;F
100256;339,739,442,1238,1153;58;F
100267;925,221,1623,1093,193,539,440,660,169,626,739,1442;24;F
100276;674,97,1149,700,1153;79;F
100285;739,660,193,1234,1720,1666;41;M
100289;897,909,434,1236;28;M
100293;1381,1234,1414,897,1550,1288,1628,1236,1153,1149,1221,1720,1623,1238,544;30;F
100300;221,897,1623,1041,677,567,553,660,169,1217,446,868,1550,544,109;37;M
100313;739,1623,897,221,909,286;34;M
100323;909;41;M
100354;260,442,573,1234,868,119,337,1414,1238,1628,335,109,1075,286,1666;37;F
100360;544,894,97;43;F
100383;339,660,553,193,1234,1238,1288,1075,909,286;33;F
100398;626,674,1628;34;F
100409;180,335,925,221,1093,1442,244,739,660,1199,868,1016,1240,1238,1163;34;M
100416;440,260,1217,739,660,539,1414,1623,221,1238,925,422,109,1075,286;45;F
100422;339,169,553,1199,127,337,780,1238,925,335,544,180,909,286,57;36;F
100425;739,1490,339,1217,633,1016,925,1666,1381,1720,1414,1623,1240,1550,1238;29;F
100437;868,1720,1414,221,1238,925,335,1628,544,109,1075,286,97,1666,700;44;F
100466;1236,180,286,531,97,321,57,700,739,1442,660,193,221,1238,544;28;M
100479;1075,1666,925,1238,897,1016,780,337,868,1199,567,442,553,1442,260;41;F
100513;440,539,1199,1623,739,1720,221,286,544;34;F
100519;1149,660,539,337,1720,221,1628,544,286,97,700,1666,1236;31;M
100523;440,1381,868,1720,1240,1238,422,154,1236,739,660,539,677,1623,221;33;M
100532;1149,674,97,700,1153;82;M
100546;1490,573,1199,1093,1720,925,1238,544,459,286,434,97,57,1153;50;F
100562;539,780,1240,897,221,1550,1163,286,434,894,700,739,1238,963,1236;25;F
100570;260,553,422,109,180;17;F
100571;1442,660,440,1234,337,677,1623,780,221,1550,925,544,109,286,97;37;M
100600;193,567,539,440,169,650,739,1442,434,963,286;27;M
100608;674,1623,1628,544,286,894,97,700,1153;44;F
100615;567,1149,193,1628,1217,739,539,1623,1550,286,909,531,434,700,1153;28;M
100627;567,193,1623,925,57,1666,1153,339,1199,1381,119,897,221,1238,909;28;F
100632;739,260,660,440,539,1199,119,780,1238,1628,544,109,286,97;43;F
100651;55,1199,119,677,1623,780,1016,1240,1628,422,461,286,894,57,1236;40;M
100670;925,434;43;M
100672;260,553,422,109,180;48;M
100681;1720,1238,260,1199,780,434;46;F
100686;1623,1381,1199,553,633,650,442,539,567,337,1720,1240,1238,544,286;29;F
100694;626,539,1016,221,109,1666,1236,286,1238,1414,442,1381,1720,544,446;20;F
100728;440,539,1623,1240,221,1238,531,660,567,1199,1720,780,544,909,286;35;F
100734;1016,1240,1236;30;F
100747;170,739,660,868,119,337,1623,1240,221,1550,925,544;34;F
100756;1623,274,1016,1240,1628,909,531,1666,739,660,567,221,286,434,1236;50;M
100765;446,674,1628,544,109,57,1666;73;F
100771;660,1720,221,286,1628;59;M
100776;1163,1217,1623,274,925,422,434;25;F
100784;739,626,660,539,1720,544,286;35;M
100787;1236,459,544,1240,780,1623,1199,440,739,660,539,1720,221;41;F
100798;170,1217,442,1234,1623,1016,660,193,1240,221,1550,1628,286,57,1666;19;M
100806;1041,119,539,1217,739,170,260,660,1720,221,1238,544,286,1236,109;33;M
100826;1093,1623,1240,422,1666,660,442,1199,119,897,221,1238,544,286,97;29;F
100845;1149,739,660,539,1628,544,335,422,180,286,531,97,700;26;M
100848;674,1234,780,1550,1628,335,544,109,1075,909,286,97,57,700,1666;25;M
100887;685,660,440,442,1199,337,1041,1623,1238,925,1075,434;75;F
100901;739,626,1550,1628,909,97,1236,650,1217,660,539,193,1623,274,57;30;M
100903;1234,260,567,909;30;F
100904;321,1199,1217,1163,1628,544,260,660,1093,1623,1238,221,422,286,1666;34;M
100905;193,1381,1720,1623,780,1238,925,1628,544,459,180,286,97,57,700;32;F
100922;260,1442,553,109,180;6;F
100923;1666;13;M
100932;1238,1240,1623,567,539,660,674,169,1221,739,286,97,700,1666,1628;46;F
100944;1214,260,109,1442,553,193,1238,925,1075,459,180,461;42;F
100949;1238;27;F
100960;567,1628,335,544,909,700;24;F
100982;626,119,1238,109,286;26;F
101002;170,339,1442,660,193,780,1550,925,544,422,461,286,531,700;21;M
101003;567,461,1163,1720,1199,1442,739,193,1381,1623,1238,1288,909,531,1666;29;F
101004;780,274,250,897,221,1288,1628,544,422,109,459,909,286,894,57;39;F
101009;339,674,1199,1238,1628,544,700;36;F
101010;339,650,674,660,442,127,1720,1238,1163,109,286,894,1666;78;F
101016;739,660,440,539,1381,1720,1623,274,221,1550,1628,544,531,1666;42;F
101020;169,244,633,1217,1214,739,626,660,539,1720,1623,221,925,1628,286;26;M
101022;868,1720,221,1238;39;F
101029;1163,154,442,244,739,1199,1234,119,1720,1623,1016,1550,221,1240,1238;39;F
101042;650,539;32;F
101043;1628,335,286,531,321,1236,739,1442,660,553,539,193,119,1720,1238;32;F
101058;544,221,1414,1720,119,539,442,739,339,1666,1199,1238,1628,335,286;43;F
101059;339,1720;25;F
101062;1414,339,1199,1238;20;M
101065;1666;10;F
101096;260,55,339,739,660,539,1199,1381,1093,1720,221,1238,154,286,1666;46;F
101098;1442;18;F
101101;1149,170,650,339,573,193,868,119,1720,1238,1163,109,1153;32;F
101106;539,1414,221,335,544,286,434,1236,339,660,553,567,1234,1623,1238;27;M
101112;650,170,739,169,193,780,221,1240,897,1550,1163,286,1666;54;F
101122;109,1238;37;F
101139;780,57,1666,739,260,660,442,573,1199,119,1623,1238,925,335,109;27;F
101148;539,250,1236,286,544,221,1720,119,1199,442,440,660,739,1217,626;37;F
101151;660,442,1199,868,1240,221,1238,544,1666,1153;34;M
101181;1666;4;M
101183;650,260,660,286,531,739,446,674,442,539,337,1623,221,544,700;65;F
101192;909,1238,897,567,660,1666,1075,1628,1163,1623,1414,1720,1199,539,739;27;M
101212;1442;17;F
101216;739,660,440,539,221,544,109,286;36;M
101227;925,434;33;F
101244;1149,170,650,1238,250,739,660,539,1199,925,1628,909,286,57,1666;34;F
101263;626,169,1217,170,685,739,244,539,1623,250,221,531,434,1699,1236;38;F
101266;674,1381,1720,1041,1240,459,1075,894,1153,97,446,127,1628,544,700;32;M
101267;127,868,274,1238,925,544,446,1442,660,1623,221,286;41;F
101268;739,660,440,539,1720,221,1238,286;28;F
101278;1442;15;F
101280;1550,1288,1163,739,339,1199,193,1234,1720,1016,1238,1236,1240,244,1666;49;F
101316;1238,422,109,286,337,1234,1381,442,660,674,260,1666,446,1628,1153;38;M
101325;57,1699;27;M
101337;244;67;F
101341;339,1442,1093,337,1238,925,700,170,660,1720,1550,544,422,286,1153;29;F
101350;1442;13;F
101363;55,685,422,1075,180,57;45;M
101367;339,1199,868,1720,1240,221,925,1628,544,97;36;F
101374;170,660,1720,677,1623,1240,221,1550,109,1236;32;F
101380;894,286,221,274,1623,1720,119,567,539,440,553,660,1221,739,1217;30;M
101391;339,739,660,442,573,539,1720,1623,1240,221,1238,1075,286,1666,1236;31;M
101411;1288,286,1666,221,1623,868,193,1199,539,660,446,739,339,1238;23;F
101415;650,260,169,1442,440,193,1234,1720,1623,221,422,286;23;F
101419;544;40;M
101423;1442;10;M
101434;626,461,180,909,894,1699,700;22;M
101463;539,1199,1214,1075,868,1093,442,221,1720,567,909;26;F
101470;660,1720,1623,221,1238,335,963,286;26;F
101484;739,626,660,440,539,1720,1414,1623,274,221,909,286,531,57;16;M
101491;544,221,274,1623,539,440,660,674,169,626,446,739,339,286,97;27;M
101498;1720,1217,1381,539,440,660,739,1214,193,1623,221,1238,1163,544,286;42;F
101504;660,539,1623,250,897,221,1550,286,894,434,700,1236,1153,909,274;37;M
101515;1238,894,286;39;M
101519;739,660,553,442,539,567,193,1093,868,337,1720,1623,897,221,1238;33;F
101523;660,567,1720,909;35;F
101532;1149,446,260,442,440,553,1199,1720,221,1238,1628,544,180,97,1153;78;F
101536;1720,1666,1149,739,674,660,1623,221,544,286,531,97,700;49;F
101537;925,434;42;F
101544;633,539,1720,1623,1240,221,154,286;53;F
101549;440,539,1234,1720,780,1623,274,221,1628,544,909,286,531,434,57;22;M
101564;553,660,650,55,739,780,1628,180;37;F
101575;1236,1153,1041,539,339,739,674,660,440,1238,544,700;37;F
101591;1214,1442,553,567,193,868,337,1238,925,422,109,459,461,180,97;5;F
101593;1720,1381,440,1217,660,539,567,1623,221,1238,459,909;43;F
101618;1217,739,660,440,567,1720,221,1238,1628,531;34;M
101622;1240,1238,1666,1236,685,339,1199,193,1093,1041,1414,274,1720,1623,1016;62;F
101639;1016,1623,539,1041,660,169,1221,739,1720,274,286,97;33;M
101650;660,1628;36;M
101661;1623,1414,1720,337,1093,1234,193,539,442,674,260,739,567,1199,1238;28;F
101663;442,193,1234,1163,660,539,567,1720,1623,221,1238,1075,286,531,434;29;M
101680;1214,739,626,539,1093,119,925,180,909,286;35;F
101686;446,260,1199,1238,1628,544,97,700;45;F
101706;897,780,119,1093,109,553,567,868;27;F
101710;170,244,1199,1623,250,925,544,109,286;40;F
101718;573,1381,1720,1288,1628,57,1666,1623,154,700,339,446,660,567,221;15;F
101747;250,531,650,685,633,1214,1149,660,1623,925,459,286,1699,221,434;55;M
101749;1442,539,1720,1623,1016,1550,1628;31;M
101766;286,193,539,660,260,739;60;M
101768;1016,567,553,660,1217,739,193,1720,274,221,1238,1628,909,286,434;33;M
101787;1217,1236,1666,286,1238,221,1623,1720,1199,539,442,440,660,739,650;33;M
101807;1238,1550,286,97,539,739,193,1381,1234,897,925,1163,544,1199,1720;31;F
101810;1442;40;F
101818;337,567,1666,1238,1623,1414,1720,1093,539,573,442,440,660,739,339;24;F
101850;260,780,1240,1666,1236,1238,544;45;M
101868;1550,1163,286;45;M
101884;1199,1234,1623,221,1238,925,544,109,1075,286,1666;27;F
101886;274,1623,539,660,169,626,553,567,909,894;49;M
101891;1720,780,274,1550,1163,1628,459,286,531,1666,170,660,193,221,925;47;M
101897;539,440,650,633,739,660,442,1199,1234,677,250,1550,925,700,685;72;F
101907;739,660,539,1720,1623,1075,286;32;F
101919;446,567,1199,221,1238,459,286,97,1153,442,539,1720,544,700,1666;46;F
101921;677,1221,169,633,739,440,1288,925,109,1720,1623;38;F
101923;244,337,925,1163,1236;39;F
101928;660,700,739,1149,1442,567,1199,1720,1623,1238,925,544,909,286,894;50;F
101931;539,1199,868,119,1720,780,1238,925,544,459,109,97,700,1666,685;47;F
101938;925,434;76;F
101981;739,119,780,1016,221,1666,1236,1153,446,674,925,1628,700,544,97;23;M
101984;286,1240,274,1623,650,739,626,539,567,1199,1720,221,1628,544,894;39;F
101999;1720,1016,274,286,1236,339,739,567,1199,193,1623,221,1238,1628,544;31;F
102021;925,434;74;F
102028;1288,459,170,1550,1199,539,1623,1016,221,1628,57,1236,660,739,1240;37;F
102036;739,1016,286,1163,221,1550,170,544,780,1628,539,193,127,1623,169;29;M
102044;459,1075,1666,1214,567,909,286,57,539,337,422;45;F
102054;221,286,544,1217,539,677,531,1199,1236,440,660,1240;38;M
102057;868,1234,1199,539,573,660,260,739,1720,1623,1238,109,1075,286,1236;31;F
102060;459,1628,1550,193,339,170,55,1041,780,1163,1075,434,97,57,700;39;F
102062;169,260,739,109,1075,286,1199,119,1238;36;F
102065;1240,1720,780,250,650,274,1699;30;F
102070;1016,1240,1153;31;F
102074;1075,180,286,909,461,221,1623,337,193,567,539,626,260,1217,660;51;M
102099;539;27;M
102103;1217,633,739,260,539,1199,1234,127,1720,1623,1550,925,544,154,109;46;F
102113;1149,739,674,660,440,1623,1550,1628,544,286,1153,700;44;M
102124;1666,1550,339,739,260,660,442,1199,1234,868,1720,1240,1238,1075,1153;39;F
102126;1234,674,260,739,446,660,440,1623,539,868,1628,286,97,1153,700;33;F
102149;1442,1221,339,170,650,739,660,539,119,1720,677,1623,1016,221,1238;31;F
102172;260,660,1720,221,1550;38;M
102198;1214,739,440,539,567,221,1238,109,286,1666,660,553,1720,335,531;30;F
102199;573,442,1217,1214,1221,539,567,868,274,1238,925,335,544,422,909;38;F
102212;169,650,1217,739,260,660,440,539,250,221,1238,1628,286,1666,1236;31;M
102225;1217,1199,1240,1238,422,909,894,57,1236;21;F
102257;553,626,1490,339,633,739,244,780,1016,1240,1550,1238,335,1236,1153;40;F
102280;1075,531,339,674,539,567,1720,925,286;26;F
102288;925,434;89;F
102294;446;10;M
102343;57,1236,170,739,660,539,868,1720,1414,1016,274,1240,221,1550,1238;34;F
102357;1149,674,193,97,1153;27;F
102363;169,567,337,1041,109,442,119,1238;31;M
102364;260,567,1199,1381,1234,868,119,335,109,434,1666,1238,925;32;F
102386;739,1442,660,1623,780,1016,1240,221,1238,1288,422,109,963,286,434;34;M
102388;221,1238,286;39;F
102393;339,739,1720,221;28;F
102395;260,660,567,1199,193,1234,1720,1623,221,1238,925,544,109,909,321;25;F
102396;531,894,286,1628,1163,1550,221,1623,1381,1199,539,660,169,339,170;32;F
102421;1199,109,1075,539,1381,221,1628,180,286,1217,339,553,567,1720,1238;32;F
102424;573,260,660,440,780,221,963,286,1238,925,1550,1240,1623,1720,685;39;F
102429;1238,260,1666,909,434,868,127,573,553,339,650,1221,567,1442,422;44;F
102437;1628,1238,221,539,1623,1240;51;M
102444;626,553,193,1720,1238,925,894;57;F
102456;553,193,180;39;F
102463;1628,544,963,286,434,739,626,660,440,539,567,1720,925,459,531;23;F
102474;1240,544,57,1236,1550;44;M
102481;660,440,1199,193,250,1240,221,1238,925,544,109,286;19;F
102500;422,1075,286,434,57,1153,339,739,660,573,539,567,221,925,531;35;F
102512;660,539,1623,250,221,286;36;F
102519;434,925,544,109;51;F
102526;434;25;M
102532;1720,660,739,650;26;F
102534;193,539,626,119,925,459,909,286,57;24;F
102547;739,909,286,169,539,1720;47;F
102555;97;71;F
102558;1217,539,1381,739,1720,1623,221,286,434;23;F
102564;539,1199,119,337,1720,1016,274,221,1238,1628,544,286,1666,1236,1153;37;F
102567;1238,339,1199,1414;53;F
102583;650,1720,1623,221,925,286;40;M
102584;544,1442;48;M
102586;626,539,567,127,1414,1623,897,1550,1238,1628,544,286,531,1699,1236;50;F
102607;739,260,169,660,440,539,274,250,1240,221,1550,1163,286,531,1236;45;M
102613;531,894,286,221,250,1623,868,1234,193,539,442,553,446,339,650;69;F
102627;339,1149,739,660,1623,274,897,221,909,286,57,1699,1236;28;F
102665;1221,260,553,660,442,1623,221,544,286,531,57,1699,1666;27;F
102666;739,1217,633,170,260,660,553,1199,193,1234,274,1163,180,286,894;34;M
102669;339,1214,739,660,539,1199,1623,1016,250,422,780,1238,1442,1720,650;51;F
102692;286,57,650,1628,1623,909,1236,1666,1153,739,442,539,1199,1720,1238;49;F
102693;1238,925,1666,539,440,660,339,1217,1720,897,260,567,1623,109,909;36;F
102703;170,685,260,1720,780,660,553,868,221,1238,1628,544,109,286,894;40;F
102709;127,567,539,446,739,660;31;F
102717;1623,1234,193,1442,260,1221,1217,739,660,1199,127,1720,1550,894;42;F
102718;780,1016,221,1628,1236,739,1442,660,1623,1240,1163,459,57,286;30;F
102748;339,440,650,1217,1381,868,1238,1199,1623,286,193,1234,539,660,739;19;F
102750;1238,339,1199,1414;59;M
102765;650,339,539,1234,1720,1016,1240,1238,459,1075,286;35;F
102773;1163,221,193,567,539,660,1381,925,544,1720;26;F
102774;1288,544,422,339,193,1234,119,337,925,250,109,459,1075,57,700;14;F
102793;1221,1217,633,1163,650,660,553,440,539,193,868,422,461,894,1720;40;F
102800;553,539,1720,274,1240,221,286,531,321,700,1236,193,1623,1238,1163;35;M
102826;1381,1550,1238,700,739,626,660,539,339,440,573,221,1628,544;42;F
102844;660,169,244,339,650,739,442,573,539,1414,221,1238,925,286,97;28;M
102856;963;31;M
102866;539,660,674,626,739,700,567,780,1623,1628,909;39;M
102867;339,1414,1238,1199;15;F
102868;339,1238,1199,1414;12;F
102918;633,739,660,440,539,1199,193,1720,1623,221,1238,909,286,894,1236;21;F
102922;337,685;48;M
102938;339,739,567,1720,1238,1628,544,459;29;M
102941;553,925,422,109,459,1075,180;38;F
102962;1238,1163,1628,531,1666,339,1381,1234,1093,250,1240,1550,925,544,1699;22;F
103004;260,626,660,1199,1234,1016,1240,221,109,459,180,286,97,57,1666;69;F
103024;633,1236,739,780;30;M
103037;685,55,1217,739,1221,193,1041,274,1240,897,1238,531,57,1699,700;28;M
103038;339,674,1550,1238,925,544,422,97;43;F
103045;700;72;F
103051;626,674,660,440,539,1720,221,1238,544,109,1075,909,286,321,1153;39;F
103055;1623,544,109,650,633,660,440,1720,1240,221,1550,286,1236,739,780;38;M
103059;544,674,660,1238,286,1153,700;34;M
103065;260,1075,109;59;M
103077;339,739,660,539,1623,250,221,544;30;F
103079;1236,739,660,539,1623,1016,274,1240,221,286,1153;29;M
103088;459,539,170,244,1720,1236,1163,925,1550,1016,780,660,739;44;M
103093;274,221,1550,925,422,909,286,434,650,1217,739,660,539,567,897;30;M
103096;553,442,573,539,868,1720,1623,780,221,1238,109,1075,286,894,1666;42;F
103129;1381,1234,1041,1016,1236,1442,1720,1623,1240,1550,1238,1628,1075,286,1666;29;F
103141;1720,567,626,1221,244,633,1217,739,660,440,539,1623,221,544,1163;42;F
103152;567,1238,909;22;M
103161;739,660,442,539,1234,868,119,1720,1623,1238,109,1075,286,894,1666;71;F
103169;1550,963,685,633,739,660,1199,1720,677,780,1016,1240,925,154,1236;81;F
103170;650,626,567,1238,925;30;M
103177;909;40;M
103197;573,1288,1628,1720,660,539,1016,650,739,260,440,1234,221,109,286;52;F
103198;1442;40;F
103201;553,739,446,626,660,1199,1234,868,1414,221,1238,1628,544,286,700;33;F
103220;739,260,442,868,337,1720,925,544,109,1075,286,97,1666;44;F
103226;442,1199,119,1238,1163,1214,868;29;F
103228;221,1623,660,446,337,339,260,119,1238,544,335,422,1075,286,97;49;F
103246;626,57,650,1720,1214,169,1016,1163,1199,244,739,633,1240,1623,1236;36;M
103249;567,193,274,461,321,1699,700,1236,1153,1550,1163;34;M
103257;739,446,169,674,567,127,1623,1016,1240,1238,1628,544,459,909,286;20;M
103262;446,674,442,193,1016,1238,925,544,109,286,97,700,1153;76;F
103281;553,422,180;8;M
103305;539,193,1381,221,1550,544,422,700,1666,1199,1240,1238,1163;47;M
103308;626,553,442,1093,119,1720,1623,221,1238,544,109,909,180,286,1666;69;F
103326;442,1234,1199,650,660,739,539,193,1720,780,250,1240,1550,925,1163;32;F
103336;1075,286,531,1236,1623,1414,1720,539,440,660,1442,260,739,339,1217;36;M
103347;1238,626;41;M
103357;1217,739,169,660,440,539,1623,1240,1550,1628,925,531,544,286,221;23;F
103358;1016,1240,1236;30;F
103359;660,539,868,677,250,221,1238,925,154,963,286,894,531,1699,274;35;M
103363;1442;9;M
103395;739,539,1381,1414,1016,1240,57,1236,1234,1623,1238,544;17;F
103399;422,180;6;M
103402;660,221;71;F
103422;55,1217,1699,1149,739,539,567,193,1623,897,221,925,434;19;M
103445;1075,925,1288,1238,1240,1381,1199,442,1720,1623,250,1550,339,650,1666;33;F
103460;739,339,685,1217,660,539,1199,677,1623,221;69;F
103487;169,440,660,1442,739,1217,650,539,1720,1623,274,250,221,1238,925;26;F
103494;1442;4;M
103518;1217,1623,274,1163,925,422,434;75;F
103519;260,660,1199,1720,1623,1016,1240,925,544,109,1236;11;M
103542;739,660,1041,1016,1550,925,539,286;40;M
103543;925,434;13;M
103577;567,539,440,660,244,1214,739,1240,1236,531,1217,1221,1720,1623,1238;26;F
103581;963,274,1016,250,544,193,1199,685,440,660;46;F
103585;244,286,531,1236,1153,544,1163,1550,221,1217,739,660;29;M
103607;1217,650,739,1442,660,539,1199,127,1720,1623,1240,221,544,286,894;40;F
103625;660,539,193,868,1720,1623,897,221,1238,1163,1628,544,286,894,700;29;F
103638;1442;45;M
103655;97,1236,1217,1214,660,567,193,1628,909,286,57;45;F
103661;1414,1720,1381,573,739,1217,339,1199,286,1238;22;F
103663;1720,1016,1240,1550,1238,909,286,894,57,1236,1666;29;F
103687;1720,925;29;F
103735;440,660,674,1221,1217,739,446,260,553,442,1550,1238,335,544,700;34;F
103783;925,434;14;F
103786;335,1628,1240,250,1623,1720,567,539,739,339,1217,650,897,1238,434;24;M
103796;539,440,660,674,626,739,446,442,119,780,1288,925,1628,57,1666;67;F
103806;739,660,539,221,1550,1628,544,286;22;M
103836;1381;55;F
103851;1093,119,1623,434,97,57;52;M
103883;1214,335,544,286,434,1217,339,442,1199,119,337,1238,1288,1628,97;27;F
103900;1628,894,531,57,660,221,286;28;F
103912;1217,739,660,440,539,1199,1093,1720,1623,1016,274,221,286,531,434;52;F
103927;660,567,539,193,1720,221,1288,925,109,286,1666,894,440,127,1623;30;F
103946;109,780,1414,1720,868,567,573,442,260;26;F
103969;1720;35;M
103987;339,170,193,1234;22;M
103989;1238,1075,109,337,868,1234,1199,573,1490,260,1442;9;F
103990;963;36;F
103994;1093,337,1720,1414,1623,221,909,1666,339,1490,626,442,573,1238,894;34;F
103997;119,274,897,544,422,459,461,97,1238;46;M
104007;925,434;10;M
104011;446,674,660,553,1720,1041,221,1238,1628,544,109,286,97,57,700;59;F
104016;660,1623,221,286,633,55,170,1240,925,1236;60;F
104024;1623,57,780;38;M
104034;260,553,660,1199,868,1720,1623,1016,1240,221,925,109,286,1236;6;M
104059;660,539,567,1041,897,1238,909;32;F
104069;633,739,677,780,1016,1240,925,1236;33;F
104079;1199,573,660,260,626,553,442,193,1720,1623,221,1238,1163,544,109;55;M
104083;1666,1075,221,1623,337,119,868,1381,442,446,1490,339,544,434;38;F
104093;1163,286,1666,442,1381,1199,1720,1238,925,544;35;F
104101;440,539,1623,1240,221,1238,1236,739,1199,1720,780,1550,1628,544,286;41;F
104102;1238,97,700;31;F
104106;442,539,193,337,1414,1623,250,1240,221,1238,109,461,1075,286,894;34;M
104109;685,1199,780,286,1163,1550,221,1623,244,1236,1240,1016,1720,660,739;36;M
104115;685,250,539,660,739,567,274,1240,221,909,286,531,1236,1217,650;33;F
104123;739,193,897,1238,335,909;36;F
104126;1381;44;M
104154;925,434;62;M
104178;1381,539,440,660,260,739,1217,700,1236,1153,1149,1623,1628,1163,1240;26;M
104192;422,531,321,1699,1236,868,119,1041,1623,221,1238,335,109,286,57;39;F
104203;1217,1221,553,337,274,1238,925,335,544,422,180,286,1699,700,1153;42;F
104205;440,739,660,1221,1214,1217,685,1442,567,274,221,1550,925,459,286;31;F
104214;339,1720;25;F
104217;335,963,909,97,539,440,660,739,1217,650,1442,1234,1623,925,531;25;M
104236;963,553,909,1699,660,434,1550,897,274,1623,567,1221,739,1217,650;37;M
104243;539,440,660,1217,633,1238,531,1666,1720,1199,739;40;F
104244;868,180,1550,221,739,650,1720;38;F
104245;1666,1153,446,1442,626,442,1199,868,119,337,274,1238,925,335;39;F
104247;925,434;33;F
104261;650,244,1041,925,963,250,660,739,567,909,539,1623,274,897,434;49;F
104270;1199,1623,1016,1240,221,1550,1238,925,335,544,1075,286,894,531,1236;31;F
104276;55,739,650,1666,700,1628,339,1149,446,674,1720,1238,544,97,1153;31;F
104302;339,739,539,1199,1720,1623;46;F
104314;685,633,1217,169,660,539,1720,1623,274,1240,221,1238,461,286,531;26;F
104315;700,321,286,544,897,1720,127,567,442,169,626,260;38;M
104331;897,1199,539,169,1221,739,339,1217,633,660,567,1041,1623,909,531;28;F
104340;446,337,221,1238,531,700,1666;41;F
104351;446,868,1720,221,925,1628,544,286,97,1666;40;F
104357;1149,127,1720,925,1628,422;54;M
104359;1149,286,180,459,1238,221,897,780,1214,650,1217,739,1221,539,567;28;M
104364;925,434;38;M
104372;221,1238,1666,739,339,1221,260,1199,193,1234,1093,119,925,335,109;28;F
104389;626,169,321,1720,1623,1550,1240,1217,1199,739,544,539,440,286,221;46;F
104391;633,1217,739,660,440,539,567,1623,1016,274,897,221,1238,1628,286;31;F
104402;337,1623,1550,169,1199,193,1381,868,1720,1238,335,544,109,1075,1666;28;F
104404;660,650,1490,260,553,539,567,868,1041,897,1238,909,434,109;33;F
104406;1217,446,1442,440,1199,1720,1628,1153;29;M
104427;169,1221,1217,170,739,260,626,660,440,539,1720,221,1163,286,531;50;F
104429;170,660,440,539,1199,1720,1623,1550,221,1238,1288,1628,335,109,286;50;F
104435;1623,1720,539,573,440,674,169,626,739,1217,221,1550,1238,1163,286;35;F
104439;1221,440,180,1217,739,260,539,1720,1623,1238,660,626,221,286,422;15;M
104455;193,1414,897,780,109,97,1221,1163,868,260,1442,567,422,1720,1238;41;M
104460;55,446,1490,660,1720,221,1238,925,544,909,286,1666,1236,739;26;F
104472;573,567,539,1238,925,1628,544,109,963,97,434,700,1666,446,193;33;F
104478;660,553,539,567,1720,1623,221,1628,286,531;52;M
104493;660,119,221,1238,925,335,286,1666;40;F
104497;440,1550,544,109,286,1075,335,1163,221,250,1623,1720,660,739,193;34;M
104501;1199,1163,780,286,633,244,1720,1623,1550,1236,739,660,1016,1240,221;39;F
104507;925,434;5;M
104521;739,626,660,440,442,539,1381,119,1623,780,221,925,544,700,1666;71;M
104542;660,440,539,1199,221,925,109,286,1075,1238,909,1720,626,274,1217;26;F
104578;169,442,1720,1623,1550,286,321,531,1666;36;M
104584;339,1490,1149,446,674,868,337,780,1238,1628,335,544,422,459,1236;30;F
104590;221,274,1016,567,539,660,626,244,739,650,193,1623;28;F
104627;221,1041,440,739,339,660,1720,1623,780,1238,925,335,422,544,286;25;F
104631;442,539,1093,1720,1217,633,1623,1240,221,1238,1288,109,286,321,1666;33;F
104653;274,780,1623,1041,1720,1093,127,1381,1199,567,539,660,170,55,339;29;M
104663;440,1199,868,1163,544,1699,1666,1238,1550,1623,1217,660,1720,274,1628;36;M
104698;1720,677,1041,1623,1016,250,897,221,544,286,1699,1236,650,685,660;38;M
104704;544;40;M
104712;339,674,868,1720,925,544,97,700;25;F
104731;244,337,677,1414,1623,897,1628,544,422,459,650,1041,780,1238;42;M
104733;1041,650,250,1217,739,169,660,539,1623,780,894,1221,567,909,274;30;F
104736;1720,1628,544,97,1153;58;M
104737;55,567,1550,1381,1217,539,1623,1238,1163,1666,1153,1720,1288,553,193;52;F
104741;1442,1221,1149,260,1234,119,1720,897,1238,925,544,109,459,1075,1236;31;F
104751;446;38;F
104777;633,154;14;M
104779;221,1623,127,1163;53;M
104782;739,440,539,1199,1720,221,286,1153;25;F
104793;1238;21;F
104805;1550,894;57;M
104809;1221,339,1217,660,1199,193,1720,1623,1240,221,1550,1238,335,154,286;28;M
104813;780,119,1199,739,1238;21;F
104818;1381,127,868,119,337,1720,544,897,180,1236,894,170,1442,1238,925;27;F
104821;531,1236,286,221,440,739,1217,660,1720,1623;32;F
104832;650,260,868,119,1240,897,925,335,422,154,286,434,97;36;F
104840;685;13;M
104841;660,626,446,260,674,868,1720,925,1628,422,109,286,894,97,57;34;F
104855;286,440,739,539,1414,221,1628;28;M
104858;1623,442,1238,1199,1236,1720;41;F
104862;539,567,1623,274,1550,544,700,739,660,221,1238,925,909,286,1720;32;F
104866;1075,109,1234,539,440,553,660,260,739,119,1720,221,1238,909,286;27;F
104872;1550,894,1442,170,339,739,1221,169,539,1199,1093,780,897,1238,925;33;M
104875;221,321,1720,1666;39;F
104880;674,193,1720,925,544,180,909,700;27;F
104895;260,700,1720,97;64;F
104908;650,1442,337,897,1238,286,894;25;F
104914;544,446;52;M
104932;1149,446,674,1414,1238,925,109,544,700;53;F
104937;539,1199,127,119,1720,1041,1623,1016,250,1240,1238,544,109,286,894;51;F
104965;539,442,1381,1720,1240,221,1550,1628,286,260,660,119,925,109,1236;67;F
104967;1720,127,1623,1016,1240,221,1550,1238,1163,1628,544,286,894,531,1236;46;M
104970;567,1199,119,897,1238,1288,1628,335,544,1075;32;M
105008;963,674,434,739,1217,1149,1442,539,1234,250,109,1075,909,286,1699;22;M
105036;650,193,1623,1442,221,1550,1628,1075,286,894,57;54;M
105037;660,440,1628;46;M
105052;897,1041,868,567,442,660,109,260;70;F
105055;337,1720,1623,274,1238,925,154,739,1221,626,660,1381,221,180,422;10;F
105058;1699,221,626,739,250,1550,109,286,531;33;M
105063;739,674,660,539,1238,335,544,700,1153;36;F
105070;1238,1666,1623,339,1217,626;27;M
105075;925;43;F
105137;97,1666,1236,567,1381,868,1240,1550,1238,1163,1628,335,109,286,894;40;M
105155;442,127,1720,1238,109,286,1666,1153,1149,119,337,925,459,97,1442;67;F
105158;1214,1221,539,567,119,109,909;80;M
105165;963;42;M
105167;459,531,97,170,739,539,127,337,221,1550,544,286,321,57,700;34;M
105188;434,1236,909,446,1221,626,169,660,1240,553,567,193,1041,274,221;39;F
105199;674,446,739,660,440,539,1234,868,119,1720,221,1238,925,1628,544;33;F
105203;260,440,442,1720,109,1075,1666;17;F
105243;260,193,1666,1199,1238,1628,1149,446,544,97;29;F
105246;339,567,1381,119,337,1720,1041,780,897,1238,335,422,925,434;41;M
105252;531,286,335,1163,221,1623,1720,442,440,260,739;26;M
105257;1381,1623,440,1720,221,286,531,321,660,674,169,127;41;F
105259;1041,925,459,1075,909,286,434,57;36;M
105282;260,539,1623,1240,221,1238,286;6;M
105315;1490,442,1238,1666,250,897,544,286,339,119,1199,1720;29;F
105336;1240,1163,109,461,1075,286,531,1236,260,660,553,539,567,193,909;34;M
105352;1221,1238,422,180;32;F
105354;685,660,1623,650,1016,244,1550,1240,739;33;M
105367;1720,321,1666;8;F
105368;1236;22;M
105370;339,260,539,1199,1234,119,1720,221,1238,1288,925,1628,544,109,286;40;F
105377;739,1217,626,660,1623,260,446,1720,221,925,1628,544;69;M
105385;1550,780,573,440,660,539,868,1623,286,739;37;F
105392;539,193,868,1720,1240,221,1550,1163,544,286,531,1236,963,1623,440;37;M
105400;335,894,97,1666,544,1238,274,1623,780,1720,119,1234,442,660,739;52;M
105402;1628,1238,286,1720,119,539,440,660,626,244,739,339,1217,650,57;30;F
105425;963;71;M
105454;739,260,169,539,1720,221,1550,1163,335,544,109,1075,286,531,321;9;F
105478;553,442,119,1163,154,97,57;70;F
105479;1720,321,1666;5;M
105483;119,337,1720,780,274,221,1550,1238,925,1163,1628,335,544,180,321;44;F
105514;180,1236,1381,442,739,685,539,260,339,633,1720,1163,894;42;F
105551;260,539,1623,1240,221,1238,286;4;M
105552;1720,321,1666;40;M
105561;685,260,1442,539,1199,193,868,1016,1238,1550,925,1163,335,422,109;44;F
105572;539,193,1234,119,1041,221,925,1628,459,1720,1623,780,1238,544,286;29;M
105587;660,650,1217,739,274,221,1238,422,459,461,180,286,894,57,1699;29;F
105611;169,1720,127,650,677,274,700,633,685,1217,442,567,1550,544,1666;49;F
105623;1623,1041,677,739,1199,1720,780,274,250,1550,925,459,434,57,1153;51;F
105627;1720,109,286,321;28;F
105628;339,440,1199,119,286,221;38;F
105640;446,260,440,1093,1628,1153,660,1199,127,1720,221,1550,544,109,286;43;M
105641;531,539,1442,660,739,339,446,674,567,1720,1238,1628,544,461,700;31;M
105661;633;26;F
105674;739,442,260,1720,109,1075,1666;58;M
105676;260,660,1720,221,1550,1163,335,544,422,109,1075,286,894,531,321;6;M
105685;169,1221,1149,1217,739,660,440,539,567,1623,897,925,544,909,286;30;F
105695;1550,286,1236,1666;45;M
105725;221,925,335,286,170,633,739,260,660,440,1199,1623,1240,1163,1236;36;F
105745;339,1214,553,442,567,1199,1628,109,909;77;F
105748;739,633,963,286,1236,650,244,1623,780,1628;27;M
105751;674,1720,221,1163,700;29;M
105764;700,544,1149,97,1153;29;M
105782;169,660,127,1720,1623,221,925,1628,286;33;M
105786;739,626,660,442,1623,700,221,1550,544,286,1153;82;M
105814;963;74;F
105837;1199,897,1238,925,335,422,180;31;M
105844;626,660,440,442,539,1720,221,1163,1236,286,674,544,169,739,1550;25;F
105852;894,909,180,1075,963,461,739,660,1016,221,1628,422,286,1442,780;31;M
105859;650,244,440,539,1240,739,660,780,1016,925,1236;53;M
105860;573,1199,260,193,1234,1666,909,1628,1414,1238,1163,180,1720,422,57;32;M
105874;553,193,1720,925,422,459,461;47;F
105879;286,544,221,1720,440,169,626,1221,244,739;35;F
105891;1442,674,660,169,626,739,539,1199,1720,1623,780,221,1550,1628,286;51;F
105921;260,244,339,739,539,1720,780,250,1238,459,963,434,57,1699,1236;72;F
105975;660;4;F
105979;739,1623,274,250,1550,286,434;45;M
106002;531,286,544,221,1720,739,626,660,440;28;M
106003;660,539,193,1720,1016,1240,221,1550,1628,544,894,1699,1666,1236,1163;52;M
106010;339,739,567,337,1720,1041,780,1238,925,434;39;F
106039;1238,544,286,97,1153,674,660,337,221,1628;47;F
106045;868,1381,260,1490,780,1238,109,1075,57;52;F
106047;739,244,1442,660,539,868,1240,221,925,286,531,1016,1550,1236;34;M
106050;660,539,193,119,337,1623,1016,221,459,286;35;F
106068;169,260,1221,446,244,1149,1490,339,739,539,660,1381,1153,1075,97;19;F
106079;739,633,1199,221,1238,335,286,531,57,700,1217,244,440,1628,1093;27;F
106083;1550,1163,544,459,286,531;18;F
106108;633,739,660,1381,1234,868,1720,1623,1016,1240,1550,1238,925,335,1236;30;M
106109;442,127,119,1550,925,544,109,459,286,894,97,57,700,1666,1153;68;F
106113;1623,250,221,1238,1288,544,422,459,909,286,531,434,97,57,1666;30;M
106127;434,97,57,700,1149,739,446,260,660,539,337,1623,1628,544,109;14;F
106138;685,553,193,1720;49;F
106146;170,1199,1720,1623,1550,544,109;41;M
106152;459,286,170,660,1199,119,1016,1240,221,1550,422,109,963,57,1236;32;F
106175;539,440,660,739,1238,544,286,1016,1240,650,894,626,1628;34;M
106204;553,1016,250,1238,422,180;53;F
106211;1720,1238,925,1628,544;36;F
106216;660,440,1288,925,339,1149,1442,573,1199,1234,1720,1623,780,1240,1238;27;M
106220;1149,244,674,250,1240;27;M
106253;1666,1016,1623,57,650,660,1240,221,1238,1628,286,1236,339,1234,1720;27;F
106259;221,1238;49;F
106262;650,339,567,337,1623,897,1238,335,909,286;27;F
106264;1214,260,539,567,1199,193,868,1720,1238,1628,335,109,1075,180,57;32;F
106266;1199,119,739,1720,1217,1221,260,626,553,440,442,1381,1238,335,1666;37;F
106281;1199,1238,544;41;F
106283;119,868,1199,567,440,1217,339,739,660,539,1381,1414,1623,1238,335;26;M
106287;660,573,244,739,1199,119,1016,1240,221,1550,1238,180,286,57,1236;23;F
106295;660,221,1550;41;M
106302;925,440,674,1442,169,1221,446,633,739,660,539,1623,1550,1238,335;44;F
106309;626,739,221,250,1550,109,963,286,531,1699;32;F
106313;422,459,97,1153,660,1199,868,780,1288,544,1628,1720,1550,109,286;65;F
106337;1720,1623,1199,963;54;F
106340;1550,1623,1720,244,685,739,660,539,1199,1016,1240,221,963,1236,286;33;M
106354;567,1234,868,1238,109,1075,286,739,660,539,1381,1720,1414,1623,221;50;F
106359;1628,925,1238,119,446,1149,674,442,544,700;74;M
106361;1550,544,700,1623,286,1381,442,1075,1720,539,1221,567,119,909,1217;36;F
106370;660,539,567,1623,274,925,909;28;F
106387;650,553,925,434;34;F
106401;1163,1238,685,650,633,1214,260,1199,1234,1016,221,1628,286,1720;49;M
106412;1149,446,1414,544,97,700,1153;38;F
106424;169,260,286,700,1666,1236,674,442,193,119,780,1550,1238,925,1628;48;F
106443;1720,1199,1442,626,1221,1214,339,1490,244,1016,1240,1238,544,286,1666;29;F
106447;1221,244,633,1217,339,739,660,440,539,1199,1720,221,1238,109,286;43;F
106453;1442;10;M
106457;244,539,1199,1550,1288,1666,1153,1149,339,193,1720,1240,221,1238,286;34;F
106460;55,685,1199,193,780,544,109,459,739,221,1666,531,1238,286,434;24;M
106470;626,337,1720,780,335,544,459,57;51;M
106479;539,1623,442,660,739,1720,1016,274,221,1238,1288,544,286,531,1666;57;F
106497;567,539,660,1217,1442,260,553,868,1623,925,422,109,180,909,894;41;M
106521;567,1720,925,1628,1623,422;28;M
106530;1623,739,339,539,221,544,286,97,1153;39;F
106538;1720,1016,1163,422,700,660,650,193,274,250,897,221,925,286,1699;34;F
106554;1490,339,119,337,1414,780,1628,335,544,97,57,274,1238,925,422;42;F
106571;553,780,1016,1240,897,1550,544,154,1236;19;M
106580;1628,1163,442,674,544,700;75;F
106583;1236,221,1623,1720,1234,127,567,539,440,660,169,626,897,1238,422;25;F
106589;286,1217,739,626,674,660,440,539,1720,1623,221,544,909,700,1153;37;F
106590;739,244,660,539,868,119,1623,780,1240;47;F
106606;1041,274;34;M
106607;1666,1288,1240,1623,780,539,660,739,339,573,119,1016,221,1238,286;49;F
106608;1550,1240,1199,1016,739,660,544,685,677,553,1236,244;38;M
106648;339,1238,925,286,894;36;F
106661;544,1623,567,739,660,440,539,1720,221,1550,1163,109,286,57,1236;27;M
106666;539,1381,868,1623,221,1238,1163,544,422,459,461,1075,531,97,321;37;F
106668;1442,539,1381,1093,868,1623,1240,894,739,660,440,286,1720,221,1238;34;F
106682;180,127,633,221,286,539,567,739,925,1221,1720,909,1623,650,274;32;M
106687;434,1666,1093,1199,567,539,260,739,633,221,1238,925,1628,544,286;29;F
106690;1720,1623,780,1016,1240,221,1628,1238,963,286,531,660,1442,260,739;37;M
106698;221,909,97,700,1240,274,780,1628,531,286,925,1041,739,567,434;15;F
106708;1442,260,446,1149,339,1217,650,685,1623,1666,321,739,660,119,544;33;M
106716;633,1149,739,260,539,1199,1720,1623,780,1016,1238,925,1163,1075,531;29;F
106724;446;68;F
106732;286,1550,1240,1238,57,633,780,677,539,442,660,685,1236;38;F
106760;1199,1381,127,868,119,1720,1238,1628,544,109;32;F
106767;739,650,286,221,909,1041,169,127,1163,780,1720,633,244,1623,170;17;M
106790;1214,650,567,780,897,1238,1163,1628,335,544,422,459,909,894,57;35;F
106791;422,1238,1623,337,868,539,442,440,660,674,446,739,1199,1381,544;46;F
106793;553,1199,1234,677,1623,1016,1240,221,1238,109,909,286,57,422,180;53;F
106799;260,660,1199,1234,868,119,1720,1238,109,1075,1490,1442;38;F
106801;544,909,531,1666,221,274,1623,567,539,440,660,1217,650,286,97;36;M
106812;1199,1720,1623,221,1550,1238,1628,544,109,1075,286,97,321,1699,700;37;F
106815;1217,660,260,442,1238,57,553,1666,461,180,422;48;F
106830;109,461,1075,180,909,1217,339,739,660,539,193,1234,1720,925,57;37;F
106843;1442;41;M
106851;660,553,193,1238,925,1628,335,422,180;24;M
106856;1217,739,1221,553,539,567,1623,221,1238,422,180,909;67;F
106870;674,544;75;F
106871;339,260,660,440,1093,1720,1623,221,544,109,286;27;F
106890;674,660,1720,221,1628,544,286;34;M
106903;739,626,169,660,539,1720,1623,1240,221,1238,286,531,57,1666,1236;19;F
106905;1214,650,170,260,626,1199,193,1234,1720,1623,250,1550,925,286,894;21;F
106922;1217,660,539,1199,1720,1623,1016,221,286;48;M
106923;446,650,1720,1628,335,1075,739,1623,221,1550,925,544,286,868,440;22;M
106930;260,440,868;23;F
106937;1075,700,1236,1490,446,260,1199,1381,868,1666,660,442,1720,1414,1238;25;F
106940;1234,868,1623,1016,1720,677,1240,221,109,286,260,739,633,1666,1236;62;F
106947;170,531,286,1238,335,1720,442,119,337,925,544,97,57,339,1666;47;F
106952;1623,531,1221,553,440,221,286,169,1720,1628,739,660,539,567,1550;35;F
106976;1221,446,339,868,544,180,119,1238,422,459;49;M
106985;739,539,567,1199,274,897,1288,909,1699;35;F
106997;1016,897,422,286,925,434;11;F
107014;1442;55;M
107030;55,260,440,193,1623,221,1238,544;16;M
107031;626,739,1214,1217,193,1720,1623,1238;29;M
107036;221,274,780,1623,1414,1720,337,650,339,925,422,260,1234,868,1093;36;F
107040;894,335,1238,250,1623,868,193,442,553,260,1490,170,650,685,1442;53;F
107041;274,780,567,1217,739,626,169,1720,221,286,1623,660,553,539,193;64;F
107042;1149,1163,1628,544,422,459,700,97;49;M
107057;1217,739,660,440,539,221,286,1666;29;F
107069;193,780,274,1628,531,119,1163,1214,260,1199,1720,1238,109,567,909;30;F
107077;1236,221,1240,660,739,440,539,1199,1238,286;33;F
107096;127,567,440,1217,739,660,539,1720,1623,221,925,1628,544,909,286;24;F
107097;127,1628,544;28;F
107145;660,1221,739,539,1720,1623,925,286,1163;49;F
107173;1217,739,1221,553,539,567,221,1238,422,180,909,286;10;F
107183;1623,274,925,434;10;M
107208;1623,1199,660,674,1221,244,1217,440,567,1720,221,1238,700,739,539;25;M
107225;650,274,250,925,434;27;F
107250;780,1623,1153,739,440,567,1199,1381,897,221,1628,544,422,97,57;28;F
107253;1666,1238,1199,1550,1016,567,553,1236,780,459,894,180,1720,422,57;40;F
107268;1490,442,539,1199,193,1234,1093,868,119,1720,1623,780;29;F
107275;1153,567,193,97,660,1163;30;M
107278;780,109,700,170,1221,660,440,1720,1163,446,193,221,1238,1628,544;22;M
107282;1442;40;M
107290;1720,1221,1217,539,567,193,909,286,1666;49;F
107333;868,539,442,1666,1153,339,1149,446,660,440,573,1199,1720,780,1238;31;F
107346;573,442,674,868,1238,925,544,422,700;39;M
107351;1217,660,567,274,544,422,909,531,434,739;38;F
107357;963,544,1628,1240,250,274,1623,1041,1720,539,440,660,169,1217,650;19;M
107382;260,553,193,1381,1720,1628,422,170,1093,780,544,109,459,97,57;49;F
107384;221,925,422;50;M
107385;1199,1720,1016,633,739,660,539,1623,780,1240,221,1628,422,286,434;43;M
107423;1217,660,567,274,422,544,909,531,434,739;34;F
107446;119,337,1720,1414,1623,780,274,1240,221,1238,109,909,286,894,57;44;M
107449;193;46;F
107466;1221,1217,553,440,1623,780,221,544,286,739,660,539,193,1720,1153;41;F
107468;1214,446,660,539,337,1720,1414,780,221,1238,925,544,286,1666,700;20;F
107494;1199,1093,119,1720,1623,221,1550,1238,925,1163,335,544,109,461,286;27;F
107504;1442;45;M
107513;739,660,539,1199,1720,1623,221,1238,925,544,286,1236;25;F
107520;573,674,739,700;25;F
107525;446,544,1153;35;F
107531;1217,674,221,1550,925,1628,544,422,180,286,894,446,868,1623,700;35;M
107534;260;4;M
107544;633,739,244,1199,677,1623,1016,1240,1288,963,286,1236;35;M
107547;739,573,539,193,1720,1623,221,1550,1238,544,109,286,531,1666;39;F
107556;446,1199,1623,1238,1163,422,1075,894,97,57;35;M
107558;544;15;M
107563;674,1238,1628,544,700;45;F
107568;1016,909,57,1217,1214,739,1221,260,660,553,539,567,1720,1238,109;36;M
107596;531,1214,739,660,440,539,567,127,1720,1623,221,1628,544,909,286;28;M
107605;544;17;M
107608;544;15;M
107613;739,626,660,539,567,1623,780,1016,250,909,894,1699,650,274;36;F
107623;780,1240,1238,221,1381,440,739,339,1666,660,442,539,1199,1720,286;36;F
107626;446,780,1628,544;41;M
107634;1149,260,442,539,1041,1240,221,1238,925,1163,154,109,97,1666,1153;40;F
107647;674,553,1720,544,180,1153,446;54;M
107650;674,660,440,193,868,780,221,1550,925,544,459,286,321,57,700;28;F
107655;260,626,660,539,1199,1234,1093,1623,109,1075,97,1153,221,1628,544;33;M
107674;544;15;M
107681;1720,119,442,660,739,1217,1221,553,567,1199,193,221,1238,544,286;30;F
107686;1623,1414,119,539,660,260,339,650,1720,739,1442,1199,1238,925,286;16;F
107696;1163,1623,868,660,440,739,170,221,1550,925,286,127;36;M
107697;1238,1041,1214,1217,925,434,57,1628,422,1221,539,1720,868,567,909;41;M
107700;221,1075,434,109,544,925,1238,1623,1720,193,539,660,260,739,97;23;F
107701;1442;68;M
107709;335,544,422,894,626,739,1214,1217,650,57,260,567,1238,109,1075;41;M
107712;553,1075,422,180;40;F
107715;1217,739,260,626,440,539,868,1240,180,531,553,1016,250,422,109;38;F
107724;422,1153;52;F
107731;422,1153;62;F
107735;650,260,1234,868,780,1238,422,109,459,1075,57;7;M
107746;1720,780,925,1628,335,539,1234,1623,221,544,422,109,286,531,1381;13;F
107749;170,660,440,1623,442,260,127,1720,780,221,1550,925,1628,109,286;69;M
107768;544;36;F
107775;674,442,193,127,1720,677,274,1628,544,97,700,1153;27;F
107819;1075,337,339,260,868,1238,925,109,422,544,1153,97,674;34;F
107828;685,573,539,1199,1381,1234,677,221,1238,1163,544,109,963,1075,286;35;M
107837;780,909,567,57,626,1221,434,1041,1720,925,274;39;M
107844;567,925,909,434;46;F
107863;260;8;M
107871;244,739,626,868,221,1550,1238,1628,544,109,909,286,894,531,434;35;F
107889;1720,1623,221,544,700,1153;29;F
107890;660,539,440,1234,1016,274,1240,897,1550,1628,544,422,286,434,700;29;F
107925;339,1149,1442,193,868,1720,1623,250,1238,925,335,544,422,553,1214;56;F
107947;633,650,674,660,169,260,739,170,1623,221,1550,459,286,57,1153;32;M
107949;1149,446,1414,544,97,700,1153;38;M
107950;1623,1163,335,461,531,321,57,1699,193;48;F
107960;660,440,573,567,274,897,221,286,531,339,739,539,1720,1238,1666;27;F
107961;339,1199,1234,119,337,1720,780,1016,1240,1238,1163,109,57,1666,1236;32;F
107965;442,1381,1093,531,221,119,567,539,739,1720,1238,544,286,57,1666;37;F
107980;674,1153,1149,97,446,1199,193,925,1163,335,544,1699,700;34;M
107991;260,1381,1234,868,780,335,109,459,1075,57;5;M
107993;739,1720,1623,1016,274,1240,221,1163,1628,544,459,286,531,57,1236;30;F
107996;1236,169,660,422,1234,739,1442,1199,193,780,1240,1550,1163,286,1628;33;M
108022;109,1075,170,553,1199,193,1093,1720,780,544,422,459,97,57,1666;15;F
108050;544;40;M
108052;1236,1016,1720,650,739,660,440,539,1199,119,1623,221,1238,1628,286;45;F
108065;446,1381,337,339,1149,260,674,868,1238,544,109,1075,286,97,1153;45;F
108078;1149,446,260,440,1199,1720,221,1238,1628,544,97,1153;14;M
108084;553,422,1075,180;2;F
108085;446,1238,1163,1628,544,109,1075;12;F
108087;434,700,1153,339,170,739,660,539,1238,1288,544,286,1149,446,97;48;F
108088;544,97,700,1153,1149;36;F
108091;633,739,446,674,1199,337,221,925,544,286,97,57,700;75;F
108094;244,1550,459,1666,1240,1153;67;F
108122;1442,1153;70;F
108126;1149,446,97;4;F
108134;442,339,1490,221,1199,868,119,337,1414,1238,925,335,109,434,1666;30;F
108145;1720,193,1199,339,119,1016,1550,1238,925,109,286,894,434,97,1236;27;F
108149;339,260,127,1720,109,1075,894;48;F
108151;339,57,1217,193;31;F
108155;1149,446,544,97,1153;61;F
108160;442,1238,286,544,1234,1199,260,446,55;38;F
108171;119,1720,1414,897,221,1550,925,544,109,286,894,434,1699,1666,1238;22;F
108173;1217,1623,274,925,1163,422,434;51;M
108187;1628,55,626,1199,193,422,109,894;40;M
108228;434,925;37;M
108234;650,739,660,1199,1720,1550,544,963,434,1041,567,1628,909;43;M
108258;446,674,553,1720,544,180,1153;40;F
108270;109,1238,434,925,1041,909,567;36;F
108271;446,97;9;M
108272;650,739,660,1199,1720,1041,1550,544,434,567,1628,909;36;F
108274;544,1153;47;M
108276;660,169,1214,1221,567,1381,868,119,925,544,422,109,909,286,57;30;F
108280;1240,1016,1236,1234,633,739,1199,440,660,677,1720,1623,221,1238,286;37;F
108291;531,286,260,660,868,1720,897,109;39;M
108303;573,459,1238,780,739;29;F
108313;544;57;F
108333;909,1666,633,1217,1214,442,925,1075,1236,260,553,109,459,461,180;73;F
108354;573,1234,250,1240,1666,1217,170,1720,1623,1016,897,221,1550,1238,109;31;F
108379;1442,127,1720,1550,894;47;M
108381;567,868,337,1623,780,221,1238,1217,180,909,286,894,531,1221,57;29;M
108383;169,1221,1149,1214,633,170,446,97;53;M
108393;925,1628,335,459,286,531,57,1666,1236,650,739,1414,250,221,1238;41;F
108394;446,674,553,1720,544,180,1153;10;F
108400;260;51;M
108402;660,440,539,1381,1720,221,1238,544,321;35;M
108416;1149,446,97;7;F
108455;442,1093,1720,260,1199;65;F
108488;660,440,1628,531,1149,1199,1720,1623,780,1238,700,1153;51;F
108526;1666,925,1240,274,780,1623,1720,1199,660,260,434,897,193;29;F
108536;1217,1214,1221,539,567,868,1720,1041,1238,925,1628,422,909,434,57;9;F
108537;446,674,553,1720,544,180,1153;4;M
108541;650,440,539,1720,1016,250,1240,221,1550,1238,544,109,1075,286,1666;54;F
108542;685,1666,660,193,1720,286,1041,1628,677,1623,909,1238;37;F
108552;650;18;F
108556;440,1414,1238,422,1075,1217,1221,539,567,925,544,109,909,286,57;56;F
108571;244,1221,660,539,193,1720,780,1623,1240,221,925,1163,459,1236,1666;32;M
108589;739,55,539,1199,1623,1240,1238,544,154,286;48;F
108597;925,1041,434;46;F
108599;567,442,660,739,339,1221,539,868,337,1238,1628,180,909,286,1666;41;F
108601;544,1666,700,127,169,1163,1199,170,1550,1720,321,531,1623,221,286;36;F
108607;1442,553,573,1720,1016,1163,1666;55;F
108618;1217,1720,1623;38;M
108629;868,1720,1623,780,1016,1288,1628,335,286,57,1666,674,1550,544,459;43;M
108633;446,674,553,1720,544,180,1153;3;M
108635;660;8;F
108637;170,109,1075,1628,169,539,897,1550,335,700,260,660,1238,286,531;43;M
108654;434,780,1217,660,1234,1623,1016,1240,221,531,539,739,633,286,1236;43;F
108666;925,434;7;M
108669;1238,1442,1153;42;F
108679;1442;14;F
108690;170,97,57,685,650,633,553,244,260,1720,677,1623,1016,1240,1236;33;F
108770;339,1199,1093,119,1238,573,539,1623,1016,1240,221,1550,1163,286,1236;25;F
108777;1149,446,544,97,1153;65;M
108780;780,1016,1240,221,1550,1238,925,109,459,963,1075,286,894,57,1236;33;F
108781;544,446;44;M
108791;739,1490,539,677,1240,221,1238,925,963,286,1153;38;F
108800;260,440,1234,868,109,1075;67;F
108805;1214,780,1238,1628,700,674;27;M
108816;531,286,1238,221,897,274,1016,1623,1381,193,539,440,660,739,1217;28;F
108833;1149,170,660,440,539,127,1623,780,221,1550,925,544,286,531,57;17;M
108834;868,1720,894,1666,193,1199,442,685,337,1238,1163,109,461,1075,180;34;F
108855;573,1623,170,1238,1163,335,154,109,459,461,1075,169,127,1550,894;34;F
108869;739,1623,1240,221,1628,286,544,1163,780,660,1550,925,97,1236,685;45;M
108877;440,539,127,1720,1016,1240,221,1550,1628,544,286,531,434,321,1236;31;M
108880;544;15;F
108888;567,274,925,335,422,109,461,1075,57;23;F
108898;1234,1381,539,440,660,626,739,339,633,674,780,1628,544,700,1153;41;M
108918;660,553,539,1720,1623,780,250,1238,335,544,109,459,1075,286,57;27;M
108941;650,339,1490,1199,1720,109,1075;36;F
108961;337,1041,1414,1238,925,1163,335,422,109,1075,700,544,1016,739,674;44;M
108964;339,897,909,1720,260,660,1623,221,1238,1628,109,1075,286,1217,553;49;F
108980;1149,446,544,97;13;M
108996;1720,567,1041,274,897,925,544,909,434;33;M
108997;531,925,221,274,539,440,660,633,685,739,446,193,1720,1623,544;33;F
108998;739,1163,260,193,1234,250,1628,335,422,109,1075,286,894,1236;36;F
109007;1199;27;F
109011;1720,1041,567,274,897,925,544,909,434;34;F
109014;633,739,660,539,1199,1720,1623,780,1016,1240,221,1628,422,286,434;12;M
109017;1041,925,434;11;M
109018;286,459,154,422,780,119,868,1234,1381,1199,626,739,660,677,1623;49;F
109019;1442;12;F
109026;422;46;M
109028;739,626,337,1720,925,1163,544,1628;41;M
109029;260,660,440,539,1720,1016,1240,221,1550,544,109,286,1666,1236,1153;63;M
109030;539,440,660,1217,674,1149,1720,221,1153;35;F
109033;1217,739,660,440,539,337,1720,1414,1240,221,1238,925,422,180,1236;15;F
109038;221,109,1075,286,180,434,1153,685,553,1623,1240,1238,544,894;54;F
109060;260,442,1199,1414,1240,221,1238,1163,335,459,1075,531,57,1236,1666;72;F
109069;109,1628,1238,868,1149,1490,260,442,573,1153;26;M
109078;442,739,170,260,169,1199,1234,1720,1623,897,1550,1238,109,286,531;38;F
109079;260,109,442,739,1214,339,1221,553,567,193,221,1238,1288,925,909;43;F
109084;244,739,339,685,1075,1490,446,260,1199,1381,868,1666,442,1414,1238;26;M
109087;97,1199,539,660,674,446,739,1414,780,1550,1163,544,1153;20;M
109093;685,193,274,250,660,1016,1550,286,650,440,567,1623,780,1240,1236;30;M
109108;1240,739,193,1236;66;F
109123;1720,739,539,1199,1093,1414,1623,1238,1163,109,1075,286,97,1666,1236;40;F
109141;1041,925,434;8;M
109153;97;16;F
109164;567,553,868,337,780,1240,221,1238,925,335,422,909,286,434,1153;45;M
109165;109,1238,434,925,1041,909,567;5;F
109173;925,434;9;F
109174;339,446,260,442,1720,109,1666,544;70;F
109188;422,674,180,97,700,1628,1550,127,660,169,260,739,1075,539,109;46;M
109198;633,739,660,539,1199,1720,1623,780,1016,1240,221,1628,422,286,434;7;M
109200;446,260,674,573,1381,868,119,337,1238,544,109,286,97,700,1153;49;M
109232;1442,119,1720,633,1199,1666,335,1550,1240,1234,260,573,868,739,1238;40;M
109234;674,434,260,1666,1381,97,739,567,650,127,1236,1217,1016,685,677;40;F
109243;1238,286,1236,660,1234,868,1623,1240,221,1720,1016;38;M
109246;1442;27;F
109247;925,544,909,286;43;F
109262;544,446;38;F
109290;1414,1623,119,868,1240,1238,925,335,544,1153;29;M
109292;260,1214,170,633,244,660,440,780,1016,1240,1550,1238,963,286,1236;47;F
109316;1236,321,193,339,739,539,567,127,1016,1550,57,286,909,459,1238;24;M
109320;544,446,1550;36;F
109331;925,434;51;M
109333;442,440,674,446,170,739,660,539,119,1720,1623,221,925,544,700;67;F
109336;633,1217,339,1490,446,553,440,442,573,1381,1234,1720,1414,1238,1163;30;F
109343;1240,780,1720,567,660,1550,221,170,1623,244;57;M
109344;193,170;35;F
109349;109,1238,434,925,1041,909,567;2;M
109355;567,1234,119,335,1238,1381,909,544,221,1720,1628,1153,1149,674,700;27;F
109358;169,660,440,539,1016,1240,221,1550,544,909,286,531,434,321,1236;33;M
109368;446,567,868,1720,221,660,180,1093,1628;26;M
109397;221,286,180,544,1628,1623,674,626,446,1149,700,1381,1720,97,1153;35;M
109403;339,660,567,193,1720,780,1240,221,1163;27;F
109410;633,739,660,539,1199,1720,1623,780,1016,1240,221,1628,422,286,434;17;F
109419;1217,539,567,1623,909,286;50;F
109423;544,461,286,57,260,660,1234,1720,1623,221;28;M
109431;1442,1153;51;M
109454;739,1221,660,539,1623,250,1240,221,286,531,1238;48;M
109462;868,1414,1240,925,1075,894,55,339,539,567,274,897,1550,544,909;31;F
109467;650,567,897,909,434,1699;5;M
109486;109,1238,434,925,1041,909,567;35;M
109488;553,539,127,868,119,1623,1240,1238,925,544,286,909,894;29;F
109493;1442;41;F
109529;446,442,1628,544;68;M
109536;446;38;F
109540;1414,1623,1163,739,260,1199,1093,1720,780,1238,1628,335,109,1075,57;52;F
109560;339,442,573,1234,868,119,1414,221,1238,422,109,286,97,1666,1153;37;F
109583;633,739,660,539,1199,1720,1623,780,1016,1240,221,1628,422,286,434;46;F
109585;677,286,1490,660,1199,193,221,97,539,1075,109,1163,446,1550,544;41;F
109603;660;38;M
109607;1720,1414,1623,221,1288,925,1628,335,544,286,567,897,1238,909,894;41;M
109624;539,274,109,1236,1217,1214,739,567,1381,868,1240,925,897,1238,909;35;F
109626;633,739,660,539,1720,221,286;59;F
109658;650,567,897,909,434,1699;1;F
109671;650,739,674,539,567,677,1240,1288,544,1234,1041,1623,1550,1163,1628;25;M
109700;739,660,440,1720,1623,1550,221,925,1628,544,422,97,700,286,57;25;M
109702;260,434,57,567,1199,1623,250,1238,109,1075,963,180,286,1720,1041;33;F
109705;335,963,677,739,1240,1288,154,1414,567,897,909,925,1720,1041,434;62;M
109706;55,221,925,422,459,180,57,1236,339,660,539,1199,274,286,897;28;F
109707;1236,440,244,674,660,1720,1016,1240,221,1550,544,286,531,321,700;61;M
109710;1442;80;M
109724;1699,97,700,1628,321,1550,1238,109,1075,339,1199,1720,335,544,531;41;F
109725;897,1217,739,660,440,1199,221,1236,539,193,1720,274,250,286,1699;39;F
109728;170,633,553,193,1381,1163;44;F
109740;1442,539,1234,193,1240,1666,1199,1720,1414,1623,1016,1550,1238,1163,1236;25;F
109749;260,109,1075,286;29;F
109757;1149,446,544,97;51;F
109761;339,221,544;32;F
109786;650,567,897,909,434,1699;44;F
109787;260,109,1075,739,1720,1041,1623,1550,925,544;17;F
109800;1720,440,260,1214,1217,739,1221,660,539,567,780,925,544,109,909;58;M
109805;169,1221,1217,650,739,626,660,440,539,119,1720,274,221,1628,286;35;F
109808;685,1236,286,739,244,660,440,539,1720,1623,1016,963,1550,1240,221;35;F
109850;553,55,567,1234,1720,1238,422,154,459,180,97,461,57,193,1163;21;M
109851;1720,335;47;M
109853;1442;76;F
109865;446,1381,1199,1623,1238,1163,422,1075,894,97,57;34;F
109887;1149,446,97;44;F
109891;221,180,1221,169,626,553,440,193,274,925,909,286,650,1217,1214;41;F
109903;677,337,1490,650,339,660,1199,193,1234,119,1720,1016,1240,925,1163;72;F
109905;573;26;M
109914;250,1623,434,925,1720,274,553,539,868,897,650,1238,909,1041,567;40;M
109923;739,260,119,1720,1414,109,544,1550,633,1093,1623,780,1238,925,286;26;F
109926;739,169,660,440,539,1720,1623,1016,274,1240,221,286,531,1699,1236;39;M
109931;1240,685,739,260,660,440,1199,1381,1234,1720,677,1623,1550,1238,1236;38;F
109933;1221,446,1217,440,539,221,97,339,739,660,1720,1623,1238,1628,544;37;F
109939;221,1288,1628,531,57,1236,1217,633,1214,442,1381,1720,1240,1238,1666;32;F
109946;894,1628,286,109,633,440,539,1720,1623,1016,274,1240,897,221,1550;39;F
109952;925,434;41;F
109962;1623;45;M
109969;660,1720,1623,221,531,633,739,244,539,1381,1016,1240,1550,1238,1236;22;F
109984;739,244,626,169,660,1720,1550,1238,1075,531,434,57,700,1236,539;18;M
109987;1217,55,660,539,567,1234,1623,897,1628,286,1381,925,440,780,909;25;M
109995;553,442,337,1238,422,180,909,1666;70;F
109996;321,1236,1381,1720,1149,97,1153,700,446,286,1628,1623,221,674,544;48;F
110000;633,244,260,169,109,1075,539,1720,1623,1016,274,1240,897,1550,925;42;M
110007;739,660,119,1381,1720,1414,1623,780,221,1550,1238,925,544,109,286;27;F
110032;1442;43;M
110042;1217,1221,193,274,434;44;F
110058;260,573,1199,1234,337,1414,1016,1240,1238,1288,335,544,109,1075,286;42;F
110072;626,1221,244,339,1240,250,1720,539,440,660,739,1217,650,221,286;25;M
110082;442,119,1623,109,127,1720,1016,221,1238,1163,1628,286,531,97,1666;65;F
110086;739,260,446,573,119,1720,1414,221,1550,1238,544,109,1153,286,97;47;F
110088;274,531,1236,739,674,660,1240,221,1550,1628,335,544,286,894,1153;40;M
110105;925,434;41;M
110108;1442;12;M
110131;739,260,626,1442,660,1199,1720,1623,221,1238,1163,109,1075,286,894;47;F
110145;193,539,1221,739,339,1217,1236,660,1240,963,286;33;M
110149;1720,739,1623,780,1016,925,1236,1628,1163,1238,1550,1240,1199,193,650;29;M
110156;119,780,221,286,531,434;48;M
110173;1442,573,1199,1075,119,1720,1414,274,250,1550,1238,1288,109,894,1666;32;F
110180;739,1442,539,660,567,1041,1016,1550,1214,544,459,97,57,780,1628;40;M
110187;55,422,109,461,1075,909,260,660,553,193,1381,1720,1623,221,180;33;F
110207;1381,1720,1217,626,660,567,193,1414,1240,274,221,1238,925,909,286;29;M
110217;1093,780,221,57;25;M
110219;180,339,553,567,193,1623,221,1238,925,422;45;F
110220;1490,422,531,1153;5;M
110222;1149,674,868,337,1623,780,1550,925,1628,335,544,422,109,97,700;36;F
110226;1221,1442,442,1666,660,1149,1720,1550,1238,1628,544,286,894,97,700;47;F
110228;925,434;4;F
110231;180,422,553;5;M
110235;1666,739,260,544,633,339,660,539,193,1093,1720,1623,109,1163,221;38;F
110242;422,909,894,1720,897,1238,925,660,221,286,434,260,1234,109,1075;11;M
110246;1240,169,1550;35;M
110248;339,1199,193,1093,1720,1623,221,544,286,57;18;F
110249;925,434;68;F
110257;459,1153,553,1442;43;M
110260;739,1217,55,660,442,1720,1240,1628,544,286,57,1666;39;M
110264;1381,868,119,337,925,650,339,739,660,442,539,1720,780,1238,434;32;F
110265;573,1199,1234,119,337,1720,274,250,1550,1238,1288,109,1075,894,1666;78;F
110270;57,573,1217,1490,660,1381,1234,780,925,109,180,260,553,868,1238;36;F
110271;1666,286,544,1238,127,660,260,739,221,1163;60;F
110274;1234,553,626,739,1217,260,567,1238,1628,909,1075,286,422,650,57;35;M
110280;739,260,440,539,567,1623,274,1240,897,221;55;M
110282;1381,868,221,286,1236;76;F
110294;440,660,674,260,739,1490,1217,539,1381,868,1720,221,544,321,1238;35;F
110313;1490,739,868,337,1041,57,925,434;39;M
110314;1199,1238;81;F
110317;442,127,868,119,337,1238,1628,109,1075,1666,286;25;M
110332;260,660,539,567,868,1623,221,1238,925,1628,544,109,286,97,1153;47;F
110340;169,739,260,674,660,539,127,1550,1628,422,109,1075,180,97,700;49;F
110343;650,1217,739,260,626,660,539,193,127,1234,1720,221,109,1075,286;40;F
110357;650,633,1217,739,626,660,440,193,1720,274,1240,221,1628,544,286;32;F
110366;925,434;77;M
110370;442,1720,221,1238,1628,544,286;32;F
110380;180,909,422,1628,925,1550,1016,1720,193,567,260,1221,739,1217,650;58;M
110388;660,440,539,193,1234,868,119,109,1666,55,442,1199,1623,221,286;65;F
110397;339,260,442,539,1199,119,1041,221,1238,109,909,286,1153;51;F
110408;925,434;14;F
110429;650,1199,1093,1720,1623,780,1016,1240,1238,544,286,57,1236,1153,1628;31;F
110440;1720,221,321;32;M
110445;963,894,286,1236,154,170,633,244,553,539,1720,677,1016,1240,1550;36;M
110450;739,169,660,440,539,1720,1623,1016,274,1240,221,286,531,1699,1236;10;M
110469;337,1381,1199,1149,446,674,868,1238,97,700,1153,925,1628,180,286;28;F
110480;1217,339,739,1236,286,170,1720,1623,274,221,544,963,1699;30;F
110491;1628,1236,531,544,739,446,674,660,539,1381,1016,221,286,700,1153;36;F
110494;339,1490,260,1238,335,544,1075;28;F
110504;674,553,1199,1414,1623,221,1238,1628,335,544,180,286,531,97,700;36;F
110509;1236,739,660,539,1623,1016,1240,221,286;38;M
110513;925,434;45;F
110526;1628,221,544,97,1153,1149,700,674;66;M
110527;925,434;5;F
110542;1075,109,335,925,1381,1199,660,1490,339,573,1093,337,1720,1623,1238;36;F
110544;1163,422,286,531,434,700,1153,1149,446,626,660,925,1628,544,97;43;F
110555;739,169,660,440,539,1720,1623,1016,274,1240,221,286,531,1699,1236;8;M
110557;1041,925,434;36;M
110558;1199,274,250,1240,897,221,1550,1288,1628,1236,539,1720,567,909,286;44;F
110560;650,660,1238;30;M
110566;539,1381,1234,1093,677,1623,1240,1238,925,544,1666,339,260,1016,109;37;F
110572;925,434;62;F
110591;127,1234,119,1720,1623,1550,1238,925,422,109,1075,894,434,1666,1236;36;F
110607;909,531,97,1236,119,1199,539,440,660,739,1217,1623,221,544,286;32;F
110609;925,434;11;F
110614;1217,1221,193,221,925,434;44;M
110629;1381;65;M
110638;97,544,1720,193,260,1149,539,1199,1628,109,1075,894;36;M
110641;1666,1153,1234,780,274,573,1720,1550,286,1163,660,539,1623,925,544;45;F
110667;1381,337,1238,925,434;10;M
110668;925,434;39;M
110680;925,434;4;F
110686;1016,1288,1163,335,1075,909,434,1666,633,1199,1414,1623,221,1720,1153;31;M
110689;539,1199,193,1381,119,1720,1016,250,1240,221,1238,461,286,894,1236;27;M
110693;1217,1214,1221,626,553,567,1623,274,221,1238,925,459,180,909,286;8;M
110707;1217,739,446,660,440,539,1720,1623,274,221,1628,909;64;M
110716;531,434,1236,1217,1720,1240,221,544,1153,700,440,660,674,739,633;28;F
110718;1214,567,337,1720,1623,780,274,897,221,925,1628,544,422,459,461;43;M
110735;422,180;39;M
110762;1720,1217,739,626,660,553,1199,1623,1550,1238,1628,422,459,286,894;33;F
110765;567,1217,626,119,1238,1288,1628,544,109,459,461,1075,909,434,1666;41;F
110773;1041,1720,286,180,1075,260,1238,250,1623,1199,567,963,109,434,57;39;M
110776;1628,221,1240,780,1041,193,440,650,660,539,1720,1623,1016,250,1153;35;F
110793;739,55,650,170,1149,626,660,539,1199,1720,1016,1550,221,1628,286;35;F
110799;1442;20;M
110821;925,434;9;M
110822;925,434;77;M
110823;1550,1628,459,461,909,894,57;41;F
110825;573,337,1628,544,1075,909,1217,260,553,567,1199,1234,1720,109,1666;44;F
110833;1623,868,1199,539,440,170,339,739,169,660,1234,1720,1550,1238,286;31;F
110837;1075,1623,909,567;44;M
110843;633,739,244,1199,677,1623,1016,1240,221,1288,963,286,1666,1236,57;32;F
110845;633,739,244,1199,677,1623,1016,1240,1288,963,286,1236;32;F
110862;339,567,193,119,337,1720,1041,1623,897,221,1238,925,909,286,1666;36;M
110864;531,434,1217,739,446,260,567,1720,1623,660,1240,221,544,109,286;31;M
110870;1550,337,868,553,660,674,260,170,1149,1442;44;F
110884;1720,1217,567,440,109;27;F
110891;422,567,1699,1628,1163,1666,286,531,1238,221,539,321;24;M
110899;1442,1221,1214,1217,626,660,553,440,567,1623,221,925,180,909,286;13;F
110901;650,1217,739,660,539,1093,119,1623,1016,274,250,1240,1288,1699,1236;30;F
110907;1238,1236,1214,1163,650,1699,250,274,897,193,1217,567,1221,1720,909;42;F
110937;1041,221,544,1699,650,626,660,440,1623,274,1550,1238,109,286,434;32;F
110947;1199,573,660,739,633,1490,244,539,1720,1240,1238,1075,109,544,1163;44;M
110955;739,260,440,573,335,422,1490,1381,1234,868,1238,925,1628,109,1075;30;F
110958;339,739,1199,1381,193,1414,1623,1238,1288,1163,335,109,1075,286,1666;53;F
110960;260,553,567,1234,1720,1238,1075,180;58;F
110966;440,286,553,544,780,925,1199,1238,1288,1414,1623,1666,1720,422,127;46;M
110972;925,434;8;F
110973;339,1490,260,1442,553,573,567,193,337,1623,221,1238,925,422,180;48;M
110980;633,739,244,1199,677,1623,1016,1240,963,286,1236;33;M
110985;1623,1720,193,567,57,739,660,440,539,1199;24;F
111002;442,170,685,539,660,739,260,1199,1720,250,1240,221,109,286,57;43;F
111003;650,567,1041,897,909,894;30;M
111008;925,434;30;F
111009;1149,446,260,440,1199,1720,221,1238,1628,544,97,1153;44;M
111019;1238,1240,1720,442,1217,633,739,660,440,539,1199,1623,221,544,286;35;F
111029;170,260,674,660,1234,1093,1720,780,1550;21;M
111037;1041,925,434;34;F
111042;660,553,440,539,567,1199,1381,274,1240,1550,221,1238,1628,286,1720;33;F
111076;553,1381,868,1238,422,544,446,660,193;37;F
111094;1236,685,1490,660,567,1381,1720,1623,1238,335,544,422,963,180,97;68;M
111106;274;15;F
111116;925,434;29;F
111117;434,1075,1623,1093,573,1149,739,1720,335,286,57,1238,660,544,221;48;M
111122;339,446,260,1221,286,1666;7;M
111124;221,1550,1238;43;M
111132;1221,553,1381,868,337,1238,925,434;4;M
111142;894,1199,1238;32;F
111147;553,868,1238,544,446,660,193;33;F
111159;633,739,660,539,1199,1381,1720,780,1240,1238,925,57;43;F
111164;250,1240,221,1238,544,461,180,909,286,1075,109,260,193,1623,1163;34;F
111165;286,244,1199,1623,633,739,1236,539,1720,193,660,1234,1016,1240;32;F
111172;1199;85;M
111184;700,244,339,170,650,660,539,1199,193,119,1550,925,286,1666,1236;27;F
111192;1442;38;M
111216;780,677,685;45;M
111219;685,260,553,250,1238,925,109,626,1016,531,57,894,422;41;M
111228;633,1217,1214,260,553,442,925,109,459,461,1075,180,909,1666,1236;48;F
111234;925,434;2;F
111250;925,685;45;M
111252;339,567,1623,780,1238,335,544,422,109,459,461,1075,286,531,57;26;M
111272;925,434;53;F
111279;573,539,567,193,868,780,221,1550,1238,544,109,459,180,909,286;35;F
111291;260,339,650,739,1199,1720,1238,1628,544,109,459,1075,286,57,1153;33;M
111295;674,553,442,127,780,274,1238,925,1628,544,434,97,57,700,1666;70;F
111305;1490,739,119,260,925,544,109,553,894,180,1720,193,422,55,626;33;F
111312;1666,739,260,660,539,1199,1720,1240,894,567,193,1623,221,909,286;26;F
111315;1442,660,553,193,1720,250,1550,1238,1163,544,109,461,180,894,1236;54;M
111321;1381,260,567,286,440,539,274,1236,739,1442,897,660,221,909,531;33;M
111335;1666,925,286,97;4;M
111352;1442;1;F
111358;660,440,539,193,119,1720,1623,221,1238,925,1163,544,422,286,531;32;F
111363;573,868,1550,1238,1381,925,1628,221,909,286,193,1217;31;M
111397;925,434;14;F
111405;650,1442,337,1240,1238,422,109,894,57,1666;45;F
111416;442,739,260,660,573,539,1381,1720,250,221,1238,1628,109,1075,286;24;F
111425;650,1214,1149,626,1442,1199,127,1041,1623,274,1628,544,1153;26;M
111431;260,739,660,539,193,337,1720,1623,1628,446,1163,544,97,700,1153;43;M
111451;1628,674,1221,1217,260,660,553,193,780,1238,544,109,909,180,57;29;M
111456;1217,339,553,567,1199,868,1238,925,422,109,909,286,57,1666,1153;39;F
111468;925,434;94;M
111481;339,660,440,539,442,1199,193,1234,119,337,1623,221,109,286,1666;77;M
111492;1041,925;48;F
111514;1163,553,193,119,868,337,1041,1016,1240,1550,544,1075,286,434,1236;42;M
111517;685,274,1217,169,739,244,97,1442,1236,1720,127,221,1550,1623,286;36;F
111518;442,553,626,739,1217,567,650,1720,1240,1550,1238,109,909,286,1236;30;F
111524;531,97,440,339,260,1199,193,337,1720,221,335,544,422,286,1666;48;F
111532;339,260,1234,1093,868,119,1720,780,221,1238,925,335,544,109,459;34;F
111542;674,660,1623,274,544,97,1149,193,1163;41;M
111565;170,169,539,1550,1288,925;65;F
111572;626,1075,1628,1720,422;29;F
111574;1199,1234,868,119,337,1623,1238,422,109,1075,180,909,286,894,1153;42;F
111580;1217,1720,1623,339,660,539,1199,193,221,180,553;38;M
111585;739,660,440,539,1720,677,1623,780,1016,1240,221,1550,1238,109,1075;31;F
111593;739,660,440,442,539,1623,221,1628,544,422,1075,286,531,57,1666;33;F
111602;1016,1240,1550,1238,925,422,1236,193,660,553,1442,260,109,544,1163;45;F
111604;1550,1236;24;M
111617;739,660,567,1720,1623,221,1628,544,109,286,57,1666;31;F
111618;868,127,1199,539,626,1221,739,339,1217,674,660,1381,1720,221,286;42;M
111622;633,739,440,539,1720,1623,274,1240,221,422,459,909,286,531,1236;30;F
111625;925,434;39;F
111635;339,1214,260,1442,553,567,1199,193,119,337,1623,221,925,422,180;10;F
111638;440,539,1199,1381,868,1720,221,1238,674,925,544,109,286,97,700;41;F
111645;925,434;70;F
111654;434,925;23;M
111656;925,434;72;F
111667;244,660,1199,677,1720,1414,1623,1016,1240,1550,1238,925,1163,154,1236;22;M
111674;1720,677,274,1163,909,434,739,660,539,567,221,925,544,286,1153;40;F
111677;1442;75;M
111692;539,119,1414,1623,250,1240,221,1238,335,109,1075,286,434,531,1699;25;M
111739;180,1666,1381,193,1442,169,1149,1214,650,244,553,925,422,459,461;35;M
111744;221,1199,660,1041,193,127,677,1016,1550,1628,544,286,531,1236,1153;28;M
111746;55,260,169,660,1199,127,868,1720,1414,1550,1238,925,335,109,286;37;F
111749;633,1490,650,1217,339,260,573,1199,119,274,897,1238,109,1666,1236;32;F
111760;894,650,244,97,1153,1238,531,1199,1623,221,544,286,700,674,440;46;F
111773;337,1381,573,442,260,446,339,1442,119,897,335,109,1075,180,894;44;M
111795;1236,1666,57,321,531,286,461,459,1163,221,1240,780,1623;24;M
111816;1217,650,55,339,1623,897,221,1238,1628,335,544,422,109,909,286;28;M
111839;260,1149,1490,739,1442,1199,1093,109;48;F
111861;274;10;F
111869;337,677,1623,1016,250,221,1288,422,459,286,1236,1199,1240,925,154;37;M
111873;925,434;71;M
111882;925,434;72;M
111884;650,1041,1623,780;35;F
111887;339,260,442,119,1623,1163,335,544;56;M
111888;633,244,260,868,1016,1240,925,109,1236;44;F
111900;170,1149,739,1442,553,868,780,221,1550,459,97,57,1153;8;F
111918;1163,1666,633,339,739,660,440,539,337,1720,677,1016,1238,109,1075;42;M
111922;1234,461,633,244,1199,780,1623,1016,1240,1238,894,1288,925,109,1236;41;F
111960;925,434;55;F
111963;1628,180,909,446,674,567,127,868,780,1238,544,422,109,894,57;36;F
112012;626,1720,1628,422,1075;29;M
112013;170,1490,260,1016,154,109,739,650;44;M
112018;677,1041,274,109,1163,1234,335,544,1666;40;M
112021;260,739,1490,1238,286;39;F
112027;1093,868,119,1720,1414,274,1240,221,1238,1288,544,286,1666,925,434;49;F
112045;739,169,660,440,442,1720,1623,221,459,531,553,193,57,539,909;28;F
112057;685,633,739,660,1199,1720,677,780,1016,1240,1550,925,154,963,1236;94;F
112058;925,434;36;F
112060;660,440,539,567,780,1240,1163,1623,446,286,1238,321,544,221,1720;38;M
112078;1149,1442,1238,925,335,97;30;M
112086;193,1414,780,897,109,97,1221,1163,868,260,1442,567,422,1720,1238;10;F
112096;1236,180,109,1163,567,260,553,539,193,677,1016,274,1240,897,925;34;M
112098;868,1199,739,660,553,442,539,567,1720,1623,897,1238,109,1075,909;41;F
112111;1623,660,739,1214,1217,1149,260,1221,193,780,925,1628,422,97,57;12;M
112148;1214,440,780;25;F
112154;553,1442,660,337,780,1016,274,221,459,286,57,1153;6;M
112164;1628,440,780;23;F
112165;739,339,633,1381,868,925,335,1238,109,685,677,1016,1240,963,1236;38;F
112173;1199,1238;28;F
112178;1214,1442,1720,274,739,1221,660,109,1075,286,894,1699;45;M
112191;739,1199,193,221,1238,1288,1628,544,422,286;29;F
112192;685;34;F
112193;109,1720,1240,897,221,335,286,1236,1217,660,440,442,539,1623,1016;33;F
112196;1236,660,1217,170,1214,1199,97,459,286,539,780,1550,1628,894,531;25;M
112206;169,660,1199,1093,1623,1016,1240,1550,286,1236,339,539,1720,221,1238;35;M
112215;119,925,335,434;38;F
112218;260,868,1041,925,109,434;42;F
112226;780,897,925,434;37;M
112233;244,1199,1720,925,97,57;24;F
112243;633,1217,170,1221,422,434,321,154,544,440,339,660,739,539,1720;36;M
112257;573,660,260,739,446,1199,1720,221,1550,1238,1628,109,286,894,97;48;M
112259;544,1550,1093,567,539,573,442,553,660,626,1217,55,260,446,909;38;M
112276;1217,1041,1550,1236,339,55,626,674,539,1720,1628,544,180,894,97;52;F
112278;650,1199,868,337,1720,925,109;38;F
112280;925,434;81;F
112284;660,1199,337,1041,1623,221,335,109,909,286,1217,868,1238,925,434;41;F
112286;1381,321,1217,660,440,539,1199,1720,221,1238,925,286,434,739,626;27;F
112315;553,539,109,1075,894;47;M
112325;553,193,180;37;M
112336;544,434,1720,169,244,633,685,1217,739,440,539,1234,221,286,1153;26;F
112340;780,626,446,1163,154,459,685,1214,244,1720,274,925,544,422,894;36;F
112366;677,685;34;F
112378;1381,440,674,260,1093,868,119,1238,685,170,1199,544,109,459,1442;47;F
112379;553,567,1381,780,250,897,1550,1238,925,434,1720,119,1234,1199,739;26;F
112396;1381,193,1199,440,260,925,97,700,1666,633,1490,446,1238,544;50;F
112401;1217,154,1623,1288,650,626,897,1720,780,1075,925,1414,1238,250,274;26;M
112413;1442;8;F
112415;626,660,553,440,442,539,567,193,868,1720,1623,221,1238,544,286;39;F
112418;780,897,925,434,57;37;F
112423;1199,193,337,1720,1414,1623,1238,1628,544,422,109,459,286,57,700;44;F
112428;573,1199,193,1234,868,1623,1238,925,1628,335,544,422,109,1075,286;35;F
112432;1199,1234,1720,1623,1016,274,1240,1550,1288,1666,286,221,339,260,660;53;F
112434;567,868,1041,925,544,434;33;F
112436;1720;34;F
112441;660,440,442,1720,544,531;66;M
112445;650,1199,119,337,1016,1240,1550,422,1236;41;F
112450;180,963,459,154,1628,1240,1016,780,1623,626,244,339,650,127,685;44;M
112456;119,1720,677,1623,780,1240,221,1238,1628,335,422,154,459,286,57;29;F
112458;180,1666,677,440,544,963,909,97,1236,567,539,553,660,1442,286;27;F
112473;169,660,440,442,573,1199,1093,1720,221,1238,1288,544,286,531,1666;37;F
112475;544,221,1240,1623,1720,260,660,677,780,925,109,286,1666;39;F
112476;925,434;48;M
112497;925,434;16;M
112523;633,1217,1214,553,442,925,109,459,461,1075,180,909,1666,1236;50;M
112556;909,180,1628,780,1199,567,1214,1217,650,1720,1041,274,250,963,1238;38;F
112563;1442,573,193,119,1041,897,925;62;M
112570;446,660,1623,780,250,1240,221,1628,544,422,459,909,286,57;32;M
112573;1199,440;38;F
112585;1149,1217,339,660,539,337,1720,1623,1238,925,1628,335,544,434,97;29;F
112593;1240,127,434,1442,567,1041,897,1238,925,909,700;34;M
112611;925,434;32;M
112668;544;40;M
112671;337,221,1238,1628,544;39;F
112678;925,1623,1238,335,422,459,1075,963,286,894,57,1236,685,780;22;M
112681;170,633,868,260,1240,1550,1238;41;M
112691;442,337,925,1238,244,260,1442,660,1240,221,1666,539,1016,335,1236;62;F
112706;700,539,440,553,1490,1234,1041,925,422,180,260,868,1720,109,434;39;M
112713;567,868,925,434;2;F
112721;97,1666,1163,1288,1234,868,1720,677,1623,780,221,1238,335,154,109;40;M
112749;339,1016,633,660,1720,1623,1240,221,1238,109,154,286,1666,925,434;68;F
112752;553,626,739,1490,1217,650,335,422,286,180,909,531,321,1236,1666;36;M
112756;925,434;31;F
112758;442,868,335,286,1666,1153;47;F
112762;459,335,1628,925,221,1240,780,1623,868,260,739,685,1490,1720,1238;34;F
112765;1217,626,193,274,1628,461,909,894,97,440,1153;40;M
112771;335,780,119,1093,1214,1288,97,1199,193,1381,1041,1414,1238,909,1666;30;F
112779;650,339,567,127,1628,109,459,1236,321;49;M
112786;193,868,1623,909,1666,650,339,567,337,1720,1041,1414,335,1238,897;33;F
112787;925,434;48;M
112792;925,1163,459,57,1666,339,739,660,440,1016,221,1238,286,97,1236;18;M
112801;539,660,169,260,739,127,1016,1240,1550,1238,544,109,1075,286,1236;39;M
112820;660,440,739,539,567,925,650,193,221,57,1623,1628,1217,909,1720;37;F
112837;57,1236,1550,109,1075,531,274,193,539,553,260,1221,739,1199,1720;26;F
112848;650,739,660,1041,780,274,897,1550,1628,459,909,286,57,700,1236;71;F
112850;626,660,553,337,1720,1238,544,422,440,567,1628,909;41;F
112853;1163;41;F
112855;633,339,739,674,539,1199,119,1623,221,1288,544,286,700;42;F
112859;544,1153;36;F
112874;339,633,109,180,1153,1238,244,650,1016,894,897,1240,1236,677,1720;32;F
112889;685,446,897,221,1163,335,544,461,180,286,894,97,1699,700,1153;53;M
112893;446,674,440,539,868,337,1720,1623,221,1238,1163,1628,544,286,531;43;F
112904;739;71;F
112907;1214,739,1221,1442,660,1720,274,109,1075,286,894,1699;42;F
112910;339,660,440,539,193,1720,1623,221,1550,1238,544,286,531,97,1666;28;F
112913;573;38;M
112917;650,170,339,1442,573,1199,1234,780,1240,221,925,1628,459,286,57;34;F
112920;1666,1163,1238,221,1623,1720,193,539,440,660,739,1149,1217,286;30;M
112922;446,553,286,221,1720,660,539,119,1623,97,1666,1234,1381,260,339;37;M
112923;1199,260,337,1720,1550,1628,335,544,109,531,321,57,1699,700,1666;3;F
112936;685,1238,1623,963;24;F
112939;119,1623,573,897,1699,434,286,894,925,250,274,1041,1720,909,567;35;F
112973;1442;68;F
112974;286,180,1666,1149,1217,553,193,1720,1623,1238,1628,335,97;24;F
112976;650,260,1214,739,660,193,780,221,1628,422,109,459,180,57,1699;33;M
112979;446,674,97,700,1153;38;M
112985;539,573,1217,739,660,440,1199,193,1240,897,221,1238,286,531,1236;40;M
112986;274,1623,1214,1221,567,57,1217;16;M
112988;633,154;19;M
112993;1720,963,677,1236,739,1240,1288,154,1414,567,897,909,925,434,1041;25;M
112997;1214,739,260,660,539,193,780,250,221,1628,109,459,286,57,1699;32;F
113007;780,1623,440,739,1149,1217,339,660,553,573,1199,119;23;F
113012;260,1490,573,442,339,868,119,337,221,1238,109,286,1666,335,544;48;F
113032;739,660,440,1720,1623,221,1550;34;F
113039;339,169,660,274,221,897,1238,925,544,109,434;38;F
113054;221,1550,180,459,739,660,539,1199,1720,780,1240,1238,1628,1236,286;25;M
113064;925,434;34;M
113072;1199,1016,1240,1163,335,1075,1720,1623,1238;36;F
113085;1199,1234,119,1041,274,250,1240,1550,925,544,109,909,434;68;F
113086;660,440,1240,221,1550,459,626,539,1016,286,57,1236,337,780,544;33;F
113095;446,626,539,650,553,567,337,1720,1414,1238,1550,1628,180,909,894;39;F
113097;633,244,260,868,119,1016,1240,1238,925,422,109,1236;11;M
113101;894,180,335,274,250,868,1199,539,440,660,169,739,1217,553,567;30;F
113102;660,567,897,925;33;F
113103;780,1240,1628,154,459,963,286,434,57,1720,1550,1163,544;30;M
113114;1214,739,1221,1442,660,1720,274,109,1075,286,894,1699;14;F
113118;1623,539,573,660,739,446,260,169,1199,1720,1550,1238,1628,286,894;15;M
113125;335,1075,109,677,1442,573,1234,1199,868,119,1238,422,260,193,894;34;F
113142;544;47;M
113143;925,434;25;M
113173;1442;92;F
113174;925,434;6;M
113177;567,868,119,897,1288,544,909,286,57,700;37;M
113186;780,677,567,440,660,169,1221,244,1214,685,170,1217,539,894,739;29;F
113193;1628,1236,1666,1217,626,660,440,442,335,109,1075,260,1199,1720,1238;31;F
113202;1199,539,660,739,119,1720,1414,1623,1238,1288,925,286,97,57,1666;27;M
113206;1153,739,446,1221,459,925,221,1550,1199,1720,1414,1623,180,286,700;31;M
113207;1442,553,109,97,1153;47;M
113218;685;41;F
113244;1214,739,1221,1442,660,1720,274,109,1075,286,894,1699;12;F
113254;250,531,57,660,244,1720,677,1016,1240,221,1550,925,335,544,1236;30;M
113273;1442,446,244,1490,1217,739,337,1720,1041,1623,780,897,925,909,434;32;F
113274;685,660,1199,1381,1623,1240,963,434;3;F
113279;193,1628,286,55,573;41;M
113282;925,434;35;F
113297;674,677,221,544,531,700,1236,1163,1016,1623,169,739,1240,1550,286;25;M
113300;739,539,1153,1720,250,1550,97;43;F
113302;925,434;84;F
113306;1240,1016,1414,1720,1381,573,442,660,170,260,567,677,897,1238,544;34;F
113315;544,109,909,57,700,739,674,660,539,1199,193,1234,1720,221,1550;36;F
113318;1217,1221,260,660,553,567,868,119,337,180,909;66;M
113353;339,440,573,539,1199,1720,1623,221,1238,335,544,109,461,286,531;31;F
113384;780,1623,337,660,739,260,169,440,539,567,1199,221,1041,925,434;36;F
113389;894,909,250,1041,539,660,170,650,739,626,1550,925,1628,180;38;F
113391;1720;69;M
113394;700,1236,1153,1240,221,459,1075,286,434,57,1623,1016,250,1238,1699;71;M
113402;1217,339,1490,739,1221,539,1199,1720,1623,274,1240,221,1238,925,1153;60;F
113404;739,660,440,539,1720,221,1238,286,531;31;F
113408;1149,1217,169,660,440,539,1720,780,221,1163,1628,109,459,1075,286;40;F
113426;1720,1217,660,286,531,685,1550,677,154,335,1016,739,1236,1240,244;39;M
113436;633,244,260,868,1016,1240,1238,925,422,109,1236;9;F
113441;221,685,339,440,442,1199,1093,677,1414,1623,780,250,1288,909,894;57;F
113442;1720,1623,573,440,1490,1236,422,1238,1199,539,660,260,244,739,685;41;F
113443;1442;66;M
113465;442,660,739,1217,440,539,567,1623,221,1238,925,1628,109,544;28;F
113472;660,260,739,650,868,337,1623,274,897,221,925,422,286,434,1236;33;F
113496;1041,925,434;47;M
113501;339,1442,1238,1163;55;M
113504;650,539,567,1623,1238,1288,286,531,1236,739,660,1199,1720,250,1699;34;M
113508;925,434;41;F
113526;739,1217,650,339,539,567,1016,1238,1075,180,909,286,531,1666,1236;30;F
113531;925,434;38;M
113533;897,180,909,97,57,700,1236,1628,925,119,339,1153,1550,1238,544;31;F
113535;897,221,925,1628,109,963,180,909,434;12;M
113538;626,1628;33;F
113543;1221,260,337,335,109,1075,909,286,1666;46;F
113545;1149,1153,1666,909,1288,1720,274,567,119;31;M
113582;442,339,1199,337,1720,1623,221,1238,925,335,544,286,894,57,1666;43;M
113586;1041,567,909,1720,925,434;37;F
113599;1442;14;F
113600;154,1163,544,193,1075,1666,1490,1199,1381,1234,1093,868,339,1414,1238;34;M
113607;1041,660,626,1217,650,567,1199,193,1720,274;38;M
113608;442,567,1041,897,1238,925,909;49;F
113612;440,260,244,739,1217,633,650,286,1414,221,544,1623,1720,674,700;26;F
113622;700,650,633,1217,660,539,1199,193,1720,1623,544,434,97,1238,440;27;M
113642;1628;33;M
113645;193,1093,1720,1238,1217,739,1221,660,440,539,1234,925,909,531,1699;24;F
113670;1442;8;M
113687;1234,677,422,1666,434,1075,440,1199,119,339,1238;31;F
113708;1163;42;M
113713;700;73;M
113715;260,442,573,1236,1234,119,1238,925,335,180,531,1666,109,909,286;64;F
113722;193,1720,1041,1240,127,567,170,244,1623,897,544,909,286,57,700;21;M
113725;1442;;M
113726;1163,1153;11;M
113736;677,1240,897,221,1288,925,335,544,531,700,1163,1550,1623,1234,169;25;F
113765;1623,539,573,660,739,446,260,169,1199,1720,1550,1238,1628,286,894;12;M
113767;553,539,567,1550,1236,1075,109,422,1238,1240,1623,1199;29;F
113773;335,1666,626,897,1214,544,459,422,57,567,1238,1221,909,553,1628;33;M
113785;109,286,894,700,1149,739,626,97,434,544,1628,925,539,193,1720;37;M
113789;1240,1550,1238,925,286,894,531,1236;28;M
113793;55,1381,1199,567,660,674,626,446,739,633,650,339,539,193,1720;37;F
113796;925,434;37;F
113814;685,1093,868,119,1720,1414,274,1240,221,1238,1288,925,544,286,434;14;F
113826;1442;72;F
113839;925,434;5;F
113844;925,1628,154,109,963,321,286,531;50;F
113874;897,221,1163,1628,286,1720,544;39;M
113877;1442,260,1490,1238,109;38;F
113879;539,442,440,260,739,1214,633,650,660,1720,1414,1238,1628,109,286;27;F
113888;660,539,221,1199,1153;42;F
113901;244,1236,1240;26;M
113904;170;25;M
113913;442,1217,739,660,567,193,1093,1623,221,1550,1163,544,1238,539,1720;34;F
113927;440,780,57,531,544,260,739,339,573,1199,1381,1234,1093,119,1238;43;F
113933;1217,1149,539,193,1720,1623,221,1628,544,459,286,894,434,57;36;M
113937;339,1217,739,660,539,193,780,250,221,1238,109,909,286,57,1153;35;F
113939;894,97,685,739,1199,1720,677,780,1240,221,1550,1163,1075,286,1236;43;M
113955;925,335,109,1075,286,97,57,1153,1381,1199,446,339,1149,1628,700;39;F
113958;339,1381,1666,1163;49;F
113963;1623,539,573,660,739,446,260,169,1199,1720,1550,1238,1628,286,894;7;M
113972;544,531,97;34;M
113978;1240,170,739,446,674,660,442,1720,1623,274,221,544,154,97,700;79;M
113996;626,1720,1628;31;M
114001;1217,339,446,660,674,1720,1414,221,1550,1238,1628,544,909,286,700;52;F
114011;339,539,193,119,1720,1623,780,221,1238,1628,544,286,531,57;28;F
114018;1490,1214,339,442,1666,1199,573,119,260,868,1238,109,1075;48;F
114019;1149,1199,119,337,780,335,109,459,1075,57,544;7;M
114020;57,1628,1016,1214,650,1217,553,539,193,780,422,459,909,286,567;29;M
114027;1093,868,119,1720,1414,274,1240,221,1238,1288,925,544,286,434,1666;12;F
114032;1442;67;F
114058;169;26;F
114063;739,1217,633,660,567,1720,1041,780,274,925,909,434;35;M
114081;1199,1720,1041,544,909,286,531,274,1236,660,539,1550,1240,1016,567;40;M
114085;1041,531,434,1217,739,660,539,567,1623,274,1240,221,1550,909,286;39;F
114113;1199,1234,1016,1240,221;32;F
114141;339,1199,442,119,1016,1240,221,925,1666,1093,1720,1238,286,440,1234;32;F
114157;221,1217,897,544,109,1075,180,286,553,440,1720,925,422,909,97;46;M
114168;925,434;69;M
114183;739,674,660,1234,221,286,434,700,1236,1628,1623,780,440,1199,544;34;F
114213;573,567,119,1720,1041,1623,274,250,897,925,909,286,894,434,1699;;F
114215;339,1149,660,440,539,567,119,1720,221,925,1288,286,1153;29;F
114223;1623,539,573,660,739,446,260,169,1199,1720,1550,1238,1628,286,894;48;F
114224;1238,1288,925,1628,335,422,109,459,1075,909,286,531,434,321,57;41;F
114232;1093,868,119,1720,1414,274,1240,221,1238,1288,925,544,286,434,1666;9;M
114245;422,335,1240,337,1234,1199,925,57,170,685;12;M
114250;660,440,539,1199,1720,677,1623,1016,274,1240,221,544,286,531,1236;29;F
114262;170,674,1199,193,1381,1093,1623,221,897,1628,544,286,57,700,1153;42;F
114265;539,193,780,1016,250,1240,221,1238,109,459,1075,286,97,57,1153;30;F
114288;1720,1041,1075,1414,626,1442,660,539,567,868,1623,274,897,925,909;33;F
114297;1016,1628;32;M
114306;286,1550,1238,250,1234,193,170,660,539,1199,1623,221;38;F
114307;925,434;44;M
114320;567,1199,1234,868,1720,221,1238,1628,531,286,1666,339,442,573,539;22;F
114325;1414,1236,1666,1075,97,1238,274,553,685,1442,1199,1381,780,925,422;45;F
114329;286,1628,674,1720,544;30;M
114332;1217,660,567,1720,1414,1240,221,1288,286,739,539,1199,1623,1238;23;F
114333;422,286,459,897,250,780,539,1442,660,553,567,221,1238,909,434;45;M
114335;440,573,193,660,1720,1234,1199,442,739,1490,339,1238,544,1075,1666;29;M
114340;739,1442,868,925,1628,286;35;M
114348;650,1041,780,274,897,221,925,109,180,909,434,57,1699;44;M
114381;1221,1153,1217,1214,567,780,894;43;F
114386;925,434;33;M
114391;660,440,193,221,109;40;M
114399;109,461,1623,1381,633,1199,193,1720,1238,1163,422,459,286,434,57;27;F
114415;868,1381,660,1628,221,109,1149,446,674,1720,1238,544,97,700,1153;41;F
114423;1490,260,1442,442,1093,1016,1238,109,894;15;F
114425;677,1016,440,567,739,660,539,1623,1240,221,925,544,286,531,57;64;F
114426;1093,868,119,1720,1414,274,1240,221,1238,1288,925,544,286,434,1236;23;F
114444;660,442,1381,119,1720,1414,250,221,1238,1288,109,1075,894,1666,1153;56;F
114445;739,573,1381,1720,1238,925,57;30;F
114450;925,434;43;F
114456;440,539,1720,1240,221,1550,286,1666,260,1414,1238,1163,335,109,1075;42;M
114459;925,434;9;M
114460;1217,626,553,1199,193,1234,1093,1720,1666,894,180,109,1041,221,1238;36;F
114471;925,434;57;M
114474;434,909,1238,221,567,553,660,1442,539,780,250,897,459,286,422;47;F
114486;1628,57,1236,780,193,660,170,221,925,544,531,97,321,1153,286;44;M
114487;442,539,1093,1016,925,1236,685,170,633,739,868,1240,1238,422,1666;41;F
114491;1221,169,567,1381,1234,1623,897,1238,925;39;F
114496;660,1628,1720,221,1149,446,868,674,1381,1238,544,109,97,700,1153;67;F
114502;925,434;89;M
114505;339,1623,274,544,909,660,567,193,1720,221,1217,739,440,539,1199;33;F
114514;868,335,1666,446;31;F
114518;925,434;54;M
114520;442,193,1234,1093,1720,274,897,221,1550,1238;46;M
114526;446,1149,544,97,1153;31;M
114530;1234,1381,446,660,868,337,1720,221,1288,1628,544,286,97,321,1666;42;M
114544;1720,127,567,553,1217,650,244,539,1238,925,660,626,1163,909,286;54;F
114553;446,739,633,674,339,897,1628,97,700,1720,1414,1623,1163,1238,544;28;M
114561;170,260,660,539,1199,1234,1623,1016,250,1240,221,1628,109,286,531;44;F
114569;1163;8;M
114580;1238,925,446,739,1490,1217,335,544,422,109,1075,286,531,434,97;32;F
114587;1093,868,119,1720,1414,274,1240,221,1238,1288,925,544,286,434,1666;21;M
114596;925,434;73;F
114598;1093,868,119,337,1414,109,1075,339,440,1199,1238,446,1153,442,544;63;F
114611;897,1414,1234,260,739,650,1214,1221,553,539,567,868,1623,274,1075;39;F
114636;442,925,1199,193,1238,544,286;26;F
114644;925,434;10;M
114656;539,660,1442,446,1221,170,1720,868,553,626,260,739,1623,422,109;45;F
114665;221,660,1221,260,626,1442,442,1720,1163,1628,154,544,894,700,1236;37;F
114670;1623,274,221,1238,925,335,544,109,1075,286,894,97,57,700,1666;6;M
114687;1623,1720,119,1234,127,440,660,650,633,339,1149,739,539,1199,1381;36;M
114694;567,193,539,553,260,1217,544,109;43;M
114707;650,1199,337,1623,109,739,339,260,1041,1414,780,1238,335,894,434;23;M
114709;650,244,677,1623,1628,193,1238,868,1075,260,127,119,1240,1550,925;45;M
114710;440,337,1628,650,544,739,446,339,260,1238,1666,1199,1720,1623,1550;27;F
114755;1442,660,1199,337,1720,677,1623,780,1240,1550,1288,925,1163,422,1236;41;F
114757;446,739,442,1720,1075,109,1238,1381,193,567,553,1442,260,650,286;23;F
114758;660,1720,780,1163,1075,685,244,260,1442,539,109,1016,1240,1236,1550;42;F
114760;925,434;39;F
114765;1093,868,119,1720,1414,274,1240,1628,422,180,321,1699,1666,1236;76;F
114777;539,193,119,274,925,660,1623,780,250,221,1238,459,286,1699,57;27;F
114779;1221,274,909,633,739,567,1623,1016,1240,459,221,1550,286,531,440;42;M
114783;674,193,1720,1623,1550,1238,909,1217,925,1628,544;35;F
114794;1236,170,339,739,674,660,442,539,1199,1720,677,1623,1240,1550,1153;24;F
114800;1217,739,446,260,1238,1628,544;46;F
114814;660,1628,544,286,97,1153;47;M
114820;567;34;M
114834;446,674,567,193,1720,1623,1238,1163,1628,335,544,461,1075,909,894;41;M
114838;567,553,440,274;37;F
114840;868,633,1163,1666,685,739,1442,442,780,1016,1240,459,97,57,1236;42;F
114842;925,434;13;F
114843;1199,894;48;M
114851;1221,897,274,925,909,1153;33;M
114864;553,567,119,1221,1217,274,1623,909;25;M
114865;339,739,446,660,440,193,1720,1414,1623,221,1238,461,286,57,700;27;F
114878;1217,739,539,1093,780,221,286,531,434,1699,1666;26;F
114902;925,434;59;F
114905;1414,626,1442,660,539,567,868,337,1623,274,897,925,1075,909,286;;M
114921;539,119,1623,897,221,1238,1628,335,109,1075,180,434,57,1699,1236;25;F
114924;57,459,780,1623,539,440,660,1199,1016,1238,286,221,1720,677,1236;37;M
114925;440,567,1199,193,221,1238,739,539,1720,1041,1163,286,531,434,57;27;M
114937;434,1240,1016,573,633,1217,739,660,440,539,1623,274,221,286,531;43;F
114941;925,434;19;F
114942;1199,539,660,339,442,193,780,1238,1628,544,154,459,286,531,57;38;F
114948;339,660,440,1720,1623,221,1238,544,109,1075,286;35;F
114956;739,442,573,1199,1414,1550,1238,925,1628,544,459,286,531,57,1236;28;F
114959;739,446,193,1623,274,1550,925,1628,544,286,434,700,1153,1149,97;59;F
114970;553,925;50;F
114975;1442,260,1214,897,335,1490,660,442,573,539,567,337,1238,925,544;30;M
114981;55,170,1234,119,221,925,544,286,894;58;F
114984;925,434;47;M
114994;739,260,539,1199,459,286,57,660,1234,1093,1720,1623,221,1238,544;35;F
114995;660,335,685,1490,739,244,539,868,1720,1623,780,221,1238,422,109;9;M
114997;1093,868,119,1720,1414,274,1240,221,1238,1288,925,544,286,434,1666;47;M
115011;925,434;12;F
115020;1221,553,539,567,909,286;31;F
115027;739,260,1442,1016,1720,1199,1238,1163,335,422,109,1075,286,57,1666;31;F
115030;539,260,660,1442,1016,1240,221,925,422,109,963,1075,286,531,1236;40;M
115035;739,660,440,539,193,1720,1623,1240,221,1163,544,422,286,531,434;11;M
115057;1442;37;M
115066;1490,1016,685,260,1442,1238,109;12;F
115088;539,567,1623,780,897,221,1628,154,109,180,909,531,434,1666,1236;68;F
115091;685,1490,127,1550,1238,1163;44;M
115096;1149,674,660,440,1199,1381,1720,221,286,97,1153;9;M
115103;567,553,440,274;43;M
115106;1628,459,963,909,434,650,1217,739,660,1623,221,286,531,1236,1240;26;M
115113;1550,154,1699,1221,1214,1199,1163,1075,1666,1381,1720,1623,897,1238,925;33;F
115119;119,1720,677,1623,274,1075,260,1442,780,221,925,109,459,286,57;40;F
115121;1214,780,459,57,650,567,422,909,1238,553,1628;32;F
115126;339,626,674,660,539,567,1623,274,221,1288,925,1628,544,909,700;55;F
115128;1163,1623,1720,193,440,260,660,539,221,1238,335,109,286;25;M
115136;650,339,442,573,119,337,1623,221,1238,180,286;58;F
115142;1666,1381,193,260,1199,1720,1041,1623,897,1238,925,1163,109,1075,434;50;F
115143;925,434;78;F
115204;685;12;F
115208;1623,221,1238,544,286,531;34;M
115219;626,660,440,539,1623,221,925;27;F
115229;446,1199,868,1623,1238,1163,335,544,422,109,1075,97,57,626,1720;30;M
115235;339,1149,260,1442,337,1720,109,459,461,1075,286;37;M
115244;650,109,1075,909,894,97,57,1221,260,127,897,1550,1238,1163,1666;32;M
115256;440,660,169,244,1217,650,739,539,677,1016,1240,1550,1238,544,1236;32;F
115267;339,1149,739,260,573,1234,119,1623,1550,1238,544,109,286,97,1153;29;F
115274;442,1442,1221,446,1149,650,739,260,674,553,1550,544,180,286,531;29;F
115283;119,337,1720,1623,221,909,1628;37;F
115290;286,1163,250,1414,1720,193,539,442,553,660,626,739,1490,1217,650;30;M
115298;553,539,127,868,119,1623,1240,1238,925,544,909,286,894;36;M
115315;440,539,1623,1699,626,553,567,1199,250,221,1238,180,909,286,1153;29;F
115328;685,1236,1217,1016,677,567,127,1214,459,1041,780,1628,422,57,909;53;M
115333;925,434;75;M
115334;544,1240,868,573,244,422,1238,1623,1720,1199,539,660,739,1490,685;5;F
115340;539,780,422,109,925,1199,260,739,685;40;F
115348;260,1442,553,109,180;59;M
115366;274,660,1217,739,539,567,1199,127,1720,1623,1238,1628,154,286,1666;25;F
115371;260,1442,553,109;15;F
115378;739,1623,650,170,1720,780,221,1238,1163,544,109,286;64;F
115383;909,1236,1699,1075,109,335,1238,221,897,119,539,260,739,339,650;58;F
115386;1442,660,553,539,868,119,337,1623,221,1238,925,335,422,180,286;7;M
115391;339,633,650,573,193,868,274,925,434;38;F
115399;1153;21;M
115413;700,739,626,660,553,539,567,1381,1234,780,1238,925,544,180,1199;29;M
115414;440,1199,119,1623,221,544,660,442,539,1666,739,1720,1550,1238,1153;33;F
115417;925,434;52;F
115420;442,1163,335,154,321,685,221,422,677,1240;50;M
115421;544,57,1666;12;F
115436;739,440,1623,573,339,1149,539,1199,193,1234,1720;36;F
115453;440,442,539,1199,1623,780,1240,221,1550,1238,1628,286,531,97,57;32;F
115455;1236;31;F
115461;573,553,1217,339,567,780,221,1238,1628,544,459,909,286,894,1666;25;F
115462;1490,1442;10;F
115464;626,221,1628,422,286;43;M
115468;1720,55,739,260,626,660,539,1199,1623,1238,109,1666,286;44;F
115488;1238,1666,286,461,221,1240,1016,1720,539,442,440,660,260,739,633;37;F
115490;925,434;14;M
115491;925,434;32;M
115497;244;78;F
115500;1666,337,573,339,660,567,1199,1720,1623,221,1238,459,909,286,57;23;F
115537;553,422,180,1442;39;F
115539;780,337,119,868,1381,539,573,442,440,244,739,1149,1214,339,633;25;F
115547;925,897,1238,434;51;M
115550;1149,674,660,440,1199,1381,1720,221,286,97,1153;5;M
115562;1075,109,422,544,335,446;7;M
115567;339,674,660,440,567,119,1720,1623,1238,1628,544,286,434,57,1153;33;F
115583;1442;38;F
115590;446,1238,544;36;F
115594;1221,1199,193,1623,544,459,531,1236,739,660,539,1720,221,1628,286;55;M
115595;544,109,446,1075;39;M
115600;446,1240,660,539,1623,221,897,1628,335,544,531,894,1236;54;M
115601;1238,897,274,1414,1720,1199,539,567,442,660,169,260,739,339,650;25;F
115603;1149,446,674,660,1381,868,1720,221,1238,1628,544,109,97,700,1153;90;F
115605;1490,1442;6;F
115611;544,446;41;M
115637;739,1199,193,1381,1234,1093,1720,1623,221,1550,544,286,97,700,1236;33;F
115644;531,434,539,660,739,442,567,1199,193,97,1623,1238,1628,1720,1666;26;F
115657;1720,337,553,446,1490,685,677,1623,1238,925,422,154,109,894,1236;4;F
115673;97,544,925,780,897,573,339,567,193,1093,868,1720,1016,1550,286;26;F
115680;573,1234,337,1720,274,925,1490,674,1199,868,1238,1041,434,97,1666;41;F
115698;442,739,1214,685,539,1240,221,1163,335,286,1666,1623,1288,1720;45;M
115707;650,685,1016,127,567,193,1199,677,1238,422,531,434,97,1666,1236;14;M
115708;650,1217,739,260,553,567,193,1720,1016,1550,925,422,909,1628,180;56;F
115729;739,442,440,1381,1720;75;F
115741;446,544,422,1075,97;5;F
115754;925,434;34;M
115756;1490,1442;4;F
115758;1016,1240,244;41;M
115765;244,1217,685,337,1238,335,339,1490,894;42;F
115769;739,539,1199,1234,544;25;F
115809;193,1623,1288,1720,1381,1234,868,337,339,544,286,1666,221,321,97;45;F
115810;567,553,633,1217,1214,739,169,1381,539,1720,1628,422,459,180,1236;6;F
115812;567,440,650,739,660,539,677,1623,1016,1240,221,335,286,1236,1720;56;M
115813;739,1442,660,553,868,119,337,1623,221,1238,925,335,422,180,286;5;F
115828;567,909,1238;39;M
115867;925,434;39;F
115874;685;11;M
115917;1442,180,422,553;40;M
115923;897,1623,677,868,1234,1381,553,260,339,685,1236;1;F
115938;446,335,544,422,109,1075;1;F
115947;897,925,434;8;M
115959;685,650,127,567,677,1199,1016,193,1238,422,531,434,97,1666,1236;12;F
115960;685;6;M
115972;446,544,1075;65;M
115974;1214,1221,1199,1381,1720,1623,897,1550,1238,925,1163,154,1075,1699,1666;38;M
115978;739,119,1623,221,1238,544;39;F
115993;1490,1442;39;M
115995;221,531;29;M
116002;1442;5;M
116033;685;;M
116047;650,685,1016,567,1199,193,127,677,1238,422,531,434,97,1666,1236;49;F
116278;1666,1234,553,461,442,260,180,286,109,119;58;F
116279;1623,1490,739,1238,1075,1153,442,260,286,109,193;90;F
99999914798;1153;34;M
99999922524;1490,244,868,1016,1240,1550,1238,1236,260,1442;36;F
99999965624;119,868,1199,553,660,260,339;40;F
99999994132;1414,868,1238,544,660,286,221,193,97;17;F